/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mabb.fontverter.FontVerterUtils;
import org.mabb.fontverter.io.DataTypeBindingDeserializer;
import org.mabb.fontverter.io.DataTypeBindingSerializer;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.io.FontDataInput;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.io.FontDataOutputStream;
import org.mabb.fontverter.opentype.Countour;
import org.mabb.fontverter.opentype.GlyphMapReader;
import org.mabb.fontverter.opentype.OpenTypeFont;
import org.mabb.fontverter.opentype.TtfInstructions.TtfInstructionParser;
import org.mabb.fontverter.opentype.TtfInstructions.instructions.TtfInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtfGlyph {
    private static final Logger log = LoggerFactory.getLogger(TtfGlyph.class);
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    short numberOfContours;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    short xMin;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    short yMin;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    short xMax;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    short yMax;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, isArray=true, arrayLength="getNumberOfContours", ignoreIf="isComposite")
    Integer[] countourEndPoints;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, ignoreIf="isComposite")
    int instructionLength;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.BYTE, isArray=true, ignoreIf="isComposite", arrayLength="instructionLength")
    Byte[] instructions;
    List<CoordinateFlagSet> flags = new LinkedList<CoordinateFlagSet>();
    private List<GlyphCoordinate> points = new LinkedList<GlyphCoordinate>();
    private OpenTypeFont font;
    private int glyphId;
    byte[] rawData;
    private boolean isParsed = false;
    private boolean useRawData = false;

    public static TtfGlyph parse(byte[] data, OpenTypeFont font) throws IOException {
        FontDataInputStream reader = new FontDataInputStream(data);
        DataTypeBindingDeserializer deserializer = new DataTypeBindingDeserializer();
        TtfGlyph glyph = (TtfGlyph)deserializer.deserialize((FontDataInput)reader, TtfGlyph.class);
        glyph.isParsed = true;
        glyph.font = font;
        glyph.glyphId = font.getGlyfTable().getGlyphs().size();
        glyph.rawData = data;
        if (glyph.isComposite()) {
            glyph.useRawData = true;
        } else {
            glyph.readSimpleGlyphData(reader);
        }
        return glyph;
    }

    public byte[] generateData() throws IOException {
        if (this.isEmpty()) {
            return new byte[0];
        }
        if (this.rawData != null && this.useRawData) {
            return this.rawData;
        }
        int t = 85;
        if (this.instructionLength > t) {
            this.instructionLength = t;
        }
        FontDataOutputStream writer = new FontDataOutputStream();
        DataTypeBindingSerializer serializer = new DataTypeBindingSerializer();
        byte[] data = serializer.serialize(this);
        writer.write(data);
        for (GlyphCoordinate pointOn : this.points) {
            CoordinateFlagSet coordFlags = new CoordinateFlagSet();
            if (pointOn.isOnCurve()) {
                coordFlags.add(CoordinateFlagType.ON_CURVE);
            }
            writer.write(coordFlags.write());
        }
        for (GlyphCoordinate pointOn : this.points) {
            writer.writeShort((int)pointOn.x);
        }
        for (GlyphCoordinate pointOn : this.points) {
            writer.writeShort((int)pointOn.y);
        }
        if (writer.size() % 2 != 0) {
            writer.writeByte(0);
        }
        return writer.toByteArray();
    }

    private void readSimpleGlyphData(FontDataInput reader) throws IOException {
        this.readFlags(reader);
        this.readCoordinates(reader);
    }

    private void readFlags(FontDataInput reader) throws IOException {
        for (int i = 0; i < this.getNumberOfPoints(); ++i) {
            CoordinateFlagSet flagSet = CoordinateFlagSet.flagsFromByte(reader.readByte());
            if (flagSet.contains((Object)CoordinateFlagType.REPEAT)) {
                flagSet.repeatCount = reader.readByte() & 0xFF;
                i += flagSet.repeatCount;
            }
            this.flags.add(flagSet);
        }
    }

    private void readCoordinates(FontDataInput reader) throws IOException {
        CoordinateFlagSet flagSetOn;
        List<Integer> coords;
        Iterator<CoordinateFlagSet> iterator = this.flags.iterator();
        while (iterator.hasNext() && (coords = this.tryGetXCoords(reader, flagSetOn = iterator.next())) != null) {
            for (Integer xOn : coords) {
                this.points.add(new GlyphCoordinate(xOn.intValue(), 0.0, flagSetOn));
            }
        }
        int yIndex = 0;
        for (CoordinateFlagSet flagSetOn2 : this.flags) {
            try {
                List<Integer> coords2 = this.tryGetYCoords(reader, flagSetOn2, yIndex);
                if (coords2 == null) break;
                for (int i = 0; i < coords2.size(); ++i) {
                    this.points.get((int)(i + yIndex)).y = coords2.get(i).intValue();
                }
                yIndex += coords2.size();
            }
            catch (EOFException ex) {
                log.warn("Went over on y coord read at flag #" + this.flags.indexOf(flagSetOn2));
                this.useRawData = true;
                break;
            }
        }
    }

    private List<Integer> readCoordinatesForFlag(FontDataInput reader, CoordinateFlagSet coordFlags, int lastCoord) throws IOException {
        boolean isX = coordFlags.forX;
        boolean is1Byte = coordFlags.contains((Object)(isX ? CoordinateFlagType.IS_X_1_BYTE : CoordinateFlagType.IS_Y_1_BYTE));
        boolean useSame2ByteCoord = coordFlags.contains((Object)(isX ? CoordinateFlagType.THIS_X_IS_SAME : CoordinateFlagType.THIS_Y_IS_SAME));
        boolean useNegative1Byte = !useSame2ByteCoord;
        LinkedList<Integer> coords = new LinkedList<Integer>();
        for (int j = 0; j < coordFlags.repeatCount + 1; ++j) {
            if (useNegative1Byte && is1Byte) {
                coords.add(-(reader.readByte() & 0xFF));
                continue;
            }
            if (is1Byte) {
                coords.add(reader.readByte() & 0xFF);
                continue;
            }
            if (useSame2ByteCoord) {
                coords.add(0);
                continue;
            }
            coords.add(Integer.valueOf(reader.readShort()));
        }
        if (coords.size() == 0) {
            throw new IOException("TTF glyph read coordinates array of 0 " + (isX ? "Xs" : "Ys"));
        }
        return coords;
    }

    private List<Integer> tryGetXCoords(FontDataInput reader, CoordinateFlagSet flagSetOn) throws IOException {
        try {
            int lastCoord = this.points.size() == 0 ? 0 : (int)this.points.get((int)(this.points.size() - 1)).x;
            return this.readCoordinatesForFlag(reader, flagSetOn, lastCoord);
        }
        catch (EOFException ex) {
            log.warn("EOF on X coord read at flag #" + this.flags.indexOf(flagSetOn) + " " + this.toString());
            this.useRawData = true;
            return null;
        }
    }

    private List<Integer> tryGetYCoords(FontDataInput reader, CoordinateFlagSet flagSetOn, int yIndex) throws IOException {
        try {
            CoordinateFlagSet coordFlags = new CoordinateFlagSet(flagSetOn);
            coordFlags.forX = false;
            int lastCoord = yIndex == 0 ? 0 : (int)this.points.get((int)(yIndex - 1)).y;
            return this.readCoordinatesForFlag(reader, coordFlags, lastCoord);
        }
        catch (EOFException ex) {
            log.warn("Went over on y coord read at flag #" + this.flags.indexOf(flagSetOn));
            this.useRawData = true;
            return null;
        }
    }

    public short getNumberOfContours() {
        return this.numberOfContours;
    }

    public boolean isComposite() {
        return this.numberOfContours < 0;
    }

    int getNumberOfPoints() {
        if (this.countourEndPoints == null) {
            return 0;
        }
        return this.countourEndPoints[this.countourEndPoints.length - 1] + 1;
    }

    public List<GlyphCoordinate> getCoordinates() {
        return this.points;
    }

    List<Path2D.Double> getPaths() {
        LinkedList<Path2D.Double> paths = new LinkedList<Path2D.Double>();
        int startPtOn = 0;
        Point2D.Double lastPoint = new Point2D.Double();
        for (Integer endPtOn : this.countourEndPoints) {
            Path2D.Double pathOn = new Path2D.Double();
            if (startPtOn == 0) {
                pathOn.moveTo(0.0, 0.0);
            }
            Point2D.Double firstPoint = new Point2D.Double();
            for (int i = startPtOn; i < endPtOn + 1; ++i) {
                Point2D.Double relativePoint = this.points.get(i);
                Point2D.Double point = new Point2D.Double();
                point.x = relativePoint.x + lastPoint.x;
                point.y = relativePoint.y + lastPoint.y;
                if (startPtOn != 0 && i == startPtOn) {
                    pathOn.moveTo(point.x, point.y);
                } else {
                    pathOn.lineTo(point.x, point.y);
                }
                if (i == startPtOn) {
                    firstPoint = point;
                }
                lastPoint = point;
            }
            startPtOn = endPtOn + 1;
            pathOn.lineTo(firstPoint.x, firstPoint.y);
            paths.add(pathOn);
        }
        return paths;
    }

    List<Countour> getCountours() {
        LinkedList<Countour> countours = new LinkedList<Countour>();
        int startPtOn = 0;
        Point2D.Double lastPoint = new Point2D.Double();
        for (Integer endPtOn : this.countourEndPoints) {
            Countour countourOn = new Countour();
            Point2D.Double firstPoint = new Point2D.Double();
            for (int i = startPtOn; i < endPtOn + 1; ++i) {
                Point2D.Double relativePoint = this.points.get(i);
                Point2D.Double point = new Point2D.Double();
                point.x = relativePoint.x + lastPoint.x;
                point.y = relativePoint.y + lastPoint.y;
                countourOn.add(relativePoint);
                if (i == startPtOn) {
                    firstPoint = point;
                }
                lastPoint = point;
            }
            startPtOn = endPtOn + 1;
            countourOn.add(firstPoint);
            countours.add(countourOn);
        }
        return countours;
    }

    public void setCountours(List<Countour> countours) {
        this.points.clear();
        for (Countour countourOn : countours) {
            for (int i = 0; i < countourOn.size(); ++i) {
                Point2D.Double ptOn = (Point2D.Double)countourOn.get(i);
                if (i == countourOn.size() - 1) continue;
                this.points.add(new GlyphCoordinate(ptOn.x, ptOn.y, new CoordinateFlagSet()));
            }
        }
    }

    public String toString() {
        if (this.font.getCmap() == null) {
            return "CMap table is null can not get string data for glyph.";
        }
        String names = "";
        for (GlyphMapReader.GlyphMapping mapOn : this.font.getCmap().getGlyphMappings()) {
            if (mapOn.glyphId != this.glyphId) continue;
            names = names + mapOn.name + ", ";
        }
        return String.format("Glyph Index:'%d' Used For Chars:'%s'", this.glyphId, names);
    }

    public boolean isEmpty() {
        return !this.isParsed && this.points.size() == 0 && this.rawData == null;
    }

    public List<TtfInstruction> getInstructions() throws IllegalAccessException, IOException, InstantiationException {
        try {
            TtfInstructionParser parser = new TtfInstructionParser();
            return parser.parse(FontVerterUtils.toPrimative(this.instructions));
        }
        catch (Exception ex) {
            log.info("Failed to parse ttfinstrctuins, currentley uneeded for conversion");
            return new ArrayList<TtfInstruction>();
        }
    }

    protected static enum CoordinateFlagType {
        ON_CURVE(0),
        IS_X_1_BYTE(1),
        IS_Y_1_BYTE(2),
        REPEAT(3),
        THIS_X_IS_SAME(4),
        THIS_Y_IS_SAME(5);

        public static final CoordinateFlagType POSITIVE_X_SHORT;
        public static final CoordinateFlagType POSITIVE_Y_SHORT;
        private final int value;

        private CoordinateFlagType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            POSITIVE_X_SHORT = THIS_X_IS_SAME;
            POSITIVE_Y_SHORT = THIS_Y_IS_SAME;
        }
    }

    protected static class CoordinateFlagSet
    extends LinkedList<CoordinateFlagType> {
        public int repeatCount = 0;
        boolean forX = true;

        public CoordinateFlagSet() {
        }

        public CoordinateFlagSet(CoordinateFlagSet coordinateFlagTypes) {
            super(coordinateFlagTypes);
            this.repeatCount = coordinateFlagTypes.repeatCount;
            this.forX = coordinateFlagTypes.forX;
        }

        public byte write() {
            char[] binary = StringUtils.repeat((String)"0", (int)8).toCharArray();
            for (CoordinateFlagType typeOn : this) {
                int bit = 8 - typeOn.getValue() - 1;
                binary[bit] = 49;
            }
            return (byte)Integer.parseInt(String.valueOf(binary));
        }

        public static CoordinateFlagSet flagsFromByte(byte flagByte) {
            CoordinateFlagSet flags = new CoordinateFlagSet();
            String binary = Integer.toBinaryString(flagByte);
            binary = StringUtils.repeat((String)"0", (int)(8 - binary.length())) + binary;
            for (CoordinateFlagType typeOn : CoordinateFlagType.values()) {
                char bitOn = binary.charAt(8 - typeOn.getValue() - 1);
                if (bitOn != '1') continue;
                flags.add(typeOn);
            }
            return flags;
        }
    }

    protected static class GlyphCoordinate
    extends Point2D.Double {
        CoordinateFlagSet flags;

        public GlyphCoordinate(double x, double y, CoordinateFlagSet flags) {
            super(x, y);
            this.flags = flags;
        }

        public boolean isOnCurve() {
            return this.flags.contains((Object)CoordinateFlagType.ON_CURVE);
        }
    }
}

