/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype.TtfInstructions;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.mabb.fontverter.opentype.OpenTypeFont;
import org.mabb.fontverter.opentype.TtfInstructions.InstructionStack;
import org.mabb.fontverter.opentype.TtfInstructions.TtfFunction;
import org.mabb.fontverter.opentype.TtfInstructions.TtfGraphicsState;
import org.mabb.fontverter.opentype.TtfInstructions.TtfInstructionVisitor;
import org.mabb.fontverter.opentype.TtfInstructions.instructions.TtfInstruction;
import org.mabb.fontverter.opentype.TtfInstructions.instructions.control.ElseInstruction;
import org.mabb.fontverter.opentype.TtfInstructions.instructions.control.EndFunctionInstruction;
import org.mabb.fontverter.opentype.TtfInstructions.instructions.control.EndIfInstruction;
import org.mabb.fontverter.opentype.TtfInstructions.instructions.control.FunctionDefInstruction;
import org.mabb.fontverter.opentype.TtfInstructions.instructions.control.IfInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtfVirtualMachine
implements TtfInstructionVisitor {
    private static final Logger log = LoggerFactory.getLogger(TtfVirtualMachine.class);
    public int jumpOffset = 0;
    private OpenTypeFont font;
    private InstructionStack stack;
    private Stack<IfInstruction> ifStack = new Stack();
    private int discardIf = 0;
    private TtfFunction functionOn;
    private Map<Integer, TtfFunction> functions = new HashMap<Integer, TtfFunction>();
    private Integer loopVar = 1;
    private TtfGraphicsState graphicsState;
    private Long[] storageArea;
    private boolean hasFpgmRun = false;
    private boolean onFpgm;

    public TtfVirtualMachine(OpenTypeFont font) {
        this.font = font;
        this.initialize();
    }

    public void execute(List<TtfInstruction> instructions) throws IOException {
        this.executeFpgmInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            TtfInstruction instructionOn = instructions.get(i);
            try {
                this.execute(instructionOn);
            }
            catch (Exception ex) {
                throw new TtfVmRuntimeException(String.format("Error on instruction #%d type: %s Message: %s", i, instructionOn.toString(), ex.getMessage()), ex);
            }
            if (this.jumpOffset <= 0) continue;
            i += this.jumpOffset - 1;
            this.jumpOffset = 0;
        }
    }

    private void initialize() {
        this.stack = new InstructionStack();
        this.graphicsState = new TtfGraphicsState();
        this.graphicsState.initialize(this.font);
        if (this.font != null && this.font.getMxap() != null) {
            this.storageArea = new Long[this.font.getMxap().getMaxStorage()];
        }
    }

    private void executeFpgmInstructions() throws IOException {
        if (this.hasFpgmRun) {
            return;
        }
        this.onFpgm = true;
        this.hasFpgmRun = true;
        if (this.font != null && this.font.getFpgmTable() != null) {
            this.execute(this.font.getFpgmTable().getInstructions());
        }
        this.onFpgm = false;
    }

    public void execute(TtfInstruction instruction) throws IOException {
        instruction.vm = this;
        if (this.functionOn == null || instruction instanceof EndFunctionInstruction) {
            instruction.accept(this);
        } else {
            this.functionOn.addInstruction(instruction);
        }
    }

    @Override
    public void visitGeneric(TtfInstruction instruction) throws IOException {
        if (!this.shouldExecuteBranch()) {
            return;
        }
        instruction.execute(this.stack);
    }

    @Override
    public void visit(IfInstruction instruction) throws IOException {
        if (!this.shouldExecuteBranch()) {
            ++this.discardIf;
            return;
        }
        instruction.execute(this.stack);
        this.ifStack.push(instruction);
    }

    @Override
    public void visit(ElseInstruction instruction) throws IOException {
        if (this.ifStack.size() == 0) {
            throw new TtfVmRuntimeException("Else with no matching If!!");
        }
        this.ifStack.peek().shouldExecute = !this.ifStack.peek().shouldExecute;
    }

    @Override
    public void visit(EndIfInstruction instruction) throws IOException {
        if (this.discardIf > 0) {
            --this.discardIf;
            return;
        }
        if (this.ifStack.size() == 0) {
            throw new TtfVmRuntimeException("End If with no matching If!!");
        }
        this.ifStack.pop();
    }

    @Override
    public void visit(FunctionDefInstruction instruction) throws IOException {
        instruction.execute(this.stack);
        this.functionOn = new TtfFunction();
        this.functions.put(instruction.getFunctionId(), this.functionOn);
    }

    @Override
    public void visit(EndFunctionInstruction instruction) throws IOException {
        if (this.functionOn == null) {
            throw new TtfVmRuntimeException("End function with no matching func def start!!");
        }
        this.functionOn = null;
    }

    public boolean shouldExecuteBranch() {
        if (this.ifStack.size() == 0) {
            return true;
        }
        return ((IfInstruction)this.ifStack.get((int)(this.ifStack.size() - 1))).shouldExecute;
    }

    public TtfFunction getFunction(Integer function) {
        return this.functions.get(function);
    }

    InstructionStack getStack() {
        return this.stack;
    }

    public OpenTypeFont getFont() {
        return this.font;
    }

    public TtfGraphicsState getGraphicsState() {
        return this.graphicsState;
    }

    public Long getStorageAreaValue(Long index) {
        if (index > (long)this.storageArea.length) {
            log.error(String.format("Referenced Storage Value at Index: %d does not exist.", index));
            return 1L;
        }
        return this.storageArea[index.intValue()];
    }

    public void setStorageAreaValue(Long index, Long value) {
        if (index > (long)this.storageArea.length) {
            log.error(String.format("Referenced Storage Value at Index: %d does not exist.", index));
            return;
        }
        this.storageArea[index.intValue()] = value;
    }

    public void setLoopVar(Integer loopVar) {
        this.loopVar = loopVar;
    }

    public Integer getLoopVar() {
        return this.loopVar;
    }

    public static class TtfVmRuntimeException
    extends IOException {
        public TtfVmRuntimeException(String message) {
            super(message);
        }

        public TtfVmRuntimeException(String message, Exception ex) {
            super(message, ex);
        }
    }
}

