/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.dm;

import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbNClob;
import java.io.BufferedReader;
import java.io.InputStream;
import org.anyline.adapter.DataReader;
import org.anyline.util.BeanUtil;

public enum DMReader {
    DmdbNClobReader(new Object[]{DmdbNClob.class}, new DataReader(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object read(Object value) {
            if (value instanceof DmdbNClob) {
                DmdbNClob clob = (DmdbNClob)value;
                if (clob.length == -1L) {
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(clob.getCharacterStream());
                        StringBuilder builder = new StringBuilder();
                        String line = reader.readLine();
                        if (null != line) {
                            builder.append(line);
                            while ((line = reader.readLine()) != null) {
                                builder.append("\n").append(line);
                            }
                        }
                        value = builder.toString();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (null != reader) {
                            try {
                                reader.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    value = clob.data;
                }
            }
            return value;
        }
    }),
    DmdbBlobReader(new Object[]{DmdbBlob.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof DmdbBlob) {
                DmdbBlob blob = (DmdbBlob)value;
                if (blob.length == -1L) {
                    try {
                        value = BeanUtil.stream2bytes((InputStream)blob.getBinaryStream());
                    }
                    catch (Exception exception) {}
                } else {
                    value = blob.data;
                }
            }
            return value;
        }
    }),
    DmdbClobReader(new Object[]{DmdbClob.class}, new DataReader(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object read(Object value) {
            if (value instanceof DmdbClob) {
                DmdbClob clob = (DmdbClob)value;
                if (clob.length == -1L) {
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(clob.getCharacterStream());
                        StringBuilder builder = new StringBuilder();
                        String line = reader.readLine();
                        if (null != line) {
                            builder.append(line);
                            while ((line = reader.readLine()) != null) {
                                builder.append("\n").append(line);
                            }
                        }
                        value = builder.toString();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (null != reader) {
                            try {
                                reader.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    value = clob.data;
                }
            }
            return value;
        }
    });

    private final Object[] supports;
    private final DataReader reader;

    public Object[] supports() {
        return this.supports;
    }

    public DataReader reader() {
        return this.reader;
    }

    private DMReader(Object[] supports, DataReader reader) {
        this.supports = supports;
        this.reader = reader;
    }
}

