/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.oracle;

import org.anyline.annotation.Component;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.oracle.OracleAdapter;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.regular.RegularUtil;

@Component(value="anyline.data.jdbc.adapter.oracle11")
public class Oracle11Adapter
extends OracleAdapter
implements JDBCAdapter {
    @Override
    public String version() {
        return "11";
    }

    @Override
    public boolean match(DataRuntime runtime, String feature, String adapterKey, boolean compensate) {
        String version;
        boolean chk = super.exeMatch(runtime, feature, adapterKey, compensate);
        if (chk && null != (version = runtime.getVersion())) {
            double v;
            version = version.toLowerCase();
            if (null != (version = RegularUtil.cut((String)version, (String[])new String[]{"release", " ", " "}))) {
                version = version.split("\\.")[0];
            }
            if (ConfigTable.IS_LOG_ADAPTER_MATCH) {
                log.debug("[adapter match][Oracle\u7248\u672c\u68c0\u6d4b][result:{}][runtime version:{}][adapter:{}]", new Object[]{false, version, ((Object)((Object)this)).getClass()});
            }
            if ((v = BasicUtil.parseDouble((Object)version, (Double)0.0).doubleValue()) < 12.0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return super.pageRowNum(runtime, run);
    }
}

