/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.oracle;

import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.anyline.adapter.DataReader;

public enum OracleReader {
    ClobReader(new Object[]{CLOB.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof CLOB) {
                try {
                    value = ((CLOB)value).stringValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return value;
        }
    }),
    BlobReader(new Object[]{BLOB.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof BLOB) {
                try {
                    value = ((BLOB)value).getBytes();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return value;
        }
    });

    private final Object[] supports;
    private final DataReader reader;

    public Object[] supports() {
        return this.supports;
    }

    public DataReader reader() {
        return this.reader;
    }

    private OracleReader(Object[] supports, DataReader reader) {
        this.supports = supports;
        this.reader = reader;
    }
}

