/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.dictionary.service.DictionaryServiceProvider;
import org.apache.carbondata.core.keygenerator.KeyGenerator;
import org.apache.carbondata.core.keygenerator.factory.KeyGeneratorFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.BucketingInfo;
import org.apache.carbondata.core.metadata.schema.SortColumnRangeInfo;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.DictionaryCardinalityFinder;

public class CarbonDataLoadConfiguration {
    private DataField[] dataFields;
    private AbsoluteTableIdentifier tableIdentifier;
    private String[] header;
    private String segmentId;
    private String taskNo;
    private BucketingInfo bucketingInfo;
    private Map<String, Object> dataLoadProperties = new HashMap<String, Object>();
    private boolean useOnePass;
    private String dictionaryServerHost;
    private int dictionaryServerPort;
    private String dictionaryServerSecretKey;
    private DictionaryServiceProvider dictionaryServiceProvider;
    private Boolean dictionaryEncryptServerSecure;
    private boolean preFetch;
    private int dimensionCount;
    private int measureCount;
    private int noDictionaryCount;
    private int complexDictionaryColumnCount;
    private int complexNonDictionaryColumnCount;
    private long schemaUpdatedTimeStamp;
    private DictionaryCardinalityFinder cardinalityFinder;
    private int numberOfSortColumns;
    private int numberOfNoDictSortColumns;
    private TableSpec tableSpec;
    private short writingCoresCount;
    private SortColumnRangeInfo sortColumnRangeInfo;
    private boolean carbonTransactionalTable;
    private String dataWritePath;
    private String parentTablePath;
    private String columnCompressor;

    public String getParentTablePath() {
        return this.parentTablePath;
    }

    public void setParentTablePath(String parentTablePath) {
        this.parentTablePath = parentTablePath;
    }

    public void setDataFields(DataField[] dataFields) {
        this.dataFields = dataFields;
        for (DataField dataField : dataFields) {
            CarbonColumn column = dataField.getColumn();
            if (column.isDimension().booleanValue()) {
                ++this.dimensionCount;
                if (column.isComplex().booleanValue()) {
                    if (!dataField.hasDictionaryEncoding()) {
                        ++this.complexNonDictionaryColumnCount;
                    } else {
                        ++this.complexDictionaryColumnCount;
                    }
                } else if (!dataField.hasDictionaryEncoding()) {
                    ++this.noDictionaryCount;
                }
            }
            if (!column.isMeasure().booleanValue()) continue;
            ++this.measureCount;
        }
    }

    public DataField[] getDataFields() {
        return this.dataFields;
    }

    public int getDimensionCount() {
        return this.dimensionCount;
    }

    public int getNoDictionaryCount() {
        return this.noDictionaryCount;
    }

    public int getComplexDictionaryColumnCount() {
        return this.complexDictionaryColumnCount;
    }

    public int getMeasureCount() {
        return this.measureCount;
    }

    public void setNumberOfSortColumns(int numberOfSortColumns) {
        this.numberOfSortColumns = numberOfSortColumns;
    }

    public int getNumberOfSortColumns() {
        return this.numberOfSortColumns;
    }

    public boolean isSortTable() {
        return this.numberOfSortColumns > 0;
    }

    public void setNumberOfNoDictSortColumns(int numberOfNoDictSortColumns) {
        this.numberOfNoDictSortColumns = numberOfNoDictSortColumns;
    }

    public int getNumberOfNoDictSortColumns() {
        return this.numberOfNoDictSortColumns;
    }

    public String[] getHeader() {
        return this.header;
    }

    public void setHeader(String[] header) {
        this.header = header;
    }

    public AbsoluteTableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public void setTableIdentifier(AbsoluteTableIdentifier tableIdentifier) {
        this.tableIdentifier = tableIdentifier;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public String getTaskNo() {
        return this.taskNo;
    }

    public void setTaskNo(String taskNo) {
        this.taskNo = taskNo;
    }

    public void setDataLoadProperty(String key, Object value) {
        this.dataLoadProperties.put(key, value);
    }

    public Object getDataLoadProperty(String key) {
        return this.dataLoadProperties.get(key);
    }

    public BucketingInfo getBucketingInfo() {
        return this.bucketingInfo;
    }

    public void setBucketingInfo(BucketingInfo bucketingInfo) {
        this.bucketingInfo = bucketingInfo;
    }

    public boolean getUseOnePass() {
        return this.useOnePass;
    }

    public void setUseOnePass(boolean useOnePass) {
        this.useOnePass = useOnePass;
    }

    public String getDictionaryServerHost() {
        return this.dictionaryServerHost;
    }

    public void setDictionaryServerHost(String dictionaryServerHost) {
        this.dictionaryServerHost = dictionaryServerHost;
    }

    public int getDictionaryServerPort() {
        return this.dictionaryServerPort;
    }

    public void setDictionaryServerPort(int dictionaryServerPort) {
        this.dictionaryServerPort = dictionaryServerPort;
    }

    public String getDictionaryServerSecretKey() {
        return this.dictionaryServerSecretKey;
    }

    public void setDictionaryServerSecretKey(String dictionaryServerSecretKey) {
        this.dictionaryServerSecretKey = dictionaryServerSecretKey;
    }

    public DictionaryServiceProvider getDictionaryServiceProvider() {
        return this.dictionaryServiceProvider;
    }

    public void setDictionaryServiceProvider(DictionaryServiceProvider dictionaryServiceProvider) {
        this.dictionaryServiceProvider = dictionaryServiceProvider;
    }

    public Boolean getDictionaryEncryptServerSecure() {
        return this.dictionaryEncryptServerSecure;
    }

    public void setDictionaryEncryptServerSecure(Boolean dictionaryEncryptServerSecure) {
        this.dictionaryEncryptServerSecure = dictionaryEncryptServerSecure;
    }

    public boolean isPreFetch() {
        return this.preFetch;
    }

    public void setPreFetch(boolean preFetch) {
        this.preFetch = preFetch;
    }

    public long getSchemaUpdatedTimeStamp() {
        return this.schemaUpdatedTimeStamp;
    }

    public void setSchemaUpdatedTimeStamp(long schemaUpdatedTimeStamp) {
        this.schemaUpdatedTimeStamp = schemaUpdatedTimeStamp;
    }

    public DictionaryCardinalityFinder getCardinalityFinder() {
        return this.cardinalityFinder;
    }

    public void setCardinalityFinder(DictionaryCardinalityFinder cardinalityFinder) {
        this.cardinalityFinder = cardinalityFinder;
    }

    public DataType[] getMeasureDataType() {
        ArrayList<Integer> measureIndexes = new ArrayList<Integer>(this.dataFields.length);
        int measureCount = 0;
        for (int i = 0; i < this.dataFields.length; ++i) {
            if (this.dataFields[i].getColumn().isDimension().booleanValue()) continue;
            measureIndexes.add(i);
            ++measureCount;
        }
        DataType[] type = new DataType[measureCount];
        for (int i = 0; i < type.length; ++i) {
            type[i] = this.dataFields[(Integer)measureIndexes.get(i)].getColumn().getDataType();
        }
        return type;
    }

    public CarbonColumn[] getNoDictAndComplexDimensions() {
        ArrayList<Integer> noDicOrCompIndexes = new ArrayList<Integer>(this.dataFields.length);
        int noDicCount = 0;
        for (int i = 0; i < this.dataFields.length; ++i) {
            if (!this.dataFields[i].getColumn().isDimension().booleanValue() || this.dataFields[i].getColumn().hasEncoding(Encoding.DICTIONARY) && !this.dataFields[i].getColumn().isComplex().booleanValue()) continue;
            noDicOrCompIndexes.add(i);
            ++noDicCount;
        }
        CarbonColumn[] dims = new CarbonColumn[noDicCount];
        for (int i = 0; i < dims.length; ++i) {
            dims[i] = this.dataFields[(Integer)noDicOrCompIndexes.get(i)].getColumn();
        }
        return dims;
    }

    public boolean[] getSortColumnMapping() {
        boolean[] sortColumnMapping = new boolean[this.dataFields.length];
        for (int i = 0; i < sortColumnMapping.length; ++i) {
            if (!this.dataFields[i].getColumn().getColumnSchema().isSortColumn()) continue;
            sortColumnMapping[i] = true;
        }
        return sortColumnMapping;
    }

    public int[] calcDimensionLengths() {
        int[] dimLensWithComplex = this.getCardinalityFinder().getCardinality();
        if (!this.isSortTable()) {
            for (int i = 0; i < dimLensWithComplex.length; ++i) {
                if (dimLensWithComplex[i] == 0) continue;
                dimLensWithComplex[i] = Integer.MAX_VALUE;
            }
        }
        ArrayList<Integer> dimsLenList = new ArrayList<Integer>();
        for (int eachDimLen : dimLensWithComplex) {
            if (eachDimLen == 0) continue;
            dimsLenList.add(eachDimLen);
        }
        int[] dimLens = new int[dimsLenList.size()];
        for (int i = 0; i < dimsLenList.size(); ++i) {
            dimLens[i] = (Integer)dimsLenList.get(i);
        }
        return dimLens;
    }

    public KeyGenerator[] createKeyGeneratorForComplexDimension() {
        int[] dimLens = this.calcDimensionLengths();
        KeyGenerator[] complexKeyGenerators = new KeyGenerator[dimLens.length];
        for (int i = 0; i < dimLens.length; ++i) {
            complexKeyGenerators[i] = KeyGeneratorFactory.getKeyGenerator((int[])new int[]{dimLens[i]});
        }
        return complexKeyGenerators;
    }

    public TableSpec getTableSpec() {
        return this.tableSpec;
    }

    public void setTableSpec(TableSpec tableSpec) {
        this.tableSpec = tableSpec;
    }

    public short getWritingCoresCount() {
        return this.writingCoresCount;
    }

    public void setWritingCoresCount(short writingCoresCount) {
        this.writingCoresCount = writingCoresCount;
    }

    public String getDataWritePath() {
        return this.dataWritePath;
    }

    public void setDataWritePath(String dataWritePath) {
        this.dataWritePath = dataWritePath;
    }

    public SortColumnRangeInfo getSortColumnRangeInfo() {
        return this.sortColumnRangeInfo;
    }

    public void setSortColumnRangeInfo(SortColumnRangeInfo sortColumnRangeInfo) {
        this.sortColumnRangeInfo = sortColumnRangeInfo;
    }

    public boolean isCarbonTransactionalTable() {
        return this.carbonTransactionalTable;
    }

    public void setCarbonTransactionalTable(boolean carbonTransactionalTable) {
        this.carbonTransactionalTable = carbonTransactionalTable;
    }

    public int getComplexNonDictionaryColumnCount() {
        return this.complexNonDictionaryColumnCount;
    }

    public String getColumnCompressor() {
        return this.columnCompressor;
    }

    public void setColumnCompressor(String columnCompressor) {
        this.columnCompressor = columnCompressor;
    }
}

