/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.SortColumnRangeInfo;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.processing.loading.AbstractDataLoadProcessorStep;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.loading.sort.SortScopeOptions;
import org.apache.carbondata.processing.loading.steps.CarbonRowDataWriterProcessorStepImpl;
import org.apache.carbondata.processing.loading.steps.DataConverterProcessorStepImpl;
import org.apache.carbondata.processing.loading.steps.DataWriterBatchProcessorStepImpl;
import org.apache.carbondata.processing.loading.steps.DataWriterProcessorStepImpl;
import org.apache.carbondata.processing.loading.steps.InputProcessorStepImpl;
import org.apache.carbondata.processing.loading.steps.InputProcessorStepWithNoConverterImpl;
import org.apache.carbondata.processing.loading.steps.JsonInputProcessorStepImpl;
import org.apache.carbondata.processing.loading.steps.SortProcessorStepImpl;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.commons.lang3.StringUtils;

public final class DataLoadProcessBuilder {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)DataLoadProcessBuilder.class.getName());

    public AbstractDataLoadProcessorStep build(CarbonLoadModel loadModel, String[] storeLocation, CarbonIterator[] inputIterators) throws Exception {
        CarbonDataLoadConfiguration configuration = DataLoadProcessBuilder.createConfiguration(loadModel, storeLocation);
        SortScopeOptions.SortScope sortScope = CarbonDataProcessorUtil.getSortScope(configuration);
        if (loadModel.isLoadWithoutConverterStep()) {
            return this.buildInternalWithNoConverter(inputIterators, configuration, sortScope);
        }
        if (loadModel.isJsonFileLoad()) {
            return this.buildInternalWithJsonInputProcessor(inputIterators, configuration, sortScope);
        }
        if (!configuration.isSortTable() || sortScope.equals((Object)SortScopeOptions.SortScope.NO_SORT)) {
            return this.buildInternalForNoSort(inputIterators, configuration);
        }
        if (configuration.getBucketingInfo() != null) {
            return this.buildInternalForBucketing(inputIterators, configuration);
        }
        if (sortScope.equals((Object)SortScopeOptions.SortScope.BATCH_SORT)) {
            return this.buildInternalForBatchSort(inputIterators, configuration);
        }
        return this.buildInternal(inputIterators, configuration);
    }

    private AbstractDataLoadProcessorStep buildInternal(CarbonIterator[] inputIterators, CarbonDataLoadConfiguration configuration) {
        InputProcessorStepImpl inputProcessorStep = new InputProcessorStepImpl(configuration, inputIterators);
        DataConverterProcessorStepImpl converterProcessorStep = new DataConverterProcessorStepImpl(configuration, inputProcessorStep);
        SortProcessorStepImpl sortProcessorStep = new SortProcessorStepImpl(configuration, converterProcessorStep);
        return new DataWriterProcessorStepImpl(configuration, sortProcessorStep);
    }

    private AbstractDataLoadProcessorStep buildInternalForNoSort(CarbonIterator[] inputIterators, CarbonDataLoadConfiguration configuration) {
        InputProcessorStepImpl inputProcessorStep = new InputProcessorStepImpl(configuration, inputIterators);
        DataConverterProcessorStepImpl converterProcessorStep = new DataConverterProcessorStepImpl(configuration, inputProcessorStep);
        return new CarbonRowDataWriterProcessorStepImpl(configuration, converterProcessorStep);
    }

    private AbstractDataLoadProcessorStep buildInternalWithNoConverter(CarbonIterator[] inputIterators, CarbonDataLoadConfiguration configuration, SortScopeOptions.SortScope sortScope) {
        InputProcessorStepWithNoConverterImpl inputProcessorStep = new InputProcessorStepWithNoConverterImpl(configuration, inputIterators);
        if (sortScope.equals((Object)SortScopeOptions.SortScope.LOCAL_SORT)) {
            SortProcessorStepImpl sortProcessorStep = new SortProcessorStepImpl(configuration, inputProcessorStep);
            return new DataWriterProcessorStepImpl(configuration, sortProcessorStep);
        }
        if (sortScope.equals((Object)SortScopeOptions.SortScope.BATCH_SORT)) {
            SortProcessorStepImpl sortProcessorStep = new SortProcessorStepImpl(configuration, inputProcessorStep);
            return new DataWriterBatchProcessorStepImpl(configuration, sortProcessorStep);
        }
        return new CarbonRowDataWriterProcessorStepImpl(configuration, inputProcessorStep);
    }

    private AbstractDataLoadProcessorStep buildInternalWithJsonInputProcessor(CarbonIterator[] inputIterators, CarbonDataLoadConfiguration configuration, SortScopeOptions.SortScope sortScope) {
        JsonInputProcessorStepImpl inputProcessorStep = new JsonInputProcessorStepImpl(configuration, inputIterators);
        DataConverterProcessorStepImpl converterProcessorStep = new DataConverterProcessorStepImpl(configuration, inputProcessorStep);
        if (sortScope.equals((Object)SortScopeOptions.SortScope.LOCAL_SORT)) {
            SortProcessorStepImpl sortProcessorStep = new SortProcessorStepImpl(configuration, converterProcessorStep);
            return new DataWriterProcessorStepImpl(configuration, sortProcessorStep);
        }
        if (sortScope.equals((Object)SortScopeOptions.SortScope.BATCH_SORT)) {
            SortProcessorStepImpl sortProcessorStep = new SortProcessorStepImpl(configuration, converterProcessorStep);
            return new DataWriterBatchProcessorStepImpl(configuration, sortProcessorStep);
        }
        return new CarbonRowDataWriterProcessorStepImpl(configuration, converterProcessorStep);
    }

    private AbstractDataLoadProcessorStep buildInternalForBatchSort(CarbonIterator[] inputIterators, CarbonDataLoadConfiguration configuration) {
        InputProcessorStepImpl inputProcessorStep = new InputProcessorStepImpl(configuration, inputIterators);
        DataConverterProcessorStepImpl converterProcessorStep = new DataConverterProcessorStepImpl(configuration, inputProcessorStep);
        SortProcessorStepImpl sortProcessorStep = new SortProcessorStepImpl(configuration, converterProcessorStep);
        return new DataWriterBatchProcessorStepImpl(configuration, sortProcessorStep);
    }

    private AbstractDataLoadProcessorStep buildInternalForBucketing(CarbonIterator[] inputIterators, CarbonDataLoadConfiguration configuration) throws Exception {
        InputProcessorStepImpl inputProcessorStep = new InputProcessorStepImpl(configuration, inputIterators);
        DataConverterProcessorStepImpl converterProcessorStep = new DataConverterProcessorStepImpl(configuration, inputProcessorStep);
        SortProcessorStepImpl sortProcessorStep = new SortProcessorStepImpl(configuration, converterProcessorStep);
        return new DataWriterProcessorStepImpl(configuration, sortProcessorStep);
    }

    public static CarbonDataLoadConfiguration createConfiguration(CarbonLoadModel loadModel, String[] storeLocation) {
        CarbonDataProcessorUtil.createLocations(storeLocation);
        String databaseName = loadModel.getDatabaseName();
        String tableName = loadModel.getTableName();
        String tempLocationKey = CarbonDataProcessorUtil.getTempStoreLocationKey(databaseName, tableName, loadModel.getSegmentId(), loadModel.getTaskNo(), false, false);
        CarbonProperties.getInstance().addProperty(tempLocationKey, StringUtils.join((Object[])storeLocation, (String)File.pathSeparator));
        return DataLoadProcessBuilder.createConfiguration(loadModel);
    }

    public static CarbonDataLoadConfiguration createConfiguration(CarbonLoadModel loadModel) {
        CarbonDataLoadConfiguration configuration = new CarbonDataLoadConfiguration();
        CarbonTable carbonTable = loadModel.getCarbonDataLoadSchema().getCarbonTable();
        AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
        configuration.setParentTablePath(loadModel.getParentTablePath());
        configuration.setTableIdentifier(identifier);
        configuration.setCarbonTransactionalTable(loadModel.isCarbonTransactionalTable());
        configuration.setSchemaUpdatedTimeStamp(carbonTable.getTableLastUpdatedTime());
        configuration.setHeader(loadModel.getCsvHeaderColumns());
        configuration.setSegmentId(loadModel.getSegmentId());
        configuration.setTaskNo(loadModel.getTaskNo());
        configuration.setDataLoadProperty("COMPLEX_DELIMITERS", new String[]{loadModel.getComplexDelimiterLevel1(), loadModel.getComplexDelimiterLevel2()});
        configuration.setDataLoadProperty("SERIALIZATION_NULL_FORMAT", loadModel.getSerializationNullFormat().split(",")[1]);
        configuration.setDataLoadProperty("FACT_TIME_STAMP", loadModel.getFactTimeStamp());
        configuration.setDataLoadProperty("BAD_RECORDS_LOGGER_ENABLE", loadModel.getBadRecordsLoggerEnable().split(",")[1]);
        configuration.setDataLoadProperty("BAD_RECORDS_LOGGER_ACTION", loadModel.getBadRecordsAction().split(",")[1]);
        configuration.setDataLoadProperty("IS_EMPTY_DATA_BAD_RECORD", loadModel.getIsEmptyDataBadRecord().split(",")[1]);
        configuration.setDataLoadProperty("SKIP_EMPTY_LINE", loadModel.getSkipEmptyLine());
        configuration.setDataLoadProperty("FACT_FILE_PATH", loadModel.getFactFilePath());
        configuration.setParentTablePath(loadModel.getParentTablePath());
        configuration.setDataLoadProperty("carbon.load.sort.scope", loadModel.getSortScope());
        configuration.setDataLoadProperty("carbon.load.batch.sort.size.inmb", loadModel.getBatchSortSizeInMb());
        configuration.setDataLoadProperty("carbon.load.global.sort.partitions", loadModel.getGlobalSortPartitions());
        configuration.setDataLoadProperty("carbon.options.bad.record.path", loadModel.getBadRecordsLocation());
        CarbonMetadata.getInstance().addCarbonTable(carbonTable);
        List dimensions = carbonTable.getDimensionByTableName(carbonTable.getTableName());
        List measures = carbonTable.getMeasureByTableName(carbonTable.getTableName());
        ArrayList<DataField> dataFields = new ArrayList<DataField>();
        ArrayList<DataField> complexDataFields = new ArrayList<DataField>();
        for (CarbonColumn column : dimensions) {
            DataField dataField = new DataField(column);
            if (column.getDataType() == DataTypes.DATE) {
                dataField.setDateFormat(loadModel.getDateFormat());
                column.setDateFormat(loadModel.getDateFormat());
            } else if (column.getDataType() == DataTypes.TIMESTAMP) {
                dataField.setTimestampFormat(loadModel.getTimestampformat());
                column.setTimestampFormat(loadModel.getTimestampformat());
            }
            if (column.isComplex().booleanValue()) {
                complexDataFields.add(dataField);
                List childDimensions = ((CarbonDimension)dataField.getColumn()).getListOfChildDimensions();
                for (CarbonDimension childDimension : childDimensions) {
                    if (childDimension.getDataType() == DataTypes.DATE) {
                        childDimension.setDateFormat(loadModel.getDateFormat());
                        continue;
                    }
                    if (childDimension.getDataType() != DataTypes.TIMESTAMP) continue;
                    childDimension.setTimestampFormat(loadModel.getTimestampformat());
                }
                continue;
            }
            dataFields.add(dataField);
        }
        dataFields.addAll(complexDataFields);
        for (CarbonColumn column : measures) {
            if (column.getColName().equals("default_dummy_measure")) continue;
            dataFields.add(new DataField(column));
        }
        configuration.setDataFields(dataFields.toArray(new DataField[dataFields.size()]));
        configuration.setBucketingInfo(carbonTable.getBucketingInfo(carbonTable.getTableName()));
        configuration.setUseOnePass(loadModel.getUseOnePass());
        configuration.setDictionaryServerHost(loadModel.getDictionaryServerHost());
        configuration.setDictionaryServerPort(loadModel.getDictionaryServerPort());
        configuration.setDictionaryServerSecretKey(loadModel.getDictionaryServerSecretKey());
        configuration.setDictionaryEncryptServerSecure(loadModel.getDictionaryEncryptServerSecure());
        configuration.setDictionaryServiceProvider(loadModel.getDictionaryServiceProvider());
        configuration.setPreFetch(loadModel.isPreFetch());
        configuration.setNumberOfSortColumns(carbonTable.getNumberOfSortColumns());
        configuration.setNumberOfNoDictSortColumns(carbonTable.getNumberOfNoDictSortColumns());
        configuration.setDataWritePath(loadModel.getDataWritePath());
        DataLoadProcessBuilder.setSortColumnInfo(carbonTable, loadModel, configuration);
        if (carbonTable.isHivePartitionTable()) {
            configuration.setWritingCoresCount((short)1);
        }
        TableSpec tableSpec = new TableSpec(carbonTable);
        configuration.setTableSpec(tableSpec);
        if (loadModel.getSdkWriterCores() > 0) {
            configuration.setWritingCoresCount(loadModel.getSdkWriterCores());
        }
        configuration.setColumnCompressor(loadModel.getColumnCompressor());
        return configuration;
    }

    private static void setSortColumnInfo(CarbonTable carbonTable, CarbonLoadModel loadModel, CarbonDataLoadConfiguration configuration) {
        String[] sortColumnBounds;
        List sortCols = carbonTable.getSortColumns(carbonTable.getTableName());
        SortScopeOptions.SortScope sortScope = SortScopeOptions.getSortScope(loadModel.getSortScope());
        if (!SortScopeOptions.SortScope.LOCAL_SORT.equals((Object)sortScope) || sortCols.size() == 0 || StringUtils.isBlank((CharSequence)loadModel.getSortColumnsBoundsStr())) {
            if (!StringUtils.isBlank((CharSequence)loadModel.getSortColumnsBoundsStr())) {
                LOGGER.warn("sort column bounds will be ignored");
            }
            configuration.setSortColumnRangeInfo(null);
            return;
        }
        int[] sortColIndex = new int[sortCols.size()];
        boolean[] isSortColNoDict = new boolean[sortCols.size()];
        DataField[] outFields = configuration.getDataFields();
        int j = 0;
        for (String[] sortCol : sortCols) {
            boolean columnExist = false;
            for (int i = 0; !columnExist && i < outFields.length; ++i) {
                if (!outFields[i].getColumn().getColName().equalsIgnoreCase((String)sortCol)) continue;
                columnExist = true;
                sortColIndex[j] = i;
                isSortColNoDict[j] = !outFields[i].hasDictionaryEncoding();
                ++j;
            }
            if (columnExist) continue;
            throw new CarbonDataLoadingException("Field " + (String)sortCol + " does not exist.");
        }
        for (String bound : sortColumnBounds = StringUtils.splitPreserveAllTokens((String)loadModel.getSortColumnsBoundsStr(), (String)";", (int)-1)) {
            String[] fieldInBounds = StringUtils.splitPreserveAllTokens((String)bound, (String)",", (int)-1);
            if (fieldInBounds.length == sortCols.size()) continue;
            String msg = "The number of field in bounds should be equal to that in sort columns." + " Expected " + sortCols.size() + ", actual " + String.valueOf(fieldInBounds.length) + "." + " The illegal bound is '" + bound + "'.";
            throw new CarbonDataLoadingException(msg);
        }
        SortColumnRangeInfo sortColumnRangeInfo = new SortColumnRangeInfo(sortColIndex, isSortColNoDict, sortColumnBounds, ",");
        configuration.setSortColumnRangeInfo(sortColumnRangeInfo);
    }
}

