/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.converter.impl;

import java.util.List;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.impl.AbstractDictionaryFieldConverterImpl;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class DirectDictionaryFieldConverterImpl
extends AbstractDictionaryFieldConverterImpl {
    private DirectDictionaryGenerator directDictionaryGenerator;
    private int index;
    private String nullFormat;
    private CarbonColumn column;
    private boolean isEmptyBadRecord;

    public DirectDictionaryFieldConverterImpl(DataField dataField, String nullFormat, int index, boolean isEmptyBadRecord) {
        this.nullFormat = nullFormat;
        this.column = dataField.getColumn();
        this.directDictionaryGenerator = dataField.getColumn().getDataType() == DataTypes.DATE && dataField.getDateFormat() != null && !dataField.getDateFormat().isEmpty() ? DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)dataField.getColumn().getDataType(), (String)dataField.getDateFormat()) : (dataField.getColumn().getDataType() == DataTypes.TIMESTAMP && dataField.getTimestampFormat() != null && !dataField.getTimestampFormat().isEmpty() ? DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)dataField.getColumn().getDataType(), (String)dataField.getTimestampFormat()) : DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)dataField.getColumn().getDataType()));
        this.index = index;
        this.isEmptyBadRecord = isEmptyBadRecord;
    }

    @Override
    public void convert(CarbonRow row, BadRecordLogHolder logHolder) {
        String value = row.getString(this.index);
        row.update(this.convert(value, logHolder), this.index);
    }

    @Override
    public Object convert(Object value, BadRecordLogHolder logHolder) throws RuntimeException {
        String literalValue = (String)value;
        if (literalValue == null) {
            logHolder.setReason(CarbonDataProcessorUtil.prepareFailureReason(this.column.getColName(), this.column.getDataType()));
            return 1;
        }
        if (literalValue.equals(this.nullFormat)) {
            return 1;
        }
        int key = this.directDictionaryGenerator.generateDirectSurrogateKey(literalValue);
        if (key == 1 && (literalValue.length() > 0 || literalValue.length() == 0 && this.isEmptyBadRecord)) {
            String message = logHolder.getColumnMessageMap().get(this.column.getColName());
            if (null == message) {
                message = CarbonDataProcessorUtil.prepareFailureReason(this.column.getColName(), this.column.getDataType());
                logHolder.getColumnMessageMap().put(this.column.getColName(), message);
            }
            logHolder.setReason(message);
        }
        return key;
    }

    @Override
    public void clear() {
    }

    @Override
    public void fillColumnCardinality(List<Integer> cardinality) {
        cardinality.add(Integer.MAX_VALUE);
    }
}

