/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.jsoninput;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import org.apache.carbondata.processing.loading.jsoninput.JsonStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonInputFormat
extends FileInputFormat<LongWritable, Text> {
    private static JsonFactory factory = new JsonFactory();
    private static ObjectMapper mapper = new ObjectMapper(factory);
    public static final String ONE_RECORD_PER_LINE = "json.input.format.one.record.per.line";
    public static final String RECORD_IDENTIFIER = "json.input.format.record.identifier";

    public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        if (!JsonInputFormat.getOneRecordPerLine(context.getConfiguration())) {
            return new JsonRecordReader();
        }
        SimpleJsonRecordReader rdr = new SimpleJsonRecordReader();
        rdr.initialize(split, context);
        return rdr;
    }

    public static synchronized JsonNode decodeLineToJsonNode(String line) {
        try {
            return mapper.readTree(line);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void setOneRecordPerLine(Job job, boolean isOneRecordPerLine) {
        job.getConfiguration().setBoolean(ONE_RECORD_PER_LINE, isOneRecordPerLine);
    }

    public static boolean getOneRecordPerLine(Configuration conf) {
        return conf.getBoolean(ONE_RECORD_PER_LINE, false);
    }

    public static void setRecordIdentifier(Job job, String record) {
        job.getConfiguration().set(RECORD_IDENTIFIER, record);
    }

    public static String getRecordIdentifier(Configuration conf) {
        return conf.get(RECORD_IDENTIFIER);
    }

    public static class JsonRecordReader
    extends RecordReader<LongWritable, Text> {
        private Logger LOG = Logger.getLogger(JsonRecordReader.class);
        private JsonStreamReader rdr = null;
        private long start = 0L;
        private long end = 0L;
        private float toRead = 0.0f;
        private String identifier = null;
        private Logger log = Logger.getLogger(JsonRecordReader.class);
        private Text outJson = new Text();
        private LongWritable outKey = new LongWritable();

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.identifier = JsonInputFormat.getRecordIdentifier(context.getConfiguration());
            if (this.identifier == null || this.identifier.isEmpty()) {
                throw new InvalidParameterException("json.input.format.record.identifier is not set.");
            }
            this.LOG.info((Object)("Initializing JsonRecordReader with identifier " + this.identifier));
            FileSplit fSplit = (FileSplit)split;
            Path file = fSplit.getPath();
            this.log.info((Object)("File is " + file));
            this.start = fSplit.getStart();
            this.end = this.start + split.getLength();
            this.toRead = this.end - this.start;
            FSDataInputStream strm = FileSystem.get((Configuration)context.getConfiguration()).open(file);
            if (this.start != 0L) {
                strm.seek(this.start);
            }
            this.rdr = new JsonStreamReader(this.identifier, new BufferedInputStream((InputStream)strm));
        }

        public boolean nextKeyValue() throws IOException {
            boolean keepGoing;
            boolean retVal = false;
            do {
                keepGoing = false;
                String record = this.rdr.getJsonRecord();
                if (record == null) continue;
                if (JsonInputFormat.decodeLineToJsonNode(record) == null) {
                    keepGoing = true;
                    continue;
                }
                this.outJson.set(record);
                this.outKey.set(this.rdr.getBytesRead());
                retVal = true;
            } while (keepGoing);
            return retVal;
        }

        public void close() throws IOException {
            this.rdr.close();
        }

        public float getProgress() {
            return (float)this.rdr.getBytesRead() / this.toRead;
        }

        public LongWritable getCurrentKey() {
            return this.outKey;
        }

        public Text getCurrentValue() {
            return this.outJson;
        }
    }

    public static class SimpleJsonRecordReader
    extends RecordReader<LongWritable, Text> {
        private LineRecordReader reader = null;
        private LongWritable outKey = new LongWritable(0L);
        private Text outValue = new Text();

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
            this.reader = new LineRecordReader();
            this.reader.initialize(split, context);
        }

        public boolean nextKeyValue() throws IOException {
            if (this.reader.nextKeyValue()) {
                this.outValue.set(this.reader.getCurrentValue());
                this.outKey.set(this.reader.getCurrentKey().get());
                return true;
            }
            return false;
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return this.reader.getProgress();
        }

        public LongWritable getCurrentKey() {
            return this.outKey;
        }

        public Text getCurrentValue() {
            return this.outValue;
        }
    }
}

