/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.partition.impl;

import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.processing.loading.partition.Partitioner;

@InterfaceAudience.Internal
public class HashPartitionerImpl
implements Partitioner<CarbonRow> {
    private int numberOfBuckets;
    private Hash[] hashes;

    public HashPartitionerImpl(List<Integer> indexes, List<ColumnSchema> columnSchemas, int numberOfBuckets) {
        this.numberOfBuckets = numberOfBuckets;
        this.hashes = new Hash[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            DataType dataType = columnSchemas.get(i).getDataType();
            this.hashes[i] = dataType == DataTypes.SHORT || dataType == DataTypes.INT || dataType == DataTypes.LONG ? new IntegralHash(indexes.get(i)) : (dataType == DataTypes.DOUBLE || dataType == DataTypes.FLOAT || DataTypes.isDecimal((DataType)dataType) ? new DecimalHash(indexes.get(i)) : new StringHash(indexes.get(i)));
        }
    }

    @Override
    public int getPartition(CarbonRow key) {
        int hashCode = 0;
        for (Hash hash : this.hashes) {
            hashCode += hash.getHash(key.getData());
        }
        return (hashCode & Integer.MAX_VALUE) % this.numberOfBuckets;
    }

    private static class StringHash
    implements Hash {
        private int index;

        private StringHash(int index) {
            this.index = index;
        }

        @Override
        public int getHash(Object[] value) {
            return value[this.index] != null ? value[this.index].hashCode() : 0;
        }
    }

    private static class DecimalHash
    implements Hash {
        private int index;

        private DecimalHash(int index) {
            this.index = index;
        }

        @Override
        public int getHash(Object[] value) {
            return value[this.index] != null ? Double.valueOf(value[this.index].toString()).hashCode() : 0;
        }
    }

    private static class IntegralHash
    implements Hash {
        private int index;

        private IntegralHash(int index) {
            this.index = index;
        }

        @Override
        public int getHash(Object[] value) {
            return value[this.index] != null ? Long.valueOf(value[this.index].toString()).hashCode() : 0;
        }
    }

    private static interface Hash {
        public int getHash(Object[] var1);
    }
}

