/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe.merger;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.memory.UnsafeSortMemoryManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.merger.UnsafeInMemoryIntermediateDataMerger;
import org.apache.carbondata.processing.loading.sort.unsafe.merger.UnsafeIntermediateFileMerger;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;

public class UnsafeIntermediateMerger {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)UnsafeIntermediateMerger.class.getName());
    private ExecutorService executorService;
    private List<UnsafeCarbonRowPage> rowPages;
    private List<UnsafeInMemoryIntermediateDataMerger> mergedPages;
    private SortParameters parameters;
    private final Object lockObject = new Object();
    private List<File> procFiles;
    private List<Future<Void>> mergerTask;
    private long spillSizeInSortMemory;

    public UnsafeIntermediateMerger(SortParameters parameters) {
        this.parameters = parameters;
        this.rowPages = new ArrayList<UnsafeCarbonRowPage>(10);
        this.mergedPages = new ArrayList<UnsafeInMemoryIntermediateDataMerger>();
        this.executorService = Executors.newFixedThreadPool(parameters.getNumberOfCores(), (ThreadFactory)new CarbonThreadFactory("UnsafeIntermediatePool:" + parameters.getTableName()));
        this.procFiles = new ArrayList<File>(10);
        this.mergerTask = new ArrayList<Future<Void>>();
        Integer spillPercentage = CarbonProperties.getInstance().getSortMemorySpillPercentage();
        this.spillSizeInSortMemory = UnsafeSortMemoryManager.INSTANCE.getUsableMemory() * (long)spillPercentage.intValue() / 100L;
        long inMemoryChunkSizeInMB = CarbonProperties.getInstance().getSortMemoryChunkSizeInMB();
        if (this.spillSizeInSortMemory < inMemoryChunkSizeInMB * 1024L * 1024L) {
            LOGGER.warn("the configure spill size is " + this.spillSizeInSortMemory + " less than the page size " + inMemoryChunkSizeInMB * 1024L * 1024L + ",so no merge and spill in-memory pages to disk");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataChunkToMerge(UnsafeCarbonRowPage rowPage) {
        Object object = this.lockObject;
        synchronized (object) {
            this.rowPages.add(rowPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileToMerge(File sortTempFile) {
        Object object = this.lockObject;
        synchronized (object) {
            this.procFiles.add(sortTempFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFileMergingIfPossible() {
        if (this.procFiles.size() >= this.parameters.getNumberOfIntermediateFileToBeMerged()) {
            File[] fileList;
            Object object = this.lockObject;
            synchronized (object) {
                fileList = this.procFiles.toArray(new File[this.procFiles.size()]);
                this.procFiles = new ArrayList<File>();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sumitting request for intermediate merging no of files: " + fileList.length);
            }
            this.startIntermediateMerging(fileList);
        }
    }

    private void startIntermediateMerging(File[] intermediateFiles) {
        String[] tempFileLocations = this.parameters.getTempFileLocation();
        String targetLocation = tempFileLocations[new Random().nextInt(tempFileLocations.length)];
        File file = new File(targetLocation + File.separator + this.parameters.getTableName() + '_' + this.parameters.getRangeId() + '_' + System.nanoTime() + ".merge");
        UnsafeIntermediateFileMerger merger = new UnsafeIntermediateFileMerger(this.parameters, intermediateFiles, file);
        this.mergerTask.add(this.executorService.submit(merger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryTriggerInmemoryMerging(boolean spillDisk) throws CarbonSortKeyAndGroupByException {
        ArrayList<UnsafeCarbonRowPage> pages2Merge = new ArrayList<UnsafeCarbonRowPage>();
        int totalRows2Merge = 0;
        Object object = this.lockObject;
        synchronized (object) {
            long sizeAdded = 0L;
            Iterator<UnsafeCarbonRowPage> iter = this.rowPages.iterator();
            while (iter.hasNext()) {
                UnsafeCarbonRowPage page = iter.next();
                if (spillDisk && sizeAdded + page.getDataBlock().size() >= this.spillSizeInSortMemory) break;
                pages2Merge.add(page);
                sizeAdded += page.getDataBlock().size();
                totalRows2Merge += page.getBuffer().getActualSize();
                iter.remove();
            }
        }
        if (pages2Merge.size() > 1) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sumitting request for intermediate merging of in-memory pages : " + pages2Merge.size());
            }
            this.startIntermediateMerging(pages2Merge.toArray(new UnsafeCarbonRowPage[pages2Merge.size()]), totalRows2Merge, spillDisk);
        }
    }

    public void startInmemoryMergingIfPossible() throws CarbonSortKeyAndGroupByException {
        if (this.rowPages.size() >= this.parameters.getNumberOfIntermediateFileToBeMerged()) {
            this.tryTriggerInmemoryMerging(false);
        }
    }

    private void startIntermediateMerging(UnsafeCarbonRowPage[] rowPages, int totalRows, boolean spillDisk) throws CarbonSortKeyAndGroupByException {
        UnsafeInMemoryIntermediateDataMerger merger = new UnsafeInMemoryIntermediateDataMerger(rowPages, totalRows, this.parameters, spillDisk);
        this.mergedPages.add(merger);
        this.mergerTask.add(this.executorService.submit(merger));
    }

    public void finish() throws CarbonSortKeyAndGroupByException {
        try {
            this.executorService.shutdown();
            this.executorService.awaitTermination(2L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new CarbonSortKeyAndGroupByException("Problem while shutdown the server ", e);
        }
        this.checkForFailure();
    }

    public void close() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
        }
        this.rowPages.clear();
        this.rowPages = null;
    }

    private void checkForFailure() throws CarbonSortKeyAndGroupByException {
        for (int i = 0; i < this.mergerTask.size(); ++i) {
            try {
                this.mergerTask.get(i).get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error((Throwable)e, e.getMessage());
                throw new CarbonSortKeyAndGroupByException(e.getMessage(), e);
            }
        }
    }

    public List<UnsafeCarbonRowPage> getRowPages() {
        return this.rowPages;
    }

    public List<UnsafeInMemoryIntermediateDataMerger> getMergedPages() {
        return this.mergedPages;
    }
}

