/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.store.writer;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.keygenerator.mdkey.NumberCompressor;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.index.BlockIndexInfo;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.CarbonIndexFileWriter;
import org.apache.carbondata.format.BlockIndex;
import org.apache.carbondata.format.BlockletIndex;
import org.apache.carbondata.format.BlockletInfo3;
import org.apache.carbondata.format.ColumnSchema;
import org.apache.carbondata.format.IndexHeader;
import org.apache.carbondata.processing.datamap.DataMapWriterListener;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;
import org.apache.carbondata.processing.store.writer.CarbonFactDataWriter;
import org.apache.thrift.TBase;

public abstract class AbstractFactDataWriter
implements CarbonFactDataWriter {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)AbstractFactDataWriter.class.getName());
    protected WritableByteChannel fileChannel;
    protected long currentOffsetInFile;
    private String carbonDataFileStorePath;
    private String carbonDataFileTempPath;
    protected String carbonDataFileName;
    protected int blockletId = 0;
    protected int pageId = 0;
    protected int[] localCardinality;
    protected List<ColumnSchema> thriftColumnSchemaList;
    protected NumberCompressor numberCompressor;
    protected CarbonFactDataHandlerModel model;
    protected List<List<Long>> dataChunksOffsets;
    protected List<List<Short>> dataChunksLength;
    protected long fileSizeInBytes;
    private int fileCount;
    private ExecutorService executorService;
    private List<Future<Void>> executorServiceSubmitList;
    private long blockSizeThreshold;
    private long currentFileSize;
    protected DataOutputStream fileOutputStream;
    protected List<BlockIndexInfo> blockIndexInfoList;
    protected List<BlockletInfo3> blockletMetadata;
    protected List<BlockletIndex> blockletIndex;
    protected DataMapWriterListener listener;
    private boolean enableDirectlyWriteDataToStorePath = false;
    protected ExecutorService fallbackExecutorService;

    public AbstractFactDataWriter(CarbonFactDataHandlerModel model) {
        this.model = model;
        this.blockIndexInfoList = new ArrayList<BlockIndexInfo>();
        CarbonProperties propInstance = CarbonProperties.getInstance();
        this.fileSizeInBytes = (long)this.model.getBlockSizeInMB() * 1024L * 1024L;
        int spaceReservedForBlockMetaSize = Integer.parseInt(propInstance.getProperty("carbon.block.meta.size.reserved.percentage", "10"));
        this.blockSizeThreshold = this.fileSizeInBytes - this.fileSizeInBytes * (long)spaceReservedForBlockMetaSize / 100L;
        LOGGER.info("Total file size: " + this.fileSizeInBytes + " and dataBlock Size: " + this.blockSizeThreshold);
        String directlyWriteData2Hdfs = propInstance.getProperty("carbon.load.directWriteToStorePath.enabled", "false");
        this.enableDirectlyWriteDataToStorePath = "TRUE".equalsIgnoreCase(directlyWriteData2Hdfs);
        if (this.enableDirectlyWriteDataToStorePath) {
            LOGGER.info("Carbondata will directly write fact data to HDFS.");
        } else {
            LOGGER.info("Carbondata will write temporary fact data to local disk.");
        }
        this.executorService = Executors.newFixedThreadPool(1, (ThreadFactory)new CarbonThreadFactory("CompleteHDFSBackendPool:" + this.model.getTableName()));
        this.executorServiceSubmitList = new ArrayList<Future<Void>>(16);
        this.localCardinality = this.model.getColCardinality();
        ArrayList<Integer> cardinalityList = new ArrayList<Integer>();
        this.thriftColumnSchemaList = AbstractFactDataWriter.getColumnSchemaListAndCardinality(cardinalityList, this.localCardinality, this.model.getWrapperColumnSchema());
        this.numberCompressor = new NumberCompressor(Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.blocklet.size", "120000")));
        this.dataChunksOffsets = new ArrayList<List<Long>>();
        this.dataChunksLength = new ArrayList<List<Short>>();
        this.blockletMetadata = new ArrayList<BlockletInfo3>();
        this.blockletIndex = new ArrayList<BlockletIndex>();
        this.listener = this.model.getDataMapWriterlistener();
        if (model.getColumnLocalDictGenMap().size() > 0) {
            int numberOfCores = 1;
            if (model.getNumberOfCores() > 1) {
                numberOfCores = model.getNumberOfCores() / 2;
            }
            this.fallbackExecutorService = Executors.newFixedThreadPool(numberOfCores, (ThreadFactory)new CarbonThreadFactory("FallbackPool:" + model.getTableName() + ", range: " + model.getBucketId()));
        }
    }

    protected void createNewFileIfReachThreshold(long blockletSizeToBeAdded) throws CarbonDataWriterException {
        if (this.currentFileSize + blockletSizeToBeAdded >= this.blockSizeThreshold && this.currentFileSize != 0L) {
            String activeFile = this.enableDirectlyWriteDataToStorePath ? this.carbonDataFileStorePath : this.carbonDataFileTempPath;
            LOGGER.info("Writing data to file as max file size reached for file: " + activeFile + ". Data block size: " + this.currentFileSize);
            this.writeFooterToFile();
            this.currentFileSize = 0L;
            this.dataChunksOffsets = new ArrayList<List<Long>>();
            this.dataChunksLength = new ArrayList<List<Short>>();
            this.blockletMetadata = new ArrayList<BlockletInfo3>();
            this.blockletIndex = new ArrayList<BlockletIndex>();
            this.commitCurrentFile(false);
            this.initializeWriter();
        }
        this.currentFileSize += blockletSizeToBeAdded;
    }

    private void notifyDataMapBlockStart() {
        if (this.listener != null) {
            try {
                this.listener.onBlockStart(this.carbonDataFileName);
            }
            catch (IOException e) {
                throw new CarbonDataWriterException("Problem while writing datamap", (Throwable)e);
            }
        }
    }

    private void notifyDataMapBlockEnd() {
        if (this.listener != null) {
            try {
                this.listener.onBlockEnd(this.carbonDataFileName);
            }
            catch (IOException e) {
                throw new CarbonDataWriterException("Problem while writing datamap", (Throwable)e);
            }
        }
    }

    protected void commitCurrentFile(boolean copyInCurrentThread) {
        this.notifyDataMapBlockEnd();
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.fileOutputStream, this.fileChannel});
        if (!this.enableDirectlyWriteDataToStorePath) {
            try {
                if (copyInCurrentThread) {
                    CarbonUtil.copyCarbonDataFileToCarbonStorePath((String)this.carbonDataFileTempPath, (String)this.model.getCarbonDataDirectoryPath(), (long)this.fileSizeInBytes);
                    FileFactory.deleteFile((String)this.carbonDataFileTempPath, (FileFactory.FileType)FileFactory.getFileType((String)this.carbonDataFileTempPath));
                } else {
                    this.executorServiceSubmitList.add(this.executorService.submit(new CompleteHdfsBackendThread(this.carbonDataFileTempPath)));
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete carbondata file from temp location" + e.getMessage());
            }
        }
    }

    @Override
    public void initializeWriter() throws CarbonDataWriterException {
        this.carbonDataFileName = CarbonTablePath.getCarbonDataFileName((Integer)this.fileCount, (Long)this.model.getCarbonDataFileAttributes().getTaskId(), (int)this.model.getBucketId(), (int)this.model.getTaskExtension(), (String)("" + this.model.getCarbonDataFileAttributes().getFactTimeStamp()), (String)this.model.getSegmentId());
        this.carbonDataFileStorePath = this.model.getCarbonDataDirectoryPath() + File.separator + this.carbonDataFileName;
        try {
            if (this.enableDirectlyWriteDataToStorePath) {
                this.fileOutputStream = FileFactory.getDataOutputStream((String)this.carbonDataFileStorePath, (FileFactory.FileType)FileFactory.FileType.HDFS, (int)24576, (long)(this.fileSizeInBytes * 2L));
            } else {
                String[] tempFileLocations = this.model.getStoreLocation();
                String chosenTempLocation = tempFileLocations[new Random().nextInt(tempFileLocations.length)];
                LOGGER.info("Randomly choose factdata temp location: " + chosenTempLocation);
                this.carbonDataFileTempPath = chosenTempLocation + File.separator + this.carbonDataFileName;
                this.fileOutputStream = FileFactory.getDataOutputStream((String)this.carbonDataFileTempPath, (FileFactory.FileType)FileFactory.FileType.LOCAL, (int)24576, (boolean)true);
            }
            ++this.fileCount;
            this.fileChannel = Channels.newChannel(this.fileOutputStream);
            this.currentOffsetInFile = 0L;
        }
        catch (IOException ex) {
            throw new CarbonDataWriterException("Problem while getting the channel for fact data file", (Throwable)ex);
        }
        this.notifyDataMapBlockStart();
    }

    protected abstract void writeFooterToFile() throws CarbonDataWriterException;

    protected abstract void fillBlockIndexInfoDetails(long var1, String var3, long var4);

    public static List<ColumnSchema> getColumnSchemaListAndCardinality(List<Integer> cardinality, int[] dictionaryColumnCardinality, List<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> wrapperColumnSchemaList) {
        ArrayList<ColumnSchema> columnSchemaList = new ArrayList<ColumnSchema>(16);
        ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
        int counter = 0;
        for (int i = 0; i < wrapperColumnSchemaList.size(); ++i) {
            columnSchemaList.add(schemaConverter.fromWrapperToExternalColumnSchema(wrapperColumnSchemaList.get(i)));
            if (CarbonUtil.hasEncoding((List)wrapperColumnSchemaList.get(i).getEncodingList(), (Encoding)Encoding.DICTIONARY)) {
                cardinality.add(dictionaryColumnCardinality[counter]);
                ++counter;
                continue;
            }
            if (!wrapperColumnSchemaList.get(i).isDimensionColumn()) continue;
            cardinality.add(-1);
        }
        return columnSchemaList;
    }

    protected void writeIndexFile() throws IOException, CarbonDataWriterException {
        String indexFileName;
        IndexHeader indexHeader = CarbonMetadataUtil.getIndexHeader((int[])this.localCardinality, this.thriftColumnSchemaList, (int)this.model.getBucketId(), (long)this.model.getSchemaUpdatedTimeStamp());
        List blockIndexThrift = CarbonMetadataUtil.getBlockIndexInfo(this.blockIndexInfoList);
        if (this.enableDirectlyWriteDataToStorePath) {
            String rawFileName = this.model.getCarbonDataDirectoryPath() + "/" + CarbonTablePath.getCarbonIndexFileName((long)this.model.getCarbonDataFileAttributes().getTaskId(), (int)this.model.getBucketId(), (int)this.model.getTaskExtension(), (String)("" + this.model.getCarbonDataFileAttributes().getFactTimeStamp()), (String)this.model.getSegmentId());
            indexFileName = FileFactory.getUpdatedFilePath((String)rawFileName, (FileFactory.FileType)FileFactory.FileType.HDFS);
        } else {
            String[] tempLocations = this.model.getStoreLocation();
            String chosenTempLocation = tempLocations[new Random().nextInt(tempLocations.length)];
            LOGGER.info("Randomly choose index file location: " + chosenTempLocation);
            indexFileName = chosenTempLocation + File.separator + CarbonTablePath.getCarbonIndexFileName((long)this.model.getCarbonDataFileAttributes().getTaskId(), (int)this.model.getBucketId(), (int)this.model.getTaskExtension(), (String)("" + this.model.getCarbonDataFileAttributes().getFactTimeStamp()), (String)this.model.getSegmentId());
        }
        CarbonIndexFileWriter writer = new CarbonIndexFileWriter();
        writer.openThriftWriter(indexFileName);
        writer.writeThrift((TBase)indexHeader);
        for (BlockIndex blockIndex : blockIndexThrift) {
            writer.writeThrift((TBase)blockIndex);
        }
        writer.close();
        if (!this.enableDirectlyWriteDataToStorePath) {
            CarbonUtil.copyCarbonDataFileToCarbonStorePath((String)indexFileName, (String)this.model.getCarbonDataDirectoryPath(), (long)this.fileSizeInBytes);
            FileFactory.deleteFile((String)indexFileName, (FileFactory.FileType)FileFactory.getFileType((String)indexFileName));
        }
    }

    protected void closeExecutorService() throws CarbonDataWriterException {
        CarbonDataWriterException exception;
        block7: {
            exception = null;
            try {
                this.listener.finish();
                this.listener = null;
            }
            catch (IOException e) {
                exception = new CarbonDataWriterException((Throwable)e);
            }
            try {
                this.executorService.shutdown();
                this.executorService.awaitTermination(2L, TimeUnit.HOURS);
                for (int i = 0; i < this.executorServiceSubmitList.size(); ++i) {
                    this.executorServiceSubmitList.get(i).get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                if (null != exception) break block7;
                exception = new CarbonDataWriterException((Throwable)e);
            }
        }
        if (null != this.fallbackExecutorService) {
            this.fallbackExecutorService.shutdownNow();
        }
        if (exception != null) {
            throw exception;
        }
    }

    private final class CompleteHdfsBackendThread
    implements Callable<Void> {
        private String fileName;

        private CompleteHdfsBackendThread(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public Void call() throws Exception {
            CarbonUtil.copyCarbonDataFileToCarbonStorePath((String)this.fileName, (String)AbstractFactDataWriter.this.model.getCarbonDataDirectoryPath(), (long)AbstractFactDataWriter.this.fileSizeInBytes);
            FileFactory.deleteFile((String)this.fileName, (FileFactory.FileType)FileFactory.getFileType((String)this.fileName));
            return null;
        }
    }
}

