/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactorSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemStoreMergerSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hadoop.hbase.regionserver.VersionedSegmentsList;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MemStoreCompactor {
    public static final String COMPACTING_MEMSTORE_THRESHOLD_KEY = "hbase.hregion.compacting.pipeline.segments.limit";
    public static final int COMPACTING_MEMSTORE_THRESHOLD_DEFAULT = 1;
    public static final long DEEP_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 4 * ClassSize.REFERENCE + 8 + ClassSize.ATOMIC_BOOLEAN));
    private static final Log LOG = LogFactory.getLog(MemStoreCompactor.class);
    private final int pipelineThreshold;
    private CompactingMemStore compactingMemStore;
    private VersionedSegmentsList versionedList;
    private final AtomicBoolean isInterrupted = new AtomicBoolean(false);
    private final int compactionKVMax;
    private Action action = Action.FLATTEN;

    public MemStoreCompactor(CompactingMemStore compactingMemStore, MemoryCompactionPolicy compactionPolicy) {
        this.compactingMemStore = compactingMemStore;
        this.compactionKVMax = compactingMemStore.getConfiguration().getInt("hbase.hstore.compaction.kv.max", 10);
        this.initiateAction(compactionPolicy);
        this.pipelineThreshold = compactingMemStore.getConfiguration().getInt(COMPACTING_MEMSTORE_THRESHOLD_KEY, 1);
    }

    public boolean start() throws IOException {
        if (!this.compactingMemStore.hasImmutableSegments()) {
            return false;
        }
        this.versionedList = this.compactingMemStore.getImmutableSegments();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting the In-Memory Compaction for store " + this.compactingMemStore.getStore().getColumnFamilyName()));
        }
        this.doCompaction();
        return true;
    }

    public void stop() {
        this.isInterrupted.compareAndSet(false, true);
    }

    public boolean isIndexCompaction() {
        return this.action == Action.MERGE;
    }

    private void releaseResources() {
        this.isInterrupted.set(false);
        this.versionedList = null;
    }

    private Action policy() {
        if (this.isInterrupted.get()) {
            return Action.NOOP;
        }
        if (this.action == Action.COMPACT) {
            LOG.debug((Object)("In-Memory Compaction Pipeline for store " + this.compactingMemStore.getFamilyName() + " is going to be compacted to the " + (Object)((Object)this.compactingMemStore.getIndexType()) + ". Number of cells before compaction is " + this.versionedList.getNumOfCells()));
            return Action.COMPACT;
        }
        int numOfSegments = this.versionedList.getNumOfSegments();
        if (numOfSegments > this.pipelineThreshold) {
            LOG.debug((Object)("In-Memory Compaction Pipeline for store " + this.compactingMemStore.getFamilyName() + " is going to be merged to the " + (Object)((Object)this.compactingMemStore.getIndexType()) + ", as there are " + numOfSegments + " segments"));
            return Action.MERGE;
        }
        LOG.debug((Object)("The youngest segment in the in-Memory Compaction Pipeline for store " + this.compactingMemStore.getFamilyName() + " is going to be flattened to the " + (Object)((Object)this.compactingMemStore.getIndexType())));
        return Action.FLATTEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompaction() {
        Segment result = null;
        boolean resultSwapped = false;
        Action nextStep = null;
        try {
            nextStep = this.policy();
            if (nextStep == Action.NOOP) {
                return;
            }
            if (nextStep == Action.FLATTEN) {
                this.compactingMemStore.flattenOneSegment(this.versionedList.getVersion());
                return;
            }
            if (!this.isInterrupted.get()) {
                result = this.createSubstitution();
            }
            if (!this.isInterrupted.get() && (resultSwapped = this.compactingMemStore.swapCompactedSegments(this.versionedList, (ImmutableSegment)result, this.action == Action.MERGE))) {
                this.compactingMemStore.updateLowestUnflushedSequenceIdInWAL(true);
            }
        }
        catch (IOException e) {
            LOG.debug((Object)("Interrupting the MemStore in-memory compaction for store " + this.compactingMemStore.getFamilyName()));
            Thread.currentThread().interrupt();
        }
        finally {
            if (nextStep != Action.MERGE && result != null && !resultSwapped) {
                result.close();
            }
            this.releaseResources();
        }
    }

    private ImmutableSegment createSubstitution() throws IOException {
        ImmutableSegment result = null;
        MemStoreSegmentsIterator iterator = null;
        switch (this.action) {
            case COMPACT: {
                iterator = new MemStoreCompactorSegmentsIterator(this.versionedList.getStoreSegments(), this.compactingMemStore.getComparator(), this.compactionKVMax, this.compactingMemStore.getStore());
                result = SegmentFactory.instance().createImmutableSegmentByCompaction(this.compactingMemStore.getConfiguration(), this.compactingMemStore.getComparator(), iterator, this.versionedList.getNumOfCells(), this.compactingMemStore.getIndexType());
                iterator.close();
                break;
            }
            case MERGE: {
                iterator = new MemStoreMergerSegmentsIterator(this.versionedList.getStoreSegments(), this.compactingMemStore.getComparator(), this.compactionKVMax);
                result = SegmentFactory.instance().createImmutableSegmentByMerge(this.compactingMemStore.getConfiguration(), this.compactingMemStore.getComparator(), iterator, this.versionedList.getNumOfCells(), this.versionedList.getStoreSegments(), this.compactingMemStore.getIndexType());
                iterator.close();
                break;
            }
            default: {
                throw new RuntimeException("Unknown action " + (Object)((Object)this.action));
            }
        }
        return result;
    }

    @VisibleForTesting
    void initiateAction(MemoryCompactionPolicy compType) {
        switch (compType) {
            case NONE: {
                this.action = Action.NOOP;
                break;
            }
            case BASIC: {
                this.action = Action.MERGE;
                break;
            }
            case EAGER: {
                this.action = Action.COMPACT;
                break;
            }
            default: {
                throw new RuntimeException("Unknown memstore type " + compType);
            }
        }
    }

    public static enum Action {
        NOOP,
        FLATTEN,
        MERGE,
        COMPACT;

    }
}

