/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
public class MemStoreSize {
    protected long dataSize;
    protected long heapSize;

    public MemStoreSize() {
        this(0L, 0L);
    }

    public MemStoreSize(long dataSize, long heapSize) {
        this.dataSize = dataSize;
        this.heapSize = heapSize;
    }

    public boolean isEmpty() {
        return this.dataSize == 0L && this.heapSize == 0L;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemStoreSize other = (MemStoreSize)obj;
        return this.dataSize == other.dataSize && this.heapSize == other.heapSize;
    }

    public int hashCode() {
        long h = 13L * this.dataSize;
        return (int)(h += 14L * this.heapSize);
    }

    public String toString() {
        return "dataSize=" + this.dataSize + " , heapSize=" + this.heapSize;
    }
}

