/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CompactionProgress {
    public long totalCompactingKVs;
    public long currentCompactedKVs = 0L;
    public long totalCompactedSize = 0L;

    public CompactionProgress(long totalCompactingKVs) {
        this.totalCompactingKVs = totalCompactingKVs;
    }

    public float getProgressPct() {
        return (float)this.currentCompactedKVs / (float)this.totalCompactingKVs;
    }

    public void cancel() {
        this.totalCompactingKVs = 0L;
        this.currentCompactedKVs = 0L;
    }

    public void complete() {
        this.totalCompactingKVs = this.currentCompactedKVs;
    }

    public long getTotalCompactingKvs() {
        return this.totalCompactingKVs;
    }

    public long getCurrentCompactedKvs() {
        return this.currentCompactedKVs;
    }

    public long getTotalCompactedSize() {
        return this.totalCompactedSize;
    }

    public String toString() {
        return String.format("%d/%d (%.2f%%)", this.currentCompactedKVs, this.totalCompactingKVs, Float.valueOf(100.0f * this.getProgressPct()));
    }
}

