/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.test.MockMetricsReporter;
import org.apache.kafka.test.MockProducerInterceptor;
import org.apache.kafka.test.MockSerializer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.api.support.membermodification.MemberModifier;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareOnlyThisForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"javax.management.*"})
public class KafkaProducerTest {
    @Test
    public void testConstructorFailureCloseResource() {
        Properties props = new Properties();
        props.setProperty("client.id", "testConstructorClose");
        props.setProperty("bootstrap.servers", "some.invalid.hostname.foo.bar:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        int oldInitCount = MockMetricsReporter.INIT_COUNT.get();
        int oldCloseCount = MockMetricsReporter.CLOSE_COUNT.get();
        try {
            KafkaProducer kafkaProducer = new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        }
        catch (KafkaException e) {
            Assert.assertEquals((long)(oldInitCount + 1), (long)MockMetricsReporter.INIT_COUNT.get());
            Assert.assertEquals((long)(oldCloseCount + 1), (long)MockMetricsReporter.CLOSE_COUNT.get());
            Assert.assertEquals((Object)"Failed to construct kafka producer", (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"should have caught an exception and returned");
    }

    @Test
    public void testSerializerClose() throws Exception {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("client.id", "testConstructorClose");
        configs.put("bootstrap.servers", "localhost:9999");
        configs.put("metric.reporters", MockMetricsReporter.class.getName());
        configs.put("security.protocol", "PLAINTEXT");
        int oldInitCount = MockSerializer.INIT_COUNT.get();
        int oldCloseCount = MockSerializer.CLOSE_COUNT.get();
        KafkaProducer producer = new KafkaProducer(configs, (Serializer)new MockSerializer(), (Serializer)new MockSerializer());
        Assert.assertEquals((long)(oldInitCount + 2), (long)MockSerializer.INIT_COUNT.get());
        Assert.assertEquals((long)oldCloseCount, (long)MockSerializer.CLOSE_COUNT.get());
        producer.close();
        Assert.assertEquals((long)(oldInitCount + 2), (long)MockSerializer.INIT_COUNT.get());
        Assert.assertEquals((long)(oldCloseCount + 2), (long)MockSerializer.CLOSE_COUNT.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterceptorConstructClose() throws Exception {
        try {
            Properties props = new Properties();
            props.setProperty("bootstrap.servers", "localhost:9999");
            props.setProperty("interceptor.classes", MockProducerInterceptor.class.getName());
            props.setProperty("mock.interceptor.append", "something");
            KafkaProducer producer = new KafkaProducer(props, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            Assert.assertEquals((long)1L, (long)MockProducerInterceptor.INIT_COUNT.get());
            Assert.assertEquals((long)0L, (long)MockProducerInterceptor.CLOSE_COUNT.get());
            Assert.assertNull((Object)MockProducerInterceptor.CLUSTER_META.get());
            producer.close();
            Assert.assertEquals((long)1L, (long)MockProducerInterceptor.INIT_COUNT.get());
            Assert.assertEquals((long)1L, (long)MockProducerInterceptor.CLOSE_COUNT.get());
        }
        finally {
            MockProducerInterceptor.resetCounters();
        }
    }

    @Test
    public void testOsDefaultSocketBufferSizes() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("send.buffer.bytes", -1);
        config.put("receive.buffer.bytes", -1);
        KafkaProducer producer = new KafkaProducer(config, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        producer.close();
    }

    @Test(expected=KafkaException.class)
    public void testInvalidSocketSendBufferSize() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("send.buffer.bytes", -2);
        new KafkaProducer(config, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    }

    @Test(expected=KafkaException.class)
    public void testInvalidSocketReceiveBufferSize() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("receive.buffer.bytes", -2);
        new KafkaProducer(config, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    }

    @PrepareOnlyThisForTest(value={Metadata.class})
    @Test
    public void testMetadataFetch() throws Exception {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        KafkaProducer producer = new KafkaProducer(props, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        Metadata metadata = (Metadata)PowerMock.createNiceMock(Metadata.class);
        MemberModifier.field(KafkaProducer.class, (String)"metadata").set(producer, metadata);
        String topic = "topic";
        ProducerRecord record = new ProducerRecord(topic, (Object)"value");
        List<Node> nodes = Collections.singletonList(new Node(0, "host1", 1000));
        Cluster emptyCluster = new Cluster(null, nodes, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        Cluster cluster = new Cluster("dummy", Collections.singletonList(new Node(0, "host1", 1000)), Arrays.asList(new PartitionInfo(topic, 0, null, null, null)), Collections.emptySet(), Collections.emptySet());
        int refreshAttempts = 5;
        EasyMock.expect((Object)metadata.fetch()).andReturn((Object)emptyCluster).times(4);
        EasyMock.expect((Object)metadata.fetch()).andReturn((Object)cluster).once();
        EasyMock.expect((Object)metadata.fetch()).andThrow((Throwable)new IllegalStateException("Unexpected call to metadata.fetch()")).anyTimes();
        PowerMock.replay((Object[])new Object[]{metadata});
        producer.send(record);
        PowerMock.verify((Object[])new Object[]{metadata});
        PowerMock.reset((Object[])new Object[]{metadata});
        EasyMock.expect((Object)metadata.fetch()).andReturn((Object)cluster).once();
        EasyMock.expect((Object)metadata.fetch()).andThrow((Throwable)new IllegalStateException("Unexpected call to metadata.fetch()")).anyTimes();
        PowerMock.replay((Object[])new Object[]{metadata});
        producer.send(record, null);
        PowerMock.verify((Object[])new Object[]{metadata});
        PowerMock.reset((Object[])new Object[]{metadata});
        EasyMock.expect((Object)metadata.fetch()).andReturn((Object)cluster).once();
        EasyMock.expect((Object)metadata.fetch()).andThrow((Throwable)new IllegalStateException("Unexpected call to metadata.fetch()")).anyTimes();
        PowerMock.replay((Object[])new Object[]{metadata});
        producer.partitionsFor(topic);
        PowerMock.verify((Object[])new Object[]{metadata});
    }

    @PrepareOnlyThisForTest(value={Metadata.class})
    @Test
    public void testMetadataFetchOnStaleMetadata() throws Exception {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        KafkaProducer producer = new KafkaProducer(props, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        Metadata metadata = (Metadata)PowerMock.createNiceMock(Metadata.class);
        MemberModifier.field(KafkaProducer.class, (String)"metadata").set(producer, metadata);
        String topic = "topic";
        ProducerRecord initialRecord = new ProducerRecord(topic, (Object)"value");
        ProducerRecord extendedRecord = new ProducerRecord(topic, Integer.valueOf(2), null, (Object)"value");
        List<Node> nodes = Collections.singletonList(new Node(0, "host1", 1000));
        Cluster emptyCluster = new Cluster(null, nodes, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        Cluster initialCluster = new Cluster("dummy", Collections.singletonList(new Node(0, "host1", 1000)), Arrays.asList(new PartitionInfo(topic, 0, null, null, null)), Collections.emptySet(), Collections.emptySet());
        Cluster extendedCluster = new Cluster("dummy", Collections.singletonList(new Node(0, "host1", 1000)), Arrays.asList(new PartitionInfo(topic, 0, null, null, null), new PartitionInfo(topic, 1, null, null, null), new PartitionInfo(topic, 2, null, null, null)), Collections.emptySet(), Collections.emptySet());
        int refreshAttempts = 5;
        EasyMock.expect((Object)metadata.fetch()).andReturn((Object)emptyCluster).times(4);
        EasyMock.expect((Object)metadata.fetch()).andReturn((Object)initialCluster).once();
        EasyMock.expect((Object)metadata.fetch()).andThrow((Throwable)new IllegalStateException("Unexpected call to metadata.fetch()")).anyTimes();
        PowerMock.replay((Object[])new Object[]{metadata});
        producer.send(initialRecord);
        PowerMock.verify((Object[])new Object[]{metadata});
        PowerMock.reset((Object[])new Object[]{metadata});
        EasyMock.expect((Object)metadata.fetch()).andReturn((Object)initialCluster).once();
        EasyMock.expect((Object)metadata.fetch()).andThrow((Throwable)new IllegalStateException("Unexpected call to metadata.fetch()")).anyTimes();
        PowerMock.replay((Object[])new Object[]{metadata});
        producer.send(initialRecord, null);
        PowerMock.verify((Object[])new Object[]{metadata});
        PowerMock.reset((Object[])new Object[]{metadata});
        EasyMock.expect((Object)metadata.fetch()).andReturn((Object)initialCluster).once();
        EasyMock.expect((Object)metadata.fetch()).andReturn((Object)initialCluster).once();
        EasyMock.expect((Object)metadata.fetch()).andThrow((Throwable)new IllegalStateException("Unexpected call to metadata.fetch()")).anyTimes();
        PowerMock.replay((Object[])new Object[]{metadata});
        try {
            producer.send(extendedRecord, null);
            Assert.fail((String)"Expected KafkaException to be raised");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
        PowerMock.verify((Object[])new Object[]{metadata});
        PowerMock.reset((Object[])new Object[]{metadata});
        EasyMock.expect((Object)metadata.fetch()).andReturn((Object)initialCluster).once();
        EasyMock.expect((Object)metadata.fetch()).andReturn((Object)extendedCluster).once();
        EasyMock.expect((Object)metadata.fetch()).andThrow((Throwable)new IllegalStateException("Unexpected call to metadata.fetch()")).anyTimes();
        PowerMock.replay((Object[])new Object[]{metadata});
        producer.send(extendedRecord, null);
        PowerMock.verify((Object[])new Object[]{metadata});
    }
}

