/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.Record;
import org.junit.Assert;
import org.junit.Test;

public class SimpleRecordTest {
    @Test
    public void testIsValidWithTooSmallBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        Record record = new Record(buffer);
        Assert.assertFalse((boolean)record.isValid());
        try {
            record.ensureValid();
            Assert.fail((String)"InvalidRecordException should have been thrown");
        }
        catch (InvalidRecordException invalidRecordException) {
            // empty catch block
        }
    }

    @Test
    public void testIsValidWithChecksumMismatch() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(2);
        Record record = new Record(buffer);
        Assert.assertFalse((boolean)record.isValid());
        try {
            record.ensureValid();
            Assert.fail((String)"InvalidRecordException should have been thrown");
        }
        catch (InvalidRecordException invalidRecordException) {
            // empty catch block
        }
    }

    @Test
    public void testIsValidWithFourBytesBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        Record record = new Record(buffer);
        Assert.assertTrue((boolean)record.isValid());
        record.ensureValid();
    }
}

