/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class DescribeAclsRequestData
implements ApiMessage {
    private byte resourceType;
    private String resourceNameFilter;
    private byte resourcePatternType;
    private String principalFilter;
    private String hostFilter;
    private byte operation;
    private byte permissionType;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("resource_type", (Type)Type.INT8, "The resource type."), new Field("resource_name_filter", (Type)Type.NULLABLE_STRING, "The resource name, or null to match any resource name."), new Field("principal_filter", (Type)Type.NULLABLE_STRING, "The principal to match, or null to match any principal."), new Field("host_filter", (Type)Type.NULLABLE_STRING, "The host to match, or null to match any host."), new Field("operation", (Type)Type.INT8, "The operation to match."), new Field("permission_type", (Type)Type.INT8, "The permission type to match.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("resource_type", (Type)Type.INT8, "The resource type."), new Field("resource_name_filter", (Type)Type.NULLABLE_STRING, "The resource name, or null to match any resource name."), new Field("resource_pattern_type", (Type)Type.INT8, "The resource pattern to match."), new Field("principal_filter", (Type)Type.NULLABLE_STRING, "The principal to match, or null to match any principal."), new Field("host_filter", (Type)Type.NULLABLE_STRING, "The host to match, or null to match any host."), new Field("operation", (Type)Type.INT8, "The operation to match."), new Field("permission_type", (Type)Type.INT8, "The permission type to match.")});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

    public DescribeAclsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public DescribeAclsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public DescribeAclsRequestData() {
        this.resourceType = 0;
        this.resourceNameFilter = "";
        this.resourcePatternType = (byte)3;
        this.principalFilter = "";
        this.hostFilter = "";
        this.operation = 0;
        this.permissionType = 0;
    }

    public short apiKey() {
        return 29;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        this.resourceType = readable.readByte();
        this.resourceNameFilter = readable.readNullableString();
        this.resourcePatternType = version >= 1 ? readable.readByte() : (byte)3;
        this.principalFilter = readable.readNullableString();
        this.hostFilter = readable.readNullableString();
        this.operation = readable.readByte();
        this.permissionType = readable.readByte();
    }

    public void write(Writable writable, short version) {
        writable.writeByte(this.resourceType);
        writable.writeNullableString(this.resourceNameFilter);
        if (version >= 1) {
            writable.writeByte(this.resourcePatternType);
        }
        writable.writeNullableString(this.principalFilter);
        writable.writeNullableString(this.hostFilter);
        writable.writeByte(this.operation);
        writable.writeByte(this.permissionType);
    }

    public void fromStruct(Struct struct, short version) {
        this.resourceType = struct.getByte("resource_type");
        this.resourceNameFilter = struct.getString("resource_name_filter");
        this.resourcePatternType = version >= 1 ? struct.getByte("resource_pattern_type") : (byte)3;
        this.principalFilter = struct.getString("principal_filter");
        this.hostFilter = struct.getString("host_filter");
        this.operation = struct.getByte("operation");
        this.permissionType = struct.getByte("permission_type");
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("resource_type", (Object)this.resourceType);
        struct.set("resource_name_filter", (Object)this.resourceNameFilter);
        if (version >= 1) {
            struct.set("resource_pattern_type", (Object)this.resourcePatternType);
        }
        struct.set("principal_filter", (Object)this.principalFilter);
        struct.set("host_filter", (Object)this.hostFilter);
        struct.set("operation", (Object)this.operation);
        struct.set("permission_type", (Object)this.permissionType);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        ++size;
        size += 2;
        if (this.resourceNameFilter != null) {
            size += MessageUtil.serializedUtf8Length((CharSequence)this.resourceNameFilter);
        }
        if (version >= 1) {
            ++size;
        } else if (this.resourcePatternType != 3) {
            throw new UnsupportedVersionException("Attempted to write a non-default resourcePatternType at version " + version);
        }
        size += 2;
        if (this.principalFilter != null) {
            size += MessageUtil.serializedUtf8Length((CharSequence)this.principalFilter);
        }
        size += 2;
        if (this.hostFilter != null) {
            size += MessageUtil.serializedUtf8Length((CharSequence)this.hostFilter);
        }
        ++size;
        return ++size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeAclsRequestData)) {
            return false;
        }
        DescribeAclsRequestData other = (DescribeAclsRequestData)obj;
        if (this.resourceType != other.resourceType) {
            return false;
        }
        if (this.resourceNameFilter == null ? other.resourceNameFilter != null : !this.resourceNameFilter.equals(other.resourceNameFilter)) {
            return false;
        }
        if (this.resourcePatternType != other.resourcePatternType) {
            return false;
        }
        if (this.principalFilter == null ? other.principalFilter != null : !this.principalFilter.equals(other.principalFilter)) {
            return false;
        }
        if (this.hostFilter == null ? other.hostFilter != null : !this.hostFilter.equals(other.hostFilter)) {
            return false;
        }
        if (this.operation != other.operation) {
            return false;
        }
        return this.permissionType == other.permissionType;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.resourceType;
        hashCode = 31 * hashCode + (this.resourceNameFilter == null ? 0 : this.resourceNameFilter.hashCode());
        hashCode = 31 * hashCode + this.resourcePatternType;
        hashCode = 31 * hashCode + (this.principalFilter == null ? 0 : this.principalFilter.hashCode());
        hashCode = 31 * hashCode + (this.hostFilter == null ? 0 : this.hostFilter.hashCode());
        hashCode = 31 * hashCode + this.operation;
        hashCode = 31 * hashCode + this.permissionType;
        return hashCode;
    }

    public String toString() {
        return "DescribeAclsRequestData(resourceType=" + this.resourceType + ", resourceNameFilter='" + this.resourceNameFilter + "', resourcePatternType=" + this.resourcePatternType + ", principalFilter='" + this.principalFilter + "', hostFilter='" + this.hostFilter + "', operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
    }

    public byte resourceType() {
        return this.resourceType;
    }

    public String resourceNameFilter() {
        return this.resourceNameFilter;
    }

    public byte resourcePatternType() {
        return this.resourcePatternType;
    }

    public String principalFilter() {
        return this.principalFilter;
    }

    public String hostFilter() {
        return this.hostFilter;
    }

    public byte operation() {
        return this.operation;
    }

    public byte permissionType() {
        return this.permissionType;
    }

    public DescribeAclsRequestData setResourceType(byte v) {
        this.resourceType = v;
        return this;
    }

    public DescribeAclsRequestData setResourceNameFilter(String v) {
        this.resourceNameFilter = v;
        return this;
    }

    public DescribeAclsRequestData setResourcePatternType(byte v) {
        this.resourcePatternType = v;
        return this;
    }

    public DescribeAclsRequestData setPrincipalFilter(String v) {
        this.principalFilter = v;
        return this;
    }

    public DescribeAclsRequestData setHostFilter(String v) {
        this.hostFilter = v;
        return this;
    }

    public DescribeAclsRequestData setOperation(byte v) {
        this.operation = v;
        return this;
    }

    public DescribeAclsRequestData setPermissionType(byte v) {
        this.permissionType = v;
        return this;
    }
}

