/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.kerberos;

import org.apache.kafka.common.security.kerberos.BadFormatString;
import org.apache.kafka.common.security.kerberos.KerberosRule;
import org.junit.Assert;
import org.junit.Test;

public class KerberosRuleTest {
    @Test
    public void testReplaceParameters() throws BadFormatString {
        Assert.assertEquals((Object)KerberosRule.replaceParameters((String)"", (String[])new String[0]), (Object)"");
        Assert.assertEquals((Object)KerberosRule.replaceParameters((String)"hello", (String[])new String[0]), (Object)"hello");
        Assert.assertEquals((Object)KerberosRule.replaceParameters((String)"", (String[])new String[]{"too", "many", "parameters", "are", "ok"}), (Object)"");
        Assert.assertEquals((Object)KerberosRule.replaceParameters((String)"hello", (String[])new String[]{"too", "many", "parameters", "are", "ok"}), (Object)"hello");
        Assert.assertEquals((Object)KerberosRule.replaceParameters((String)"hello $0", (String[])new String[]{"too", "many", "parameters", "are", "ok"}), (Object)"hello too");
        Assert.assertEquals((Object)KerberosRule.replaceParameters((String)"hello $0", (String[])new String[]{"no recursion $1"}), (Object)"hello no recursion $1");
        try {
            KerberosRule.replaceParameters((String)"$0", (String[])new String[0]);
            Assert.fail((String)"An out-of-bounds parameter number should trigger an exception!");
        }
        catch (BadFormatString badFormatString) {
            // empty catch block
        }
        try {
            KerberosRule.replaceParameters((String)"hello $a", (String[])new String[]{"does not matter"});
            Assert.fail((String)"A malformed parameter name should trigger an exception!");
        }
        catch (BadFormatString badFormatString) {
            // empty catch block
        }
    }
}

