/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.RequestOrResponse;
import kafka.cluster.Broker;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerStats$;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine$;
import kafka.controller.ReplicaStateMachine$BrokerChangeListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001\u001d\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u0011-A\u0011\u0011BD\u0007\u0002\u0015)\u00111\u0002D\u0001\u0005Y\u0006twMC\u0001\u000e\u0003\u0011Q\u0017M^1\n\u0005=Q!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\t\u0005)Q\u000f^5mg&\u0011QC\u0005\u0002\b\u0019><w-\u001b8h!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\r\u0001!\u0011!Q\u0001\nu\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJDQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtDC\u0001\u0013&!\tq\u0002\u0001C\u0003\u0004C\u0001\u0007Q\u0004C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001*!\tq\"&\u0003\u0002,\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r5\u0002\u0001\u0015!\u0003*\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f=\u0002!\u0019!C\u0005a\u0005a1m\u001c8ue>dG.\u001a:JIV\t\u0011\u0007\u0005\u0002\u0018e%\u00111\u0007\u0007\u0002\u0004\u0013:$\bBB\u001b\u0001A\u0003%\u0011'A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0003!Q8n\u00117jK:$X#A\u001d\u0011\u0005i\nU\"A\u001e\u000b\u0005qj\u0014\u0001\u0003>lG2LWM\u001c;\u000b\u0005yz\u0014AB%1\u0013R,7MC\u0001A\u0003\ry'oZ\u0005\u0003\u0005n\u0012\u0001BW6DY&,g\u000e\u001e\u0005\u0007\t\u0002\u0001\u000b\u0011B\u001d\u0002\u0013i\\7\t\\5f]R\u0004\u0003b\u0002$\u0001\u0001\u0004%\taR\u0001\re\u0016\u0004H.[2b'R\fG/Z\u000b\u0002\u0011B!\u0011J\u0014)[\u001b\u0005Q%BA&M\u0003\u001diW\u000f^1cY\u0016T!!\u0014\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002P\u0015\n\u0019Q*\u00199\u0011\u000b]\t6+M\u0019\n\u0005IC\"A\u0002+va2,7\u0007\u0005\u0002U/:\u0011q#V\u0005\u0003-b\ta\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\u0019\u0019FO]5oO*\u0011a\u000b\u0007\t\u0003=mK!\u0001\u0018\u0002\u0003\u0019I+\u0007\u000f\\5dCN#\u0018\r^3\t\u000fy\u0003\u0001\u0019!C\u0001?\u0006\u0001\"/\u001a9mS\u000e\f7\u000b^1uK~#S-\u001d\u000b\u0003A\u000e\u0004\"aF1\n\u0005\tD\"\u0001B+oSRDq\u0001Z/\u0002\u0002\u0003\u0007\u0001*A\u0002yIEBaA\u001a\u0001!B\u0013A\u0015!\u0004:fa2L7-Y*uCR,\u0007\u0005C\u0004i\u0001\t\u0007I\u0011A5\u0002%\t\u0014xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u000b\u0002UB\u0011ad[\u0005\u0003Y\n\u0011AdQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\u0003\u0004o\u0001\u0001\u0006IA[\u0001\u0014EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\t\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u0003)A\u0017m]*uCJ$X\rZ\u000b\u0002eB\u00111O_\u0007\u0002i*\u0011QO^\u0001\u0007CR|W.[2\u000b\u0005]D\u0018AC2p]\u000e,(O]3oi*\u0011\u0011\u0010D\u0001\u0005kRLG.\u0003\u0002|i\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:Da! \u0001!\u0002\u0013\u0011\u0018a\u00035bgN#\u0018M\u001d;fI\u0002B\u0001b \u0001C\u0002\u0013%\u0011\u0011A\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014XCAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\tQ\u0001\\8hi)T1!!\u0004@\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011CA\u0004\u0005\u0019aunZ4fe\"A\u0011Q\u0003\u0001!\u0002\u0013\t\u0019!\u0001\nti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\u0003bBA\r\u0001\u0011\u0005\u00111D\u0001\bgR\f'\u000f^;q)\u0005\u0001\u0007bBA\u0010\u0001\u0011\u0005\u00111D\u0001\u0012e\u0016<\u0017n\u001d;fe2K7\u000f^3oKJ\u001c\bbBA\u0012\u0001\u0011\u0005\u00111D\u0001\tg\",H\u000fZ8x]\"9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0012A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$R\u0001YA\u0016\u0003{A\u0001\"!\f\u0002&\u0001\u0007\u0011qF\u0001\te\u0016\u0004H.[2bgB1\u0011\u0011GA\u001a\u0003oi\u0011\u0001T\u0005\u0004\u0003ka%aA*fiB\u0019a$!\u000f\n\u0007\u0005m\"AA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017\rC\u0004\u0002@\u0005\u0015\u0002\u0019\u0001.\u0002\u0017Q\f'oZ3u'R\fG/\u001a\u0005\b\u0003\u0007\u0002A\u0011AA#\u0003EA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-\u001a\u000b\nA\u0006\u001d\u00131JA(\u0003'Bq!!\u0013\u0002B\u0001\u00071+A\u0003u_BL7\rC\u0004\u0002N\u0005\u0005\u0003\u0019A\u0019\u0002\u0013A\f'\u000f^5uS>t\u0007bBA)\u0003\u0003\u0002\r!M\u0001\ne\u0016\u0004H.[2b\u0013\u0012Dq!a\u0010\u0002B\u0001\u0007!\fC\u0004\u0002X\u0001!I!!\u0017\u00023\u0005\u001c8/\u001a:u-\u0006d\u0017\u000e\u001a)sKZLw.^:Ti\u0006$Xm\u001d\u000b\fA\u0006m\u0013QLA0\u0003C\nY\u0007C\u0004\u0002J\u0005U\u0003\u0019A*\t\u000f\u00055\u0013Q\u000ba\u0001c!9\u0011\u0011KA+\u0001\u0004\t\u0004\u0002CA2\u0003+\u0002\r!!\u001a\u0002\u0015\u0019\u0014x.\\*uCR,7\u000fE\u0003\u00022\u0005\u001d$,C\u0002\u0002j1\u00131aU3r\u0011\u001d\ty$!\u0016A\u0002iCq!a\u001c\u0001\t\u0013\t\t(\u0001\u000fsK\u001eL7\u000f^3s\u0005J|7.\u001a:DQ\u0006tw-\u001a'jgR,g.\u001a:\u0015\u0005\u0005M\u0004CBA;\u0003o\nY(D\u0001y\u0013\r\tI\b\u001f\u0002\u0005\u0019&\u001cH\u000fE\u0002\n\u0003{J!\u0001\u0017\u0006\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u001c\u00051\u0012N\\5uS\u0006d\u0017N_3SKBd\u0017nY1Ti\u0006$X\rC\u0004\u0002\u0006\u0002!I!a\"\u0002-\u001d,G/\u00117m%\u0016\u0004H.[2bg>s'I]8lKJ$b!a\f\u0002\n\u0006=\u0005\u0002CAF\u0003\u0007\u0003\r!!$\u0002\rQ|\u0007/[2t!\u0015\t\t$a\u001aT\u0011!\t\t*a!A\u0002\u0005M\u0015!\u00032s_.,'/\u00133t!\u0015\t\t$a\u001a2\u0011\u001d\t9\n\u0001C\u0001\u00033\u000bQdZ3u!\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:,G\rV8Ce>\\WM\u001d\u000b\u0007\u00037\u000bI+a+\u0011\r\u0005E\u0012qMAO!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAAR\t\u000511m\\7n_:LA!a*\u0002\"\n\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005-\u0015Q\u0013a\u0001\u0003\u001bCq!!,\u0002\u0016\u0002\u0007\u0011'\u0001\u0005ce>\\WM]%e\r\u0019\t\t\f\u0001\u0001\u00024\n!\"I]8lKJ\u001c\u0005.\u00198hK2K7\u000f^3oKJ\u001cr!a,\t\u0003k\u0003b\u0003E\u0002;\u0003oK1!!/<\u0005AI%l[\"iS2$G*[:uK:,'\u000fC\u0004#\u0003_#\t!!0\u0015\u0005\u0005}\u0006\u0003BAa\u0003_k\u0011\u0001\u0001\u0005\t\u0003\u000b\fy\u000b\"\u0001\u0002H\u0006\t\u0002.\u00198eY\u0016\u001c\u0005.\u001b7e\u0007\"\fgnZ3\u0015\u000b\u0001\fI-!4\t\u000f\u0005-\u00171\u0019a\u0001'\u0006Q\u0001/\u0019:f]R\u0004\u0016\r\u001e5\t\u0011\u0005=\u00171\u0019a\u0001\u0003#\f\u0011cY;se\u0016tGO\u0011:pW\u0016\u0014H*[:u!\u0015\t)(a\u001eT\u0001")
public class ReplicaStateMachine
implements Logging {
    public final KafkaController kafka$controller$ReplicaStateMachine$$controller;
    private final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkClient kafka$controller$ReplicaStateMachine$$zkClient;
    private Map<Tuple3<String, Object, Object>, ReplicaState> replicaState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext() {
        return this.kafka$controller$ReplicaStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public final ZkClient kafka$controller$ReplicaStateMachine$$zkClient() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient;
    }

    public Map<Tuple3<String, Object, Object>, ReplicaState> replicaState() {
        return this.replicaState;
    }

    public void replicaState_$eq(Map<Tuple3<String, Object, Object>, ReplicaState> map) {
        this.replicaState = map;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted() {
        return this.kafka$controller$ReplicaStateMachine$$hasStarted;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializeReplicaState();
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(true);
        this.handleStateChanges(this.getAllReplicasOnBroker((Seq<String>)this.kafka$controller$ReplicaStateMachine$$controllerContext().allTopics().toSeq(), (Seq<Object>)this.kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().toSeq()), OnlineReplica$.MODULE$);
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Started replica state machine with initial state -> ").append((Object)this.$outer.replicaState().toString()).toString();
            }
            {
                if (replicaStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaStateMachine;
            }
        });
    }

    public void registerListeners() {
        this.registerBrokerChangeListener();
    }

    public void shutdown() {
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(false);
        this.replicaState().clear();
    }

    public void handleStateChanges(Set<PartitionAndReplica> set, ReplicaState replicaState) {
        this.info((Function0<String>)new Serializable(this, set, replicaState){
            public static final long serialVersionUID;
            private final Set replicas$1;
            private final ReplicaState targetState$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Invoking state change to %s for replicas %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.replicas$1.mkString(",")}));
            }
            {
                this.replicas$1 = set;
                this.targetState$1 = replicaState;
            }
        });
        try {
            this.brokerRequestBatch().newBatch();
            set.foreach((Function1)new Serializable(this, replicaState){
                public static final long serialVersionUID;
                private final ReplicaStateMachine $outer;
                private final ReplicaState targetState$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(PartitionAndReplica partitionAndReplica) {
                    this.$outer.handleStateChange(partitionAndReplica.topic(), partitionAndReplica.partition(), partitionAndReplica.replica(), this.targetState$1);
                }
                {
                    if (replicaStateMachine == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = replicaStateMachine;
                    this.targetState$1 = replicaState;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$ReplicaStateMachine$$controller.epoch(), this.kafka$controller$ReplicaStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, replicaState){
                public static final long serialVersionUID;
                private final ReplicaState targetState$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Error while moving some replicas to %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = replicaState;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = throwable;
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleStateChange(String string, int n, int n2, ReplicaState replicaState) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        if (!this.kafka$controller$ReplicaStateMachine$$hasStarted().get()) {
            throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition %s to %s failed because replica state machine has not started").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition, replicaState})));
        }
        try {
            boolean bl;
            block32: {
                Option option;
                block33: {
                    this.replicaState().getOrElseUpdate((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Function0)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final NonExistentReplica$ apply() {
                            return NonExistentReplica$.MODULE$;
                        }
                    });
                    Seq seq = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                    ReplicaState replicaState2 = replicaState;
                    NewReplica$ newReplica$ = NewReplica$.MODULE$;
                    ReplicaState replicaState3 = replicaState2;
                    if (!(newReplica$ != null ? !newReplica$.equals(replicaState3) : replicaState3 != null)) {
                        Option<LeaderIsrAndControllerEpoch> option2;
                        this.assertValidPreviousStates(string, n, n2, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentReplica$[]{NonExistentReplica$.MODULE$})), replicaState);
                        Option<LeaderIsrAndControllerEpoch> option3 = option2 = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$ReplicaStateMachine$$zkClient(), string, n);
                        if (option3 instanceof Some) {
                            Some some = (Some)option3;
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = leaderIsrAndControllerEpoch;
                            if (leaderIsrAndControllerEpoch2.leaderAndIsr().leader() == n2) {
                                throw new StateChangeFailedException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Replica %d for partition %s cannot be moved to NewReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n2), topicAndPartition}))).append((Object)"state as it is being requested to become leader").toString());
                            }
                            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n2})), string, n, leaderIsrAndControllerEpoch2, (Seq<Object>)seq);
                        } else {
                            None$ none$ = None$.MODULE$;
                            Option<LeaderIsrAndControllerEpoch> option4 = option3;
                            if (none$ == null) {
                                if (option4 != null) {
                                    throw new MatchError(option3);
                                }
                            } else if (!none$.equals(option4)) throw new MatchError(option3);
                        }
                        this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)NewReplica$.MODULE$);
                        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to NewReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                        return;
                    }
                    NonExistentReplica$ nonExistentReplica$ = NonExistentReplica$.MODULE$;
                    ReplicaState replicaState4 = replicaState2;
                    if (!(nonExistentReplica$ != null ? !nonExistentReplica$.equals(replicaState4) : replicaState4 != null)) {
                        this.assertValidPreviousStates(string, n, n2, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflineReplica$[]{OfflineReplica$.MODULE$})), replicaState);
                        this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n2})), string, n, true);
                        Seq seq2 = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                        this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, seq2.filterNot((Function1)new Serializable(this, n2){
                            public static final long serialVersionUID;
                            private final int replicaId$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final boolean apply(int n) {
                                return this.apply$mcZI$sp(n);
                            }

                            public boolean apply$mcZI$sp(int n) {
                                return n == this.replicaId$1;
                            }
                            {
                                this.replicaId$1 = n;
                            }
                        }));
                        this.replicaState().remove((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)));
                        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to NonExistentReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                        return;
                    }
                    OnlineReplica$ onlineReplica$ = OnlineReplica$.MODULE$;
                    ReplicaState replicaState5 = replicaState2;
                    if (!(onlineReplica$ != null ? !onlineReplica$.equals(replicaState5) : replicaState5 != null)) {
                        this.assertValidPreviousStates(string, n, n2, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$})), replicaState);
                        ReplicaState replicaState6 = (ReplicaState)this.replicaState().apply((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)));
                        NewReplica$ newReplica$2 = NewReplica$.MODULE$;
                        ReplicaState replicaState7 = replicaState6;
                        if (!(newReplica$2 != null ? !newReplica$2.equals(replicaState7) : replicaState7 != null)) {
                            Seq seq3 = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                            Object object = seq3.contains((Object)BoxesRunTime.boxToInteger((int)n2)) ? BoxedUnit.UNIT : this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, seq3.$colon$plus((Object)BoxesRunTime.boxToInteger((int)n2), Seq$.MODULE$.canBuildFrom()));
                            this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to OnlineReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                        } else {
                            Option option5 = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                            if (option5 instanceof Some) {
                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n2})), string, n, (LeaderIsrAndControllerEpoch)((Some)option5).x(), (Seq<Object>)seq);
                                this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)OnlineReplica$.MODULE$);
                                this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to OnlineReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                            } else {
                                None$ none$ = None$.MODULE$;
                                Option option6 = option5;
                                if (none$ == null) {
                                    if (option6 != null) {
                                        throw new MatchError((Object)option5);
                                    }
                                } else if (!none$.equals(option6)) throw new MatchError((Object)option5);
                            }
                        }
                        this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)OnlineReplica$.MODULE$);
                        return;
                    }
                    OfflineReplica$ offlineReplica$ = OfflineReplica$.MODULE$;
                    ReplicaState replicaState8 = replicaState2;
                    if (offlineReplica$ == null) {
                        if (replicaState8 != null) {
                            throw new MatchError((Object)replicaState2);
                        }
                    } else if (!offlineReplica$.equals(replicaState8)) throw new MatchError((Object)replicaState2);
                    this.assertValidPreviousStates(string, n, n2, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$})), replicaState);
                    option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                    if (!(option instanceof Some)) break block33;
                    if (((LeaderIsrAndControllerEpoch)((Some)option).x()).leaderAndIsr().isr().contains((Object)BoxesRunTime.boxToInteger((int)n2))) {
                        Option<LeaderIsrAndControllerEpoch> option7 = this.kafka$controller$ReplicaStateMachine$$controller.removeReplicaFromIsr(string, n, n2);
                        if (option7 instanceof Some) {
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
                            Some some = (Some)option7;
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch3 = leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderIsrAndControllerEpoch3.leaderAndIsr().leader()})), string, n, leaderIsrAndControllerEpoch3, (Seq<Object>)seq);
                            this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)OfflineReplica$.MODULE$);
                            this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to OfflineReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                            bl = false;
                            break block32;
                        } else {
                            None$ none$ = None$.MODULE$;
                            Option<LeaderIsrAndControllerEpoch> option8 = option7;
                            if (none$ == null) {
                                if (option8 != null) {
                                    throw new MatchError(option7);
                                }
                            } else if (!none$.equals(option8)) throw new MatchError(option7);
                            bl = true;
                        }
                        break block32;
                    } else {
                        this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)OfflineReplica$.MODULE$);
                        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to OfflineReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                        bl = false;
                    }
                    break block32;
                }
                None$ none$ = None$.MODULE$;
                Option option9 = option;
                if (none$ == null) {
                    if (option9 != null) {
                        throw new MatchError((Object)option);
                    }
                } else if (!none$.equals(option9)) throw new MatchError((Object)option);
                bl = true;
            }
            boolean bl2 = bl;
            if (!bl2) return;
            throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Failed to change state of replica %d for partition %s since the leader and isr path in zookeeper is empty").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
        }
        catch (Throwable throwable) {
            this.stateChangeLogger().error((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition [%s,%d] to %s failed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), string, BoxesRunTime.boxToInteger((int)n), replicaState})), throwable);
        }
    }

    private void assertValidPreviousStates(String string, int n, int n2, Seq<ReplicaState> seq, ReplicaState replicaState) {
        Predef$.MODULE$.assert(seq.contains(this.replicaState().apply((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)))), (Function0)new Serializable(this, string, n, n2, seq, replicaState){
            public static final long serialVersionUID;
            private final ReplicaStateMachine $outer;
            private final String topic$1;
            private final int partition$1;
            private final int replicaId$2;
            private final Seq fromStates$1;
            private final ReplicaState targetState$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Replica %s for partition [%s,%d] should be in the %s states before moving to %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$2), this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1), this.fromStates$1.mkString(","), this.targetState$2}))).append((Object)Predef$.MODULE$.augmentString(". Instead it is in %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.replicaState().apply((Object)new Tuple3((Object)this.topic$1, (Object)BoxesRunTime.boxToInteger((int)this.partition$1), (Object)BoxesRunTime.boxToInteger((int)this.replicaId$2)))}))).toString();
            }
            {
                if (replicaStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaStateMachine;
                this.topic$1 = string;
                this.partition$1 = n;
                this.replicaId$2 = n2;
                this.fromStates$1 = seq;
                this.targetState$2 = replicaState;
            }
        });
    }

    private List<String> registerBrokerChangeListener() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerIdsPath(), (IZkChildListener)new BrokerChangeListener(this));
    }

    private void initializeReplicaState() {
        ((IterableLike)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple22 = tuple2;
                if (tuple22 != null) {
                    TopicAndPartition topicAndPartition;
                    TopicAndPartition topicAndPartition2 = topicAndPartition = (TopicAndPartition)tuple22._1();
                    String string = topicAndPartition2.topic();
                    int n = topicAndPartition2.partition();
                    ((IterableLike)tuple22._2()).foreach((Function1)new Serializable(this, string, n){
                        public static final long serialVersionUID;
                        private final $anonfun$initializeReplicaState$2 $outer;
                        private final String topic$2;
                        private final int partition$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Option<ReplicaState> apply(int n) {
                            boolean bl;
                            block4: {
                                Option option;
                                block3: {
                                    block2: {
                                        bl = this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)n));
                                        if (!bl) break block2;
                                        option = this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().replicaState().put((Object)new Tuple3((Object)this.topic$2, (Object)BoxesRunTime.boxToInteger((int)this.partition$2), (Object)BoxesRunTime.boxToInteger((int)n)), (Object)OnlineReplica$.MODULE$);
                                        break block3;
                                    }
                                    if (bl) break block4;
                                    option = this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().replicaState().put((Object)new Tuple3((Object)this.topic$2, (Object)BoxesRunTime.boxToInteger((int)this.partition$2), (Object)BoxesRunTime.boxToInteger((int)n)), (Object)OfflineReplica$.MODULE$);
                                }
                                return option;
                            }
                            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                            this.topic$2 = string;
                            this.partition$2 = n;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple22);
            }

            public ReplicaStateMachine kafka$controller$ReplicaStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if (replicaStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaStateMachine;
            }
        });
    }

    private Set<PartitionAndReplica> getAllReplicasOnBroker(Seq<String> seq, Seq<Object> seq2) {
        return ((TraversableOnce)((GenericTraversableTemplate)seq2.map((Function1)new Serializable(this, seq, seq2){
            public static final long serialVersionUID;
            private final ReplicaStateMachine $outer;
            public final Seq topics$1;
            public final Seq brokerIds$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Iterable<PartitionAndReplica> apply(int n) {
                Map map = (Map)this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, n){
                    public static final long serialVersionUID;
                    private final $anonfun$getAllReplicasOnBroker$1 $outer;
                    private final int brokerId$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                        return this.$outer.topics$1.contains((Object)((TopicAndPartition)tuple2._1()).topic()) && ((SeqLike)tuple2._2()).contains((Object)BoxesRunTime.boxToInteger((int)this.brokerId$1));
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                        this.brokerId$1 = n;
                    }
                });
                if (map.size() == 0) {
                    this.$outer.info((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$getAllReplicasOnBroker$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("No state transitions triggered since no partitions are assigned to brokers %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.brokerIds$1.mkString(",")}));
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                        }
                    });
                }
                return (Iterable)map.map((Function1)new Serializable(this, n){
                    public static final long serialVersionUID;
                    private final int brokerId$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final PartitionAndReplica apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                        return new PartitionAndReplica(((TopicAndPartition)tuple2._1()).topic(), ((TopicAndPartition)tuple2._1()).partition(), this.brokerId$1);
                    }
                    {
                        this.brokerId$1 = n;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
            {
                if (replicaStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaStateMachine;
                this.topics$1 = seq;
                this.brokerIds$1 = seq2;
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms())).toSet();
    }

    public Seq<TopicAndPartition> getPartitionsAssignedToBroker(Seq<String> seq, int n) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, n){
            public static final long serialVersionUID;
            private final int brokerId$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                return ((SeqLike)tuple2._2()).contains((Object)BoxesRunTime.boxToInteger((int)this.brokerId$2));
            }
            {
                this.brokerId$2 = n;
            }
        })).keySet().toSeq();
    }

    public ReplicaStateMachine(KafkaController kafkaController) {
        this.kafka$controller$ReplicaStateMachine$$controller = kafkaController;
        Logging$class.$init$(this);
        this.kafka$controller$ReplicaStateMachine$$controllerContext = kafkaController.controllerContext();
        this.controllerId = kafkaController.config().brokerId();
        this.kafka$controller$ReplicaStateMachine$$zkClient = this.kafka$controller$ReplicaStateMachine$$controllerContext().zkClient();
        this.replicaState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(kafkaController.controllerContext(), (Function3<Object, RequestOrResponse, Function1<RequestOrResponse, BoxedUnit>, BoxedUnit>)new $anonfun$1(this), this.controllerId(), kafkaController.clientId());
        this.kafka$controller$ReplicaStateMachine$$hasStarted = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica state machine on controller ").append((Object)BoxesRunTime.boxToInteger((int)kafkaController.config().brokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class BrokerChangeListener
    implements IZkChildListener,
    Logging {
        public final ReplicaStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Logger logger() {
            if ((this.bitmap$0 & 1) != 0) return this.logger;
            BrokerChangeListener brokerChangeListener = this;
            synchronized (brokerChangeListener) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 |= 1;
                }
                return this.logger;
            }
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string) {
            this.logIdent = string;
        }

        @Override
        public final Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
            this.loggerName = string;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        @Override
        public void trace(Function0<String> function0) {
            Logging$class.trace(this, function0);
        }

        @Override
        public Object trace(Function0<Throwable> function0) {
            return Logging$class.trace(this, function0);
        }

        @Override
        public void trace(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.trace(this, function0, function02);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> function0) {
            Logging$class.swallowTrace(this, function0);
        }

        @Override
        public void debug(Function0<String> function0) {
            Logging$class.debug(this, function0);
        }

        @Override
        public Object debug(Function0<Throwable> function0) {
            return Logging$class.debug(this, function0);
        }

        @Override
        public void debug(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.debug(this, function0, function02);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> function0) {
            Logging$class.swallowDebug(this, function0);
        }

        @Override
        public void info(Function0<String> function0) {
            Logging$class.info(this, function0);
        }

        @Override
        public Object info(Function0<Throwable> function0) {
            return Logging$class.info(this, function0);
        }

        @Override
        public void info(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.info(this, function0, function02);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> function0) {
            Logging$class.swallowInfo(this, function0);
        }

        @Override
        public void warn(Function0<String> function0) {
            Logging$class.warn(this, function0);
        }

        @Override
        public Object warn(Function0<Throwable> function0) {
            return Logging$class.warn(this, function0);
        }

        @Override
        public void warn(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.warn(this, function0, function02);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> function0) {
            Logging$class.swallowWarn(this, function0);
        }

        @Override
        public void swallow(Function0<BoxedUnit> function0) {
            Logging$class.swallow(this, function0);
        }

        @Override
        public void error(Function0<String> function0) {
            Logging$class.error(this, function0);
        }

        @Override
        public Object error(Function0<Throwable> function0) {
            return Logging$class.error(this, function0);
        }

        @Override
        public void error(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.error(this, function0, function02);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> function0) {
            Logging$class.swallowError(this, function0);
        }

        @Override
        public void fatal(Function0<String> function0) {
            Logging$class.fatal(this, function0);
        }

        @Override
        public Object fatal(Function0<Throwable> function0) {
            return Logging$class.fatal(this, function0);
        }

        @Override
        public void fatal(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.fatal(this, function0, function02);
        }

        public void handleChildChange(String string, List<String> list) {
            this.info((Function0<String>)new Serializable(this, string, list){
                public static final long serialVersionUID;
                private final String parentPath$1;
                private final List currentBrokerList$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Broker change listener fired for path %s with children %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentPath$1, JavaConversions$.MODULE$.asScalaBuffer(this.currentBrokerList$1).mkString(",")}));
                }
                {
                    this.parentPath$1 = string;
                    this.currentBrokerList$1 = list;
                }
            });
            Object object = this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerLock();
            synchronized (object) {
                Object object2 = this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$hasStarted().get() ? ControllerStats$.MODULE$.leaderElectionTimer().time(new Serializable(this, list){
                    public static final long serialVersionUID;
                    private final BrokerChangeListener $outer;
                    private final List currentBrokerList$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        try {
                            scala.collection.immutable.Set set = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(this.currentBrokerList$1).map((Function1)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final int apply(String string) {
                                    return Predef$.MODULE$.augmentString(string).toInt();
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).toSet();
                            scala.collection.immutable.Set set2 = (scala.collection.immutable.Set)set.$minus$minus(this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveOrShuttingDownBrokerIds());
                            scala.collection.immutable.Set set3 = (scala.collection.immutable.Set)set2.map((Function1)new Serializable(this){
                                public static final long serialVersionUID;
                                private final BrokerChangeListener$$anonfun$handleChildChange$1 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Option<Broker> apply(int n) {
                                    return ZkUtils$.MODULE$.getBrokerInfo(this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$zkClient(), n);
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                }
                            }, Set$.MODULE$.canBuildFrom());
                            scala.collection.immutable.Set set4 = (scala.collection.immutable.Set)((SetLike)set3.filter((Function1)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final boolean apply(Option<Broker> option) {
                                    return option.isDefined();
                                }
                            })).map((Function1)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Broker apply(Option<Broker> option) {
                                    return (Broker)option.get();
                                }
                            }, Set$.MODULE$.canBuildFrom());
                            scala.collection.immutable.Set set5 = (scala.collection.immutable.Set)this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveOrShuttingDownBrokerIds().$minus$minus((GenTraversableOnce)set);
                            this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokers_$eq((scala.collection.immutable.Set<Broker>)((scala.collection.immutable.Set)((SetLike)((TraversableLike)set.map((Function1)new Serializable(this){
                                public static final long serialVersionUID;
                                private final BrokerChangeListener$$anonfun$handleChildChange$1 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Option<Broker> apply(int n) {
                                    return ZkUtils$.MODULE$.getBrokerInfo(this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$zkClient(), n);
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                }
                            }, Set$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final boolean apply(Option<Broker> option) {
                                    return option.isDefined();
                                }
                            })).map((Function1)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Broker apply(Option<Broker> option) {
                                    return (Broker)option.get();
                                }
                            }, Set$.MODULE$.canBuildFrom())));
                            this.$outer.info((Function0<String>)new Serializable(this, set2, set5){
                                public static final long serialVersionUID;
                                private final BrokerChangeListener$$anonfun$handleChildChange$1 $outer;
                                private final scala.collection.immutable.Set newBrokerIds$1;
                                private final scala.collection.immutable.Set deadBrokerIds$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Newly added brokers: %s, deleted brokers: %s, all live brokers: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newBrokerIds$1.mkString(","), this.deadBrokerIds$1.mkString(","), this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().mkString(",")}));
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                    this.newBrokerIds$1 = set;
                                    this.deadBrokerIds$1 = set2;
                                }
                            });
                            set4.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID;
                                private final BrokerChangeListener$$anonfun$handleChildChange$1 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final void apply(Broker broker) {
                                    this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerChannelManager().addBroker(broker);
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                }
                            });
                            set5.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID;
                                private final BrokerChangeListener$$anonfun$handleChildChange$1 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final void apply(int n) {
                                    this.apply$mcVI$sp(n);
                                }

                                public void apply$mcVI$sp(int n) {
                                    this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerChannelManager().removeBroker(n);
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                }
                            });
                            if (set2.size() > 0) {
                                this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controller.onBrokerStartup((Seq<Object>)set2.toSeq());
                            }
                            if (set5.size() > 0) {
                                this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controller.onBrokerFailure((Seq<Object>)set5.toSeq());
                            }
                        }
                        catch (Throwable throwable) {
                            this.$outer.error((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return "Error while handling broker changes";
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable){
                                public static final long serialVersionUID;
                                private final Throwable e$2;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Throwable apply() {
                                    return this.e$2;
                                }
                                {
                                    this.e$2 = throwable;
                                }
                            });
                        }
                    }

                    public BrokerChangeListener kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if (brokerChangeListener == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = brokerChangeListener;
                        this.currentBrokerList$1 = list;
                    }
                }) : BoxedUnit.UNIT;
                return;
            }
        }

        public ReplicaStateMachine kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer() {
            return this.$outer;
        }

        public BrokerChangeListener(ReplicaStateMachine replicaStateMachine) {
            if (replicaStateMachine == null) {
                throw new NullPointerException();
            }
            this.$outer = replicaStateMachine;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[BrokerChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)replicaStateMachine.kafka$controller$ReplicaStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

