/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Range;
import kafka.utils.Range$class;
import kafka.utils.SystemTime$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001\u0002\u0005\f\u001a!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0003SC:<W\r\u0005\u0002\u0012/%\u0011\u0001D\u0005\u0002\b\u0019><w-\u001b8h!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\u0001\u0002!Q1A\u0005\u0002\u0005\n!\"\\3tg\u0006<WmU3u+\u0005\u0011\u0003CA\u0012%\u001b\u0005\u0011\u0011BA\u0013\u0003\u000591\u0015\u000e\\3NKN\u001c\u0018mZ3TKRD\u0001b\n\u0001\u0003\u0002\u0003\u0006IAI\u0001\f[\u0016\u001c8/Y4f'\u0016$\b\u0005\u0003\u0005*\u0001\t\u0015\r\u0011\"\u0001+\u0003\u0015Ig\u000eZ3y+\u0005Y\u0003CA\u0012-\u0013\ti#AA\u0006PM\u001a\u001cX\r^%oI\u0016D\b\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\r%tG-\u001a=!\u0011!\t\u0004A!b\u0001\n\u0003\u0011\u0014!B:uCJ$X#A\u001a\u0011\u0005i!\u0014BA\u001b\u001c\u0005\u0011auN\\4\t\u0011]\u0002!\u0011!Q\u0001\nM\naa\u001d;beR\u0004\u0003\u0002C\u001d\u0001\u0005\u000b\u0007I\u0011\u0001\u001e\u0002%%tG-\u001a=J]R,'O^1m\u0005f$Xm]\u000b\u0002wA\u0011!\u0004P\u0005\u0003{m\u00111!\u00138u\u0011!y\u0004A!A!\u0002\u0013Y\u0014aE5oI\u0016D\u0018J\u001c;feZ\fGNQ=uKN\u0004\u0003\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\tQLW.\u001a\t\u0003#\rK!\u0001\u0012\n\u0003\tQKW.\u001a\u0005\u0006\r\u0002!\taR\u0001\u0007y%t\u0017\u000e\u001e \u0015\r!K%j\u0013'N!\t\u0019\u0003\u0001C\u0003!\u000b\u0002\u0007!\u0005C\u0003*\u000b\u0002\u00071\u0006C\u00032\u000b\u0002\u00071\u0007C\u0003:\u000b\u0002\u00071\bC\u0003B\u000b\u0002\u0007!\tC\u0004P\u0001\u0001\u0007I\u0011\u0001)\u0002\u001f\u0019L'o\u001d;BaB,g\u000e\u001a+j[\u0016,\u0012!\u0015\t\u00045I\u001b\u0014BA*\u001c\u0005\u0019y\u0005\u000f^5p]\"9Q\u000b\u0001a\u0001\n\u00031\u0016a\u00054jeN$\u0018\t\u001d9f]\u0012$\u0016.\\3`I\u0015\fHCA,[!\tQ\u0002,\u0003\u0002Z7\t!QK\\5u\u0011\u001dYF+!AA\u0002E\u000b1\u0001\u001f\u00132\u0011\u0019i\u0006\u0001)Q\u0005#\u0006\u0001b-\u001b:ti\u0006\u0003\b/\u001a8e)&lW\r\t\u0005\b?\u0002\u0001\r\u0011\"\u0001;\u0003a\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/\u001f\u0005\bC\u0002\u0001\r\u0011\"\u0001c\u0003q\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/_0%KF$\"aV2\t\u000fm\u0003\u0017\u0011!a\u0001w!1Q\r\u0001Q!\nm\n\u0011DY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cH/\u00138eKb,e\u000e\u001e:zA!9q\r\u0001a\u0001\n\u0003A\u0017a\u00023fY\u0016$X\rZ\u000b\u0002SB\u0011!D[\u0005\u0003Wn\u0011qAQ8pY\u0016\fg\u000eC\u0004n\u0001\u0001\u0007I\u0011\u00018\u0002\u0017\u0011,G.\u001a;fI~#S-\u001d\u000b\u0003/>Dqa\u00177\u0002\u0002\u0003\u0007\u0011\u000e\u0003\u0004r\u0001\u0001\u0006K![\u0001\tI\u0016dW\r^3eA!\u0012\u0001o\u001d\t\u00035QL!!^\u000e\u0003\u0011Y|G.\u0019;jY\u0016DQA\u0012\u0001\u0005\u0002]$\u0002\u0002\u0013=\u0002\u0002\u0005\u0015\u0011q\u0001\u0005\u0006sZ\u0004\rA_\u0001\u0004I&\u0014\bCA>\u007f\u001b\u0005a(BA?\r\u0003\tIw.\u0003\u0002\u0000y\n!a)\u001b7f\u0011\u0019\t\u0019A\u001ea\u0001g\u0005Y1\u000f^1si>3gm]3u\u0011\u0015Id\u000f1\u0001<\u0011\u0019\tIA\u001ea\u0001w\u0005aQ.\u0019=J]\u0012,\u0007pU5{K\"1\u0011Q\u0002\u0001\u0005\u0002I\nAa]5{K\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0011!F;qI\u0006$XMR5sgR\f\u0005\u000f]3oIRKW.\u001a\u000b\u0002/\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0011AB1qa\u0016tG\rF\u0003X\u00037\ty\u0002C\u0004\u0002\u001e\u0005U\u0001\u0019A\u001a\u0002\r=4gm]3u\u0011!\t\t#!\u0006A\u0002\u0005\r\u0012\u0001C7fgN\fw-Z:\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b\u0005\u0003\u001diWm]:bO\u0016LA!!\f\u0002(\t!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKRDq!!\r\u0001\t\u0013\t\u0019$A\bue\u0006t7\u000f\\1uK>3gm]3u)\u0011\t)$a\u000f\u0011\u0007\r\n9$C\u0002\u0002:\t\u0011ab\u00144gg\u0016$\bk\\:ji&|g\u000eC\u0004\u0002\u001e\u0005=\u0002\u0019A\u001a\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B\u0005!!/Z1e)!\t\u0019%!\u0013\u0002L\u0005=\u0003\u0003BA\u0013\u0003\u000bJA!a\u0012\u0002(\tQQ*Z:tC\u001e,7+\u001a;\t\u000f\u0005\r\u0011Q\ba\u0001g!9\u0011QJA\u001f\u0001\u0004Y\u0014aB7bqNK'0\u001a\u0005\b\u0003#\ni\u00041\u0001R\u0003%i\u0017\r_(gMN,G\u000fC\u0004\u0002V\u0001!\t%a\u0016\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0017\u0011\u0007%\tY&C\u0002\u0002^)\u0011aa\u0015;sS:<\u0007bBA1\u0001\u0011\u0005\u00111M\u0001\u000biJ,hnY1uKR{GcA,\u0002f!9\u0011QDA0\u0001\u0004\u0019\u0004bBA5\u0001\u0011\u0005\u00111N\u0001\u000b]\u0016DHo\u00144gg\u0016$H#A\u001a\t\u000f\u0005=\u0004\u0001\"\u0001\u0002\u0014\u0005)a\r\\;tQ\"9\u00111\u000f\u0001\u0005\u0002\u0005M\u0011!B2m_N,\u0007f\u0001\u0001\u0002xA\u0019\u0011#!\u001f\n\u0007\u0005m$CA\u0007o_:$\bN]3bIN\fg-\u001a")
public class LogSegment
implements Range,
Logging {
    private final FileMessageSet messageSet;
    private final OffsetIndex index;
    private final long start;
    private final int indexIntervalBytes;
    private final Time time;
    private Option<Object> firstAppendTime;
    private int bytesSinceLastIndexEntry;
    private volatile boolean deleted;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    @Override
    public boolean isEmpty() {
        return Range$class.isEmpty(this);
    }

    @Override
    public boolean contains(long l) {
        return Range$class.contains(this, l);
    }

    public FileMessageSet messageSet() {
        return this.messageSet;
    }

    public OffsetIndex index() {
        return this.index;
    }

    @Override
    public long start() {
        return this.start;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public Option<Object> firstAppendTime() {
        return this.firstAppendTime;
    }

    public void firstAppendTime_$eq(Option<Object> option) {
        this.firstAppendTime = option;
    }

    public int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    public void bytesSinceLastIndexEntry_$eq(int n) {
        this.bytesSinceLastIndexEntry = n;
    }

    public boolean deleted() {
        return this.deleted;
    }

    public void deleted_$eq(boolean bl) {
        this.deleted = bl;
    }

    @Override
    public long size() {
        return this.messageSet().sizeInBytes();
    }

    public void updateFirstAppendTime() {
        if (this.firstAppendTime().isEmpty()) {
            this.firstAppendTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.milliseconds())));
        }
    }

    public void append(long l, ByteBufferMessageSet byteBufferMessageSet) {
        if (byteBufferMessageSet.sizeInBytes() > 0) {
            this.trace((Function0<String>)new Serializable(this, l, byteBufferMessageSet){
                public static final long serialVersionUID;
                private final LogSegment $outer;
                private final long offset$1;
                private final ByteBufferMessageSet messages$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Inserting %d bytes at offset %d at position %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.messageSet().sizeInBytes())}));
                }
                {
                    if (logSegment == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = logSegment;
                    this.offset$1 = l;
                    this.messages$1 = byteBufferMessageSet;
                }
            });
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(l, this.messageSet().sizeInBytes());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.messageSet().append(byteBufferMessageSet);
            this.updateFirstAppendTime();
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + byteBufferMessageSet.sizeInBytes());
        }
    }

    private OffsetPosition translateOffset(long l) {
        OffsetPosition offsetPosition = this.index().lookup(l);
        return this.messageSet().searchFor(l, offsetPosition.position());
    }

    public MessageSet read(long l, int n, Option<Object> option) {
        Option<Object> option2;
        block9: {
            int n2;
            OffsetPosition offsetPosition;
            block8: {
                int n3;
                block7: {
                    if (n < 0) {
                        throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
                    }
                    if (n == 0) {
                        return MessageSet$.MODULE$.Empty();
                    }
                    n3 = this.messageSet().sizeInBytes();
                    offsetPosition = this.translateOffset(l);
                    if (offsetPosition == null) {
                        return MessageSet$.MODULE$.Empty();
                    }
                    option2 = option;
                    None$ none$ = None$.MODULE$;
                    Option<Object> option3 = option2;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block7;
                    n2 = n;
                    break block8;
                }
                if (!(option2 instanceof Some)) break block9;
                Some some = (Some)option2;
                long l2 = BoxesRunTime.unboxToLong((Object)some.x());
                long l3 = l2;
                if (l3 < l) {
                    throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Attempt to read with a maximum offset (%d) less than the start offset (%d).").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l3), BoxesRunTime.boxToLong((long)l)})));
                }
                OffsetPosition offsetPosition2 = this.translateOffset(l3);
                int n4 = offsetPosition2 == null ? n3 : offsetPosition2.position();
                n2 = package$.MODULE$.min(n4 - offsetPosition.position(), n);
            }
            int n5 = n2;
            return this.messageSet().read(offsetPosition.position(), n5);
        }
        throw new MatchError(option2);
    }

    @Override
    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(start=").append((Object)BoxesRunTime.boxToLong((long)this.start())).append((Object)", size=").append((Object)BoxesRunTime.boxToLong((long)this.size())).append((Object)")").toString();
    }

    public void truncateTo(long l) {
        OffsetPosition offsetPosition = this.translateOffset(l);
        if (offsetPosition == null) {
            return;
        }
        this.index().truncateTo(l);
        this.index().resize(this.index().maxIndexSize());
        this.messageSet().truncateTo(offsetPosition.position());
        if (this.messageSet().sizeInBytes() == 0) {
            this.firstAppendTime_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
    }

    public long nextOffset() {
        Option option;
        block4: {
            long l;
            block3: {
                block2: {
                    MessageSet messageSet = this.read(this.index().lastOffset(), this.messageSet().sizeInBytes(), (Option<Object>)None$.MODULE$);
                    option = messageSet.lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    l = this.start();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                l = ((MessageAndOffset)((Some)option).x()).nextOffset();
            }
            return l;
        }
        throw new MatchError((Object)option);
    }

    public void flush() {
        this.messageSet().flush();
        this.index().flush();
    }

    public void close() {
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID;
            private final LogSegment $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.index().close();
            }
            {
                if (logSegment == null) {
                    throw new NullPointerException();
                }
                this.$outer = logSegment;
            }
        });
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID;
            private final LogSegment $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.messageSet().close();
            }
            {
                if (logSegment == null) {
                    throw new NullPointerException();
                }
                this.$outer = logSegment;
            }
        });
    }

    public LogSegment(FileMessageSet fileMessageSet, OffsetIndex offsetIndex, long l, int n, Time time) {
        this.messageSet = fileMessageSet;
        this.index = offsetIndex;
        this.start = l;
        this.indexIntervalBytes = n;
        this.time = time;
        Range$class.$init$(this);
        Logging$class.$init$(this);
        this.firstAppendTime = fileMessageSet.sizeInBytes() > 0 ? new Some((Object)BoxesRunTime.boxToLong((long)time.milliseconds())) : None$.MODULE$;
        this.bytesSinceLastIndexEntry = 0;
        this.deleted = false;
    }

    public LogSegment(File file, long l, int n, int n2) {
        this(new FileMessageSet(Log$.MODULE$.logFilename(file, l)), new OffsetIndex(Log$.MODULE$.indexFilename(file, l), l, n2), l, n, SystemTime$.MODULE$);
    }
}

