/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track1;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.example.kddcup.track1.EstimateConverter;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Track1Callable
implements Callable<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(Track1Callable.class);
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final Recommender recommender;
    private final PreferenceArray userTest;

    Track1Callable(Recommender recommender, PreferenceArray userTest) {
        this.recommender = recommender;
        this.userTest = userTest;
    }

    @Override
    public byte[] call() throws TasteException {
        long userID = this.userTest.get(0).getUserID();
        byte[] result = new byte[this.userTest.length()];
        for (int i = 0; i < this.userTest.length(); ++i) {
            double estimate;
            long itemID = this.userTest.getItemID(i);
            try {
                estimate = this.recommender.estimatePreference(userID, itemID);
            }
            catch (NoSuchItemException nsie) {
                log.warn("Unknown item {}; OK unless this is the real contest data", (Object)itemID);
                continue;
            }
            result[i] = EstimateConverter.convert(estimate, userID, itemID);
        }
        if (COUNT.incrementAndGet() % 10000 == 0) {
            log.info("Completed {} users", (Object)COUNT.get());
        }
        return result;
    }
}

