/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.FloatFunction;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.ObjectFloatProcedure;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractObjectFloatMap<T>
extends AbstractSet {
    public boolean containsKey(final T key) {
        return !this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final float value) {
        return !this.forEachPair(new ObjectFloatProcedure<T>(){

            @Override
            public boolean apply(T iterKey, float iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractObjectFloatMap<T> copy() {
        return (AbstractObjectFloatMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractObjectFloatMap)) {
            return false;
        }
        final AbstractObjectFloatMap other = (AbstractObjectFloatMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ObjectFloatProcedure<T>(){

            @Override
            public boolean apply(T key, float value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ObjectFloatProcedure<T>(){

            @Override
            public boolean apply(T key, float value) {
                return AbstractObjectFloatMap.this.containsKey(key) && AbstractObjectFloatMap.this.get(key) == value;
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachPair(new ObjectFloatProcedure<T>(){
            int i = 0;

            @Override
            public boolean apply(Object key, float value) {
                buf[this.i++] = key.hashCode() ^ HashUtils.hash(value);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(ObjectProcedure<T> var1);

    public boolean forEachPair(final ObjectFloatProcedure<T> procedure) {
        return this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                return procedure.apply(key, AbstractObjectFloatMap.this.get(key));
            }
        });
    }

    public abstract float get(T var1);

    public List<T> keys() {
        ArrayList list = new ArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final List<T> list) {
        list.clear();
        this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(List<T> keyList) {
        this.pairsSortedByValue(keyList, new FloatArrayList(this.size()));
    }

    public void pairsMatching(final ObjectFloatProcedure<T> condition, final List<T> keyList, final FloatArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ObjectFloatProcedure<T>(){

            @Override
            public boolean apply(T key, float value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(List<T> keyList, FloatArrayList valueList) {
        this.keys(keyList);
        if (keyList.isEmpty()) {
            return;
        }
        T k = keyList.get(0);
        if (!(k instanceof Comparable)) {
            throw new UnsupportedOperationException("The key type for this map does not implement comparable");
        }
        Collections.sort(keyList);
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.get(i)));
        }
    }

    public void pairsSortedByValue(final List<T> keyList, FloatArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final float[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                float t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                Object t2 = keyList.get(a);
                keyList.set(a, keyList.get(b));
                keyList.set(b, t2);
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : 0);
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(T var1, float var2);

    public abstract boolean removeKey(T var1);

    public String toString() {
        List<T> theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            T key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ArrayList theKeys = new ArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            Object key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public FloatArrayList values() {
        FloatArrayList list = new FloatArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final FloatArrayList list) {
        list.clear();
        this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                list.add(AbstractObjectFloatMap.this.get(key));
                return true;
            }
        });
    }

    public void assign(final FloatFunction function) {
        this.copy().forEachPair(new ObjectFloatProcedure<T>(){

            @Override
            public boolean apply(T key, float value) {
                AbstractObjectFloatMap.this.put(key, function.apply(value));
                return true;
            }
        });
    }

    public void assign(AbstractObjectFloatMap<T> other) {
        this.clear();
        other.forEachPair(new ObjectFloatProcedure<T>(){

            @Override
            public boolean apply(T key, float value) {
                AbstractObjectFloatMap.this.put(key, value);
                return true;
            }
        });
    }

    public float adjustOrPutValue(T key, float newValue, float incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

