/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DependencyNode;

final class CycleBreakerGraphTransformer
implements DependencyGraphTransformer {
    CycleBreakerGraphTransformer() {
    }

    public DependencyNode transformGraph(DependencyNode dependencyNode, DependencyGraphTransformationContext context) {
        this.flagCycle(dependencyNode, new HashSet<Artifact>(), new HashSet<DependencyNode>());
        return dependencyNode;
    }

    private void flagCycle(DependencyNode node, Set<Artifact> ancestors, Set<DependencyNode> visitedNodes) {
        Artifact artifact = node.getArtifact();
        if (ancestors.contains(artifact)) {
            node.setChildren(new ArrayList());
            HashMap<String, String> newProperties = new HashMap<String, String>(node.getArtifact().getProperties());
            newProperties.put("Cycle", "True");
            node.setArtifact(node.getArtifact().setProperties(newProperties));
            return;
        }
        if (visitedNodes.add(node)) {
            ancestors.add(artifact);
            for (DependencyNode child : node.getChildren()) {
                this.flagCycle(child, ancestors, visitedNodes);
            }
            ancestors.remove(artifact);
        }
    }
}

