/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.unicast;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingUnicastRoutingEngine
implements ShardingRouteEngine {
    private final Collection<String> logicTables;

    @Override
    public void route(RouteContext routeContext, ShardingRule shardingRule) {
        String dataSourceName = this.getRandomDataSourceName(shardingRule.getDataSourceNames());
        RouteMapper dataSourceMapper = new RouteMapper(dataSourceName, dataSourceName);
        if (shardingRule.isAllBroadcastTables(this.logicTables)) {
            ArrayList<RouteMapper> tableMappers = new ArrayList<RouteMapper>(this.logicTables.size());
            for (String each : this.logicTables) {
                tableMappers.add(new RouteMapper(each, each));
            }
            routeContext.getRouteUnits().add(new RouteUnit(dataSourceMapper, tableMappers));
        } else if (this.logicTables.isEmpty()) {
            routeContext.getRouteUnits().add(new RouteUnit(dataSourceMapper, Collections.emptyList()));
        } else if (1 == this.logicTables.size()) {
            String logicTableName = this.logicTables.iterator().next();
            if (!shardingRule.findTableRule(logicTableName).isPresent()) {
                routeContext.getRouteUnits().add(new RouteUnit(dataSourceMapper, Collections.emptyList()));
                return;
            }
            DataNode dataNode = shardingRule.getDataNode(logicTableName);
            routeContext.getRouteUnits().add(new RouteUnit(new RouteMapper(dataNode.getDataSourceName(), dataNode.getDataSourceName()), Collections.singletonList(new RouteMapper(logicTableName, dataNode.getTableName()))));
        } else {
            ArrayList<RouteMapper> tableMappers = new ArrayList<RouteMapper>(this.logicTables.size());
            Sets.SetView availableDatasourceNames = null;
            boolean first = true;
            for (String each : this.logicTables) {
                TableRule tableRule = shardingRule.getTableRule(each);
                DataNode dataNode = (DataNode)tableRule.getActualDataNodes().get(0);
                tableMappers.add(new RouteMapper(each, dataNode.getTableName()));
                Sets.SetView currentDataSourceNames = new HashSet(tableRule.getActualDatasourceNames().size());
                for (DataNode eachDataNode : tableRule.getActualDataNodes()) {
                    currentDataSourceNames.add(eachDataNode.getDataSourceName());
                }
                if (first) {
                    availableDatasourceNames = currentDataSourceNames;
                    first = false;
                    continue;
                }
                availableDatasourceNames = Sets.intersection(availableDatasourceNames, currentDataSourceNames);
            }
            if (availableDatasourceNames.isEmpty()) {
                throw new ShardingSphereConfigurationException("Cannot find actual datasource intersection for logic tables: %s", new Object[]{this.logicTables});
            }
            dataSourceName = this.getRandomDataSourceName((Collection<String>)availableDatasourceNames);
            routeContext.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName, dataSourceName), tableMappers));
        }
    }

    private String getRandomDataSourceName(Collection<String> dataSourceNames) {
        return (String)Lists.newArrayList(dataSourceNames).get(ThreadLocalRandom.current().nextInt(dataSourceNames.size()));
    }

    @Generated
    public ShardingUnicastRoutingEngine(Collection<String> logicTables) {
        this.logicTables = logicTables;
    }
}

