/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.ExpectationAggregator;
import org.apache.spark.ml.clustering.GaussianMixture$;
import org.apache.spark.ml.clustering.GaussianMixtureModel;
import org.apache.spark.ml.clustering.GaussianMixtureParams;
import org.apache.spark.ml.clustering.GaussianMixtureSummary;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.IndexedSeqView;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t}a\u0001\u0002\u000f\u001e\u0001!B\u0001B\u000f\u0001\u0003\u0006\u0004%\te\u000f\u0005\t%\u0002\u0011\t\u0011)A\u0005y!)A\u000b\u0001C\u0001+\")!\f\u0001C!7\")A\u000b\u0001C\u0001K\")q\r\u0001C\u0001Q\")Q\u000e\u0001C\u0001]\")\u0011\u000f\u0001C\u0001e\")Q\u000f\u0001C\u0001m\")Q\u0010\u0001C\u0001}\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\n\u0003?\u0001!\u0019!C\u0005\u0003CAq!a\t\u0001A\u0003%\u0001\u0010C\u0004\u0002&\u0001!\t%a\n\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u0011\u0011\u000e\u0001\u0005\n\u0005-taBAU;!\u0005\u00111\u0016\u0004\u00079uA\t!!,\t\rQ\u001bB\u0011AAa\u0011)\t\u0019m\u0005b\u0001\n\u0003i\u0012\u0011\u0005\u0005\b\u0003\u000b\u001c\u0002\u0015!\u0003y\u0011\u001d\t9m\u0005C!\u0003\u0013D\u0001\"!5\u0014\t\u0003i\u00121\u001b\u0005\t\u0003?\u001cB\u0011A\u000f\u0002b\"A\u0011\u0011_\n\u0005\u0002u\t\u0019\u0010C\u0005\u0003\bM\t\t\u0011\"\u0003\u0003\n\tyq)Y;tg&\fg.T5yiV\u0014XM\u0003\u0002\u001f?\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u0001\n\u0013AA7m\u0015\t\u00113%A\u0003ta\u0006\u00148N\u0003\u0002%K\u00051\u0011\r]1dQ\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0005\u0001%\nD\u0007E\u0002+W5j\u0011aH\u0005\u0003Y}\u0011\u0011\"R:uS6\fGo\u001c:\u0011\u00059zS\"A\u000f\n\u0005Aj\"\u0001F$bkN\u001c\u0018.\u00198NSb$XO]3N_\u0012,G\u000e\u0005\u0002/e%\u00111'\b\u0002\u0016\u000f\u0006,8o]5b]6K\u0007\u0010^;sKB\u000b'/Y7t!\t)\u0004(D\u00017\u0015\t9t$\u0001\u0003vi&d\u0017BA\u001d7\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\f1!^5e+\u0005a\u0004CA\u001fG\u001d\tqD\t\u0005\u0002@\u00056\t\u0001I\u0003\u0002BO\u00051AH]8pizR\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u000ba\u0001\u0015:fI\u00164\u0017BA$I\u0005\u0019\u0019FO]5oO*\u0011QI\u0011\u0015\u0004\u0003)\u0003\u0006CA&O\u001b\u0005a%BA'\"\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u001f2\u0013QaU5oG\u0016\f\u0013!U\u0001\u0006e9\u0002d\u0006M\u0001\u0005k&$\u0007\u0005K\u0002\u0003\u0015B\u000ba\u0001P5oSRtDC\u0001,X!\tq\u0003\u0001C\u0003;\u0007\u0001\u0007A\bK\u0002X\u0015BC3a\u0001&Q\u0003\u0011\u0019w\u000e]=\u0015\u0005Yc\u0006\"B/\u0005\u0001\u0004q\u0016!B3yiJ\f\u0007CA0c\u001b\u0005\u0001'BA1 \u0003\u0015\u0001\u0018M]1n\u0013\t\u0019\u0007M\u0001\u0005QCJ\fW.T1qQ\r!!\n\u0015\u000b\u0002-\"\u001aQA\u0013)\u0002\u001dM,GOR3biV\u0014Xm]\"pYR\u0011\u0011N[\u0007\u0002\u0001!)1N\u0002a\u0001y\u0005)a/\u00197vK\"\u001aaA\u0013)\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGCA5p\u0011\u0015Yw\u00011\u0001=Q\r9!\nU\u0001\u0012g\u0016$\bK]8cC\nLG.\u001b;z\u0007>dGCA5t\u0011\u0015Y\u0007\u00021\u0001=Q\rA!\nU\u0001\u0005g\u0016$8\n\u0006\u0002jo\")1.\u0003a\u0001qB\u0011\u0011P_\u0007\u0002\u0005&\u00111P\u0011\u0002\u0004\u0013:$\bfA\u0005K!\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0005%|\b\"B6\u000b\u0001\u0004A\bf\u0001\u0006K!\u000611/\u001a;U_2$2![A\u0004\u0011\u0019Y7\u00021\u0001\u0002\nA\u0019\u00110a\u0003\n\u0007\u00055!I\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u0017)\u0003\u0016aB:fiN+W\r\u001a\u000b\u0004S\u0006U\u0001BB6\r\u0001\u0004\t9\u0002E\u0002z\u00033I1!a\u0007C\u0005\u0011auN\\4)\u00071Q\u0005+\u0001\u0006ok6\u001c\u0016-\u001c9mKN,\u0012\u0001_\u0001\f]Vl7+Y7qY\u0016\u001c\b%A\u0002gSR$2!LA\u0015\u0011\u001d\tYc\u0004a\u0001\u0003[\tq\u0001Z1uCN,G\u000f\r\u0003\u00020\u0005}\u0002CBA\u0019\u0003o\tY$\u0004\u0002\u00024)\u0019\u0011QG\u0011\u0002\u0007M\fH.\u0003\u0003\u0002:\u0005M\"a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003{\ty\u0004\u0004\u0001\u0005\u0019\u0005\u0005\u0013\u0011FA\u0001\u0002\u0003\u0015\t!a\u0011\u0003\u0007}##'\u0005\u0003\u0002F\u0005-\u0003cA=\u0002H%\u0019\u0011\u0011\n\"\u0003\u000f9{G\u000f[5oOB\u0019\u00110!\u0014\n\u0007\u0005=#IA\u0002B]fD3a\u0004&Q\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BA,\u0003G\u0002B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0005\u0003;\n\u0019$A\u0003usB,7/\u0003\u0003\u0002b\u0005m#AC*ueV\u001cG\u000fV=qK\"9\u0011Q\r\tA\u0002\u0005]\u0013AB:dQ\u0016l\u0017\rK\u0002\u0011\u0015B\u000b!\"\u001b8jiJ\u000bg\u000eZ8n)!\ti'!#\u0002 \u0006\r\u0006cB=\u0002p\u0005M\u0014\u0011P\u0005\u0004\u0003c\u0012%A\u0002+va2,'\u0007E\u0003z\u0003k\nI!C\u0002\u0002x\t\u0013Q!\u0011:sCf\u0004R!_A;\u0003w\u0002r!_A8\u0003{\ni\b\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019iH\u0001\u0007Y&t\u0017\r\\4\n\t\u0005\u001d\u0015\u0011\u0011\u0002\f\t\u0016t7/\u001a,fGR|'\u000fC\u0004\u0002\fF\u0001\r!!$\u0002\u0013%t7\u000f^1oG\u0016\u001c\bCBAH\u0003+\u000bI*\u0004\u0002\u0002\u0012*\u0019\u00111S\u0011\u0002\u0007I$G-\u0003\u0003\u0002\u0018\u0006E%a\u0001*E\tB!\u0011qPAN\u0013\u0011\ti*!!\u0003\rY+7\r^8s\u0011\u0019\t\t+\u0005a\u0001q\u0006Ya.^7DYV\u001cH/\u001a:t\u0011\u0019\t)+\u0005a\u0001q\u0006Ya.^7GK\u0006$XO]3tQ\r\u0001!\nU\u0001\u0010\u000f\u0006,8o]5b]6K\u0007\u0010^;sKB\u0011afE\n\b'\u0005=\u0016QWA^!\rI\u0018\u0011W\u0005\u0004\u0003g\u0013%AB!osJ+g\r\u0005\u00036\u0003o3\u0016bAA]m\t)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007cA=\u0002>&\u0019\u0011q\u0018\"\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005-\u0016\u0001E'B1~sU+T0G\u000b\u0006#VKU#T\u0003Ei\u0015\tW0O+6{f)R!U+J+5\u000bI\u0001\u0005Y>\fG\rF\u0002W\u0003\u0017Da!!4\u0018\u0001\u0004a\u0014\u0001\u00029bi\"D3a\u0006&Q\u0003e\u0019\bn\\;mI\u0012K7\u000f\u001e:jEV$XmR1vgNL\u0017M\\:\u0015\r\u0005U\u00171\\Ao!\rI\u0018q[\u0005\u0004\u00033\u0014%a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003CC\u0002\u0019\u0001=\t\r\u0005\u0015\u0006\u00041\u0001y\u0003m)h\u000e]1dWV\u0003\b/\u001a:Ue&\fgnZ;mCJl\u0015\r\u001e:jqR1\u00111]Au\u0003[\u0004B!a \u0002f&!\u0011q]AA\u0005-!UM\\:f\u001b\u0006$(/\u001b=\t\r\u0005-\u0018\u00041\u0001y\u0003\u0005q\u0007bBAx3\u0001\u0007\u00111O\u0001\u0011iJL\u0017M\\4vY\u0006\u0014h+\u00197vKN\f\u0011$\u001e9eCR,w+Z5hQR\u001c\u0018I\u001c3HCV\u001c8/[1ogRQ\u0011Q_A|\u0003w\fyPa\u0001\u0011\u000fe\fy'!\u0003\u0002|!9\u0011\u0011 \u000eA\u0002\u0005u\u0014\u0001B7fC:Dq!!@\u001b\u0001\u0004\ti(A\u0002d_ZDqA!\u0001\u001b\u0001\u0004\tI!\u0001\u0004xK&<\u0007\u000e\u001e\u0005\b\u0005\u000bQ\u0002\u0019AA\u0005\u0003)\u0019X/\\,fS\u001eDGo]\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\fA!!Q\u0002B\f\u001b\t\u0011yA\u0003\u0003\u0003\u0012\tM\u0011\u0001\u00027b]\u001eT!A!\u0006\u0002\t)\fg/Y\u0005\u0005\u00053\u0011yA\u0001\u0004PE*,7\r\u001e\u0015\u0004')\u0003\u0006f\u0001\nK!\u0002")
public class GaussianMixture
extends Estimator<GaussianMixtureModel>
implements GaussianMixtureParams,
DefaultParamsWritable {
    private final String uid;
    private final int numSamples;
    private final IntParam k;
    private final DoubleParam tol;
    private final Param<String> probabilityCol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static GaussianMixture load(String string) {
        return GaussianMixture$.MODULE$.load(string);
    }

    public static MLReader<GaussianMixture> read() {
        return GaussianMixture$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return GaussianMixtureParams.getK$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return GaussianMixtureParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final void org$apache$spark$ml$clustering$GaussianMixtureParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public GaussianMixture copy(ParamMap extra) {
        return (GaussianMixture)this.defaultCopy(extra);
    }

    public GaussianMixture setFeaturesCol(String value) {
        return (GaussianMixture)this.set(this.featuresCol(), value);
    }

    public GaussianMixture setPredictionCol(String value) {
        return (GaussianMixture)this.set(this.predictionCol(), value);
    }

    public GaussianMixture setProbabilityCol(String value) {
        return (GaussianMixture)this.set(this.probabilityCol(), value);
    }

    public GaussianMixture setK(int value) {
        return (GaussianMixture)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public GaussianMixture setMaxIter(int value) {
        return (GaussianMixture)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public GaussianMixture setTol(double value) {
        return (GaussianMixture)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public GaussianMixture setSeed(long value) {
        return (GaussianMixture)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    private int numSamples() {
        return this.numSamples;
    }

    @Override
    public GaussianMixtureModel fit(Dataset<?> dataset) {
        return (GaussianMixtureModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            int iter;
            this.transformSchema(dataset.schema(), true);
            SparkContext sc = dataset.sparkSession().sparkContext();
            int numClusters = BoxesRunTime.unboxToInt((Object)this.$(this.k()));
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol())})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                org.apache.spark.ml.linalg.Vector vector;
                Object features;
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((features = ((SeqLike)some.get()).apply(0)) instanceof org.apache.spark.ml.linalg.Vector)) {
                    throw new MatchError((Object)row);
                }
                org.apache.spark.ml.linalg.Vector vector2 = vector = (org.apache.spark.ml.linalg.Vector)features;
                return vector2;
            }, ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class));
            Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            int numFeatures = ((org.apache.spark.ml.linalg.Vector)instances.first()).size();
            Predef$.MODULE$.require(numFeatures < GaussianMixture$.MODULE$.MAX_NUM_FEATURES(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("GaussianMixture cannot handle more ").append(new StringBuilder(49).append("than ").append(GaussianMixture$.MODULE$.MAX_NUM_FEATURES()).append(" features because the size of the covariance").toString()).append(" matrix is quadratic in the number of features.").toString());
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.featuresCol(), this.predictionCol(), this.probabilityCol(), this.k(), this.maxIter(), this.seed(), this.tol()}));
            instr.logNumFeatures(numFeatures);
            boolean shouldDistributeGaussians = GaussianMixture$.MODULE$.shouldDistributeGaussians(numClusters, numFeatures);
            Tuple2<double[], Tuple2<DenseVector, DenseVector>[]> tuple2 = this.initRandom((RDD<org.apache.spark.ml.linalg.Vector>)instances, numClusters, numFeatures);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            double[] weights = (double[])tuple2._1();
            Tuple2[] gaussians = (Tuple2[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)weights, (Object)gaussians);
            Tuple2 tuple23 = tuple22;
            double[] weights2 = (double[])tuple23._1();
            Tuple2[] gaussians2 = (Tuple2[])tuple23._2();
            double logLikelihood = Double$.MODULE$.MinValue();
            double logLikelihoodPrev = 0.0;
            for (iter = 0; iter < BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())) && package$.MODULE$.abs(logLikelihood - logLikelihoodPrev) > BoxesRunTime.unboxToDouble((Object)this.$(this.tol())); ++iter) {
                Broadcast bcWeights = instances.sparkContext().broadcast((Object)weights2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                Broadcast bcGaussians = instances.sparkContext().broadcast((Object)gaussians2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
                ExpectationAggregator x$1 = new ExpectationAggregator(numFeatures, (Broadcast<double[]>)bcWeights, (Broadcast<Tuple2<DenseVector, DenseVector>[]>)bcGaussians);
                Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(c, v) -> {
                    Tuple2 tuple2 = new Tuple2(c, v);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    ExpectationAggregator aggregator = (ExpectationAggregator)tuple2._1();
                    org.apache.spark.ml.linalg.Vector instance = (org.apache.spark.ml.linalg.Vector)tuple2._2();
                    ExpectationAggregator expectationAggregator = aggregator.add(instance);
                    return expectationAggregator;
                };
                Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(c1, c2) -> {
                    Tuple2 tuple2 = new Tuple2(c1, c2);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    ExpectationAggregator aggregator1 = (ExpectationAggregator)tuple2._1();
                    ExpectationAggregator aggregator2 = (ExpectationAggregator)tuple2._2();
                    ExpectationAggregator expectationAggregator = aggregator1.merge(aggregator2);
                    return expectationAggregator;
                };
                int x$4 = instances.treeAggregate$default$4((Object)x$1);
                ExpectationAggregator sums = (ExpectationAggregator)instances.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(ExpectationAggregator.class));
                bcWeights.destroy(false);
                bcGaussians.destroy(false);
                if (iter == 0) {
                    long numSamples = sums.count();
                    instr.logNumExamples(numSamples);
                }
                double sumWeights = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sums.weights())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                if (shouldDistributeGaussians) {
                    int numPartitions = package$.MODULE$.min(numClusters, 1024);
                    Seq tuples = (Seq)Seq$.MODULE$.tabulate(numClusters, (Function1 & Serializable & scala.Serializable)i -> GaussianMixture.$anonfun$fit$6(sums, BoxesRunTime.unboxToInt((Object)i)));
                    Tuple2 tuple24 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sc.parallelize(tuples, numPartitions, ClassTag$.MODULE$.apply(Tuple3.class)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple3 tuple3 = x0$2;
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        DenseVector mean = (DenseVector)tuple3._1();
                        DenseVector cov = (DenseVector)tuple3._2();
                        double weight = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        Tuple2<Object, Tuple2<DenseVector, DenseVector>> tuple2 = GaussianMixture$.MODULE$.updateWeightsAndGaussians(mean, cov, weight, sumWeights);
                        return tuple2;
                    }, ClassTag$.MODULE$.apply(Tuple2.class)).collect())).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple2.class));
                    if (tuple24 == null) {
                        throw new MatchError((Object)tuple24);
                    }
                    double[] ws = (double[])tuple24._1();
                    Tuple2[] gs = (Tuple2[])tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)ws, (Object)gs);
                    Tuple2 tuple26 = tuple25;
                    double[] ws2 = (double[])tuple26._1();
                    Tuple2[] gs2 = (Tuple2[])tuple26._2();
                    Array$.MODULE$.copy((Object)ws2, 0, (Object)weights2, 0, ws2.length);
                    Array$.MODULE$.copy((Object)gs2, 0, (Object)gaussians2, 0, gs2.length);
                } else {
                    for (int i2 = 0; i2 < numClusters; ++i2) {
                        Tuple2<Object, Tuple2<DenseVector, DenseVector>> tuple27 = GaussianMixture$.MODULE$.updateWeightsAndGaussians(sums.means()[i2], sums.covs()[i2], sums.weights()[i2], sumWeights);
                        if (tuple27 == null) {
                            throw new MatchError(tuple27);
                        }
                        double weight = tuple27._1$mcD$sp();
                        Tuple2 gaussian = (Tuple2)tuple27._2();
                        Tuple2 tuple28 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)weight), (Object)gaussian);
                        Tuple2 tuple29 = tuple28;
                        double weight2 = tuple29._1$mcD$sp();
                        Tuple2 gaussian2 = (Tuple2)tuple29._2();
                        weights2[i2] = weight2;
                        gaussians2[i2] = gaussian2;
                    }
                }
                logLikelihoodPrev = logLikelihood;
                logLikelihood = sums.logLikelihood();
            }
            Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
            MultivariateGaussian[] gaussianDists = (MultivariateGaussian[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gaussians2)).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DenseVector mean = (DenseVector)tuple2._1();
                DenseVector covVec = (DenseVector)tuple2._2();
                DenseMatrix cov = GaussianMixture$.MODULE$.unpackUpperTriangularMatrix(numFeatures, covVec.values());
                MultivariateGaussian multivariateGaussian = new MultivariateGaussian((org.apache.spark.ml.linalg.Vector)mean, (Matrix)cov);
                return multivariateGaussian;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
            GaussianMixtureModel model = ((Model)this.copyValues(new GaussianMixtureModel(this.uid(), weights2, gaussianDists), this.copyValues$default$2())).setParent(this);
            GaussianMixtureSummary summary = new GaussianMixtureSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.probabilityCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), logLikelihood, iter);
            instr.logNamedValue("logLikelihood", logLikelihood);
            instr.logNamedValue("clusterSizes", summary.clusterSizes());
            return model.setSummary((Option<GaussianMixtureSummary>)new Some((Object)summary));
        });
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    private Tuple2<double[], Tuple2<DenseVector, DenseVector>[]> initRandom(RDD<org.apache.spark.ml.linalg.Vector> instances, int numClusters, int numFeatures) {
        org.apache.spark.ml.linalg.Vector[] samples = (org.apache.spark.ml.linalg.Vector[])instances.takeSample(true, numClusters * this.numSamples(), BoxesRunTime.unboxToLong((Object)this.$(this.seed())));
        double[] weights = (double[])Array$.MODULE$.fill(numClusters, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0 / (double)numClusters, ClassTag$.MODULE$.Double());
        Tuple2[] gaussians = (Tuple2[])Array$.MODULE$.tabulate(numClusters, (Function1 & Serializable & scala.Serializable)i -> GaussianMixture.$anonfun$initRandom$2(this, samples, numFeatures, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class));
        return new Tuple2((Object)weights, (Object)gaussians);
    }

    public static final /* synthetic */ Tuple3 $anonfun$fit$6(ExpectationAggregator sums$1, int i) {
        return new Tuple3((Object)sums$1.means()[i], (Object)sums$1.covs()[i], (Object)BoxesRunTime.boxToDouble((double)sums$1.weights()[i]));
    }

    public static final /* synthetic */ void $anonfun$initRandom$5(DenseVector covVec$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double v = tuple2._1$mcD$sp();
        int i = tuple2._2$mcI$sp();
        double d = v;
        int n = i;
        covVec$1.values()[n + n * (n + 1) / 2] = d;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Tuple2 $anonfun$initRandom$2(GaussianMixture $this, org.apache.spark.ml.linalg.Vector[] samples$1, int numFeatures$2, int i) {
        IndexedSeqView slice = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])samples$1)).view(i * $this.numSamples(), (i + 1) * $this.numSamples());
        DenseVector v = new DenseVector(new double[numFeatures$2]);
        for (int i2 = 0; i2 < $this.numSamples(); ++i2) {
            BLAS$.MODULE$.axpy(1.0, (org.apache.spark.ml.linalg.Vector)slice.apply(i2), (org.apache.spark.ml.linalg.Vector)v);
        }
        BLAS$.MODULE$.scal(1.0 / (double)$this.numSamples(), (org.apache.spark.ml.linalg.Vector)v);
        DenseVector mean = v;
        Vector ss = new DenseVector(new double[numFeatures$2]).asBreeze();
        slice.foreach((Function1 & Serializable & scala.Serializable)xi -> (Vector)ss.$plus$eq(((ImmutableNumericOps)xi.asBreeze().$minus((Object)mean.asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub())).$up$colon$up((Object)BoxesRunTime.boxToDouble((double)2.0), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpPow()), (UFunc.InPlaceImpl2)Vector$.MODULE$.v_v_Idempotent_UpdateOp_Double_OpAdd()));
        org.apache.spark.ml.linalg.Vector diagVec = Vectors$.MODULE$.fromBreeze(ss);
        BLAS$.MODULE$.scal(1.0 / (double)$this.numSamples(), diagVec);
        DenseVector covVec = new DenseVector((double[])Array$.MODULE$.fill(numFeatures$2 * (numFeatures$2 + 1) / 2, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(diagVec.toArray())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GaussianMixture.$anonfun$initRandom$5(covVec, x0$1);
            return BoxedUnit.UNIT;
        });
        DenseVector cov = covVec;
        return new Tuple2((Object)mean, (Object)cov);
    }

    public GaussianMixture(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasProbabilityCol.$init$(this);
        HasTol.$init$(this);
        GaussianMixtureParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.k().$minus$greater(BoxesRunTime.boxToInteger((int)2)), this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100)), this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)0.01))}));
        this.numSamples = 5;
    }

    public GaussianMixture() {
        this(Identifiable$.MODULE$.randomUID("GaussianMixture"));
    }
}

