/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import breeze.linalg.DenseVector;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.GaussianMixtureModel$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelWriter$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelWriter$Data$;
import org.apache.spark.ml.clustering.GaussianMixtureParams;
import org.apache.spark.ml.clustering.GaussianMixtureSummary;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\u0015e\u0001\u0002\"D\u00019C\u0001B\u0018\u0001\u0003\u0006\u0004%\te\u0018\u0005\tm\u0002\u0011\t\u0011)A\u0005A\"A\u0001\u0010\u0001BC\u0002\u0013\u0005\u0011\u0010C\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005u\"Q\u0011\u0011\u0002\u0001\u0003\u0006\u0004%\t!a\u0003\t\u0015\u0005\u0005\u0002A!A!\u0002\u0013\ti\u0001\u0003\u0005\u0002&\u0001!\t!RA\u0014\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u00111\u000e\u0001\u0005B\u00055\u0004bBA\\\u0001\u0011\u0005\u0013\u0011\u0018\u0005\t\u0003\u001b\u0004A\u0011A\"\u0002P\"A\u0011q\u001d\u0001\u0005\u0002\r\u000bI\u000fC\u0004\u0002n\u0002!\t!a<\t\u000f\u0005M\b\u0001\"\u0011\u0002v\"I\u0011q \u0001A\u0002\u0013%!\u0011\u0001\u0005\n\u0005\u001f\u0001\u0001\u0019!C\u0005\u0005#A\u0001B!\b\u0001A\u0003&!1\u0001\u0005\t\u0005?\u0001A\u0011A\"\u0003\"!9!q\u0005\u0001\u0005\u0002\t%\u0002b\u0002B\u0013\u0001\u0011\u0005!1G\u0004\b\u0005s\u0019\u0005\u0012\u0001B\u001e\r\u0019\u00115\t#\u0001\u0003>!9\u0011QE\r\u0005\u0002\tE\u0003b\u0002B*3\u0011\u0005#Q\u000b\u0005\b\u0005?JB\u0011\tB1\r\u001d\u0011I'\u0007\u0001\u001a\u0005WB\u0011B!\u001c\u001e\u0005\u0003\u0005\u000b\u0011B*\t\u000f\u0005\u0015R\u0004\"\u0001\u0003p\u00191!qO\u000fE\u0005sB\u0001\u0002\u001f\u0011\u0003\u0016\u0004%\t!\u001f\u0005\n\u0003\u000b\u0001#\u0011#Q\u0001\niD!B!!!\u0005+\u0007I\u0011\u0001BB\u0011)\u0011\u0019\n\tB\tB\u0003%!Q\u0011\u0005\u000b\u0005+\u0003#Q3A\u0005\u0002\t]\u0005B\u0003BQA\tE\t\u0015!\u0003\u0003\u001a\"9\u0011Q\u0005\u0011\u0005\u0002\t\r\u0006\"CA+A\u0005\u0005I\u0011\u0001BX\u0011%\u00119\fII\u0001\n\u0003\u0011I\fC\u0005\u0003N\u0002\n\n\u0011\"\u0001\u0003P\"I!1\u001b\u0011\u0012\u0002\u0013\u0005!Q\u001b\u0005\n\u00053\u0004\u0013\u0011!C!\u00057D\u0011Ba;!\u0003\u0003%\tA!<\t\u0013\t=\b%!A\u0005\u0002\tE\b\"\u0003B{A\u0005\u0005I\u0011\tB|\u0011%\u0019)\u0001IA\u0001\n\u0003\u00199\u0001C\u0005\u0004\f\u0001\n\t\u0011\"\u0011\u0004\u000e!I1q\u0002\u0011\u0002\u0002\u0013\u00053\u0011\u0003\u0005\n\u0007'\u0001\u0013\u0011!C!\u0007+9\u0011b!\u0007\u001e\u0003\u0003EIaa\u0007\u0007\u0013\t]T$!A\t\n\ru\u0001bBA\u0013k\u0011\u000511\u0006\u0005\n\u0007\u001f)\u0014\u0011!C#\u0007#A\u0011b!\f6\u0003\u0003%\tia\f\t\u0013\r]R'!A\u0005\u0002\u000ee\u0002bBB$;\u0011E3\u0011\n\u0004\u0007\u0007\u001bJBaa\u0014\t\u000f\u0005\u00152\b\"\u0001\u0004R!I1QK\u001eC\u0002\u0013%!1\u001c\u0005\t\u0007/Z\u0004\u0015!\u0003\u0003^\"9!qL\u001e\u0005B\re\u0003\u0002CB/3\u0011\u00051ia\u0018\t\u0013\r]\u0014$!A\u0005\n\re$\u0001F$bkN\u001c\u0018.\u00198NSb$XO]3N_\u0012,GN\u0003\u0002E\u000b\u0006Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u0019;\u0015AA7m\u0015\tA\u0015*A\u0003ta\u0006\u00148N\u0003\u0002K\u0017\u00061\u0011\r]1dQ\u0016T\u0011\u0001T\u0001\u0004_J<7\u0001A\n\u0005\u0001=+\u0006\fE\u0002Q#Nk\u0011!R\u0005\u0003%\u0016\u0013Q!T8eK2\u0004\"\u0001\u0016\u0001\u000e\u0003\r\u0003\"\u0001\u0016,\n\u0005]\u001b%!F$bkN\u001c\u0018.\u00198NSb$XO]3QCJ\fWn\u001d\t\u00033rk\u0011A\u0017\u0006\u00037\u0016\u000bA!\u001e;jY&\u0011QL\u0017\u0002\u000b\u001b2;&/\u001b;bE2,\u0017aA;jIV\t\u0001\r\u0005\u0002bU:\u0011!\r\u001b\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K6\u000ba\u0001\u0010:p_Rt$\"A4\u0002\u000bM\u001c\u0017\r\\1\n\u0005%4\u0017A\u0002)sK\u0012,g-\u0003\u0002lY\n11\u000b\u001e:j]\u001eT!!\u001b4)\u0007\u0005qG\u000f\u0005\u0002pe6\t\u0001O\u0003\u0002r\u000f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005M\u0004(!B*j]\u000e,\u0017%A;\u0002\u000bIr\u0003G\f\u0019\u0002\tULG\r\t\u0015\u0004\u00059$\u0018aB<fS\u001eDGo]\u000b\u0002uB\u00191\u0010 @\u000e\u0003\u0019L!! 4\u0003\u000b\u0005\u0013(/Y=\u0011\u0005m|\u0018bAA\u0001M\n1Ai\\;cY\u0016D3a\u00018u\u0003!9X-[4iiN\u0004\u0003f\u0001\u0003oi\u0006Iq-Y;tg&\fgn]\u000b\u0003\u0003\u001b\u0001Ba\u001f?\u0002\u0010A!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011\u0001\u00043jgR\u0014\u0018NY;uS>t'bAA\r\u000b\u0006!1\u000f^1u\u0013\u0011\ti\"a\u0005\u0003)5+H\u000e^5wCJL\u0017\r^3HCV\u001c8/[1oQ\r)a\u000e^\u0001\u000bO\u0006,8o]5b]N\u0004\u0003f\u0001\u0004oi\u00061A(\u001b8jiz\"raUA\u0015\u0003[\t\t\u0004C\u0003_\u000f\u0001\u0007\u0001\r\u000b\u0003\u0002*9$\b\"\u0002=\b\u0001\u0004Q\b\u0006BA\u0017]RDq!!\u0003\b\u0001\u0004\ti\u0001\u000b\u0003\u000229$\u0018AD:fi\u001a+\u0017\r^;sKN\u001cu\u000e\u001c\u000b\u0005\u0003s\tY$D\u0001\u0001\u0011\u0019\ti\u0004\u0003a\u0001A\u0006)a/\u00197vK\"\"\u0001B\\A!C\t\t\u0019%A\u00033]Er\u0003'\u0001\ttKR\u0004&/\u001a3jGRLwN\\\"pYR!\u0011\u0011HA%\u0011\u0019\ti$\u0003a\u0001A\"\"\u0011B\\A!\u0003E\u0019X\r\u001e)s_\n\f'-\u001b7jif\u001cu\u000e\u001c\u000b\u0005\u0003s\t\t\u0006\u0003\u0004\u0002>)\u0001\r\u0001\u0019\u0015\u0005\u00159\f\t%\u0001\u0003d_BLHcA*\u0002Z!9\u00111L\u0006A\u0002\u0005u\u0013!B3yiJ\f\u0007\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rT)A\u0003qCJ\fW.\u0003\u0003\u0002h\u0005\u0005$\u0001\u0003)be\u0006lW*\u00199)\u0007-qG/A\u0005ue\u0006t7OZ8s[R!\u0011qNAI!\u0011\t\t(a#\u000f\t\u0005M\u0014Q\u0011\b\u0005\u0003k\n\tI\u0004\u0003\u0002x\u0005}d\u0002BA=\u0003{r1aYA>\u0013\u0005a\u0015B\u0001&L\u0013\tA\u0015*C\u0002\u0002\u0004\u001e\u000b1a]9m\u0013\u0011\t9)!#\u0002\u000fA\f7m[1hK*\u0019\u00111Q$\n\t\u00055\u0015q\u0012\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!a\"\u0002\n\"9\u00111\u0013\u0007A\u0002\u0005U\u0015a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003/\u000b\u0019\u000b\u0005\u0004\u0002\u001a\u0006m\u0015qT\u0007\u0003\u0003\u0013KA!!(\u0002\n\n9A)\u0019;bg\u0016$\b\u0003BAQ\u0003Gc\u0001\u0001\u0002\u0007\u0002&\u0006E\u0015\u0011!A\u0001\u0006\u0003\t9KA\u0002`IE\nB!!+\u00020B\u001910a+\n\u0007\u00055fMA\u0004O_RD\u0017N\\4\u0011\u0007m\f\t,C\u0002\u00024\u001a\u00141!\u00118zQ\raa\u000e^\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR!\u00111XAd!\u0011\ti,a1\u000e\u0005\u0005}&\u0002BAa\u0003\u0013\u000bQ\u0001^=qKNLA!!2\u0002@\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005%W\u00021\u0001\u0002<\u000611o\u00195f[\u0006D3!\u00048u\u0003\u001d\u0001(/\u001a3jGR$B!!5\u0002XB\u001910a5\n\u0007\u0005UgMA\u0002J]RDq!!7\u000f\u0001\u0004\tY.\u0001\u0005gK\u0006$XO]3t!\u0011\ti.a9\u000e\u0005\u0005}'bAAq\u000b\u00061A.\u001b8bY\u001eLA!!:\u0002`\n1a+Z2u_J\f!\u0003\u001d:fI&\u001cG\u000f\u0015:pE\u0006\u0014\u0017\u000e\\5usR!\u00111\\Av\u0011\u001d\tIn\u0004a\u0001\u00037\f1bZ1vgNL\u0017M\\:E\rV\u0011\u0011q\u000e\u0015\u0004!9$\u0018!B<sSR,WCAA|!\rI\u0016\u0011`\u0005\u0004\u0003wT&\u0001C'M/JLG/\u001a:)\u0007EqG/A\bue\u0006Lg.\u001b8h'VlW.\u0019:z+\t\u0011\u0019\u0001E\u0003|\u0005\u000b\u0011I!C\u0002\u0003\b\u0019\u0014aa\u00149uS>t\u0007c\u0001+\u0003\f%\u0019!QB\"\u0003-\u001d\u000bWo]:jC:l\u0015\u000e\u001f;ve\u0016\u001cV/\\7bef\f1\u0003\u001e:bS:LgnZ*v[6\f'/_0%KF$BAa\u0005\u0003\u001aA\u00191P!\u0006\n\u0007\t]aM\u0001\u0003V]&$\b\"\u0003B\u000e'\u0005\u0005\t\u0019\u0001B\u0002\u0003\rAH%M\u0001\u0011iJ\f\u0017N\\5oON+X.\\1ss\u0002\n!b]3u'VlW.\u0019:z)\u0011\tIDa\t\t\u000f\t\u0015R\u00031\u0001\u0003\u0004\u000591/^7nCJL\u0018A\u00035bgN+X.\\1ssV\u0011!1\u0006\t\u0004w\n5\u0012b\u0001B\u0018M\n9!i\\8mK\u0006t\u0007f\u0001\foiV\u0011!\u0011\u0002\u0015\u0004/9$\bf\u0001\u0001oi\u0006!r)Y;tg&\fg.T5yiV\u0014X-T8eK2\u0004\"\u0001V\r\u0014\u000fe\u0011yD!\u0012\u0003LA\u00191P!\u0011\n\u0007\t\rcM\u0001\u0004B]f\u0014VM\u001a\t\u00053\n\u001d3+C\u0002\u0003Ji\u0013!\"\u0014'SK\u0006$\u0017M\u00197f!\rY(QJ\u0005\u0004\u0005\u001f2'\u0001D*fe&\fG.\u001b>bE2,GC\u0001B\u001e\u0003\u0011\u0011X-\u00193\u0016\u0005\t]\u0003\u0003B-\u0003ZMK1Aa\u0017[\u0005!iEJU3bI\u0016\u0014\bfA\u000eoi\u0006!An\\1e)\r\u0019&1\r\u0005\u0007\u0005Kb\u0002\u0019\u00011\u0002\tA\fG\u000f\u001b\u0015\u000499$(AG$bkN\u001c\u0018.\u00198NSb$XO]3N_\u0012,Gn\u0016:ji\u0016\u00148cA\u000f\u0002x\u0006A\u0011N\\:uC:\u001cW\r\u0006\u0003\u0003r\tU\u0004c\u0001B:;5\t\u0011\u0004\u0003\u0004\u0003n}\u0001\ra\u0015\u0002\u0005\t\u0006$\u0018mE\u0004!\u0005\u007f\u0011YHa\u0013\u0011\u0007m\u0014i(C\u0002\u0003\u0000\u0019\u0014q\u0001\u0015:pIV\u001cG/A\u0002nkN,\"A!\"\u0011\tmd(q\u0011\t\u0005\u0005\u0013\u0013\t*\u0004\u0002\u0003\f*!\u0011\u0011\u001dBG\u0015\r\u0011yiR\u0001\u0006[2d\u0017NY\u0005\u0005\u0003K\u0014Y)\u0001\u0003nkN\u0004\u0013AB:jO6\f7/\u0006\u0002\u0003\u001aB!1\u0010 BN!\u0011\u0011II!(\n\t\t}%1\u0012\u0002\u0007\u001b\u0006$(/\u001b=\u0002\u000fMLw-\\1tAQA!Q\u0015BU\u0005W\u0013i\u000bE\u0002\u0003(\u0002j\u0011!\b\u0005\u0006q\u001e\u0002\rA\u001f\u0005\b\u0005\u0003;\u0003\u0019\u0001BC\u0011\u001d\u0011)j\na\u0001\u00053#\u0002B!*\u00032\nM&Q\u0017\u0005\bq\"\u0002\n\u00111\u0001{\u0011%\u0011\t\t\u000bI\u0001\u0002\u0004\u0011)\tC\u0005\u0003\u0016\"\u0002\n\u00111\u0001\u0003\u001a\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B^U\rQ(QX\u0016\u0003\u0005\u007f\u0003BA!1\u0003J6\u0011!1\u0019\u0006\u0005\u0005\u000b\u00149-A\u0005v]\u000eDWmY6fI*\u0011\u0011OZ\u0005\u0005\u0005\u0017\u0014\u0019MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003R*\"!Q\u0011B_\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa6+\t\te%QX\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tu\u0007\u0003\u0002Bp\u0005Sl!A!9\u000b\t\t\r(Q]\u0001\u0005Y\u0006twM\u0003\u0002\u0003h\u0006!!.\u0019<b\u0013\rY'\u0011]\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003#\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00020\nM\b\"\u0003B\u000e]\u0005\u0005\t\u0019AAi\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B}!\u0019\u0011Yp!\u0001\u000206\u0011!Q \u0006\u0004\u0005\u007f4\u0017AC2pY2,7\r^5p]&!11\u0001B\u007f\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t-2\u0011\u0002\u0005\n\u00057\u0001\u0014\u0011!a\u0001\u0003_\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003#\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005;\fa!Z9vC2\u001cH\u0003\u0002B\u0016\u0007/A\u0011Ba\u00074\u0003\u0003\u0005\r!a,\u0002\t\u0011\u000bG/\u0019\t\u0004\u0005O+4#B\u001b\u0004 \t-\u0003cCB\u0011\u0007OQ(Q\u0011BM\u0005Kk!aa\t\u000b\u0007\r\u0015b-A\u0004sk:$\u0018.\\3\n\t\r%21\u0005\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAB\u000e\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011)k!\r\u00044\rU\u0002\"\u0002=9\u0001\u0004Q\bb\u0002BAq\u0001\u0007!Q\u0011\u0005\b\u0005+C\u0004\u0019\u0001BM\u0003\u001d)h.\u00199qYf$Baa\u000f\u0004DA)1P!\u0002\u0004>AA1pa\u0010{\u0005\u000b\u0013I*C\u0002\u0004B\u0019\u0014a\u0001V;qY\u0016\u001c\u0004\"CB#s\u0005\u0005\t\u0019\u0001BS\u0003\rAH\u0005M\u0001\tg\u00064X-S7qYR!!1CB&\u0011\u0019\u0011)G\u000fa\u0001A\nQr)Y;tg&\fg.T5yiV\u0014X-T8eK2\u0014V-\u00193feN\u00191Ha\u0016\u0015\u0005\rM\u0003c\u0001B:w\u0005I1\r\\1tg:\u000bW.Z\u0001\u000bG2\f7o\u001d(b[\u0016\u0004CcA*\u0004\\!1!QM A\u0002\u0001\fAcY8naV$X\r\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHc\u0002>\u0004b\rE4Q\u000f\u0005\b\u00033\u0004\u0005\u0019AB2!\u0015\u0019)g!\u001c\u007f\u001b\t\u00199G\u0003\u0003\u0002b\u000e%$BAB6\u0003\u0019\u0011'/Z3{K&!1qNB4\u0005-!UM\\:f-\u0016\u001cGo\u001c:\t\u000f\rM\u0004\t1\u0001\u0002\u000e\u0005)A-[:ug\")\u0001\u0010\u0011a\u0001u\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019Y\b\u0005\u0003\u0003`\u000eu\u0014\u0002BB@\u0005C\u0014aa\u00142kK\u000e$\bfA\roi\"\u001a\u0001D\u001c;")
public class GaussianMixtureModel
extends Model<GaussianMixtureModel>
implements GaussianMixtureParams,
MLWritable {
    private final String uid;
    private final double[] weights;
    private final MultivariateGaussian[] gaussians;
    private Option<GaussianMixtureSummary> trainingSummary;
    private final IntParam k;
    private final DoubleParam tol;
    private final Param<String> probabilityCol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static GaussianMixtureModel load(String string) {
        return GaussianMixtureModel$.MODULE$.load(string);
    }

    public static MLReader<GaussianMixtureModel> read() {
        return GaussianMixtureModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return GaussianMixtureParams.getK$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return GaussianMixtureParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final void org$apache$spark$ml$clustering$GaussianMixtureParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public double[] weights() {
        return this.weights;
    }

    public MultivariateGaussian[] gaussians() {
        return this.gaussians;
    }

    public GaussianMixtureModel setFeaturesCol(String value) {
        return (GaussianMixtureModel)this.set(this.featuresCol(), value);
    }

    public GaussianMixtureModel setPredictionCol(String value) {
        return (GaussianMixtureModel)this.set(this.predictionCol(), value);
    }

    public GaussianMixtureModel setProbabilityCol(String value) {
        return (GaussianMixtureModel)this.set(this.probabilityCol(), value);
    }

    @Override
    public GaussianMixtureModel copy(ParamMap extra) {
        GaussianMixtureModel copied = this.copyValues(new GaussianMixtureModel(this.uid(), this.weights(), this.gaussians()), extra);
        return (GaussianMixtureModel)copied.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(GaussianMixtureModel $outer) {
            }
        }
        UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> BoxesRunTime.boxToInteger((int)this.predict(vector)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(null)));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(GaussianMixtureModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(GaussianMixtureModel $outer) {
            }
        }
        UserDefinedFunction probUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> this.predictProbability((org.apache.spark.ml.linalg.Vector)vector), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(null)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(null)));
        return dataset.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol())}))).withColumn(this.$(this.probabilityCol()), probUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol())})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public int predict(org.apache.spark.ml.linalg.Vector features) {
        org.apache.spark.ml.linalg.Vector r = this.predictProbability(features);
        return r.argmax();
    }

    public org.apache.spark.ml.linalg.Vector predictProbability(org.apache.spark.ml.linalg.Vector features) {
        double[] probs = GaussianMixtureModel$.MODULE$.computeProbabilities((DenseVector<Object>)features.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), this.gaussians(), this.weights());
        return org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(probs);
    }

    public Dataset<Row> gaussiansDF() {
        Tuple2[] modelGaussians = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.gaussians())).map((Function1 & Serializable & scala.Serializable)gaussian -> new Tuple2((Object)Vectors$.MODULE$.fromML(gaussian.mean()), (Object)Matrices$.MODULE$.fromML(gaussian.cov())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2(GaussianMixtureModel $outer) {
            }
        }
        return SparkSession$.MODULE$.builder().getOrCreate().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])modelGaussians), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "cov"}));
    }

    @Override
    public MLWriter write() {
        return new GaussianMixtureModelWriter(this);
    }

    private Option<GaussianMixtureSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<GaussianMixtureSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public GaussianMixtureModel setSummary(Option<GaussianMixtureSummary> summary) {
        this.trainingSummary_$eq(summary);
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().nonEmpty();
    }

    public GaussianMixtureSummary summary() {
        return (GaussianMixtureSummary)this.trainingSummary().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException(new StringBuilder(38).append("No training summary available for the ").append(this.getClass().getSimpleName()).toString());
        });
    }

    public GaussianMixtureModel(String uid, double[] weights, MultivariateGaussian[] gaussians) {
        this.uid = uid;
        this.weights = weights;
        this.gaussians = gaussians;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasProbabilityCol.$init$(this);
        HasTol.$init$(this);
        GaussianMixtureParams.$init$(this);
        MLWritable.$init$(this);
        this.trainingSummary = None$.MODULE$;
    }

    public static class GaussianMixtureModelReader
    extends MLReader<GaussianMixtureModel> {
        private final String className = GaussianMixtureModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GaussianMixtureModel load(String path) {
            Matrix[] sigmas;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row row = (Row)this.sparkSession().read().parquet(dataPath).select("weights", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mus", "sigmas"})).head();
            double[] weights = (double[])row.getSeq(0).toArray(ClassTag$.MODULE$.Double());
            Vector[] mus = (Vector[])row.getSeq(1).toArray(ClassTag$.MODULE$.apply(Vector.class));
            Predef$.MODULE$.require(mus.length == (sigmas = (Matrix[])row.getSeq(2).toArray(ClassTag$.MODULE$.apply(Matrix.class))).length, (Function0 & Serializable & scala.Serializable)() -> "Length of Mu and Sigma array must match");
            Predef$.MODULE$.require(mus.length == weights.length, (Function0 & Serializable & scala.Serializable)() -> "Length of weight and Gaussian array must match");
            MultivariateGaussian[] gaussians = (MultivariateGaussian[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mus)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sigmas), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector mu = (Vector)tuple2._1();
                Matrix sigma = (Matrix)tuple2._2();
                MultivariateGaussian multivariateGaussian = new MultivariateGaussian(mu.asML(), sigma.asML());
                return multivariateGaussian;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
            GaussianMixtureModel model = new GaussianMixtureModel(metadata.uid(), weights, gaussians);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GaussianMixtureModelWriter
    extends MLWriter {
        private volatile GaussianMixtureModel$GaussianMixtureModelWriter$Data$ Data$module;
        private final GaussianMixtureModel instance;

        private GaussianMixtureModel$GaussianMixtureModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            double[] weights = this.instance.weights();
            MultivariateGaussian[] gaussians = this.instance.gaussians();
            Vector[] mus = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gaussians)).map((Function1 & Serializable & scala.Serializable)g -> Vectors$.MODULE$.fromML(g.mean()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Matrix[] sigmas = (Matrix[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gaussians)).map((Function1 & Serializable & scala.Serializable)c -> Matrices$.MODULE$.fromML(c.cov()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Matrix.class)));
            Data data = new Data(this, weights, mus, sigmas);
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.GaussianMixtureModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.GaussianMixtureModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$3(GaussianMixtureModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$3(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            GaussianMixtureModelWriter gaussianMixtureModelWriter = this;
            synchronized (gaussianMixtureModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new GaussianMixtureModel$GaussianMixtureModelWriter$Data$(this);
                }
            }
        }

        public GaussianMixtureModelWriter(GaussianMixtureModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        scala.Serializable {
            private final double[] weights;
            private final Vector[] mus;
            private final Matrix[] sigmas;
            public final /* synthetic */ GaussianMixtureModelWriter $outer;

            public double[] weights() {
                return this.weights;
            }

            public Vector[] mus() {
                return this.mus;
            }

            public Matrix[] sigmas() {
                return this.sigmas;
            }

            public Data copy(double[] weights, Vector[] mus, Matrix[] sigmas) {
                return new Data(this.org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer(), weights, mus, sigmas);
            }

            public double[] copy$default$1() {
                return this.weights();
            }

            public Vector[] copy$default$2() {
                return this.mus();
            }

            public Matrix[] copy$default$3() {
                return this.sigmas();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object[] objectArray;
                int n = x$1;
                switch (n) {
                    case 0: {
                        objectArray = this.weights();
                        break;
                    }
                    case 1: {
                        objectArray = this.mus();
                        break;
                    }
                    case 2: {
                        objectArray = this.sigmas();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return objectArray;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer() != this.org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.weights() != data.weights()) return false;
                if (this.mus() != data.mus()) return false;
                if (this.sigmas() != data.sigmas()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ GaussianMixtureModelWriter org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(GaussianMixtureModelWriter $outer, double[] weights, Vector[] mus, Matrix[] sigmas) {
                this.weights = weights;
                this.mus = mus;
                this.sigmas = sigmas;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

