/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.clustering.KMeans$;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.clustering.KMeansParams;
import org.apache.spark.ml.clustering.KMeansSummary;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasDistanceMeasure;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001\u0002\f\u0018\u0001\tB\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t%\u000e\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005m!)a\n\u0001C\u0001\u001f\")A\u000b\u0001C!+\")a\n\u0001C\u0001?\")\u0011\r\u0001C\u0001E\")q\r\u0001C\u0001Q\")1\u000e\u0001C\u0001Y\")1\u000f\u0001C\u0001i\")q\u000f\u0001C\u0001q\")Q\u0010\u0001C\u0001}\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t9\u0003\u0001C!\u0003SAq!!\u0017\u0001\t\u0003\nYfB\u0004\u0002r]A\t!a\u001d\u0007\rY9\u0002\u0012AA;\u0011\u0019q%\u0003\"\u0001\u0002\n\"9\u00111\u0012\n\u0005B\u00055\u0005\"CAM%\u0005\u0005I\u0011BAN\u0005\u0019YU*Z1og*\u0011\u0001$G\u0001\u000bG2,8\u000f^3sS:<'B\u0001\u000e\u001c\u0003\tiGN\u0003\u0002\u001d;\u0005)1\u000f]1sW*\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0012,]A\u0019A%J\u0014\u000e\u0003eI!AJ\r\u0003\u0013\u0015\u001bH/[7bi>\u0014\bC\u0001\u0015*\u001b\u00059\u0012B\u0001\u0016\u0018\u0005-YU*Z1og6{G-\u001a7\u0011\u0005!b\u0013BA\u0017\u0018\u00051YU*Z1ogB\u000b'/Y7t!\ty#'D\u00011\u0015\t\t\u0014$\u0001\u0003vi&d\u0017BA\u001a1\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\f1!^5e+\u00051\u0004CA\u001cA\u001d\tAd\b\u0005\u0002:y5\t!H\u0003\u0002<C\u00051AH]8pizR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\na\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011q\b\u0010\u0015\u0004\u0003\u0011S\u0005CA#I\u001b\u00051%BA$\u001c\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u0013\u001a\u0013QaU5oG\u0016\f\u0013aS\u0001\u0006c9*d\u0006M\u0001\u0005k&$\u0007\u0005K\u0002\u0003\t*\u000ba\u0001P5oSRtDC\u0001)R!\tA\u0003\u0001C\u00035\u0007\u0001\u0007a\u0007K\u0002R\t*C3a\u0001#K\u0003\u0011\u0019w\u000e]=\u0015\u0005A3\u0006\"B,\u0005\u0001\u0004A\u0016!B3yiJ\f\u0007CA-]\u001b\u0005Q&BA.\u001a\u0003\u0015\u0001\u0018M]1n\u0013\ti&L\u0001\u0005QCJ\fW.T1qQ\r!AI\u0013\u000b\u0002!\"\u001aQ\u0001\u0012&\u0002\u001dM,GOR3biV\u0014Xm]\"pYR\u00111\rZ\u0007\u0002\u0001!)QM\u0002a\u0001m\u0005)a/\u00197vK\"\u001aa\u0001\u0012&\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGCA2j\u0011\u0015)w\u00011\u00017Q\r9AIS\u0001\u0005g\u0016$8\n\u0006\u0002d[\")Q\r\u0003a\u0001]B\u0011q\u000e]\u0007\u0002y%\u0011\u0011\u000f\u0010\u0002\u0004\u0013:$\bf\u0001\u0005E\u0015\u0006Y1/\u001a;J]&$Xj\u001c3f)\t\u0019W\u000fC\u0003f\u0013\u0001\u0007a\u0007K\u0002\n\t*\u000b!c]3u\t&\u001cH/\u00198dK6+\u0017m];sKR\u00111-\u001f\u0005\u0006K*\u0001\rA\u000e\u0015\u0004\u0015\u0011[\u0018%\u0001?\u0002\u000bIrCG\f\u0019\u0002\u0019M,G/\u00138jiN#X\r]:\u0015\u0005\r|\b\"B3\f\u0001\u0004q\u0007fA\u0006E\u0015\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0007\r\f9\u0001C\u0003f\u0019\u0001\u0007a\u000eK\u0002\r\t*\u000baa]3u)>dGcA2\u0002\u0010!1Q-\u0004a\u0001\u0003#\u00012a\\A\n\u0013\r\t)\u0002\u0010\u0002\u0007\t>,(\r\\3)\u00075!%*A\u0004tKR\u001cV-\u001a3\u0015\u0007\r\fi\u0002\u0003\u0004f\u001d\u0001\u0007\u0011q\u0004\t\u0004_\u0006\u0005\u0012bAA\u0012y\t!Aj\u001c8hQ\rqAIS\u0001\u0004M&$HcA\u0014\u0002,!9\u0011QF\bA\u0002\u0005=\u0012a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003c\t\t\u0005\u0005\u0004\u00024\u0005e\u0012QH\u0007\u0003\u0003kQ1!a\u000e\u001c\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003w\t)DA\u0004ECR\f7/\u001a;\u0011\t\u0005}\u0012\u0011\t\u0007\u0001\t1\t\u0019%a\u000b\u0002\u0002\u0003\u0005)\u0011AA#\u0005\ryFeM\t\u0005\u0003\u000f\ni\u0005E\u0002p\u0003\u0013J1!a\u0013=\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\\A(\u0013\r\t\t\u0006\u0010\u0002\u0004\u0003:L\b\u0006B\bE\u0003+\n#!a\u0016\u0002\u000bIr\u0003G\f\u0019\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$B!!\u0018\u0002jA!\u0011qLA3\u001b\t\t\tG\u0003\u0003\u0002d\u0005U\u0012!\u0002;za\u0016\u001c\u0018\u0002BA4\u0003C\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\tY\u0007\u0005a\u0001\u0003;\naa]2iK6\f\u0007f\u0001\tE\u0015\"\u001a\u0001\u0001\u0012&\u0002\r-kU-\u00198t!\tA#cE\u0004\u0013\u0003o\ni(a!\u0011\u0007=\fI(C\u0002\u0002|q\u0012a!\u00118z%\u00164\u0007\u0003B\u0018\u0002\u0000AK1!!!1\u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u00042a\\AC\u0013\r\t9\t\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003g\nA\u0001\\8bIR\u0019\u0001+a$\t\r\u0005EE\u00031\u00017\u0003\u0011\u0001\u0018\r\u001e5)\tQ!\u0015QS\u0011\u0003\u0003/\u000bQ!\r\u00187]A\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0014\t\u0005\u0003?\u000bI+\u0004\u0002\u0002\"*!\u00111UAS\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0016\u0001\u00026bm\u0006LA!a+\u0002\"\n1qJ\u00196fGRDCA\u0005#\u0002\u0016\"\"\u0011\u0003RAK\u0001")
public class KMeans
extends Estimator<KMeansModel>
implements KMeansParams,
DefaultParamsWritable {
    private final String uid;
    private final IntParam k;
    private final Param<String> initMode;
    private final IntParam initSteps;
    private final Param<String> distanceMeasure;
    private final DoubleParam tol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static KMeans load(String string) {
        return KMeans$.MODULE$.load(string);
    }

    public static MLReader<KMeans> read() {
        return KMeans$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return KMeansParams.getK$(this);
    }

    @Override
    public String getInitMode() {
        return KMeansParams.getInitMode$(this);
    }

    @Override
    public int getInitSteps() {
        return KMeansParams.getInitSteps$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return KMeansParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final String getDistanceMeasure() {
        return HasDistanceMeasure.getDistanceMeasure$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final Param<String> initMode() {
        return this.initMode;
    }

    @Override
    public final IntParam initSteps() {
        return this.initSteps;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initMode_$eq(Param<String> x$1) {
        this.initMode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initSteps_$eq(IntParam x$1) {
        this.initSteps = x$1;
    }

    @Override
    public final Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasDistanceMeasure$_setter_$distanceMeasure_$eq(Param<String> x$1) {
        this.distanceMeasure = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public KMeans copy(ParamMap extra) {
        return (KMeans)this.defaultCopy(extra);
    }

    public KMeans setFeaturesCol(String value) {
        return (KMeans)this.set(this.featuresCol(), value);
    }

    public KMeans setPredictionCol(String value) {
        return (KMeans)this.set(this.predictionCol(), value);
    }

    public KMeans setK(int value) {
        return (KMeans)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setInitMode(String value) {
        return (KMeans)this.set(this.initMode(), value);
    }

    public KMeans setDistanceMeasure(String value) {
        return (KMeans)this.set(this.distanceMeasure(), value);
    }

    public KMeans setInitSteps(int value) {
        return (KMeans)this.set(this.initSteps(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setMaxIter(int value) {
        return (KMeans)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setTol(double value) {
        return (KMeans)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public KMeans setSeed(long value) {
        return (KMeans)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public KMeansModel fit(Dataset<?> dataset) {
        return (KMeansModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            this.transformSchema(dataset.schema(), true);
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            RDD<Vector> instances = DatasetUtils$.MODULE$.columnToOldVector(dataset, this.getFeaturesCol());
            Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.featuresCol(), this.predictionCol(), this.k(), this.initMode(), this.initSteps(), this.distanceMeasure(), this.maxIter(), this.seed(), this.tol()}));
            org.apache.spark.mllib.clustering.KMeans algo = new org.apache.spark.mllib.clustering.KMeans().setK(BoxesRunTime.unboxToInt((Object)this.$(this.k()))).setInitializationMode(this.$(this.initMode())).setInitializationSteps(BoxesRunTime.unboxToInt((Object)this.$(this.initSteps()))).setMaxIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter()))).setSeed(BoxesRunTime.unboxToLong((Object)this.$(this.seed()))).setEpsilon(BoxesRunTime.unboxToDouble((Object)this.$(this.tol()))).setDistanceMeasure(this.$(this.distanceMeasure()));
            org.apache.spark.mllib.clustering.KMeansModel parentModel = algo.run(instances, (Option<Instrumentation>)Option$.MODULE$.apply(instr));
            KMeansModel model = this.copyValues(new KMeansModel(this.uid(), parentModel).setParent(this), this.copyValues$default$2());
            KMeansSummary summary = new KMeansSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), parentModel.numIter(), parentModel.trainingCost());
            model.setSummary((Option<KMeansSummary>)new Some((Object)summary));
            instr.logNamedValue("clusterSizes", summary.clusterSizes());
            Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
            return model;
        });
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public KMeans(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasTol.$init$(this);
        HasDistanceMeasure.$init$(this);
        KMeansParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.k().$minus$greater(BoxesRunTime.boxToInteger((int)2)), this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)20)), this.initMode().$minus$greater(org.apache.spark.mllib.clustering.KMeans$.MODULE$.K_MEANS_PARALLEL()), this.initSteps().$minus$greater(BoxesRunTime.boxToInteger((int)2)), this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-4)), this.distanceMeasure().$minus$greater(DistanceMeasure$.MODULE$.EUCLIDEAN())}));
    }

    public KMeans() {
        this(Identifiable$.MODULE$.randomUID("kmeans"));
    }
}

