/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.evaluation.Silhouette;
import org.apache.spark.ml.evaluation.SquaredEuclideanSilhouette;
import org.apache.spark.ml.evaluation.SquaredEuclideanSilhouette$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class SquaredEuclideanSilhouette$
extends Silhouette {
    public static SquaredEuclideanSilhouette$ MODULE$;
    private boolean kryoRegistrationPerformed;

    static {
        new SquaredEuclideanSilhouette$();
    }

    public void registerKryoClasses(SparkContext sc) {
        block0: {
            if (this.kryoRegistrationPerformed) break block0;
            sc.getConf().registerKryoClasses((Class[])((Object[])new Class[]{SquaredEuclideanSilhouette.ClusterStats.class}));
            this.kryoRegistrationPerformed = true;
        }
    }

    public Map<Object, SquaredEuclideanSilhouette.ClusterStats> computeClusterStats(Dataset<Row> df, String predictionCol, String featuresCol) {
        int numFeatures = this.getNumberOfFeatures(df, featuresCol);
        RDD clustersStatsRDD = RDD$.MODULE$.rddToPairRDDFunctions(df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(predictionCol).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(featuresCol), functions$.MODULE$.col("squaredNorm")})).rdd().map((Function1 & Serializable & scala.Serializable)row -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)row.getDouble(0)), (Object)new Tuple2(row.getAs(1), (Object)BoxesRunTime.boxToDouble((double)row.getDouble(2)))), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Double$.MODULE$).aggregateByKey((Object)new Tuple3((Object)Vectors$.MODULE$.zeros(numFeatures).toDense(), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            long l;
            double d;
            DenseVector denseVector;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    Tuple3 tuple3 = (Tuple3)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple3 == null) break block2;
                    DenseVector featureSum = (DenseVector)tuple3._1();
                    double squaredNormSum = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    long numOfPoints = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    if (featureSum == null) break block2;
                    denseVector = featureSum;
                    d = squaredNormSum;
                    l = numOfPoints;
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Vector features = (Vector)tuple2._1();
            double squaredNorm = tuple2._2$mcD$sp();
            BLAS$.MODULE$.axpy(1.0, features, (Vector)denseVector);
            Tuple3 tuple3 = new Tuple3((Object)denseVector, (Object)BoxesRunTime.boxToDouble((double)(d + squaredNorm)), (Object)BoxesRunTime.boxToLong((long)(l + 1L)));
            return tuple3;
        }, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            long numOfPoints1;
            double squaredNormSum1;
            DenseVector featureSum1;
            Tuple3 tuple3;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = new Tuple2(x0$2, x1$2);
                    if (tuple2 == null) break block2;
                    Tuple3 tuple32 = (Tuple3)tuple2._1();
                    tuple3 = (Tuple3)tuple2._2();
                    if (tuple32 == null) break block2;
                    featureSum1 = (DenseVector)tuple32._1();
                    squaredNormSum1 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                    numOfPoints1 = BoxesRunTime.unboxToLong((Object)tuple32._3());
                    if (tuple3 != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            DenseVector featureSum2 = (DenseVector)tuple3._1();
            double squaredNormSum2 = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            long numOfPoints2 = BoxesRunTime.unboxToLong((Object)tuple3._3());
            BLAS$.MODULE$.axpy(1.0, (Vector)featureSum2, (Vector)featureSum1);
            Tuple3 tuple33 = new Tuple3((Object)featureSum1, (Object)BoxesRunTime.boxToDouble((double)(squaredNormSum1 + squaredNormSum2)), (Object)BoxesRunTime.boxToLong((long)(numOfPoints1 + numOfPoints2)));
            return tuple33;
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(clustersStatsRDD, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.Double$.MODULE$).collectAsMap().mapValues((Function1 & Serializable & scala.Serializable)x0$3 -> {
            long numOfPoints;
            double squaredNormSum;
            DenseVector featureSum;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x0$3;
                    if (tuple3 == null) break block2;
                    featureSum = (DenseVector)tuple3._1();
                    squaredNormSum = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    numOfPoints = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    if (featureSum != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            DenseVector denseVector = featureSum;
            double d = squaredNormSum;
            long l = numOfPoints;
            SquaredEuclideanSilhouette.ClusterStats clusterStats = new SquaredEuclideanSilhouette.ClusterStats((Vector)denseVector, d, l);
            return clusterStats;
        }).toMap(Predef$.MODULE$.$conforms());
    }

    public double computeSilhouetteCoefficient(Broadcast<Map<Object, SquaredEuclideanSilhouette.ClusterStats>> broadcastedClustersMap, Vector point, double clusterId, double squaredNorm) {
        return this.pointSilhouetteCoefficient((Set<Object>)((scala.collection.immutable.MapLike)broadcastedClustersMap.value()).keySet(), clusterId, ((SquaredEuclideanSilhouette.ClusterStats)((MapLike)broadcastedClustersMap.value()).apply((Object)BoxesRunTime.boxToDouble((double)clusterId))).numOfPoints(), (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)targetClusterId -> SquaredEuclideanSilhouette$.compute$1(targetClusterId, broadcastedClustersMap, point, squaredNorm));
    }

    public double computeSilhouetteScore(Dataset<?> dataset, String predictionCol, String featuresCol) {
        this.registerKryoClasses(dataset.sparkSession().sparkContext());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_evaluation_SquaredEuclideanSilhouette$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_SquaredEuclideanSilhouette$$typecreator1$1() {
            }
        }
        UserDefinedFunction squaredNormUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.pow(Vectors$.MODULE$.norm(features, 2.0), 2.0)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_evaluation_SquaredEuclideanSilhouette$$typecreator1$1()));
        Dataset dfWithSquaredNorm = dataset.withColumn("squaredNorm", squaredNormUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresCol)})));
        Map<Object, SquaredEuclideanSilhouette.ClusterStats> clustersStatsMap = this.computeClusterStats((Dataset<Row>)dfWithSquaredNorm, predictionCol, featuresCol);
        Predef$.MODULE$.assert(clustersStatsMap.size() > 1, (Function0 & Serializable & scala.Serializable)() -> "Number of clusters must be greater than one.");
        Broadcast bClustersStatsMap = dataset.sparkSession().sparkContext().broadcast(clustersStatsMap, ClassTag$.MODULE$.apply(Map.class));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_evaluation_SquaredEuclideanSilhouette$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_SquaredEuclideanSilhouette$$typecreator2$1() {
            }
        }
        UserDefinedFunction computeSilhouetteCoefficientUDF = functions$.MODULE$.udf((Function3 & Serializable & scala.Serializable)(x$2, x$3, x$4) -> BoxesRunTime.boxToDouble((double)SquaredEuclideanSilhouette$.MODULE$.computeSilhouetteCoefficient((Broadcast<Map<Object, SquaredEuclideanSilhouette.ClusterStats>>)bClustersStatsMap, x$2, BoxesRunTime.unboxToDouble((Object)x$3), BoxesRunTime.unboxToDouble((Object)x$4))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_evaluation_SquaredEuclideanSilhouette$$typecreator2$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        double silhouetteScore = this.overallScore((Dataset<Row>)dfWithSquaredNorm, computeSilhouetteCoefficientUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresCol), functions$.MODULE$.col(predictionCol).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col("squaredNorm")})));
        bClustersStatsMap.destroy();
        return silhouetteScore;
    }

    private static final double compute$1(double targetClusterId, Broadcast broadcastedClustersMap$1, Vector point$1, double squaredNorm$1) {
        SquaredEuclideanSilhouette.ClusterStats clusterStats = (SquaredEuclideanSilhouette.ClusterStats)((MapLike)broadcastedClustersMap$1.value()).apply((Object)BoxesRunTime.boxToDouble((double)targetClusterId));
        double pointDotClusterFeaturesSum = BLAS$.MODULE$.dot(point$1, clusterStats.featureSum());
        return squaredNorm$1 + clusterStats.squaredNormSum() / (double)clusterStats.numOfPoints() - (double)2 * pointDotClusterFeaturesSum / (double)clusterStats.numOfPoints();
    }

    private SquaredEuclideanSilhouette$() {
        MODULE$ = this;
        this.kryoRegistrationPerformed = false;
    }
}

