/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.attribute.UnresolvedAttribute$;
import org.apache.spark.ml.feature.FeatureEncoder;
import org.apache.spark.ml.feature.Interaction$;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.param.shared.HasInputCols;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001\u0002\n\u0014\u0001yA\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t%\u000e\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005m!)a\n\u0001C\u0001\u001f\")a\n\u0001C\u0001+\")q\u000b\u0001C\u00011\")\u0011\r\u0001C\u0001E\")a\r\u0001C!O\")1\u000f\u0001C!i\"9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA-\u0001\u0011%\u00111\f\u0005\b\u0003W\u0002A\u0011BA7\u0011\u001d\t)\t\u0001C!\u0003\u000f;q!!'\u0014\u0011\u0003\tYJ\u0002\u0004\u0013'!\u0005\u0011Q\u0014\u0005\u0007\u001d:!\t!!-\t\u000f\u0005Mf\u0002\"\u0011\u00026\"I\u0011Q\u0018\b\u0002\u0002\u0013%\u0011q\u0018\u0002\f\u0013:$XM]1di&|gN\u0003\u0002\u0015+\u00059a-Z1ukJ,'B\u0001\f\u0018\u0003\tiGN\u0003\u0002\u00193\u0005)1\u000f]1sW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019R\u0001A\u0010$W9\u0002\"\u0001I\u0011\u000e\u0003UI!AI\u000b\u0003\u0017Q\u0013\u0018M\\:g_JlWM\u001d\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\naa\u001d5be\u0016$'B\u0001\u0015\u0016\u0003\u0015\u0001\u0018M]1n\u0013\tQSE\u0001\u0007ICNLe\u000e];u\u0007>d7\u000f\u0005\u0002%Y%\u0011Q&\n\u0002\r\u0011\u0006\u001cx*\u001e;qkR\u001cu\u000e\u001c\t\u0003_Ij\u0011\u0001\r\u0006\u0003cU\tA!\u001e;jY&\u00111\u0007\r\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:Xe&$\u0018M\u00197f\u0003\r)\u0018\u000eZ\u000b\u0002mA\u0011q\u0007\u0011\b\u0003qy\u0002\"!\u000f\u001f\u000e\u0003iR!aO\u000f\u0002\rq\u0012xn\u001c;?\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011I\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}b\u0004fA\u0001E\u0015B\u0011Q\tS\u0007\u0002\r*\u0011qiF\u0001\u000bC:tw\u000e^1uS>t\u0017BA%G\u0005\u0015\u0019\u0016N\\2fC\u0005Y\u0015!B\u0019/m9\u0002\u0014\u0001B;jI\u0002B3A\u0001#K\u0003\u0019a\u0014N\\5u}Q\u0011\u0001K\u0015\t\u0003#\u0002i\u0011a\u0005\u0005\u0006i\r\u0001\rA\u000e\u0015\u0004%\u0012S\u0005fA\u0002E\u0015R\t\u0001\u000bK\u0002\u0005\t*\u000bAb]3u\u0013:\u0004X\u000f^\"pYN$\"!\u0017.\u000e\u0003\u0001AQaW\u0003A\u0002q\u000baA^1mk\u0016\u001c\bcA/_m5\tA(\u0003\u0002`y\t)\u0011I\u001d:bs\"\u001aQ\u0001\u0012&\u0002\u0019M,GoT;uaV$8i\u001c7\u0015\u0005e\u001b\u0007\"\u00023\u0007\u0001\u00041\u0014!\u0002<bYV,\u0007f\u0001\u0004E\u0015\u0006yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0002iaB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0006if\u0004Xm\u001d\u0006\u0003[^\t1a]9m\u0013\ty'N\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!]\u0004A\u0002!\faa]2iK6\f\u0007fA\u0004E\u0015\u0006IAO]1og\u001a|'/\u001c\u000b\u0004k\u0006%\u0001c\u0001<\u0002\u00049\u0011qo \b\u0003qzt!!_?\u000f\u0005idhBA\u001d|\u0013\u0005a\u0012B\u0001\u000e\u001c\u0013\tA\u0012$\u0003\u0002n/%\u0019\u0011\u0011\u00017\u0002\u000fA\f7m[1hK&!\u0011QAA\u0004\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002\u00021Dq!a\u0003\t\u0001\u0004\ti!A\u0004eCR\f7/\u001a;1\t\u0005=\u00111\u0004\t\u0007\u0003#\t\u0019\"a\u0006\u000e\u00031L1!!\u0006m\u0005\u001d!\u0015\r^1tKR\u0004B!!\u0007\u0002\u001c1\u0001A\u0001DA\u000f\u0003\u0013\t\t\u0011!A\u0003\u0002\u0005}!aA0%cE!\u0011\u0011EA\u0014!\ri\u00161E\u0005\u0004\u0003Ka$a\u0002(pi\"Lgn\u001a\t\u0004;\u0006%\u0012bAA\u0016y\t\u0019\u0011I\\=)\t!!\u0015qF\u0011\u0003\u0003c\tQA\r\u00181]A\n!cZ3u\r\u0016\fG/\u001e:f\u000b:\u001cw\u000eZ3sgR!\u0011qGA !\u0011if,!\u000f\u0011\u0007E\u000bY$C\u0002\u0002>M\u0011aBR3biV\u0014X-\u00128d_\u0012,'\u000fC\u0004\u0002B%\u0001\r!a\u0011\u0002\u0011\u0019,\u0017\r^;sKN\u0004b!!\u0012\u0002N\u0005Mc\u0002BA$\u0003\u0017r1!OA%\u0013\u0005i\u0014bAA\u0001y%!\u0011qJA)\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0003a\u0004cA5\u0002V%\u0019\u0011q\u000b6\u0003\u0017M#(/^2u\r&,G\u000eZ\u0001\u0010O\u0016$h)Z1ukJ,\u0017\t\u001e;sgR!\u0011QLA5!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2+\u0005I\u0011\r\u001e;sS\n,H/Z\u0005\u0005\u0003O\n\tG\u0001\bBiR\u0014\u0018NY;uK\u001e\u0013x.\u001e9\t\u000f\u0005\u0005#\u00021\u0001\u0002D\u0005\u0019RM\\2pI\u0016$g)Z1ukJ,\u0017\t\u001e;sgR1\u0011qNA<\u0003w\u0002b!!\u0012\u0002N\u0005E\u0004\u0003BA0\u0003gJA!!\u001e\u0002b\tI\u0011\t\u001e;sS\n,H/\u001a\u0005\b\u0003sZ\u0001\u0019AA8\u0003)Ig\u000e];u\u0003R$(o\u001d\u0005\b\u0003{Z\u0001\u0019AA@\u0003%9'o\\;q\u001d\u0006lW\r\u0005\u0003^\u0003\u00033\u0014bAABy\t1q\n\u001d;j_:\fAaY8qsR\u0019\u0001+!#\t\u000f\u0005-E\u00021\u0001\u0002\u000e\u0006)Q\r\u001f;sCB!\u0011qRAI\u001b\u00059\u0013bAAJO\tA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002\r\t*C3\u0001\u0001#K\u0003-Ie\u000e^3sC\u000e$\u0018n\u001c8\u0011\u0005Es1c\u0002\b\u0002 \u0006\u0015\u00161\u0016\t\u0004;\u0006\u0005\u0016bAARy\t1\u0011I\\=SK\u001a\u0004BaLAT!&\u0019\u0011\u0011\u0016\u0019\u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB\u0019Q,!,\n\u0007\u0005=FH\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002\u001c\u0006!An\\1e)\r\u0001\u0016q\u0017\u0005\u0007\u0003s\u0003\u0002\u0019\u0001\u001c\u0002\tA\fG\u000f\u001b\u0015\u0004!\u0011S\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!1\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006!A.\u00198h\u0015\t\tY-\u0001\u0003kCZ\f\u0017\u0002BAh\u0003\u000b\u0014aa\u00142kK\u000e$\bf\u0001\bE\u0015\"\u001aQ\u0002\u0012&")
public class Interaction
extends Transformer
implements HasInputCols,
HasOutputCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> outputCol;
    private final StringArrayParam inputCols;

    public static Interaction load(String string) {
        return Interaction$.MODULE$.load(string);
    }

    public static MLReader<Interaction> read() {
        return Interaction$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String[] getInputCols() {
        return HasInputCols.getInputCols$(this);
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final StringArrayParam inputCols() {
        return this.inputCols;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCols$_setter_$inputCols_$eq(StringArrayParam x$1) {
        this.inputCols = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Interaction setInputCols(String[] values) {
        return (Interaction)this.set(this.inputCols(), values);
    }

    public Interaction setOutputCol(String value) {
        return (Interaction)this.set(this.outputCol(), value);
    }

    @Override
    public StructType transformSchema(StructType schema) {
        Predef$.MODULE$.require(this.get(this.inputCols()).isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Input cols must be defined first.");
        Predef$.MODULE$.require(this.get(this.outputCol()).isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Output col must be defined first.");
        Predef$.MODULE$.require(this.$(this.inputCols()).length > 0, (Function0 & Serializable & scala.Serializable)() -> "Input cols must have non-zero length.");
        Predef$.MODULE$.require(((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$(this.inputCols()))).distinct()).length == this.$(this.inputCols()).length, (Function0 & Serializable & scala.Serializable)() -> "Input cols must be distinct.");
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).$colon$plus((Object)new StructField(this.$(this.outputCol()), (DataType)new VectorUDT(), false, StructField$.MODULE$.apply$default$4()), ClassTag$.MODULE$.apply(StructField.class)));
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        StructField[] inputFeatures = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$(this.inputCols()))).map((Function1 & Serializable & scala.Serializable)c -> dataset.schema().apply(c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        FeatureEncoder[] featureEncoders = this.getFeatureEncoders((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])inputFeatures));
        AttributeGroup featureAttrs = this.getFeatureAttrs((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])inputFeatures));
        Column[] featureCols = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputFeatures)).map((Function1 & Serializable & scala.Serializable)f -> {
            Column column;
            DataType dataType = f.dataType();
            if (DoubleType$.MODULE$.equals(dataType)) {
                column = dataset.apply(f.name());
            } else if (dataType instanceof VectorUDT) {
                column = dataset.apply(f.name());
            } else {
                boolean bl = dataType instanceof NumericType ? true : BooleanType$.MODULE$.equals(dataType);
                if (bl) {
                    column = dataset.apply(f.name()).cast((DataType)DoubleType$.MODULE$);
                } else {
                    throw new MatchError((Object)dataType);
                }
            }
            return column;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*"), Interaction.interactFunc$1(featureEncoders).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])featureCols))})).as(this.$(this.outputCol()), featureAttrs.toMetadata())}));
    }

    private FeatureEncoder[] getFeatureEncoders(Seq<StructField> features) {
        return (FeatureEncoder[])((TraversableOnce)features.map((Function1 & Serializable & scala.Serializable)f -> {
            int[] nArray;
            DataType dataType = f.dataType();
            boolean bl = dataType instanceof NumericType ? true : BooleanType$.MODULE$.equals(dataType);
            if (bl) {
                nArray = new int[]{Interaction.getNumFeatures$1(Attribute$.MODULE$.fromStructField((StructField)f))};
            } else if (dataType instanceof VectorUDT) {
                Attribute[] attrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField((StructField)f).attributes().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new SparkException("Vector attributes must be defined for interaction.");
                });
                nArray = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attrs)).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToInteger((int)Interaction.getNumFeatures$1(attr)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            } else {
                throw new MatchError((Object)dataType);
            }
            int[] numFeatures = nArray;
            return new FeatureEncoder(numFeatures);
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FeatureEncoder.class));
    }

    private AttributeGroup getFeatureAttrs(Seq<StructField> features) {
        ObjectRef featureAttrs = ObjectRef.create((Object)Nil$.MODULE$);
        ((IterableLike)features.reverse()).foreach((Function1 & Serializable & scala.Serializable)f -> {
            Interaction.$anonfun$getFeatureAttrs$1(this, featureAttrs, f);
            return BoxedUnit.UNIT;
        });
        return new AttributeGroup(this.$(this.outputCol()), (Attribute[])((Seq)featureAttrs.elem).toArray(ClassTag$.MODULE$.apply(Attribute.class)));
    }

    private Seq<Attribute> encodedFeatureAttrs(Seq<Attribute> inputAttrs, Option<String> groupName) {
        return (Seq)((TraversableLike)inputAttrs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Attribute nominal = (Attribute)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (nominal instanceof NominalAttribute) {
                    NominalAttribute nominalAttribute = (NominalAttribute)nominal;
                    return nominalAttribute.values().isDefined() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nominalAttribute.values().get())).map((Function1 & Serializable & scala.Serializable)v -> BinaryAttribute$.MODULE$.defaultAttr().withName(Interaction.format$1(i, nominalAttribute.name(), (Option)new Some(v), groupName)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BinaryAttribute.class))))) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.tabulate(BoxesRunTime.unboxToInt((Object)nominalAttribute.getNumValues().get()), (Function1 & Serializable & scala.Serializable)j -> Interaction.$anonfun$encodedFeatureAttrs$5(i, nominalAttribute, groupName, BoxesRunTime.unboxToInt((Object)j)), ClassTag$.MODULE$.apply(BinaryAttribute.class))));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Attribute a = (Attribute)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (a == null) throw new MatchError((Object)tuple2);
            Attribute attribute = a;
            return (SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericAttribute[]{NumericAttribute$.MODULE$.defaultAttr().withName(Interaction.format$1(i, attribute.name(), (Option)None$.MODULE$, groupName))}));
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Interaction copy(ParamMap extra) {
        return (Interaction)this.defaultCopy(extra);
    }

    private static final UserDefinedFunction interactFunc$1(FeatureEncoder[] featureEncoders$1) {
        public final class Org_apache_spark_ml_feature_Interaction$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.Row").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_Interaction$$typecreator2$1(Interaction $outer) {
            }
        }
        public final class Org_apache_spark_ml_feature_Interaction$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_Interaction$$typecreator1$1(Interaction $outer) {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Interaction.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Interaction.class.getClassLoader());
        return functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)row -> {
            ObjectRef indices = ObjectRef.create((Object)ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int()));
            ObjectRef values = ObjectRef.create((Object)ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double()));
            int size = 1;
            ((ArrayBuilder)indices.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
            ((ArrayBuilder)values.elem).$plus$eq((Object)BoxesRunTime.boxToDouble((double)1.0));
            for (int featureIndex = row.length() - 1; featureIndex >= 0; --featureIndex) {
                int[] prevIndices = (int[])((ArrayBuilder)indices.elem).result();
                double[] prevValues = (double[])((ArrayBuilder)values.elem).result();
                int prevSize = size;
                FeatureEncoder currentEncoder = featureEncoders$1[featureIndex];
                indices.elem = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
                values.elem = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
                size *= currentEncoder.outputSize();
                currentEncoder.foreachNonzeroOutput(row.apply(featureIndex), (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(i, a) -> {
                    for (int j = 0; j < prevIndices.length; ++j) {
                        ((ArrayBuilder)indices$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)(prevIndices[j] + i * prevSize)));
                        ((ArrayBuilder)values$1.elem).$plus$eq((Object)BoxesRunTime.boxToDouble((double)(prevValues[j] * a)));
                    }
                });
            }
            return Vectors$.MODULE$.sparse(size, (int[])((ArrayBuilder)indices.elem).result(), (double[])((ArrayBuilder)values.elem).result()).compressed();
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Interaction$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Interaction$$typecreator2$1(null)));
    }

    private static final int getNumFeatures$1(Attribute attr) {
        int n;
        Attribute attribute = attr;
        if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            n = scala.math.package$.MODULE$.max(1, BoxesRunTime.unboxToInt((Object)nominalAttribute.getNumValues().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new SparkException("Nominal features must have attr numValues defined.");
            })));
        } else {
            n = 1;
        }
        return n;
    }

    public static final /* synthetic */ void $anonfun$getFeatureAttrs$1(Interaction $this, ObjectRef featureAttrs$1, StructField f) {
        Seq<Attribute> seq;
        DataType dataType = f.dataType();
        boolean bl = dataType instanceof NumericType ? true : BooleanType$.MODULE$.equals(dataType);
        if (bl) {
            Attribute attr;
            Attribute attribute = attr = Attribute$.MODULE$.decodeStructField(f, true);
            UnresolvedAttribute$ unresolvedAttribute$ = UnresolvedAttribute$.MODULE$;
            seq = !(attribute != null ? !attribute.equals(unresolvedAttribute$) : unresolvedAttribute$ != null) ? $this.encodedFeatureAttrs((Seq<Attribute>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericAttribute[]{NumericAttribute$.MODULE$.defaultAttr().withName(f.name())}))), (Option<String>)None$.MODULE$) : (!attr.name().isDefined() ? $this.encodedFeatureAttrs((Seq<Attribute>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{attr.withName(f.name())}))), (Option<String>)None$.MODULE$) : $this.encodedFeatureAttrs((Seq<Attribute>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{attr}))), (Option<String>)None$.MODULE$));
        } else if (dataType instanceof VectorUDT) {
            AttributeGroup group = AttributeGroup$.MODULE$.fromStructField(f);
            seq = $this.encodedFeatureAttrs((Seq<Attribute>)Predef$.MODULE$.wrapRefArray((Object[])group.attributes().get()), (Option<String>)new Some((Object)group.name()));
        } else {
            throw new MatchError((Object)dataType);
        }
        Seq<Attribute> encodedAttrs = seq;
        featureAttrs$1.elem = ((Seq)featureAttrs$1.elem).isEmpty() ? encodedAttrs : (Seq)encodedAttrs.flatMap((Function1 & Serializable & scala.Serializable)head -> (Seq)((Seq)featureAttrs$1.elem).map((Function1 & Serializable & scala.Serializable)tail -> NumericAttribute$.MODULE$.defaultAttr().withName(new StringBuilder(1).append((String)head.name().get()).append(":").append(tail.name().get()).toString()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    private static final String format$1(int index, Option attrName, Option categoryName, Option groupName$1) {
        Seq parts = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{groupName$1, new Some(attrName.getOrElse((Function0 & Serializable & scala.Serializable)() -> ((Object)BoxesRunTime.boxToInteger((int)index)).toString())), categoryName}));
        return ((TraversableOnce)parts.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).mkString("_");
    }

    public static final /* synthetic */ BinaryAttribute $anonfun$encodedFeatureAttrs$5(int i$1, NominalAttribute x2$1, Option groupName$1, int j) {
        return BinaryAttribute$.MODULE$.defaultAttr().withName(Interaction.format$1(i$1, x2$1.name(), (Option)new Some((Object)((Object)BoxesRunTime.boxToInteger((int)j)).toString()), groupName$1));
    }

    public Interaction(String uid) {
        this.uid = uid;
        HasInputCols.$init$(this);
        HasOutputCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public Interaction() {
        this(Identifiable$.MODULE$.randomUID("interaction"));
    }
}

