/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.LSHParams;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005ca\u0002\t\u0012\u0003\u0003\u00192$\t\u0005\u0006q\u0001!\t!\u000f\u0005\u0006u\u0001!\ta\u000f\u0005\u0006\u0015\u0002!\ta\u0013\u0005\u0007\u001b\u00021\tb\u0005(\t\ri\u0003a\u0011C\n\\\u0011\u0019\u0019\u0007A\"\u0005\u0014I\")\u0001\u000f\u0001C!c\"9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0002\u0002CA\u001b\u0001\u0011\u0005\u0011#a\u000e\t\u000f\u0005U\u0002\u0001\"\u0001\u0002l!9\u0011Q\u0007\u0001\u0005\u0002\u0005%\u0005\u0002CAS\u0001\u0001&I!a*\t\u0011\u0005%\u0007\u0001)C\u0005\u0003\u0017Dq!a;\u0001\t\u0003\ti\u000fC\u0004\u0002l\u0002!\tAa\u0007\u0003\u00111\u001b\u0006*T8eK2T!AE\n\u0002\u000f\u0019,\u0017\r^;sK*\u0011A#F\u0001\u0003[2T!AF\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u000b\u00039\r\u001aB\u0001A\u000f0eA\u0019adH\u0011\u000e\u0003MI!\u0001I\n\u0003\u000b5{G-\u001a7\u0011\u0005\t\u001aC\u0002\u0001\u0003\u0006I\u0001\u0011\rA\n\u0002\u0002)\u000e\u0001\u0011CA\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\f\u0001\"\u001b\u0005\t\u0002C\u0001\u00181\u0013\t\t\u0014CA\u0005M'\"\u0003\u0016M]1ngB\u00111GN\u0007\u0002i)\u0011QgE\u0001\u0005kRLG.\u0003\u00028i\tQQ\nT,sSR\f'\r\\3\u0002\rqJg.\u001b;?)\u0005i\u0013aC:fi&s\u0007/\u001e;D_2$\"\u0001P\u001f\u000e\u0003\u0001AQA\u0010\u0002A\u0002}\nQA^1mk\u0016\u0004\"\u0001Q$\u000f\u0005\u0005+\u0005C\u0001\"*\u001b\u0005\u0019%B\u0001#&\u0003\u0019a$o\\8u}%\u0011a)K\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002GS\u0005a1/\u001a;PkR\u0004X\u000f^\"pYR\u0011A\b\u0014\u0005\u0006}\r\u0001\raP\u0001\rQ\u0006\u001c\bNR;oGRLwN\u001c\u000b\u0003\u001fb\u00032\u0001\u000b)S\u0013\t\t\u0016FA\u0003BeJ\f\u0017\u0010\u0005\u0002T-6\tAK\u0003\u0002V'\u00051A.\u001b8bY\u001eL!a\u0016+\u0003\rY+7\r^8s\u0011\u0015IF\u00011\u0001S\u0003\u0015)G.Z7t\u0003-YW-\u001f#jgR\fgnY3\u0015\u0007q{\u0016\r\u0005\u0002);&\u0011a,\u000b\u0002\u0007\t>,(\r\\3\t\u000b\u0001,\u0001\u0019\u0001*\u0002\u0003aDQAY\u0003A\u0002I\u000b\u0011!_\u0001\rQ\u0006\u001c\b\u000eR5ti\u0006t7-\u001a\u000b\u00049\u0016|\u0007\"\u00021\u0007\u0001\u00041\u0007cA4m%:\u0011\u0001N\u001b\b\u0003\u0005&L\u0011AK\u0005\u0003W&\nq\u0001]1dW\u0006<W-\u0003\u0002n]\n\u00191+Z9\u000b\u0005-L\u0003\"\u00022\u0007\u0001\u00041\u0017!\u0003;sC:\u001chm\u001c:n)\r\u0011\u0018Q\u0001\t\u0003g~t!\u0001^?\u000f\u0005U\\hB\u0001<{\u001d\t9\u0018P\u0004\u0002Cq&\t!$\u0003\u0002\u00193%\u0011acF\u0005\u0003yV\t1a]9m\u0013\tYgP\u0003\u0002}+%!\u0011\u0011AA\u0002\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002l}\"9\u0011qA\u0004A\u0002\u0005%\u0011a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003\u0017\t)\u0002\u0005\u0004\u0002\u000e\u0005=\u00111C\u0007\u0002}&\u0019\u0011\u0011\u0003@\u0003\u000f\u0011\u000bG/Y:fiB\u0019!%!\u0006\u0005\u0019\u0005]\u0011QAA\u0001\u0002\u0003\u0015\t!!\u0007\u0003\u0007}#\u0013'E\u0002(\u00037\u00012\u0001KA\u000f\u0013\r\ty\"\u000b\u0002\u0004\u0003:L\u0018a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005\u0015\u0012\u0011\u0007\t\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111\u0006@\u0002\u000bQL\b/Z:\n\t\u0005=\u0012\u0011\u0006\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\u001a\u0011\u0001\u0007\u0011QE\u0001\u0007g\u000eDW-\\1\u0002-\u0005\u0004\bO]8y\u001d\u0016\f'/Z:u\u001d\u0016Lw\r\u001b2peN$B\"!\u000f\u0002D\u0005=\u00131KA/\u0003O\u0002D!a\u000f\u0002@A1\u0011QBA\b\u0003{\u00012AIA \t-\t\t%CA\u0001\u0002\u0003\u0015\t!!\u0007\u0003\u0007}#3\u0007C\u0004\u0002\b%\u0001\r!!\u00121\t\u0005\u001d\u00131\n\t\u0007\u0003\u001b\ty!!\u0013\u0011\u0007\t\nY\u0005\u0002\u0007\u0002N\u0005\r\u0013\u0011!A\u0001\u0006\u0003\tIBA\u0002`IIBa!!\u0015\n\u0001\u0004\u0011\u0016aA6fs\"9\u0011QK\u0005A\u0002\u0005]\u0013a\u00058v[:+\u0017M]3ti:+\u0017n\u001a5c_J\u001c\bc\u0001\u0015\u0002Z%\u0019\u00111L\u0015\u0003\u0007%sG\u000fC\u0004\u0002`%\u0001\r!!\u0019\u0002\u0017MLgn\u001a7f!J|'-\u001a\t\u0004Q\u0005\r\u0014bAA3S\t9!i\\8mK\u0006t\u0007BBA5\u0013\u0001\u0007q(A\u0004eSN$8i\u001c7\u0015\u0015\u00055\u0014qOAB\u0003\u000b\u000b9\t\r\u0003\u0002p\u0005M\u0004CBA\u0007\u0003\u001f\t\t\bE\u0002#\u0003g\"1\"!\u001e\u000b\u0003\u0003\u0005\tQ!\u0001\u0002\u001a\t\u0019q\fJ\u001b\t\u000f\u0005\u001d!\u00021\u0001\u0002zA\"\u00111PA@!\u0019\ti!a\u0004\u0002~A\u0019!%a \u0005\u0019\u0005\u0005\u0015qOA\u0001\u0002\u0003\u0015\t!!\u0007\u0003\u0007}#C\u0007\u0003\u0004\u0002R)\u0001\rA\u0015\u0005\b\u0003+R\u0001\u0019AA,\u0011\u0019\tIG\u0003a\u0001\u007fQA\u00111RAK\u0003C\u000b\u0019\u000b\r\u0003\u0002\u000e\u0006E\u0005CBA\u0007\u0003\u001f\ty\tE\u0002#\u0003##1\"a%\f\u0003\u0003\u0005\tQ!\u0001\u0002\u001a\t\u0019q\fJ\u001c\t\u000f\u0005\u001d1\u00021\u0001\u0002\u0018B\"\u0011\u0011TAO!\u0019\ti!a\u0004\u0002\u001cB\u0019!%!(\u0005\u0019\u0005}\u0015QSA\u0001\u0002\u0003\u0015\t!!\u0007\u0003\u0007}#c\u0007\u0003\u0004\u0002R-\u0001\rA\u0015\u0005\b\u0003+Z\u0001\u0019AA,\u00039\u0001(o\\2fgN$\u0015\r^1tKR$\u0002\"!+\u00024\u0006}\u00161\u0019\u0019\u0005\u0003W\u000by\u000b\u0005\u0004\u0002\u000e\u0005=\u0011Q\u0016\t\u0004E\u0005=FaCAY\u0019\u0005\u0005\t\u0011!B\u0001\u00033\u00111a\u0018\u0013:\u0011\u001d\t9\u0001\u0004a\u0001\u0003k\u0003D!a.\u0002<B1\u0011QBA\b\u0003s\u00032AIA^\t1\ti,a-\u0002\u0002\u0003\u0005)\u0011AA\r\u0005\ryF\u0005\u000f\u0005\u0007\u0003\u0003d\u0001\u0019A \u0002\u0013%t\u0007/\u001e;OC6,\u0007bBAc\u0019\u0001\u0007\u0011qY\u0001\fKb\u0004Hn\u001c3f\u0007>d7\u000fE\u0002hY~\n1B]3de\u0016\fG/Z\"pYRA\u0011QZAl\u0003G\f9\u000f\r\u0003\u0002P\u0006M\u0007CBA\u0007\u0003\u001f\t\t\u000eE\u0002#\u0003'$1\"!6\u000e\u0003\u0003\u0005\tQ!\u0001\u0002\u001a\t!q\fJ\u00192\u0011\u001d\t9!\u0004a\u0001\u00033\u0004D!a7\u0002`B1\u0011QBA\b\u0003;\u00042AIAp\t1\t\t/a6\u0002\u0002\u0003\u0005)\u0011AA\r\u0005\u0011yF%\r\u0019\t\r\u0005\u0015X\u00021\u0001@\u0003\u001d\u0019w\u000e\u001c(b[\u0016Da!!;\u000e\u0001\u0004y\u0014A\u0003;na\u000e{GNT1nK\u0006!\u0012\r\u001d9s_b\u001c\u0016.\\5mCJLG/\u001f&pS:$\"\"a<\u0002z\n\u001d!Q\u0003B\ra\u0011\t\t0!>\u0011\r\u00055\u0011qBAz!\r\u0011\u0013Q\u001f\u0003\f\u0003ot\u0011\u0011!A\u0001\u0006\u0003\tIB\u0001\u0003`IE\"\u0004bBA~\u001d\u0001\u0007\u0011Q`\u0001\tI\u0006$\u0018m]3u\u0003B\"\u0011q B\u0002!\u0019\ti!a\u0004\u0003\u0002A\u0019!Ea\u0001\u0005\u0019\t\u0015\u0011\u0011`A\u0001\u0002\u0003\u0015\t!!\u0007\u0003\t}#\u0013G\r\u0005\b\u0005\u0013q\u0001\u0019\u0001B\u0006\u0003!!\u0017\r^1tKR\u0014\u0005\u0007\u0002B\u0007\u0005#\u0001b!!\u0004\u0002\u0010\t=\u0001c\u0001\u0012\u0003\u0012\u0011a!1\u0003B\u0004\u0003\u0003\u0005\tQ!\u0001\u0002\u001a\t!q\fJ\u00194\u0011\u0019\u00119B\u0004a\u00019\u0006IA\u000f\u001b:fg\"|G\u000e\u001a\u0005\u0007\u0003Sr\u0001\u0019A \u0015\u0011\tu!q\u0005B\u001a\u0005\u007f\u0001DAa\b\u0003$A1\u0011QBA\b\u0005C\u00012A\tB\u0012\t-\u0011)cDA\u0001\u0002\u0003\u0015\t!!\u0007\u0003\t}#\u0013g\u000e\u0005\b\u0003w|\u0001\u0019\u0001B\u0015a\u0011\u0011YCa\f\u0011\r\u00055\u0011q\u0002B\u0017!\r\u0011#q\u0006\u0003\r\u0005c\u00119#!A\u0001\u0002\u000b\u0005\u0011\u0011\u0004\u0002\u0005?\u0012\nT\u0007C\u0004\u0003\n=\u0001\rA!\u000e1\t\t]\"1\b\t\u0007\u0003\u001b\tyA!\u000f\u0011\u0007\t\u0012Y\u0004\u0002\u0007\u0003>\tM\u0012\u0011!A\u0001\u0006\u0003\tIB\u0001\u0003`IE2\u0004B\u0002B\f\u001f\u0001\u0007A\f")
public abstract class LSHModel<T extends LSHModel<T>>
extends Model<T>
implements LSHParams,
MLWritable {
    private final IntParam numHashTables;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final int getNumHashTables() {
        return LSHParams.getNumHashTables$(this);
    }

    @Override
    public final StructType validateAndTransformSchema(StructType schema) {
        return LSHParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public final IntParam numHashTables() {
        return this.numHashTables;
    }

    @Override
    public final void org$apache$spark$ml$feature$LSHParams$_setter_$numHashTables_$eq(IntParam x$1) {
        this.numHashTables = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    public T setInputCol(String value) {
        return (T)((LSHModel)this.set(this.inputCol(), value));
    }

    public T setOutputCol(String value) {
        return (T)((LSHModel)this.set(this.outputCol(), value));
    }

    public abstract Vector[] hashFunction(Vector var1);

    public abstract double keyDistance(Vector var1, Vector var2);

    public abstract double hashDistance(Seq<Vector> var1, Seq<Vector> var2);

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        UserDefinedFunction transformUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x$1 -> this.hashFunction((Vector)x$1), (DataType)DataTypes.createArrayType((DataType)new VectorUDT()));
        return dataset.withColumn(this.$(this.outputCol()), transformUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.apply(this.$(this.inputCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public Dataset<?> approxNearestNeighbors(Dataset<?> dataset, Vector key, int numNearestNeighbors, boolean singleProbe, String distCol) {
        Dataset dataset2;
        Dataset<Row> modelDataset;
        Predef$.MODULE$.require(numNearestNeighbors > 0, (Function0 & Serializable & scala.Serializable)() -> "The number of nearest neighbors cannot be less than 1");
        Vector[] keyHash = this.hashFunction(key);
        Dataset<Row> dataset3 = modelDataset = !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.columns())).contains((Object)this.$(this.outputCol())) ? this.transform(dataset) : dataset.toDF();
        if (singleProbe) {
            UserDefinedFunction sameBucketWithKeyUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LSHModel.sameBucket$1(x, (Seq)Predef$.MODULE$.wrapRefArray((Object[])keyHash))), DataTypes.BooleanType);
            dataset2 = modelDataset.filter(sameBucketWithKeyUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.outputCol()))})));
        } else {
            UserDefinedFunction hashDistUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)this.hashDistance((Seq<Vector>)x, (Seq<Vector>)Predef$.MODULE$.wrapRefArray((Object[])keyHash))), DataTypes.DoubleType);
            Column hashDistCol = hashDistUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.outputCol()))}));
            Dataset modelDatasetSortedByHash = modelDataset.sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{hashDistCol})).limit(numNearestNeighbors);
            Dataset thresholdDataset = modelDatasetSortedByHash.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(hashDistCol)}));
            double hashThreshold = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])thresholdDataset.take(1))).head()).getDouble(0);
            dataset2 = modelDataset.filter(hashDistCol.$less$eq((Object)BoxesRunTime.boxToDouble((double)hashThreshold)));
        }
        Dataset modelSubset = dataset2;
        UserDefinedFunction keyDistUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)this.keyDistance(x, key)), DataTypes.DoubleType);
        Dataset modelSubsetWithDistCol = modelSubset.withColumn(distCol, keyDistUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})));
        return modelSubsetWithDistCol.sort(distCol, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).limit(numNearestNeighbors);
    }

    public Dataset<?> approxNearestNeighbors(Dataset<?> dataset, Vector key, int numNearestNeighbors, String distCol) {
        return this.approxNearestNeighbors(dataset, key, numNearestNeighbors, true, distCol);
    }

    public Dataset<?> approxNearestNeighbors(Dataset<?> dataset, Vector key, int numNearestNeighbors) {
        return this.approxNearestNeighbors(dataset, key, numNearestNeighbors, true, "distCol");
    }

    private Dataset<?> processDataset(Dataset<?> dataset, String inputName, Seq<String> explodeCols) {
        Predef$.MODULE$.require(explodeCols.size() == 2, (Function0 & Serializable & scala.Serializable)() -> "explodeCols must be two strings.");
        Dataset<Row> modelDataset = !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.columns())).contains((Object)this.$(this.outputCol())) ? this.transform(dataset) : dataset.toDF();
        return modelDataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*")})).as(inputName), functions$.MODULE$.posexplode(functions$.MODULE$.col(this.$(this.outputCol()))).as(explodeCols)}));
    }

    private Dataset<?> recreateCol(Dataset<?> dataset, String colName, String tmpColName) {
        return dataset.withColumnRenamed(colName, tmpColName).withColumn(colName, functions$.MODULE$.col(tmpColName)).drop(tmpColName);
    }

    public Dataset<?> approxSimilarityJoin(Dataset<?> datasetA, Dataset<?> datasetB, double threshold, String distCol) {
        Dataset<?> dataset;
        String leftColName = "datasetA";
        String rightColName = "datasetB";
        Seq explodeCols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"entry", "hashValue"}));
        Dataset<?> explodedA = this.processDataset(datasetA, leftColName, (Seq<String>)explodeCols);
        Dataset<?> dataset2 = datasetA;
        Dataset<?> dataset3 = datasetB;
        if (dataset2 == null ? dataset3 != null : !dataset2.equals(dataset3)) {
            dataset = this.processDataset(datasetB, rightColName, (Seq<String>)explodeCols);
        } else {
            Dataset<?> recreatedB = this.recreateCol(datasetB, this.$(this.inputCol()), new StringBuilder(1).append((Object)this.$(this.inputCol())).append("#").append(Random$.MODULE$.nextString(5)).toString());
            dataset = this.processDataset(recreatedB, rightColName, (Seq<String>)explodeCols);
        }
        Dataset<?> explodedB = dataset;
        Dataset joinedDataset = explodedA.join(explodedB, explodeCols).drop(explodeCols).distinct();
        UserDefinedFunction distUDF = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToDouble((double)this.keyDistance(x, y)), DataTypes.DoubleType);
        Dataset joinedDatasetWithDist = joinedDataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*"), distUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(1).append(leftColName).append(".").append((Object)this.$(this.inputCol())).toString()), functions$.MODULE$.col(new StringBuilder(1).append(rightColName).append(".").append((Object)this.$(this.inputCol())).toString())})).as(distCol)}));
        return joinedDatasetWithDist.filter(functions$.MODULE$.col(distCol).$less((Object)BoxesRunTime.boxToDouble((double)threshold)));
    }

    public Dataset<?> approxSimilarityJoin(Dataset<?> datasetA, Dataset<?> datasetB, double threshold) {
        return this.approxSimilarityJoin(datasetA, datasetB, threshold, "distCol");
    }

    public static final /* synthetic */ boolean $anonfun$approxNearestNeighbors$2(Tuple2 tuple) {
        return BoxesRunTime.equals((Object)tuple._1(), (Object)tuple._2());
    }

    private static final boolean sameBucket$1(Seq x, Seq y) {
        return ((IterableLike)x.zip((GenIterable)y, Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)tuple -> BoxesRunTime.boxToBoolean((boolean)LSHModel.$anonfun$approxNearestNeighbors$2(tuple)));
    }

    public LSHModel() {
        HasInputCol.$init$(this);
        HasOutputCol.$init$(this);
        LSHParams.$init$(this);
        MLWritable.$init$(this);
    }
}

