/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.feature.MinMaxScaler$;
import org.apache.spark.ml.feature.MinMaxScalerModel;
import org.apache.spark.ml.feature.MinMaxScalerParams;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\t\u0013\u0001uA\u0001b\f\u0001\u0003\u0006\u0004%\t\u0005\r\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005c!)\u0011\n\u0001C\u0001\u0015\")\u0011\n\u0001C\u0001\u001f\")\u0011\u000b\u0001C\u0001%\")q\u000b\u0001C\u00011\")1\f\u0001C\u00019\")1\r\u0001C\u0001I\")q\r\u0001C!Q\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\f\u0001\u0011\u0005\u0013\u0011D\u0004\b\u0003_\u0011\u0002\u0012AA\u0019\r\u0019\t\"\u0003#\u0001\u00024!1\u0011*\u0004C\u0001\u0003\u000fBq!!\u0013\u000e\t\u0003\nY\u0005C\u0005\u0002X5\t\t\u0011\"\u0003\u0002Z\taQ*\u001b8NCb\u001c6-\u00197fe*\u00111\u0003F\u0001\bM\u0016\fG/\u001e:f\u0015\t)b#\u0001\u0002nY*\u0011q\u0003G\u0001\u0006gB\f'o\u001b\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qb%\u000b\t\u0004?\u0001\u0012S\"\u0001\u000b\n\u0005\u0005\"\"!C#ti&l\u0017\r^8s!\t\u0019C%D\u0001\u0013\u0013\t)#CA\tNS:l\u0015\r_*dC2,'/T8eK2\u0004\"aI\u0014\n\u0005!\u0012\"AE'j]6\u000b\u0007pU2bY\u0016\u0014\b+\u0019:b[N\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003]-\u0012Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW-A\u0002vS\u0012,\u0012!\r\t\u0003emr!aM\u001d\u0011\u0005Q:T\"A\u001b\u000b\u0005Yb\u0012A\u0002\u001fs_>$hHC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQt'\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e8Q\r\tq(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005Z\t!\"\u00198o_R\fG/[8o\u0013\t!\u0015IA\u0003TS:\u001cW-I\u0001G\u0003\u0015\td&\u000e\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\tyT)\u0001\u0004=S:LGO\u0010\u000b\u0003\u00172\u0003\"a\t\u0001\t\u000b=\u001a\u0001\u0019A\u0019)\u00071{T\tK\u0002\u0004\u007f\u0015#\u0012a\u0013\u0015\u0004\t}*\u0015aC:fi&s\u0007/\u001e;D_2$\"a\u0015+\u000e\u0003\u0001AQ!V\u0003A\u0002E\nQA^1mk\u0016D3!B F\u00031\u0019X\r^(viB,HoQ8m)\t\u0019\u0016\fC\u0003V\r\u0001\u0007\u0011\u0007K\u0002\u0007\u007f\u0015\u000baa]3u\u001b&tGCA*^\u0011\u0015)v\u00011\u0001_!\ty\u0006-D\u00018\u0013\t\twG\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u000f}*\u0015AB:fi6\u000b\u0007\u0010\u0006\u0002TK\")Q\u000b\u0003a\u0001=\"\u001a\u0001bP#\u0002\u0007\u0019LG\u000f\u0006\u0002#S\")!.\u0003a\u0001W\u00069A-\u0019;bg\u0016$\bG\u00017u!\ri\u0007O]\u0007\u0002]*\u0011qNF\u0001\u0004gFd\u0017BA9o\u0005\u001d!\u0015\r^1tKR\u0004\"a\u001d;\r\u0001\u0011IQ/[A\u0001\u0002\u0003\u0015\tA\u001e\u0002\u0004?\u0012\n\u0014CA<{!\ty\u00060\u0003\u0002zo\t9aj\u001c;iS:<\u0007CA0|\u0013\taxGA\u0002B]fD3!C \u007fC\u0005y\u0018!\u0002\u001a/a9\u0002\u0014a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005\u0015\u0011\u0011\u0003\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u00028\u0002\u000bQL\b/Z:\n\t\u0005=\u0011\u0011\u0002\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\n\u0015\u0001\u0007\u0011QA\u0001\u0007g\u000eDW-\\1)\u0007)yT)\u0001\u0003d_BLHcA&\u0002\u001c!9\u0011QD\u0006A\u0002\u0005}\u0011!B3yiJ\f\u0007\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015B#A\u0003qCJ\fW.\u0003\u0003\u0002*\u0005\r\"\u0001\u0003)be\u0006lW*\u00199)\u0007-yT\tK\u0002\u0001\u007f\u0015\u000bA\"T5o\u001b\u0006D8kY1mKJ\u0004\"aI\u0007\u0014\u000f5\t)$a\u000f\u0002BA\u0019q,a\u000e\n\u0007\u0005erG\u0001\u0004B]f\u0014VM\u001a\t\u0005U\u0005u2*C\u0002\u0002@-\u0012Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\rE\u0002`\u0003\u0007J1!!\u00128\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\t\t$\u0001\u0003m_\u0006$GcA&\u0002N!1\u0011qJ\bA\u0002E\nA\u0001]1uQ\"\"qbPA*C\t\t)&A\u00032]Yr\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAA.!\u0011\ti&a\u001a\u000e\u0005\u0005}#\u0002BA1\u0003G\nA\u0001\\1oO*\u0011\u0011QM\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002j\u0005}#AB(cU\u0016\u001cG\u000f\u000b\u0003\u000e\u007f\u0005M\u0003\u0006\u0002\u0007@\u0003'\u0002")
public class MinMaxScaler
extends Estimator<MinMaxScalerModel>
implements MinMaxScalerParams,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam min;
    private final DoubleParam max;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    public static MinMaxScaler load(String string) {
        return MinMaxScaler$.MODULE$.load(string);
    }

    public static MLReader<MinMaxScaler> read() {
        return MinMaxScaler$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public double getMin() {
        return MinMaxScalerParams.getMin$(this);
    }

    @Override
    public double getMax() {
        return MinMaxScalerParams.getMax$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return MinMaxScalerParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public DoubleParam min() {
        return this.min;
    }

    @Override
    public DoubleParam max() {
        return this.max;
    }

    @Override
    public void org$apache$spark$ml$feature$MinMaxScalerParams$_setter_$min_$eq(DoubleParam x$1) {
        this.min = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$MinMaxScalerParams$_setter_$max_$eq(DoubleParam x$1) {
        this.max = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public MinMaxScaler setInputCol(String value) {
        return (MinMaxScaler)this.set(this.inputCol(), value);
    }

    public MinMaxScaler setOutputCol(String value) {
        return (MinMaxScaler)this.set(this.outputCol(), value);
    }

    public MinMaxScaler setMin(double value) {
        return (MinMaxScaler)this.set(this.min(), BoxesRunTime.boxToDouble((double)value));
    }

    public MinMaxScaler setMax(double value) {
        return (MinMaxScaler)this.set(this.max(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public MinMaxScalerModel fit(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        RDD input = dataset.select(this.$(this.inputCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object v;
            Row row = x0$1;
            Some some = Row$.MODULE$.unapplySeq(row);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((v = ((SeqLike)some.get()).apply(0)) instanceof Vector)) {
                throw new MatchError((Object)row);
            }
            Vector vector = (Vector)v;
            org.apache.spark.mllib.linalg.Vector vector2 = Vectors$.MODULE$.fromML(vector);
            return vector2;
        }, ClassTag$.MODULE$.apply(org.apache.spark.mllib.linalg.Vector.class));
        MultivariateStatisticalSummary summary = Statistics$.MODULE$.colStats((RDD<org.apache.spark.mllib.linalg.Vector>)input);
        return this.copyValues(new MinMaxScalerModel(this.uid(), VectorImplicits$.MODULE$.mllibVectorToMLVector(summary.min()), VectorImplicits$.MODULE$.mllibVectorToMLVector(summary.max())).setParent(this), this.copyValues$default$2());
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    @Override
    public MinMaxScaler copy(ParamMap extra) {
        return (MinMaxScaler)this.defaultCopy(extra);
    }

    public MinMaxScaler(String uid) {
        this.uid = uid;
        HasInputCol.$init$(this);
        HasOutputCol.$init$(this);
        MinMaxScalerParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.min().$minus$greater(BoxesRunTime.boxToDouble((double)0.0)), this.max().$minus$greater(BoxesRunTime.boxToDouble((double)1.0))}));
    }

    public MinMaxScaler() {
        this(Identifiable$.MODULE$.randomUID("minMaxScal"));
    }
}

