/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.regression.AFTPoint;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\f\u0019\t\rB\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A1\t\u0001B\u0001B\u0003%A\tC\u0003I\u0001\u0011\u0005\u0011\nC\u0004P\u0001\t\u0007I\u0011\u0002)\t\rQ\u0003\u0001\u0015!\u0003R\u0011!)\u0006\u0001#b\u0001\n\u00131\u0006\u0002C.\u0001\u0011\u000b\u0007I\u0011\u0002,\t\u0011u\u0003\u0001R1A\u0005\nyC\u0001\u0002\u0019\u0001\t\u0006\u0004%IA\u0018\u0005\bE\u0002\u0001\r\u0011\"\u0003d\u0011\u001d9\u0007\u00011A\u0005\n!DaA\u001c\u0001!B\u0013!\u0007bB8\u0001\u0001\u0004%IA\u0018\u0005\ba\u0002\u0001\r\u0011\"\u0003r\u0011\u0019\u0019\b\u0001)Q\u0005y!AA\u000f\u0001EC\u0002\u0013%Q\u000fC\u0003w\u0001\u0011\u00051\rC\u0003x\u0001\u0011\u0005a\fC\u0003y\u0001\u0011\u0005a\u000bC\u0003z\u0001\u0011\u0005!\u0010C\u0004\u0002\u0004\u0001!\t!!\u0002\u0003\u001b\u00053E+Q4he\u0016<\u0017\r^8s\u0015\tI\"$\u0001\u0006sK\u001e\u0014Xm]:j_:T!a\u0007\u000f\u0002\u00055d'BA\u000f\u001f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g!\t)3&\u0003\u0002-M\ta1+\u001a:jC2L'0\u00192mK\u0006a!m\u0019)be\u0006lW\r^3sgB\u0019qF\r\u001b\u000e\u0003AR!!\r\u000f\u0002\u0013\t\u0014x.\u00193dCN$\u0018BA\u001a1\u0005%\u0011%o\\1eG\u0006\u001cH\u000fE\u00026uqj\u0011A\u000e\u0006\u0003oa\na\u0001\\5oC2<'\"A\u001d\u0002\r\t\u0014X-\u001a>f\u0013\tYdGA\u0006EK:\u001cXMV3di>\u0014\bCA\u0013>\u0013\tqdE\u0001\u0004E_V\u0014G.Z\u0001\rM&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\t\u0003K\u0005K!A\u0011\u0014\u0003\u000f\t{w\u000e\\3b]\u0006i!m\u0019$fCR,(/Z:Ti\u0012\u00042a\f\u001aF!\r)c\tP\u0005\u0003\u000f\u001a\u0012Q!\u0011:sCf\fa\u0001P5oSRtD\u0003\u0002&M\u001b:\u0003\"a\u0013\u0001\u000e\u0003aAQ!\f\u0003A\u00029BQa\u0010\u0003A\u0002\u0001CQa\u0011\u0003A\u0002\u0011\u000ba\u0001\\3oORDW#A)\u0011\u0005\u0015\u0012\u0016BA*'\u0005\rIe\u000e^\u0001\bY\u0016tw\r\u001e5!\u0003)\u0001\u0018M]1nKR,'o]\u000b\u0002i!\u0012q\u0001\u0017\t\u0003KeK!A\u0017\u0014\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001D2pK\u001a4\u0017nY5f]R\u001c\bF\u0001\u0005Y\u0003%Ig\u000e^3sG\u0016\u0004H/F\u0001=Q\tI\u0001,A\u0003tS\u001el\u0017\r\u000b\u0002\u000b1\u0006AAo\u001c;bY\u000esG/F\u0001e!\t)S-\u0003\u0002gM\t!Aj\u001c8h\u00031!x\u000e^1m\u0007:$x\fJ3r)\tIG\u000e\u0005\u0002&U&\u00111N\n\u0002\u0005+:LG\u000fC\u0004n\u0019\u0005\u0005\t\u0019\u00013\u0002\u0007a$\u0013'A\u0005u_R\fGn\u00118uA\u00059An\\:t'Vl\u0017a\u00037pgN\u001cV/\\0%KF$\"!\u001b:\t\u000f5|\u0011\u0011!a\u0001y\u0005AAn\\:t'Vl\u0007%\u0001\the\u0006$\u0017.\u001a8u'Vl\u0017I\u001d:bsV\tQ)A\u0003d_VtG/\u0001\u0003m_N\u001c\u0018\u0001C4sC\u0012LWM\u001c;\u0002\u0007\u0005$G\r\u0006\u0002|y6\t\u0001\u0001C\u0003~+\u0001\u0007a0\u0001\u0003eCR\f\u0007CA&\u0000\u0013\r\t\t\u0001\u0007\u0002\t\u0003\u001a#\u0006k\\5oi\u0006)Q.\u001a:hKR\u001910a\u0002\t\r\u0005%a\u00031\u0001K\u0003\u0015yG\u000f[3s\u0001")
public class AFTAggregator
implements Serializable {
    private transient DenseVector<Object> parameters;
    private transient DenseVector<Object> coefficients;
    private transient double intercept;
    private transient double sigma;
    private double[] gradientSumArray;
    private final Broadcast<DenseVector<Object>> bcParameters;
    private final boolean fitIntercept;
    private final Broadcast<double[]> bcFeaturesStd;
    private final int length;
    private long totalCnt;
    private double lossSum;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    private int length() {
        return this.length;
    }

    private DenseVector<Object> parameters$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.parameters = (DenseVector)this.bcParameters.value();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.parameters;
    }

    private DenseVector<Object> parameters() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.parameters$lzycompute() : this.parameters;
    }

    private DenseVector<Object> coefficients$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.coefficients = this.parameters().slice$mcD$sp(2, this.length(), this.parameters().slice$default$3());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.coefficients;
    }

    private DenseVector<Object> coefficients() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.coefficients$lzycompute() : this.coefficients;
    }

    private double intercept$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.intercept = this.parameters().apply$mcD$sp(1);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.intercept;
    }

    private double intercept() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.intercept$lzycompute() : this.intercept;
    }

    private double sigma$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.sigma = package$.MODULE$.exp(this.parameters().apply$mcD$sp(0));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.sigma;
    }

    private double sigma() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.sigma$lzycompute() : this.sigma;
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    private double lossSum() {
        return this.lossSum;
    }

    private void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = (double[])Array$.MODULE$.ofDim(this.length(), ClassTag$.MODULE$.Double());
                this.bitmap$0 = true;
            }
        }
        return this.gradientSumArray;
    }

    private double[] gradientSumArray() {
        return !this.bitmap$0 ? this.gradientSumArray$lzycompute() : this.gradientSumArray;
    }

    public long count() {
        return this.totalCnt();
    }

    public double loss() {
        Predef$.MODULE$.require((double)this.totalCnt() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("The number of instances should be ").append(new StringBuilder(27).append("greater than 0.0, but got ").append(this.totalCnt()).append(".").toString()).toString());
        return this.lossSum() / (double)this.totalCnt();
    }

    public DenseVector<Object> gradient() {
        Predef$.MODULE$.require((double)this.totalCnt() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("The number of instances should be ").append(new StringBuilder(27).append("greater than 0.0, but got ").append(this.totalCnt()).append(".").toString()).toString());
        return new DenseVector.mcD.sp((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.gradientSumArray())).map((Function1)(JFunction1.mcDD.sp & java.io.Serializable & Serializable)x$2 -> x$2 / (double)this.totalCnt(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    public AFTAggregator add(AFTPoint data) {
        Vector xi = data.features();
        double ti = data.label();
        double delta = data.censor();
        Predef$.MODULE$.require(ti > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "The lifetime or label should be  greater than 0.");
        double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
        DoubleRef sum = DoubleRef.create((double)0.0);
        xi.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
            block0: {
                if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                sum$1.elem += this.coefficients().apply$mcD$sp(index) * (value / localFeaturesStd[index]);
            }
        });
        double margin = sum.elem + this.intercept();
        double epsilon = (package$.MODULE$.log(ti) - margin) / this.sigma();
        this.lossSum_$eq(this.lossSum() + (delta * package$.MODULE$.log(this.sigma()) - delta * epsilon + package$.MODULE$.exp(epsilon)));
        double multiplier = (delta - package$.MODULE$.exp(epsilon)) / this.sigma();
        this.gradientSumArray()[0] = this.gradientSumArray()[0] + (delta + multiplier * this.sigma() * epsilon);
        this.gradientSumArray()[1] = this.gradientSumArray()[1] + (this.fitIntercept ? multiplier : 0.0);
        xi.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
            block0: {
                if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                int n = index + 2;
                $this.gradientSumArray()[n] = this.gradientSumArray()[n] + multiplier * (value / localFeaturesStd[index]);
            }
        });
        this.totalCnt_$eq(this.totalCnt() + 1L);
        return this;
    }

    public AFTAggregator merge(AFTAggregator other) {
        if (other.count() != 0L) {
            this.totalCnt_$eq(this.totalCnt() + other.totalCnt());
            this.lossSum_$eq(this.lossSum() + other.lossSum());
            for (int i = 0; i < this.length(); ++i) {
                int n = i;
                this.gradientSumArray()[n] = this.gradientSumArray()[n] + other.gradientSumArray()[i];
            }
        }
        return this;
    }

    public AFTAggregator(Broadcast<DenseVector<Object>> bcParameters, boolean fitIntercept, Broadcast<double[]> bcFeaturesStd) {
        this.bcParameters = bcParameters;
        this.fitIntercept = fitIntercept;
        this.bcFeaturesStd = bcFeaturesStd;
        this.length = ((DenseVector)bcParameters.value()).length();
        this.totalCnt = 0L;
        this.lossSum = 0.0;
    }
}

