/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.AFTCostFun;
import org.apache.spark.ml.regression.AFTPoint;
import org.apache.spark.ml.regression.AFTSurvivalRegression$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001\u0002\r\u001a\u0001\u0011B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t%\u0010\u0005\t)\u0002\u0011\t\u0011)A\u0005}!)a\u000b\u0001C\u0001/\")a\u000b\u0001C\u00019\")a\f\u0001C\u0001?\")A\r\u0001C\u0001K\")\u0001\u000e\u0001C\u0001S\")A\u000e\u0001C\u0001[\")\u0001\u000f\u0001C\u0001c\")1\u0010\u0001C\u0001y\"1q\u0010\u0001C\u0001\u0003\u0003Aq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!A\u0011q\u0006\u0001\u0005\u0012m\t\t\u0004C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u0011\u0011\u0014\u0001\u0005B\u0005muaBA]3!\u0005\u00111\u0018\u0004\u00071eA\t!!0\t\rY#B\u0011AAi\u0011\u001d\t\u0019\u000e\u0006C!\u0003+D\u0011\"!8\u0015\u0003\u0003%I!a8\u0003+\u00053EkU;sm&4\u0018\r\u001c*fOJ,7o]5p]*\u0011!dG\u0001\u000be\u0016<'/Z:tS>t'B\u0001\u000f\u001e\u0003\tiGN\u0003\u0002\u001f?\u0005)1\u000f]1sW*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u0013.aY\u00022AJ\u0014*\u001b\u0005Y\u0012B\u0001\u0015\u001c\u0005%)5\u000f^5nCR|'\u000f\u0005\u0002+W5\t\u0011$\u0003\u0002-3\tQ\u0012I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>tWj\u001c3fYB\u0011!FL\u0005\u0003_e\u00111$\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g\u000eU1sC6\u001c\bCA\u00195\u001b\u0005\u0011$BA\u001a\u001c\u0003\u0011)H/\u001b7\n\u0005U\u0012$!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7o\u0016:ji\u0006\u0014G.\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0003su\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003wa\u0012q\u0001T8hO&tw-A\u0002vS\u0012,\u0012A\u0010\t\u0003\u007f!s!\u0001\u0011$\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u001b\u0013A\u0002\u001fs_>$hHC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9E)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$EQ\r\tAJ\u0015\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001fv\t!\"\u00198o_R\fG/[8o\u0013\t\tfJA\u0003TS:\u001cW-I\u0001T\u0003\u0015\tdF\u000e\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\ta%+\u0001\u0004=S:LGO\u0010\u000b\u00031f\u0003\"A\u000b\u0001\t\u000bq\u001a\u0001\u0019\u0001 )\u0007ec%\u000bK\u0002\u0004\u0019J#\u0012\u0001\u0017\u0015\u0004\t1\u0013\u0016AD:fi\u001a+\u0017\r^;sKN\u001cu\u000e\u001c\u000b\u0003A\u0006l\u0011\u0001\u0001\u0005\u0006E\u0016\u0001\rAP\u0001\u0006m\u0006dW/\u001a\u0015\u0004\u000b1\u0013\u0016aC:fi2\u000b'-\u001a7D_2$\"\u0001\u00194\t\u000b\t4\u0001\u0019\u0001 )\u0007\u0019a%+\u0001\u0007tKR\u001cUM\\:pe\u000e{G\u000e\u0006\u0002aU\")!m\u0002a\u0001}!\u001aq\u0001\u0014*\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGC\u00011o\u0011\u0015\u0011\u0007\u00021\u0001?Q\rAAJU\u0001\u0019g\u0016$\u0018+^1oi&dW\r\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHC\u00011s\u0011\u0015\u0011\u0017\u00021\u0001t!\r!Xo^\u0007\u0002\t&\u0011a\u000f\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003ibL!!\u001f#\u0003\r\u0011{WO\u00197fQ\rIAJU\u0001\u0010g\u0016$\u0018+^1oi&dWm]\"pYR\u0011\u0001- \u0005\u0006E*\u0001\rA\u0010\u0015\u0004\u00151\u0013\u0016aD:fi\u001aKG/\u00138uKJ\u001cW\r\u001d;\u0015\u0007\u0001\f\u0019\u0001\u0003\u0004c\u0017\u0001\u0007\u0011Q\u0001\t\u0004i\u0006\u001d\u0011bAA\u0005\t\n9!i\\8mK\u0006t\u0007fA\u0006M%\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0007\u0001\f\t\u0002\u0003\u0004c\u0019\u0001\u0007\u00111\u0003\t\u0004i\u0006U\u0011bAA\f\t\n\u0019\u0011J\u001c;)\u00071a%+\u0001\u0004tKR$v\u000e\u001c\u000b\u0004A\u0006}\u0001\"\u00022\u000e\u0001\u00049\bfA\u0007M%\u0006\u00192/\u001a;BO\u001e\u0014XmZ1uS>tG)\u001a9uQR\u0019\u0001-a\n\t\r\tt\u0001\u0019AA\nQ\u0011qA*a\u000b\"\u0005\u00055\u0012!\u0002\u001a/c9\u0002\u0014\u0001E3yiJ\f7\r^!G)B{\u0017N\u001c;t)\u0011\t\u0019$!\u0012\u0011\r\u0005U\u00121HA \u001b\t\t9DC\u0002\u0002:u\t1A\u001d3e\u0013\u0011\ti$a\u000e\u0003\u0007I#E\tE\u0002+\u0003\u0003J1!a\u0011\u001a\u0005!\te\t\u0016)pS:$\bbBA$\u001f\u0001\u0007\u0011\u0011J\u0001\bI\u0006$\u0018m]3ua\u0011\tY%a\u0017\u0011\r\u00055\u00131KA,\u001b\t\tyEC\u0002\u0002Ru\t1a]9m\u0013\u0011\t)&a\u0014\u0003\u000f\u0011\u000bG/Y:fiB!\u0011\u0011LA.\u0019\u0001!A\"!\u0018\u0002F\u0005\u0005\t\u0011!B\u0001\u0003?\u00121a\u0018\u00132#\u0011\t\t'a\u001a\u0011\u0007Q\f\u0019'C\u0002\u0002f\u0011\u0013qAT8uQ&tw\rE\u0002u\u0003SJ1!a\u001bE\u0005\r\te._\u0001\u0004M&$HcA\u0015\u0002r!9\u0011q\t\tA\u0002\u0005M\u0004\u0007BA;\u0003s\u0002b!!\u0014\u0002T\u0005]\u0004\u0003BA-\u0003s\"A\"a\u001f\u0002r\u0005\u0005\t\u0011!B\u0001\u0003?\u00121a\u0018\u00133Q\u0011\u0001B*a \"\u0005\u0005\u0005\u0015!\u0002\u001a/a9\u0002\u0014a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005\u001d\u00151\u0013\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*!\u0011QRA(\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\t*a#\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002\u0016F\u0001\r!a\"\u0002\rM\u001c\u0007.Z7bQ\r\tBJU\u0001\u0005G>\u0004\u0018\u0010F\u0002Y\u0003;Cq!a(\u0013\u0001\u0004\t\t+A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002$\u0006%VBAAS\u0015\r\t9kG\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003W\u000b)K\u0001\u0005QCJ\fW.T1qQ\r\u0011BJ\u0015\u0015\u0004\u00011\u0013\u0006f\u0001\u0001\u00024B\u0019Q*!.\n\u0007\u0005]fJ\u0001\u0007FqB,'/[7f]R\fG.A\u000bB\rR\u001bVO\u001d<jm\u0006d'+Z4sKN\u001c\u0018n\u001c8\u0011\u0005)\"2c\u0002\u000b\u0002@\u0006\u0015\u00171\u001a\t\u0004i\u0006\u0005\u0017bAAb\t\n1\u0011I\\=SK\u001a\u0004B!MAd1&\u0019\u0011\u0011\u001a\u001a\u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB\u0019A/!4\n\u0007\u0005=GI\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002<\u0006!An\\1e)\rA\u0016q\u001b\u0005\u0007\u000334\u0002\u0019\u0001 \u0002\tA\fG\u000f\u001b\u0015\u0004-1\u0013\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!9\u0011\t\u0005\r\u0018Q^\u0007\u0003\u0003KTA!a:\u0002j\u0006!A.\u00198h\u0015\t\tY/\u0001\u0003kCZ\f\u0017\u0002BAx\u0003K\u0014aa\u00142kK\u000e$\bf\u0001\u000bM%\"\u001a1\u0003\u0014*")
public class AFTSurvivalRegression
extends Estimator<AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final IntParam aggregationDepth;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final Param<String> predictionCol;
    private final Param<String> labelCol;
    private final Param<String> featuresCol;

    public static AFTSurvivalRegression load(String string) {
        return AFTSurvivalRegression$.MODULE$.load(string);
    }

    public static MLReader<AFTSurvivalRegression> read() {
        return AFTSurvivalRegression$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams.getCensorCol$(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams.getQuantileProbabilities$(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams.getQuantilesCol$(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams.hasQuantilesCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams.validateAndTransformSchema$(this, schema, fitting);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param<String> x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param<String> x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public AFTSurvivalRegression setFeaturesCol(String value) {
        return (AFTSurvivalRegression)this.set(this.featuresCol(), value);
    }

    public AFTSurvivalRegression setLabelCol(String value) {
        return (AFTSurvivalRegression)this.set(this.labelCol(), value);
    }

    public AFTSurvivalRegression setCensorCol(String value) {
        return (AFTSurvivalRegression)this.set(this.censorCol(), value);
    }

    public AFTSurvivalRegression setPredictionCol(String value) {
        return (AFTSurvivalRegression)this.set(this.predictionCol(), value);
    }

    public AFTSurvivalRegression setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegression)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegression setQuantilesCol(String value) {
        return (AFTSurvivalRegression)this.set(this.quantilesCol(), value);
    }

    public AFTSurvivalRegression setFitIntercept(boolean value) {
        return (AFTSurvivalRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public AFTSurvivalRegression setMaxIter(int value) {
        return (AFTSurvivalRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public AFTSurvivalRegression setTol(double value) {
        return (AFTSurvivalRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public AFTSurvivalRegression setAggregationDepth(int value) {
        return (AFTSurvivalRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public RDD<AFTPoint> extractAFTPoints(Dataset<?> dataset) {
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(this.$(this.censorCol())).cast((DataType)DoubleType$.MODULE$)})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            Vector vector;
            Object censor;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                    Object features = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    censor = ((SeqLike)some.get()).apply(2);
                    if (!(features instanceof Vector)) break block2;
                    vector = (Vector)features;
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (censor instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d2 = BoxesRunTime.unboxToDouble((Object)censor);
            AFTPoint aFTPoint = new AFTPoint(vector, d, d2);
            return aFTPoint;
        }, ClassTag$.MODULE$.apply(AFTPoint.class));
    }

    @Override
    public AFTSurvivalRegressionModel fit(Dataset<?> dataset) {
        return (AFTSurvivalRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            this.transformSchema(dataset.schema(), true);
            RDD<AFTPoint> instances = this.extractAFTPoints(dataset);
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            Function2 & Serializable & scala.Serializable seqOp = (Function2 & Serializable & scala.Serializable)(c, v) -> c.add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(v.features()));
            Function2 & Serializable & scala.Serializable combOp = (Function2 & Serializable & scala.Serializable)(c1, c2) -> c1.merge((MultivariateOnlineSummarizer)c2);
            MultivariateOnlineSummarizer featuresSummarizer = (MultivariateOnlineSummarizer)instances.treeAggregate((Object)new MultivariateOnlineSummarizer(), (Function2)seqOp, (Function2)combOp, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
            double[] featuresStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresSummarizer.variance().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.sqrt(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            int numFeatures = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresStd)).size();
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.censorCol(), this.predictionCol(), this.quantilesCol(), this.fitIntercept(), this.maxIter(), this.tol(), this.aggregationDepth()}));
            instr.logNamedValue("quantileProbabilities.size", this.$(this.quantileProbabilities()).length);
            instr.logNumFeatures(numFeatures);
            instr.logNumExamples(featuresSummarizer.count());
            if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> featuresStd[i] == 0.0 && featuresSummarizer.mean().apply(i) != 0.0)) {
                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fitting AFTSurvivalRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is different from R survival::survreg.");
            }
            Broadcast bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            AFTCostFun costFun = new AFTCostFun(instances, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), (Broadcast<double[]>)bcFeaturesStd, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())));
            LBFGS optimizer = new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
            Vector initialParameters = Vectors$.MODULE$.zeros(numFeatures + 2);
            Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialParameters.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
            ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
            FirstOrderMinimizer.State state = null;
            while (states.hasNext()) {
                state = (FirstOrderMinimizer.State)states.next();
                arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
            }
            if (state == null) {
                String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                throw new SparkException(msg);
            }
            double[] parameters = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
            bcFeaturesStd.destroy(false);
            Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
            double[] rawCoefficients = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(parameters)).slice(2, parameters.length);
            for (int i2 = 0; i2 < numFeatures; ++i2) {
                int n = i2;
                rawCoefficients[n] = rawCoefficients[n] * (featuresStd[i2] != 0.0 ? 1.0 / featuresStd[i2] : 0.0);
            }
            Vector coefficients = Vectors$.MODULE$.dense(rawCoefficients);
            double intercept = parameters[1];
            double scale = package$.MODULE$.exp(parameters[0]);
            return this.copyValues(new AFTSurvivalRegressionModel(this.uid(), coefficients, intercept, scale).setParent(this), this.copyValues$default$2());
        });
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, true);
    }

    @Override
    public AFTSurvivalRegression copy(ParamMap extra) {
        return (AFTSurvivalRegression)this.defaultCopy(extra);
    }

    public AFTSurvivalRegression(String uid) {
        this.uid = uid;
        HasFeaturesCol.$init$(this);
        HasLabelCol.$init$(this);
        HasPredictionCol.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasAggregationDepth.$init$(this);
        AFTSurvivalRegressionParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aggregationDepth().$minus$greater(BoxesRunTime.boxToInteger((int)2))}));
    }

    public AFTSurvivalRegression() {
        this(Identifiable$.MODULE$.randomUID("aftSurvReg"));
    }
}

