/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.impl.BaggedPoint;
import org.apache.spark.ml.tree.impl.NodeIdCache$;
import org.apache.spark.ml.tree.impl.NodeIndexUpdater;
import org.apache.spark.ml.tree.impl.TreePoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!\u0002\u000e\u001c\u0001\u0005:\u0003\u0002\u0003\u001b\u0001\u0005\u0003\u0007I\u0011\u0001\u001c\t\u0011\r\u0003!\u00111A\u0005\u0002\u0011C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ka\u000e\u0005\t\u0017\u0002\u0011)\u0019!C\u0001\u0019\"AQ\n\u0001B\u0001B\u0003%\u0001\tC\u0003O\u0001\u0011\u0005q\nC\u0004U\u0001\u0001\u0007I\u0011\u0002\u001c\t\u000fU\u0003\u0001\u0019!C\u0005-\"1\u0001\f\u0001Q!\n]Bq!\u0017\u0001C\u0002\u0013%!\f\u0003\u0004d\u0001\u0001\u0006Ia\u0017\u0005\bI\u0002\u0001\r\u0011\"\u0003M\u0011\u001d)\u0007\u00011A\u0005\n\u0019Da\u0001\u001b\u0001!B\u0013\u0001\u0005bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007]\u0002\u0001\u000b\u0011B6\t\u000f=\u0004!\u0019!C\u0005a\"1\u0011\u0010\u0001Q\u0001\nEDQA\u001f\u0001\u0005\u0002mDq!!\f\u0001\t\u0003\tyc\u0002\u0005\u00022mA\t!IA\u001a\r\u001dQ2\u0004#\u0001\"\u0003kAaA\u0014\f\u0005\u0002\u0005]\u0002bBA\u001d-\u0011\u0005\u00111\b\u0005\n\u0003\u00132\u0012\u0013!C\u0001\u0003\u0017\u00121BT8eK&#7)Y2iK*\u0011A$H\u0001\u0005S6\u0004HN\u0003\u0002\u001f?\u0005!AO]3f\u0015\t\u0001\u0013%\u0001\u0002nY*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xmE\u0002\u0001Q9\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0007CA\u00183\u001b\u0005\u0001$BA\u0019\"\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001a1\u0005\u001daunZ4j]\u001e\f1C\\8eK&#7OR8s\u0013:\u001cH/\u00198dKN\u001c\u0001!F\u00018!\rA4(P\u0007\u0002s)\u0011!(I\u0001\u0004e\u0012$\u0017B\u0001\u001f:\u0005\r\u0011F\t\u0012\t\u0004Sy\u0002\u0015BA +\u0005\u0015\t%O]1z!\tI\u0013)\u0003\u0002CU\t\u0019\u0011J\u001c;\u0002/9|G-Z%eg\u001a{'/\u00138ti\u0006t7-Z:`I\u0015\fHCA#I!\tIc)\u0003\u0002HU\t!QK\\5u\u0011\u001dI%!!AA\u0002]\n1\u0001\u001f\u00132\u0003Qqw\u000eZ3JIN4uN]%ogR\fgnY3tA\u0005\u00112\r[3dWB|\u0017N\u001c;J]R,'O^1m+\u0005\u0001\u0015aE2iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2\u0004\u0013A\u0002\u001fj]&$h\bF\u0002Q%N\u0003\"!\u0015\u0001\u000e\u0003mAQ\u0001\u000e\u0004A\u0002]BQa\u0013\u0004A\u0002\u0001\u000bq\u0003\u001d:fm:{G-Z%eg\u001a{'/\u00138ti\u0006t7-Z:\u00027A\u0014XM\u001e(pI\u0016LEm\u001d$pe&s7\u000f^1oG\u0016\u001cx\fJ3r)\t)u\u000bC\u0004J\u0011\u0005\u0005\t\u0019A\u001c\u00021A\u0014XM\u001e(pI\u0016LEm\u001d$pe&s7\u000f^1oG\u0016\u001c\b%A\bdQ\u0016\u001c7\u000e]8j]R\fV/Z;f+\u0005Y\u0006c\u0001/bo5\tQL\u0003\u0002_?\u00069Q.\u001e;bE2,'B\u00011+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Ev\u0013Q!U;fk\u0016\f\u0001c\u00195fG.\u0004x.\u001b8u#V,W/\u001a\u0011\u0002\u001dI$G-\u00169eCR,7i\\;oi\u0006\u0011\"\u000f\u001a3Va\u0012\fG/Z\"pk:$x\fJ3r)\t)u\rC\u0004J\u001b\u0005\u0005\t\u0019\u0001!\u0002\u001fI$G-\u00169eCR,7i\\;oi\u0002\nQbY1o\u0007\",7m\u001b9pS:$X#A6\u0011\u0005%b\u0017BA7+\u0005\u001d\u0011un\u001c7fC:\fabY1o\u0007\",7m\u001b9pS:$\b%\u0001\u0006iC\u0012|w\u000e]\"p]\u001a,\u0012!\u001d\t\u0003e^l\u0011a\u001d\u0006\u0003iV\fAaY8oM*\u0011aoI\u0001\u0007Q\u0006$wn\u001c9\n\u0005a\u001c(!D\"p]\u001aLw-\u001e:bi&|g.A\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\u0013!E;qI\u0006$XMT8eK&sG-[2fgR1Q\t`A\u0006\u0003;AQ!`\nA\u0002y\fA\u0001Z1uCB\u0019\u0001hO@\u0011\u000bE\u000b\t!!\u0002\n\u0007\u0005\r1DA\u0006CC\u001e<W\r\u001a)pS:$\bcA)\u0002\b%\u0019\u0011\u0011B\u000e\u0003\u0013Q\u0013X-\u001a)pS:$\bbBA\u0007'\u0001\u0007\u0011qB\u0001\u000f]>$W-\u00133Va\u0012\fG/\u001a:t!\u0011Ic(!\u0005\u0011\rq\u000b\u0019\u0002QA\f\u0013\r\t)\"\u0018\u0002\u0004\u001b\u0006\u0004\bcA)\u0002\u001a%\u0019\u00111D\u000e\u0003!9{G-Z%oI\u0016DX\u000b\u001d3bi\u0016\u0014\bbBA\u0010'\u0001\u0007\u0011\u0011E\u0001\u0007gBd\u0017\u000e^:\u0011\t%r\u00141\u0005\t\u0005Sy\n)\u0003\u0005\u0003\u0002(\u0005%R\"A\u000f\n\u0007\u0005-RDA\u0003Ta2LG/\u0001\u000beK2,G/Z!mY\u000eCWmY6q_&tGo\u001d\u000b\u0002\u000b\u0006Yaj\u001c3f\u0013\u0012\u001c\u0015m\u00195f!\t\tfc\u0005\u0002\u0017QQ\u0011\u00111G\u0001\u0005S:LG\u000fF\u0005Q\u0003{\ty$a\u0011\u0002F!)Q\u0010\u0007a\u0001}\"1\u0011\u0011\t\rA\u0002\u0001\u000b\u0001B\\;n)J,Wm\u001d\u0005\u0006\u0017b\u0001\r\u0001\u0011\u0005\t\u0003\u000fB\u0002\u0013!a\u0001\u0001\u00069\u0011N\\5u-\u0006d\u0017AD5oSR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001bR3\u0001QA(W\t\t\t\u0006\u0005\u0003\u0002T\u0005uSBAA+\u0015\u0011\t9&!\u0017\u0002\u0013Ut7\r[3dW\u0016$'bAA.U\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0013Q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class NodeIdCache
implements Logging {
    private RDD<int[]> nodeIdsForInstances;
    private final int checkpointInterval;
    private RDD<int[]> prevNodeIdsForInstances;
    private final Queue<RDD<int[]>> checkpointQueue;
    private int rddUpdateCount;
    private final boolean canCheckpoint;
    private final Configuration hadoopConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int init$default$4() {
        return NodeIdCache$.MODULE$.init$default$4();
    }

    public static NodeIdCache init(RDD<BaggedPoint<TreePoint>> rDD, int n, int n2, int n3) {
        return NodeIdCache$.MODULE$.init(rDD, n, n2, n3);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RDD<int[]> nodeIdsForInstances() {
        return this.nodeIdsForInstances;
    }

    public void nodeIdsForInstances_$eq(RDD<int[]> x$1) {
        this.nodeIdsForInstances = x$1;
    }

    public int checkpointInterval() {
        return this.checkpointInterval;
    }

    private RDD<int[]> prevNodeIdsForInstances() {
        return this.prevNodeIdsForInstances;
    }

    private void prevNodeIdsForInstances_$eq(RDD<int[]> x$1) {
        this.prevNodeIdsForInstances = x$1;
    }

    private Queue<RDD<int[]>> checkpointQueue() {
        return this.checkpointQueue;
    }

    private int rddUpdateCount() {
        return this.rddUpdateCount;
    }

    private void rddUpdateCount_$eq(int x$1) {
        this.rddUpdateCount = x$1;
    }

    private boolean canCheckpoint() {
        return this.canCheckpoint;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public void updateNodeIndices(RDD<BaggedPoint<TreePoint>> data, Map<Object, NodeIndexUpdater>[] nodeIdUpdaters, Split[][] splits) {
        block4: {
            Object object = this.prevNodeIdsForInstances() != null ? this.prevNodeIdsForInstances().unpersist(false) : BoxedUnit.UNIT;
            this.prevNodeIdsForInstances_$eq(this.nodeIdsForInstances());
            this.nodeIdsForInstances_$eq((RDD<int[]>)data.zip(this.nodeIdsForInstances(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                int[] ids;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    BaggedPoint point = (BaggedPoint)tuple2._1();
                    ids = (int[])tuple2._2();
                    for (int treeId = 0; treeId < nodeIdUpdaters.length; ++treeId) {
                        int newNodeIndex;
                        NodeIndexUpdater nodeIdUpdater = (NodeIndexUpdater)nodeIdUpdaters[treeId].getOrElse((Object)BoxesRunTime.boxToInteger((int)ids[treeId]), (Function0 & Serializable & scala.Serializable)() -> null);
                        if (nodeIdUpdater == null) continue;
                        int featureIndex = nodeIdUpdater.split().featureIndex();
                        ids[treeId] = newNodeIndex = nodeIdUpdater.updateNodeIndex(((TreePoint)point.datum()).binnedFeatures()[featureIndex], splits[featureIndex]);
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                int[] nArray = ids;
                return nArray;
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
            this.nodeIdsForInstances().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
            this.rddUpdateCount_$eq(this.rddUpdateCount() + 1);
            if (!this.canCheckpoint() || this.checkpointInterval() == -1 || this.rddUpdateCount() % this.checkpointInterval() != 0) break block4;
            boolean canDelete = true;
            while (this.checkpointQueue().size() > 1 && canDelete) {
                Object object2;
                if (((RDD)this.checkpointQueue().apply(1)).getCheckpointFile().isDefined()) {
                    RDD old = (RDD)this.checkpointQueue().dequeue();
                    try {
                        Path path = new Path((String)old.getCheckpointFile().get());
                        FileSystem fs = path.getFileSystem(this.hadoopConf());
                        object2 = BoxesRunTime.boxToBoolean((boolean)fs.delete(path, true));
                    }
                    catch (IOException e) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Decision Tree learning using cacheNodeIds failed to remove checkpoint").append(new StringBuilder(7).append(" file: ").append(old.getCheckpointFile().get()).toString()).toString());
                        object2 = BoxedUnit.UNIT;
                    }
                    continue;
                }
                canDelete = false;
                object2 = BoxedUnit.UNIT;
            }
            this.nodeIdsForInstances().checkpoint();
            this.checkpointQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{this.nodeIdsForInstances()}));
        }
    }

    public void deleteAllCheckpoints() {
        block4: {
            while (this.checkpointQueue().nonEmpty()) {
                Object object;
                RDD old = (RDD)this.checkpointQueue().dequeue();
                if (old.getCheckpointFile().isDefined()) {
                    try {
                        Path path = new Path((String)old.getCheckpointFile().get());
                        FileSystem fs = path.getFileSystem(this.hadoopConf());
                        object = BoxesRunTime.boxToBoolean((boolean)fs.delete(path, true));
                    }
                    catch (IOException e) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Decision Tree learning using cacheNodeIds failed to remove checkpoint").append(new StringBuilder(7).append(" file: ").append(old.getCheckpointFile().get()).toString()).toString());
                        object = BoxedUnit.UNIT;
                    }
                    continue;
                }
                object = BoxedUnit.UNIT;
            }
            Object object = this.nodeIdsForInstances() != null ? this.nodeIdsForInstances().unpersist(false) : BoxedUnit.UNIT;
            if (this.prevNodeIdsForInstances() == null) break block4;
            this.prevNodeIdsForInstances().unpersist(false);
        }
    }

    public NodeIdCache(RDD<int[]> nodeIdsForInstances, int checkpointInterval) {
        this.nodeIdsForInstances = nodeIdsForInstances;
        this.checkpointInterval = checkpointInterval;
        Logging.$init$((Logging)this);
        this.prevNodeIdsForInstances = null;
        this.checkpointQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.rddUpdateCount = 0;
        this.canCheckpoint = this.nodeIdsForInstances().sparkContext().getCheckpointDir().nonEmpty();
        this.hadoopConf = this.nodeIdsForInstances().sparkContext().hadoopConfiguration();
    }
}

