/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseVector;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.GaussianMixtureModel$;
import org.apache.spark.mllib.clustering.GaussianMixtureModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}g\u0001\u0002\u001d:\u0001\u0011C\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\t!\u0016\u0005\tK\u0002\u0011\t\u0011)A\u0005-\"Aq\r\u0001BC\u0002\u0013\u0005\u0001\u000e\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003j\u0011\u0015)\b\u0001\"\u0001w\u0011\u0015q\b\u0001\"\u0015\u0000\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005E\u0003\u0001\"\u0001\u0002v!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005\u0005\u0005bBAO\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003;\u0003A\u0011AAT\u0011\u001d\ti\u000b\u0001C\u0005\u0003_;q!!4:\u0011\u0003\tyM\u0002\u00049s!\u0005\u0011\u0011\u001b\u0005\u0007kB!\t!!7\b\u000f\u0005m\u0007\u0003#\u0003\u0002^\u001a9\u0011\u0011\u001d\t\t\n\u0005\r\bBB;\u0014\t\u0003\t)O\u0002\u0004\u0002hN\u0001\u0015\u0011\u001e\u0005\u000b\u0003c,\"Q3A\u0005\u0002\u0005M\b\"CA{+\tE\t\u0015!\u0003Z\u0011)\t90\u0006BK\u0002\u0013\u0005\u0011\u0011 \u0005\u000b\u0003w,\"\u0011#Q\u0001\n\u0005\u001d\u0004BCA\u007f+\tU\r\u0011\"\u0001\u0002\u0000\"Q!qA\u000b\u0003\u0012\u0003\u0006IA!\u0001\t\rU,B\u0011\u0001B\u0005\u0011%\u0011)\"FA\u0001\n\u0003\u00119\u0002C\u0005\u0003 U\t\n\u0011\"\u0001\u0003\"!I!QG\u000b\u0012\u0002\u0013\u0005!q\u0007\u0005\n\u0005w)\u0012\u0013!C\u0001\u0005{A\u0001B!\u0011\u0016\u0003\u0003%\te \u0005\n\u0005\u0007*\u0012\u0011!C\u0001\u0003\u000fB\u0011B!\u0012\u0016\u0003\u0003%\tAa\u0012\t\u0013\tMS#!A\u0005B\tU\u0003\"\u0003B2+\u0005\u0005I\u0011\u0001B3\u0011%\u0011y'FA\u0001\n\u0003\u0012\t\bC\u0005\u0003tU\t\t\u0011\"\u0011\u0003v!I!qO\u000b\u0002\u0002\u0013\u0005#\u0011P\u0004\n\u0005{\u001a\u0012\u0011!E\u0001\u0005\u007f2\u0011\"a:\u0014\u0003\u0003E\tA!!\t\rUTC\u0011\u0001BH\u0011%\u0011\u0019HKA\u0001\n\u000b\u0012)\bC\u0005\u0003\u0012*\n\t\u0011\"!\u0003\u0014\"I!1\u0014\u0016\u0002\u0002\u0013\u0005%Q\u0014\u0005\n\u0005_S\u0013\u0011!C\u0005\u0005cC\u0001B!/\u0014\u0005\u0004%\ta \u0005\t\u0005w\u001b\u0002\u0015!\u0003\u0002\u0002!A!QX\nC\u0002\u0013\u0005q\u0010\u0003\u0005\u0003@N\u0001\u000b\u0011BA\u0001\u0011\u001d\t\tb\u0005C\u0001\u0005\u0003DqAa3\u0014\t\u0003\u0011i\rC\u0004\u0003LB!\tEa5\t\u0013\t=\u0006#!A\u0005\n\tE&\u0001F$bkN\u001c\u0018.\u00198NSb$XO]3N_\u0012,GN\u0003\u0002;w\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005qj\u0014!B7mY&\u0014'B\u0001 @\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\u0004\u0001M!\u0001!R&O!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0019\te.\u001f*fMB\u0011a\tT\u0005\u0003\u001b\u001e\u0013AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"a\u0014*\u000e\u0003AS!!U\u001e\u0002\tU$\u0018\u000e\\\u0005\u0003'B\u0013\u0001bU1wK\u0006\u0014G.Z\u0001\bo\u0016Lw\r\u001b;t+\u00051\u0006c\u0001$X3&\u0011\u0001l\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\rjK!aW$\u0003\r\u0011{WO\u00197fQ\r\tQl\u0019\t\u0003=\u0006l\u0011a\u0018\u0006\u0003Av\n!\"\u00198o_R\fG/[8o\u0013\t\u0011wLA\u0003TS:\u001cW-I\u0001e\u0003\u0015\tdf\r\u00181\u0003!9X-[4iiN\u0004\u0003f\u0001\u0002^G\u0006Iq-Y;tg&\fgn]\u000b\u0002SB\u0019ai\u00166\u0011\u0005-\u0004X\"\u00017\u000b\u00055t\u0017\u0001\u00043jgR\u0014\u0018NY;uS>t'BA8<\u0003\u0011\u0019H/\u0019;\n\u0005Ed'\u0001F'vYRLg/\u0019:jCR,w)Y;tg&\fg\u000eK\u0002\u0004;\u000e\f!bZ1vgNL\u0017M\\:!Q\r!QlY\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007]L8\u0010\u0005\u0002y\u00015\t\u0011\bC\u0003U\u000b\u0001\u0007a\u000bK\u0002z;\u000eDQaZ\u0003A\u0002%D3a_/dQ\r)QlY\u0001\u000eM>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0005Y\u0006twM\u0003\u0002\u0002\f\u0005!!.\u0019<b\u0013\u0011\ty!!\u0002\u0003\rM#(/\u001b8h\u0003\u0011\u0019\u0018M^3\u0015\r\u0005U\u00111DA\u0014!\r1\u0015qC\u0005\u0004\u000339%\u0001B+oSRDq!!\b\b\u0001\u0004\ty\"\u0001\u0002tGB!\u0011\u0011EA\u0012\u001b\u0005i\u0014bAA\u0013{\ta1\u000b]1sW\u000e{g\u000e^3yi\"9\u0011\u0011F\u0004A\u0002\u0005-\u0012\u0001\u00029bi\"\u0004B!!\f\u0002<9!\u0011qFA\u001c!\r\t\tdR\u0007\u0003\u0003gQ1!!\u000eD\u0003\u0019a$o\\8u}%\u0019\u0011\u0011H$\u0002\rA\u0013X\rZ3g\u0013\u0011\ty!!\u0010\u000b\u0007\u0005er\t\u000b\u0003\b;\u0006\u0005\u0013EAA\"\u0003\u0015\td\u0006\u000e\u00181\u0003\u0005YWCAA%!\r1\u00151J\u0005\u0004\u0003\u001b:%aA%oi\"\u001a\u0001\"X2\u0002\u000fA\u0014X\rZ5diR!\u0011QKA1!\u0019\t9&!\u0018\u0002J5\u0011\u0011\u0011\f\u0006\u0004\u00037j\u0014a\u0001:eI&!\u0011qLA-\u0005\r\u0011F\t\u0012\u0005\b\u0003GJ\u0001\u0019AA3\u0003\u0019\u0001x.\u001b8ugB1\u0011qKA/\u0003O\u0002B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[Z\u0014A\u00027j]\u0006dw-\u0003\u0003\u0002r\u0005-$A\u0002,fGR|'\u000fK\u0002\n;\u000e$B!!\u0013\u0002x!9\u0011\u0011\u0010\u0006A\u0002\u0005\u001d\u0014!\u00029pS:$\b\u0006\u0002\u0006^\u0003{\n#!a \u0002\u000bErSG\f\u0019\u0015\t\u0005\r\u0015q\u0013\t\u0007\u0003\u000b\u000bi)!%\u000e\u0005\u0005\u001d%\u0002BA\u0006\u0003\u0013S1!a#>\u0003\r\t\u0007/[\u0005\u0005\u0003\u001f\u000b9IA\u0004KCZ\f'\u000b\u0012#\u0011\t\u0005\r\u00111S\u0005\u0005\u0003+\u000b)AA\u0004J]R,w-\u001a:\t\u000f\u0005\r4\u00021\u0001\u0002\u001aB1\u0011QQAG\u0003OBCaC/\u0002B\u0005Y\u0001O]3eS\u000e$8k\u001c4u)\u0011\t\t+a)\u0011\u000b\u0005]\u0013Q\f,\t\u000f\u0005\rD\u00021\u0001\u0002f!\u001aA\"X2\u0015\u0007Y\u000bI\u000bC\u0004\u0002z5\u0001\r!a\u001a)\t5i\u0016\u0011I\u0001\u0017G>l\u0007/\u001e;f'>4G/Q:tS\u001etW.\u001a8ugRIa+!-\u0002D\u0006\u001d\u0017\u0011\u001a\u0005\b\u0003gs\u0001\u0019AA[\u0003\t\u0001H\u000fE\u0003\u00028\u0006}\u0016,\u0004\u0002\u0002:*!\u0011QNA^\u0015\t\ti,\u0001\u0004ce\u0016,'0Z\u0005\u0005\u0003\u0003\fILA\u0006EK:\u001cXMV3di>\u0014\bBBAc\u001d\u0001\u0007\u0011.A\u0003eSN$8\u000fC\u0003U\u001d\u0001\u0007a\u000bC\u0004\u0002F9\u0001\r!!\u0013)\u0007\u0001i6-\u0001\u000bHCV\u001c8/[1o\u001b&DH/\u001e:f\u001b>$W\r\u001c\t\u0003qB\u0019R\u0001E#\u0002T.\u0003BaTAko&\u0019\u0011q\u001b)\u0003\r1{\u0017\rZ3s)\t\ty-\u0001\u0007TCZ,Gj\\1e-Fz\u0006\u0007E\u0002\u0002`Ni\u0011\u0001\u0005\u0002\r'\u00064X\rT8bIZ\u000bt\fM\n\u0003'\u0015#\"!!8\u0003\t\u0011\u000bG/Y\n\u0006+\u0015\u000bYo\u0013\t\u0004\r\u00065\u0018bAAx\u000f\n9\u0001K]8ek\u000e$\u0018AB<fS\u001eDG/F\u0001Z\u0003\u001d9X-[4ii\u0002\n!!\\;\u0016\u0005\u0005\u001d\u0014aA7vA\u0005)1/[4nCV\u0011!\u0011\u0001\t\u0005\u0003S\u0012\u0019!\u0003\u0003\u0003\u0006\u0005-$AB'biJL\u00070\u0001\u0004tS\u001el\u0017\r\t\u000b\t\u0005\u0017\u0011yA!\u0005\u0003\u0014A\u0019!QB\u000b\u000e\u0003MAa!!=\u001d\u0001\u0004I\u0006bBA|9\u0001\u0007\u0011q\r\u0005\b\u0003{d\u0002\u0019\u0001B\u0001\u0003\u0011\u0019w\u000e]=\u0015\u0011\t-!\u0011\u0004B\u000e\u0005;A\u0001\"!=\u001e!\u0003\u0005\r!\u0017\u0005\n\u0003ol\u0002\u0013!a\u0001\u0003OB\u0011\"!@\u001e!\u0003\u0005\rA!\u0001\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0005\u0016\u00043\n\u00152F\u0001B\u0014!\u0011\u0011IC!\r\u000e\u0005\t-\"\u0002\u0002B\u0017\u0005_\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u0001<\u0015\u0002\u0002B\u001a\u0005W\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\u000f+\t\u0005\u001d$QE\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011yD\u000b\u0003\u0003\u0002\t\u0015\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t%#q\n\t\u0004\r\n-\u0013b\u0001B'\u000f\n\u0019\u0011I\\=\t\u0013\tE3%!AA\u0002\u0005%\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003XA1!\u0011\fB0\u0005\u0013j!Aa\u0017\u000b\u0007\tus)\u0001\u0006d_2dWm\u0019;j_:LAA!\u0019\u0003\\\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u00119G!\u001c\u0011\u0007\u0019\u0013I'C\u0002\u0003l\u001d\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0003R\u0015\n\t\u00111\u0001\u0003J\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002J\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0002\u00051Q-];bYN$BAa\u001a\u0003|!I!\u0011\u000b\u0015\u0002\u0002\u0003\u0007!\u0011J\u0001\u0005\t\u0006$\u0018\rE\u0002\u0003\u000e)\u001aBA\u000bBB\u0017BY!Q\u0011BF3\u0006\u001d$\u0011\u0001B\u0006\u001b\t\u00119IC\u0002\u0003\n\u001e\u000bqA];oi&lW-\u0003\u0003\u0003\u000e\n\u001d%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011!qP\u0001\u0006CB\u0004H.\u001f\u000b\t\u0005\u0017\u0011)Ja&\u0003\u001a\"1\u0011\u0011_\u0017A\u0002eCq!a>.\u0001\u0004\t9\u0007C\u0004\u0002~6\u0002\rA!\u0001\u0002\u000fUt\u0017\r\u001d9msR!!q\u0014BV!\u00151%\u0011\u0015BS\u0013\r\u0011\u0019k\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011\u0019\u00139+WA4\u0005\u0003I1A!+H\u0005\u0019!V\u000f\u001d7fg!I!Q\u0016\u0018\u0002\u0002\u0003\u0007!1B\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa-\u0011\t\u0005\r!QW\u0005\u0005\u0005o\u000b)A\u0001\u0004PE*,7\r^\u0001\u0012M>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8Wc}\u0003\u0014A\u00054pe6\fGOV3sg&|gNV\u0019`a\u0001\nQb\u00197bgNt\u0015-\\3Wc}\u0003\u0014AD2mCN\u001ch*Y7f-Fz\u0006\u0007\t\u000b\u000b\u0003+\u0011\u0019M!2\u0003H\n%\u0007bBA\u000fi\u0001\u0007\u0011q\u0004\u0005\b\u0003S!\u0004\u0019AA\u0016\u0011\u0015!F\u00071\u0001W\u0011\u00159G\u00071\u0001j\u0003\u0011aw.\u00193\u0015\u000b]\u0014yM!5\t\u000f\u0005uQ\u00071\u0001\u0002 !9\u0011\u0011F\u001bA\u0002\u0005-B#B<\u0003V\n]\u0007bBA\u000fm\u0001\u0007\u0011q\u0004\u0005\b\u0003S1\u0004\u0019AA\u0016Q\u00111T,!\u0011)\tAi\u0016\u0011\t\u0015\u0005\u001fu\u000b\t\u0005")
public class GaussianMixtureModel
implements scala.Serializable,
Saveable {
    private final double[] weights;
    private final MultivariateGaussian[] gaussians;

    public static GaussianMixtureModel load(SparkContext sparkContext, String string) {
        return GaussianMixtureModel$.MODULE$.load(sparkContext, string);
    }

    public double[] weights() {
        return this.weights;
    }

    public MultivariateGaussian[] gaussians() {
        return this.gaussians;
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public void save(SparkContext sc, String path) {
        GaussianMixtureModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.weights(), this.gaussians());
    }

    public int k() {
        return this.weights().length;
    }

    public RDD<Object> predict(RDD<Vector> points) {
        RDD<double[]> responsibilityMatrix = this.predictSoft(points);
        return responsibilityMatrix.map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)GaussianMixtureModel.$anonfun$predict$1(r)), ClassTag$.MODULE$.Int());
    }

    public int predict(Vector point) {
        double[] r = this.predictSoft(point);
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(r)).indexOf(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(r)).max((Ordering)Ordering.Double$.MODULE$));
    }

    public JavaRDD<Integer> predict(JavaRDD<Vector> points) {
        return this.predict((RDD<Vector>)points.rdd()).toJavaRDD();
    }

    public RDD<double[]> predictSoft(RDD<Vector> points) {
        SparkContext sc = points.sparkContext();
        Broadcast bcDists = sc.broadcast((Object)this.gaussians(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(MultivariateGaussian.class)));
        Broadcast bcWeights = sc.broadcast((Object)this.weights(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return points.map((Function1 & Serializable & scala.Serializable)x -> this.computeSoftAssignments((DenseVector<Object>)x.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), (MultivariateGaussian[])bcDists.value(), (double[])bcWeights.value(), this.k()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public double[] predictSoft(Vector point) {
        return this.computeSoftAssignments((DenseVector<Object>)point.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), this.gaussians(), this.weights(), this.k());
    }

    private double[] computeSoftAssignments(DenseVector<Object> pt, MultivariateGaussian[] dists, double[] weights, int k) {
        double[] p = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])dists), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)GaussianMixtureModel.$anonfun$computeSoftAssignments$1(pt, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double pSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            p$1[i] = p[i] / pSum;
        });
        return p;
    }

    public static final /* synthetic */ int $anonfun$predict$1(double[] r) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(r)).indexOf(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(r)).max((Ordering)Ordering.Double$.MODULE$));
    }

    public static final /* synthetic */ double $anonfun$computeSoftAssignments$1(DenseVector pt$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double weight = tuple2._1$mcD$sp();
        MultivariateGaussian dist = (MultivariateGaussian)tuple2._2();
        double d = MLUtils$.MODULE$.EPSILON() + weight * dist.pdf((breeze.linalg.Vector<Object>)pt$1);
        return d;
    }

    public GaussianMixtureModel(double[] weights, MultivariateGaussian[] gaussians) {
        this.weights = weights;
        this.gaussians = gaussians;
        Predef$.MODULE$.require(weights.length == gaussians.length, (Function0 & Serializable & scala.Serializable)() -> "Length of weight and Gaussian arrays must match");
    }
}

