/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.BitVector$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.Matrix$;
import breeze.linalg.NumericOps;
import breeze.linalg.all$;
import breeze.linalg.package;
import breeze.linalg.sum$;
import breeze.math.Ring$;
import breeze.math.Semiring$;
import breeze.numerics.package;
import breeze.stats.distributions.Gamma;
import breeze.stats.distributions.RandBasis;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Random;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LDAUtils$;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.clustering.LocalLDAModel$;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import shapeless.package$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\tug\u0001B%K\u0005UCQA\u001a\u0001\u0005\u0002\u001dDq!\u001b\u0001A\u0002\u0013%!\u000eC\u0004o\u0001\u0001\u0007I\u0011B8\t\rU\u0004\u0001\u0015)\u0003l\u0011\u001d1\b\u00011A\u0005\n]Dqa\u001f\u0001A\u0002\u0013%A\u0010\u0003\u0004\u007f\u0001\u0001\u0006K\u0001\u001f\u0005\b\u007f\u0002\u0001\r\u0011\"\u0003k\u0011%\t\t\u0001\u0001a\u0001\n\u0013\t\u0019\u0001C\u0004\u0002\b\u0001\u0001\u000b\u0015B6\t\u0013\u0005%\u0001\u00011A\u0005\n\u0005-\u0001\"CA\r\u0001\u0001\u0007I\u0011BA\u000e\u0011!\ty\u0002\u0001Q!\n\u00055\u0001\u0002CA\u0011\u0001\u0011\u0005!*a\u0003\t\u0013\u0005\r\u0002\u00011A\u0005\n\u0005\u0015\u0002\"CA\u0017\u0001\u0001\u0007I\u0011BA\u0018\u0011!\t\u0019\u0004\u0001Q!\n\u0005\u001d\u0002\u0002CA\u001b\u0001\u0011\u0005!*!\n\t\u0013\u0005]\u0002\u00011A\u0005\n\u0005e\u0002\"CA&\u0001\u0001\u0007I\u0011BA'\u0011!\t\t\u0006\u0001Q!\n\u0005m\u0002\"CA*\u0001\u0001\u0007I\u0011BA+\u0011%\ti\u0006\u0001a\u0001\n\u0013\ty\u0006\u0003\u0005\u0002d\u0001\u0001\u000b\u0015BA,\u0011%\t)\u0007\u0001a\u0001\n\u0013\t)\u0003C\u0005\u0002h\u0001\u0001\r\u0011\"\u0003\u0002j!A\u0011Q\u000e\u0001!B\u0013\t9\u0003C\u0005\u0002p\u0001\u0001\r\u0011\"\u0003\u0002&!I\u0011\u0011\u000f\u0001A\u0002\u0013%\u00111\u000f\u0005\t\u0003o\u0002\u0001\u0015)\u0003\u0002(!I\u0011\u0011\u0010\u0001A\u0002\u0013%\u0011Q\u0005\u0005\n\u0003w\u0002\u0001\u0019!C\u0005\u0003{B\u0001\"!!\u0001A\u0003&\u0011q\u0005\u0005\n\u0003\u0007\u0003\u0001\u0019!C\u0005\u0003+B\u0011\"!\"\u0001\u0001\u0004%I!a\"\t\u0011\u0005-\u0005\u0001)Q\u0005\u0003/B\u0011\"!$\u0001\u0001\u0004%I!a$\t\u0013\u0005\r\u0006\u00011A\u0005\n\u0005\u0015\u0006\u0002CAU\u0001\u0001\u0006K!!%\t\u0013\u0005-\u0006\u00011A\u0005\n\u00055\u0006\"CA_\u0001\u0001\u0007I\u0011BA`\u0011!\t\u0019\r\u0001Q!\n\u0005=\u0006\u0002CAc\u0001\u0011\u0005!*!,\t\u0011\u0005\u001d\u0007\u00011A\u0005\n)D\u0011\"!3\u0001\u0001\u0004%I!a3\t\u000f\u0005=\u0007\u0001)Q\u0005W\"I\u0011\u0011\u001b\u0001A\u0002\u0013%\u0011Q\u0005\u0005\n\u0003'\u0004\u0001\u0019!C\u0005\u0003+D\u0001\"!7\u0001A\u0003&\u0011q\u0005\u0005\b\u00037\u0004A\u0011AA\u0013\u0011\u001d\ty\u000f\u0001C\u0001\u0003cDq!!?\u0001\t\u0003\t)\u0003C\u0004\u0002~\u0002!\t!a@\t\u000f\t\u0015\u0001\u0001\"\u0001\u0002&!9!\u0011\u0002\u0001\u0005\u0002\t-\u0001b\u0002B\t\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011!\u0011\t\u0003\u0001C\u0001\u0015\n\r\u0002\u0002\u0003B\u0014\u0001\u0011\u0005!J!\u000b\t\u0011\t=\u0002\u0001\"\u0001K\u0005cA\u0001Ba\u000e\u0001\t\u0003R%\u0011\b\u0005\b\u0005\u000f\u0002A\u0011\t&h\u0011!\u0011I\u0005\u0001C\u0001\u0015\n-\u0003b\u0002B)\u0001\u0011%!1\u000b\u0005\b\u0005;\u0002A\u0011\u0002B0\u0011\u001d\u0011y\u0007\u0001C\u0005\u0005cBqAa\u001d\u0001\t\u0013\u0011)\b\u0003\u0005\u0003\u0000\u0001!\tE\u0013BA\u000f!\u0011iJ\u0013E\u0001\u0015\n}eaB%K\u0011\u0003Q%\u0011\u0015\u0005\u0007M\u001a#\tAa)\t\u0011\t\u0015f\t\"\u0001K\u0005O\u0013!c\u00148mS:,G\nR!PaRLW.\u001b>fe*\u00111\nT\u0001\u000bG2,8\u000f^3sS:<'BA'O\u0003\u0015iG\u000e\\5c\u0015\ty\u0005+A\u0003ta\u0006\u00148N\u0003\u0002R%\u00061\u0011\r]1dQ\u0016T\u0011aU\u0001\u0004_J<7\u0001A\n\u0005\u0001Yc\u0006\r\u0005\u0002X56\t\u0001LC\u0001Z\u0003\u0015\u00198-\u00197b\u0013\tY\u0006L\u0001\u0004B]f\u0014VM\u001a\t\u0003;zk\u0011AS\u0005\u0003?*\u0013A\u0002\u0014#B\u001fB$\u0018.\\5{KJ\u0004\"!\u00193\u000e\u0003\tT!a\u0019(\u0002\u0011%tG/\u001a:oC2L!!\u001a2\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\u001b\t\u0003;\u0002\t\u0011a[\u000b\u0002WB\u0011q\u000b\\\u0005\u0003[b\u00131!\u00138u\u0003\u0015Yw\fJ3r)\t\u00018\u000f\u0005\u0002Xc&\u0011!\u000f\u0017\u0002\u0005+:LG\u000fC\u0004u\u0007\u0005\u0005\t\u0019A6\u0002\u0007a$\u0013'\u0001\u0002lA\u0005Q1m\u001c:qkN\u001c\u0016N_3\u0016\u0003a\u0004\"aV=\n\u0005iD&\u0001\u0002'p]\u001e\fabY8saV\u001c8+\u001b>f?\u0012*\u0017\u000f\u0006\u0002q{\"9AOBA\u0001\u0002\u0004A\u0018aC2peB,8oU5{K\u0002\n\u0011B^8dC\n\u001c\u0016N_3\u0002\u001bY|7-\u00192TSj,w\fJ3r)\r\u0001\u0018Q\u0001\u0005\bi&\t\t\u00111\u0001l\u0003)1xnY1c'&TX\rI\u0001\u0006C2\u0004\b.Y\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'a\u0015A\u00027j]\u0006dw-\u0003\u0003\u0002\u0018\u0005E!A\u0002,fGR|'/A\u0005bYBD\u0017m\u0018\u0013fcR\u0019\u0001/!\b\t\u0011Qd\u0011\u0011!a\u0001\u0003\u001b\ta!\u00197qQ\u0006\u0004\u0013\u0001C4fi\u0006c\u0007\u000f[1\u0002\u0007\u0015$\u0018-\u0006\u0002\u0002(A\u0019q+!\u000b\n\u0007\u0005-\u0002L\u0001\u0004E_V\u0014G.Z\u0001\bKR\fw\fJ3r)\r\u0001\u0018\u0011\u0007\u0005\tiB\t\t\u00111\u0001\u0002(\u0005!Q\r^1!\u0003\u00199W\r^#uC\u0006y!/\u00198e_6<UM\\3sCR|'/\u0006\u0002\u0002<A!\u0011QHA$\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001B;uS2T!!!\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\nyD\u0001\u0004SC:$w.\\\u0001\u0014e\u0006tGm\\7HK:,'/\u0019;pe~#S-\u001d\u000b\u0004a\u0006=\u0003\u0002\u0003;\u0015\u0003\u0003\u0005\r!a\u000f\u0002!I\fg\u000eZ8n\u000f\u0016tWM]1u_J\u0004\u0013!F:b[BdWmV5uQJ+\u0007\u000f\\1dK6,g\u000e^\u000b\u0003\u0003/\u00022aVA-\u0013\r\tY\u0006\u0017\u0002\b\u0005>|G.Z1o\u0003e\u0019\u0018-\u001c9mK^KG\u000f\u001b*fa2\f7-Z7f]R|F%Z9\u0015\u0007A\f\t\u0007\u0003\u0005u/\u0005\u0005\t\u0019AA,\u0003Y\u0019\u0018-\u001c9mK^KG\u000f\u001b*fa2\f7-Z7f]R\u0004\u0013\u0001\u0002;bkB\n\u0001\u0002^1va}#S-\u001d\u000b\u0004a\u0006-\u0004\u0002\u0003;\u001b\u0003\u0003\u0005\r!a\n\u0002\u000bQ\fW\u000f\r\u0011\u0002\u000b-\f\u0007\u000f]1\u0002\u0013-\f\u0007\u000f]1`I\u0015\fHc\u00019\u0002v!AA/HA\u0001\u0002\u0004\t9#\u0001\u0004lCB\u0004\u0018\rI\u0001\u0012[&t\u0017NQ1uG\"4%/Y2uS>t\u0017!F7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]~#S-\u001d\u000b\u0004a\u0006}\u0004\u0002\u0003;!\u0003\u0003\u0005\r!a\n\u0002%5Lg.\u001b\"bi\u000eDgI]1di&|g\u000eI\u0001\u0019_B$\u0018.\\5{K\u0012{7mQ8oG\u0016tGO]1uS>t\u0017\u0001H8qi&l\u0017N_3E_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]~#S-\u001d\u000b\u0004a\u0006%\u0005\u0002\u0003;$\u0003\u0003\u0005\r!a\u0016\u00023=\u0004H/[7ju\u0016$unY\"p]\u000e,g\u000e\u001e:bi&|g\u000eI\u0001\u0005I>\u001c7/\u0006\u0002\u0002\u0012B1\u00111SAM\u0003;k!!!&\u000b\u0007\u0005]e*A\u0002sI\u0012LA!a'\u0002\u0016\n\u0019!\u000b\u0012#\u0011\r]\u000by\n_A\u0007\u0013\r\t\t\u000b\u0017\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0011\u0011|7m]0%KF$2\u0001]AT\u0011!!h%!AA\u0002\u0005E\u0015!\u00023pGN\u0004\u0013A\u00027b[\n$\u0017-\u0006\u0002\u00020B1\u0011\u0011WA]\u0003Oi!!a-\u000b\t\u0005M\u0011Q\u0017\u0006\u0003\u0003o\u000baA\u0019:fKj,\u0017\u0002BA^\u0003g\u00131\u0002R3og\u0016l\u0015\r\u001e:jq\u0006QA.Y7cI\u0006|F%Z9\u0015\u0007A\f\t\r\u0003\u0005uS\u0005\u0005\t\u0019AAX\u0003\u001da\u0017-\u001c2eC\u0002\n\u0011bZ3u\u0019\u0006l'\rZ1\u0002\u0013%$XM]1uS>t\u0017!D5uKJ\fG/[8o?\u0012*\u0017\u000fF\u0002q\u0003\u001bDq\u0001^\u0017\u0002\u0002\u0003\u00071.\u0001\u0006ji\u0016\u0014\u0018\r^5p]\u0002\n!bZ1n[\u0006\u001c\u0006.\u00199f\u000399\u0017-\\7b'\"\f\u0007/Z0%KF$2\u0001]Al\u0011!!\b'!AA\u0002\u0005\u001d\u0012aC4b[6\f7\u000b[1qK\u0002\nqaZ3u)\u0006,\b\u0007K\u00033\u0003?\fY\u000f\u0005\u0003\u0002b\u0006\u001dXBAAr\u0015\r\t)OT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAu\u0003G\u0014QaU5oG\u0016\f#!!<\u0002\u000bErCG\f\u0019\u0002\u000fM,G\u000fV1vaQ!\u00111_A{\u001b\u0005\u0001\u0001bBA3g\u0001\u0007\u0011q\u0005\u0015\u0006g\u0005}\u00171^\u0001\tO\u0016$8*\u00199qC\"*A'a8\u0002l\u0006A1/\u001a;LCB\u0004\u0018\r\u0006\u0003\u0002t\n\u0005\u0001bBA8k\u0001\u0007\u0011q\u0005\u0015\u0006k\u0005}\u00171^\u0001\u0015O\u0016$X*\u001b8j\u0005\u0006$8\r\u001b$sC\u000e$\u0018n\u001c8)\u000bY\ny.a;\u0002)M,G/T5oS\n\u000bGo\u00195Ge\u0006\u001cG/[8o)\u0011\t\u0019P!\u0004\t\u000f\u0005et\u00071\u0001\u0002(!*q'a8\u0002l\u0006Yr-\u001a;PaRLW.\u001b>f\t>\u001c7i\u001c8dK:$(/\u0019;j_:DS\u0001OAp\u0005+\t#Aa\u0006\u0002\u000bErSG\f\u0019\u00027M,Go\u00149uS6L'0\u001a#pG\u000e{gnY3oiJ\fG/[8o)\u0011\t\u0019P!\b\t\u000f\u0005\r\u0015\b1\u0001\u0002X!*\u0011(a8\u0003\u0016\u0005I1/\u001a;MC6\u0014G-\u0019\u000b\u0005\u0003g\u0014)\u0003C\u0004\u0002,j\u0002\r!a,\u0002\u001bM,GoR1n[\u0006\u001c\u0006.\u00199f)\u0011\t\u0019Pa\u000b\t\u000f\t52\b1\u0001\u0002(\u0005)1\u000f[1qK\u0006A2/\u001a;TC6\u0004H.Z,ji\"\u0014V\r\u001d7bG\u0016lWM\u001c;\u0015\t\u0005M(1\u0007\u0005\b\u0005ka\u0004\u0019AA,\u0003\u001d\u0011X\r\u001d7bG\u0016\f!\"\u001b8ji&\fG.\u001b>f)\u0015A'1\bB\u001f\u0011\u001d\ti)\u0010a\u0001\u0003#CqAa\u0010>\u0001\u0004\u0011\t%A\u0002mI\u0006\u00042!\u0018B\"\u0013\r\u0011)E\u0013\u0002\u0004\u0019\u0012\u000b\u0015\u0001\u00028fqR\fqb];c[&$X*\u001b8j\u0005\u0006$8\r\u001b\u000b\u0004Q\n5\u0003b\u0002B(\u007f\u0001\u0007\u0011\u0011S\u0001\u0006E\u0006$8\r[\u0001\rkB$\u0017\r^3MC6\u0014G-\u0019\u000b\u0006a\nU#\u0011\f\u0005\b\u0005/\u0002\u0005\u0019AAX\u0003\u0011\u0019H/\u0019;\t\r\tm\u0003\t1\u0001l\u0003%\u0011\u0017\r^2i'&TX-A\u0006va\u0012\fG/Z!ma\"\fG#\u00029\u0003b\t-\u0004b\u0002B2\u0003\u0002\u0007!QM\u0001\bY><\u0007\u000f[1u!\u0019\t\tLa\u001a\u0002(%!!\u0011NAZ\u0005-!UM\\:f-\u0016\u001cGo\u001c:\t\u000f\t5\u0014\t1\u0001\u0002(\u0005ian\u001c8F[B$\u0018\u0010R8dg:\u000b1A\u001d5p)\t\t9#\u0001\bhKR<\u0015-\\7b\u001b\u0006$(/\u001b=\u0015\r\u0005=&q\u000fB>\u0011\u0019\u0011Ih\u0011a\u0001W\u0006\u0019!o\\<\t\r\tu4\t1\u0001l\u0003\r\u0019w\u000e\\\u0001\fO\u0016$H\nR!N_\u0012,G\u000e\u0006\u0003\u0003\u0004\n%\u0005cA/\u0003\u0006&\u0019!q\u0011&\u0003\u00111#\u0015)T8eK2DqAa#E\u0001\u0004\u0011i)\u0001\bji\u0016\u0014\u0018\r^5p]RKW.Z:\u0011\u000b]\u0013y)a\n\n\u0007\tE\u0005LA\u0003BeJ\f\u0017\u0010K\u0002\u0001\u0005+\u0003B!!9\u0003\u0018&!!\u0011TAr\u00051!UM^3m_B,'/\u00119jQ\u0015\u0001\u0011q\\Av\u0003Iye\u000e\\5oK2#\u0015i\u00149uS6L'0\u001a:\u0011\u0005u35C\u0001$W)\t\u0011y*A\rwCJL\u0017\r^5p]\u0006dGk\u001c9jG&sg-\u001a:f]\u000e,GC\u0004BU\u0005\u000f\u0014YMa4\u0003V\n]'\u0011\u001c\t\n/\n-&QMAX\u0005_K1A!,Y\u0005\u0019!V\u000f\u001d7fgA)!\u0011\u0017BaW:!!1\u0017B_\u001d\u0011\u0011)La/\u000e\u0005\t]&b\u0001B])\u00061AH]8pizJ\u0011!W\u0005\u0004\u0005\u007fC\u0016a\u00029bG.\fw-Z\u0005\u0005\u0005\u0007\u0014)M\u0001\u0003MSN$(b\u0001B`1\"9!\u0011\u001a%A\u0002\u00055\u0011A\u0003;fe6\u001cu.\u001e8ug\"9!Q\u001a%A\u0002\u0005=\u0016aC3ya\u0016cwn\u001a2fi\u0006Dq!!\u0003I\u0001\u0004\u0011\t\u000e\u0005\u0004\u00022\nM\u0017qE\u0005\u0005\u0003/\t\u0019\fC\u0004\u0002R\"\u0003\r!a\n\t\u000b%D\u0005\u0019A6\t\r\tm\u0007\n1\u0001y\u0003\u0011\u0019X-\u001a3")
public final class OnlineLDAOptimizer
implements LDAOptimizer,
Logging {
    private int k;
    private long corpusSize;
    private int vocabSize;
    private Vector alpha;
    private double eta;
    private Random randomGenerator;
    private boolean sampleWithReplacement;
    private double tau0;
    private double kappa;
    private double miniBatchFraction;
    private boolean optimizeDocConcentration;
    private RDD<Tuple2<Object, Vector>> docs;
    private DenseMatrix<Object> lambda;
    private int iteration;
    private double gammaShape;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private long corpusSize() {
        return this.corpusSize;
    }

    private void corpusSize_$eq(long x$1) {
        this.corpusSize = x$1;
    }

    private int vocabSize() {
        return this.vocabSize;
    }

    private void vocabSize_$eq(int x$1) {
        this.vocabSize = x$1;
    }

    private Vector alpha() {
        return this.alpha;
    }

    private void alpha_$eq(Vector x$1) {
        this.alpha = x$1;
    }

    public Vector getAlpha() {
        return this.alpha();
    }

    private double eta() {
        return this.eta;
    }

    private void eta_$eq(double x$1) {
        this.eta = x$1;
    }

    public double getEta() {
        return this.eta();
    }

    private Random randomGenerator() {
        return this.randomGenerator;
    }

    private void randomGenerator_$eq(Random x$1) {
        this.randomGenerator = x$1;
    }

    private boolean sampleWithReplacement() {
        return this.sampleWithReplacement;
    }

    private void sampleWithReplacement_$eq(boolean x$1) {
        this.sampleWithReplacement = x$1;
    }

    private double tau0() {
        return this.tau0;
    }

    private void tau0_$eq(double x$1) {
        this.tau0 = x$1;
    }

    private double kappa() {
        return this.kappa;
    }

    private void kappa_$eq(double x$1) {
        this.kappa = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private boolean optimizeDocConcentration() {
        return this.optimizeDocConcentration;
    }

    private void optimizeDocConcentration_$eq(boolean x$1) {
        this.optimizeDocConcentration = x$1;
    }

    private RDD<Tuple2<Object, Vector>> docs() {
        return this.docs;
    }

    private void docs_$eq(RDD<Tuple2<Object, Vector>> x$1) {
        this.docs = x$1;
    }

    private DenseMatrix<Object> lambda() {
        return this.lambda;
    }

    private void lambda_$eq(DenseMatrix<Object> x$1) {
        this.lambda = x$1;
    }

    public DenseMatrix<Object> getLambda() {
        return this.lambda();
    }

    private int iteration() {
        return this.iteration;
    }

    private void iteration_$eq(int x$1) {
        this.iteration = x$1;
    }

    private double gammaShape() {
        return this.gammaShape;
    }

    private void gammaShape_$eq(double x$1) {
        this.gammaShape = x$1;
    }

    public double getTau0() {
        return this.tau0();
    }

    public OnlineLDAOptimizer setTau0(double tau0) {
        Predef$.MODULE$.require(tau0 > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("LDA tau0 must be positive, but was set to ").append(tau0).toString());
        this.tau0_$eq(tau0);
        return this;
    }

    public double getKappa() {
        return this.kappa();
    }

    public OnlineLDAOptimizer setKappa(double kappa) {
        Predef$.MODULE$.require(kappa >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Online LDA kappa must be nonnegative, but was set to ").append(kappa).toString());
        this.kappa_$eq(kappa);
        return this;
    }

    public double getMiniBatchFraction() {
        return this.miniBatchFraction();
    }

    public OnlineLDAOptimizer setMiniBatchFraction(double miniBatchFraction) {
        Predef$.MODULE$.require(miniBatchFraction > 0.0 && miniBatchFraction <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Online LDA miniBatchFraction must be in range (0,1], but was set to ").append(miniBatchFraction).toString());
        this.miniBatchFraction_$eq(miniBatchFraction);
        return this;
    }

    public boolean getOptimizeDocConcentration() {
        return this.optimizeDocConcentration();
    }

    public OnlineLDAOptimizer setOptimizeDocConcentration(boolean optimizeDocConcentration) {
        this.optimizeDocConcentration_$eq(optimizeDocConcentration);
        return this;
    }

    public OnlineLDAOptimizer setLambda(DenseMatrix<Object> lambda) {
        this.lambda_$eq(lambda);
        return this;
    }

    public OnlineLDAOptimizer setGammaShape(double shape) {
        this.gammaShape_$eq(shape);
        return this;
    }

    public OnlineLDAOptimizer setSampleWithReplacement(boolean replace) {
        this.sampleWithReplacement_$eq(replace);
        return this;
    }

    @Override
    public OnlineLDAOptimizer initialize(RDD<Tuple2<Object, Vector>> docs, LDA lda) {
        Vector vector;
        this.k_$eq(lda.getK());
        this.corpusSize_$eq(docs.count());
        this.vocabSize_$eq(((Vector)((Tuple2)docs.first())._2()).size());
        if (lda.getAsymmetricDocConcentration().size() == 1) {
            if (lda.getAsymmetricDocConcentration().apply(0) == (double)-1) {
                vector = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.k(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0 / (double)this.k(), ClassTag$.MODULE$.Double()));
            } else {
                Predef$.MODULE$.require(lda.getAsymmetricDocConcentration().apply(0) >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("all entries in alpha must be >=0, got: ").append(this.alpha()).toString());
                vector = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.k(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> lda.getAsymmetricDocConcentration().apply(0), ClassTag$.MODULE$.Double()));
            }
        } else {
            Predef$.MODULE$.require(lda.getAsymmetricDocConcentration().size() == this.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("alpha must have length k, got: ").append(this.alpha()).toString());
            lda.getAsymmetricDocConcentration().foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$1, x1$1);
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                double x = sp2._2$mcD$sp();
                Predef$.MODULE$.require(x >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("all entries in alpha must be >= 0, got: ").append(this.alpha()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
            vector = lda.getAsymmetricDocConcentration();
        }
        this.alpha_$eq(vector);
        this.eta_$eq(lda.getTopicConcentration() == (double)-1 ? 1.0 / (double)this.k() : lda.getTopicConcentration());
        this.randomGenerator_$eq(new Random(lda.getSeed()));
        this.docs_$eq(docs);
        this.lambda_$eq(this.getGammaMatrix(this.k(), this.vocabSize()));
        this.iteration_$eq(0);
        return this;
    }

    @Override
    public OnlineLDAOptimizer next() {
        RDD batch = this.docs().sample(this.sampleWithReplacement(), this.miniBatchFraction(), this.randomGenerator().nextLong());
        if (batch.isEmpty()) {
            return this;
        }
        return this.submitMiniBatch((RDD<Tuple2<Object, Vector>>)batch);
    }

    public OnlineLDAOptimizer submitMiniBatch(RDD<Tuple2<Object, Vector>> batch) {
        DenseMatrix denseMatrix;
        long nonEmptyDocsN;
        Option logphatOption;
        Broadcast expElogbetaBc;
        DenseMatrix expElogbeta;
        block5: {
            Tuple3 tuple3;
            block4: {
                this.iteration_$eq(this.iteration() + 1);
                int k = this.k();
                int vocabSize = this.vocabSize();
                expElogbeta = (DenseMatrix)((ImmutableNumericOps)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation(this.lambda()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))).t(DenseMatrix$.MODULE$.canTranspose());
                expElogbetaBc = batch.sparkContext().broadcast((Object)expElogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
                breeze.linalg.Vector<Object> alpha = this.alpha().asBreeze();
                double gammaShape = this.gammaShape();
                boolean optimizeDocConcentration = this.optimizeDocConcentration();
                long seed = this.randomGenerator().nextLong();
                Function0 & Serializable & scala.Serializable logphatPartOptionBase = (Function0 & Serializable & scala.Serializable)() -> optimizeDocConcentration ? new Some((Object)DenseVector$.MODULE$.zeros$mDc$sp(k, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$)) : None$.MODULE$;
                RDD stats = batch.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(index, docs) -> OnlineLDAOptimizer.$anonfun$submitMiniBatch$2(k, vocabSize, logphatPartOptionBase, expElogbetaBc, alpha, gammaShape, seed, BoxesRunTime.unboxToInt((Object)index), docs), batch.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple3.class));
                Function2 & Serializable & scala.Serializable elementWiseSum = (Function2 & Serializable & scala.Serializable)(u, v) -> {
                    ((NumericOps)u._1()).$plus$eq(v._1(), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpAdd());
                    ((Option)u._2()).foreach((Function1 & Serializable & scala.Serializable)x$10 -> (DenseVector)x$10.$plus$eq(((Option)v._2()).get(), DenseVector$.MODULE$.canAddIntoD()));
                    return new Tuple3(u._1(), u._2(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)u._3()) + BoxesRunTime.unboxToLong((Object)v._3()))));
                };
                Tuple3 x$1 = new Tuple3((Object)DenseMatrix$.MODULE$.zeros$mDc$sp(k, vocabSize, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), logphatPartOptionBase.apply(), (Object)BoxesRunTime.boxToLong((long)0L));
                Function2 & Serializable & scala.Serializable x$2 = elementWiseSum;
                Function2 & Serializable & scala.Serializable x$3 = elementWiseSum;
                int x$4 = stats.treeAggregate$default$4((Object)x$1);
                tuple3 = (Tuple3)stats.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(Tuple3.class));
                if (tuple3 == null) break block4;
                DenseMatrix statsSum = (DenseMatrix)tuple3._1();
                logphatOption = (Option)tuple3._2();
                nonEmptyDocsN = BoxesRunTime.unboxToLong((Object)tuple3._3());
                if (statsSum == null) break block4;
                denseMatrix = statsSum;
                if (logphatOption != null) break block5;
            }
            throw new MatchError((Object)tuple3);
        }
        Option option = logphatOption;
        long l = nonEmptyDocsN;
        Tuple3 tuple3 = new Tuple3((Object)denseMatrix, (Object)option, (Object)BoxesRunTime.boxToLong((long)l));
        Tuple3 tuple32 = tuple3;
        DenseMatrix statsSum = (DenseMatrix)tuple32._1();
        Option logphatOption2 = (Option)tuple32._2();
        long nonEmptyDocsN2 = BoxesRunTime.unboxToLong((Object)tuple32._3());
        expElogbetaBc.destroy(false);
        if (nonEmptyDocsN2 == 0L) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No non-empty documents were submitted in the batch.");
            return this;
        }
        DenseMatrix batchResult = (DenseMatrix)statsSum.$times$colon$times(expElogbeta.t(DenseMatrix$.MODULE$.canTranspose()), DenseMatrix$.MODULE$.op_DM_DM_Double_OpMulScalar());
        int batchSize = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(this.miniBatchFraction() * (double)this.corpusSize()));
        this.updateLambda((DenseMatrix<Object>)batchResult, batchSize);
        logphatOption2.foreach((Function1 & Serializable & scala.Serializable)x$12 -> (DenseVector)x$12.$div$eq((Object)BoxesRunTime.boxToDouble((double)nonEmptyDocsN2), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpDiv()));
        logphatOption2.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            this.updateAlpha((DenseVector<Object>)x$13, nonEmptyDocsN2);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    private void updateLambda(DenseMatrix<Object> stat, int batchSize) {
        double weight = this.rho();
        this.lambda().$colon$eq(((NumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)(1.0 - weight)))).$times(this.lambda(), DenseMatrix$.MODULE$.s_dm_op_Double_OpMulMatrix())).$plus(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)weight))).$times(((NumericOps)stat.$times((Object)BoxesRunTime.boxToDouble((double)((double)this.corpusSize() / (double)batchSize)), DenseMatrix$.MODULE$.op_DM_S_Double_OpMulMatrix())).$plus((Object)BoxesRunTime.boxToDouble((double)this.eta()), DenseMatrix$.MODULE$.op_DM_S_Double_OpAdd()), DenseMatrix$.MODULE$.s_dm_op_Double_OpMulMatrix()), DenseMatrix$.MODULE$.op_DM_DM_Double_OpAdd()), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet());
    }

    private void updateAlpha(DenseVector<Object> logphat, double nonEmptyDocsN) {
        block0: {
            double weight = this.rho();
            DenseVector alpha = this.alpha().asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
            DenseVector gradf = (DenseVector)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)nonEmptyDocsN))).$times(((NumericOps)LDAUtils$.MODULE$.dirichletExpectation((DenseVector<Object>)alpha).unary_$minus(DenseVector$.MODULE$.negFromScale(DenseVector$.MODULE$.dv_s_Op_Double_OpMulScalar(), Ring$.MODULE$.ringD()))).$plus(logphat, DenseVector$.MODULE$.canAddD()), DenseVector$.MODULE$.s_dv_Op_Double_OpMulMatrix());
            double c = nonEmptyDocsN * package.trigamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)alpha, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))), (UFunc.UImpl)package.trigamma$.trigammaImplDouble$.MODULE$);
            DenseVector q = (DenseVector)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)(-nonEmptyDocsN)))).$times(package.trigamma$.MODULE$.apply((Object)alpha, package.trigamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.trigamma$.trigammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))), DenseVector$.MODULE$.s_dv_Op_Double_OpMulMatrix());
            double b = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(gradf.$div((Object)q, DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) / (1.0 / c + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)1.0))).$div((Object)q, DenseVector$.MODULE$.s_dv_Op_Double_OpDiv()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))));
            DenseVector dalpha = (DenseVector)((ImmutableNumericOps)((ImmutableNumericOps)gradf.$minus((Object)BoxesRunTime.boxToDouble((double)b), DenseVector$.MODULE$.dv_s_Op_Double_OpSub())).unary_$minus(DenseVector$.MODULE$.negFromScale(DenseVector$.MODULE$.dv_s_Op_Double_OpMulScalar(), Ring$.MODULE$.ringD()))).$div((Object)q, DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv());
            if (!BoxesRunTime.unboxToBoolean((Object)all$.MODULE$.apply(((NumericOps)((NumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)weight))).$times((Object)dalpha, DenseVector$.MODULE$.s_dv_Op_Double_OpMulMatrix())).$plus((Object)alpha, DenseVector$.MODULE$.canAddD())).$greater$colon$greater((Object)BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_CompOp_Double_OpGT()), (UFunc.UImpl)BitVector$.MODULE$.allImpl()))) break block0;
            alpha.$colon$plus$eq(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)weight))).$times((Object)dalpha, DenseVector$.MODULE$.s_dv_Op_Double_OpMulMatrix()), DenseVector$.MODULE$.canAddIntoD());
            this.alpha_$eq(Vectors$.MODULE$.dense(alpha.toArray$mcD$sp(ClassTag$.MODULE$.Double())));
        }
    }

    private double rho() {
        return scala.math.package$.MODULE$.pow(this.getTau0() + (double)this.iteration(), -this.getKappa());
    }

    private DenseMatrix<Object> getGammaMatrix(int row, int col) {
        RandBasis randBasis = new RandBasis((RandomGenerator)new MersenneTwister(this.randomGenerator().nextLong()));
        Gamma gammaRandomGenerator = new Gamma(this.gammaShape(), 1.0 / this.gammaShape(), randBasis);
        double[] temp = (double[])gammaRandomGenerator.sample(row * col).toArray(ClassTag$.MODULE$.Double());
        return (DenseMatrix)new DenseMatrix.mcD.sp(col, row, temp).t(DenseMatrix$.MODULE$.canTranspose());
    }

    @Override
    public LDAModel getLDAModel(double[] iterationTimes) {
        return new LocalLDAModel(Matrices$.MODULE$.fromBreeze((Matrix<Object>)this.lambda()).transpose(), this.alpha(), this.eta(), LocalLDAModel$.MODULE$.$lessinit$greater$default$4()).setSeed(this.randomGenerator().nextLong());
    }

    public static final /* synthetic */ boolean $anonfun$submitMiniBatch$3(Tuple2 x$7) {
        return ((Vector)x$7._2()).numNonzeros() > 0;
    }

    public static final /* synthetic */ void $anonfun$submitMiniBatch$4(LongRef nonEmptyDocCount$1, Broadcast expElogbetaBc$1, breeze.linalg.Vector alpha$2, double gammaShape$1, int k$2, long seed$1, int index$1, DenseMatrix stat$1, Option logphatPartOption$1, Tuple2 x0$1) {
        Tuple3 tuple3;
        Vector termCounts;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (termCounts = (Vector)tuple2._2()) != null) {
            Vector vector = termCounts;
            ++nonEmptyDocCount$1.elem;
            Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple32 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)expElogbetaBc$1.value()), (breeze.linalg.Vector<Object>)alpha$2, gammaShape$1, k$2, seed$1 + (long)index$1);
            if (tuple32 == null) {
                throw new MatchError(tuple32);
            }
            DenseVector gammad = (DenseVector)tuple32._1();
            DenseMatrix sstats = (DenseMatrix)tuple32._2();
            List ids = (List)tuple32._3();
            tuple3 = new Tuple3((Object)gammad, (Object)sstats, (Object)ids);
        } else {
            throw new MatchError((Object)tuple2);
        }
        Tuple3 tuple33 = tuple3;
        DenseVector gammad = (DenseVector)tuple33._1();
        DenseMatrix sstats = (DenseMatrix)tuple33._2();
        List ids = (List)tuple33._3();
        ((NumericOps)stat$1.apply((Object)scala.package$.MODULE$.$colon$colon(), (Object)ids, DenseMatrix$.MODULE$.canSliceWeirdCols(Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.Double()))).$colon$eq(((NumericOps)stat$1.apply((Object)scala.package$.MODULE$.$colon$colon(), (Object)ids, DenseMatrix$.MODULE$.canSliceWeirdCols(Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.Double()))).$plus((Object)sstats, Matrix$.MODULE$.castOps(Predef$.MODULE$.$conforms(), package$.MODULE$.neq(), Predef$.MODULE$.$conforms(), package$.MODULE$.neq(), (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpAdd())), Matrix$.MODULE$.castUpdateOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.InPlaceImpl2)Matrix$.MODULE$.m_m_UpdateOp_Double_OpSet()));
        logphatPartOption$1.foreach((Function1 & Serializable & scala.Serializable)x$9 -> (DenseVector)x$9.$plus$eq(LDAUtils$.MODULE$.dirichletExpectation((DenseVector<Object>)gammad), DenseVector$.MODULE$.canAddIntoD()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Iterator $anonfun$submitMiniBatch$2(int k$2, int vocabSize$1, Function0 logphatPartOptionBase$1, Broadcast expElogbetaBc$1, breeze.linalg.Vector alpha$2, double gammaShape$1, long seed$1, int index, Iterator docs) {
        Iterator nonEmptyDocs = docs.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)OnlineLDAOptimizer.$anonfun$submitMiniBatch$3(x$7)));
        DenseMatrix stat = DenseMatrix$.MODULE$.zeros$mDc$sp(k$2, vocabSize$1, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Option logphatPartOption = (Option)logphatPartOptionBase$1.apply();
        LongRef nonEmptyDocCount = LongRef.create((long)0L);
        nonEmptyDocs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            OnlineLDAOptimizer.$anonfun$submitMiniBatch$4(nonEmptyDocCount, expElogbetaBc$1, alpha$2, gammaShape$1, k$2, seed$1, index, stat, logphatPartOption, x0$1);
            return BoxedUnit.UNIT;
        });
        return scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)stat, (Object)logphatPartOption, (Object)BoxesRunTime.boxToLong((long)nonEmptyDocCount.elem))}));
    }

    public OnlineLDAOptimizer() {
        Logging.$init$((Logging)this);
        this.k = 0;
        this.corpusSize = 0L;
        this.vocabSize = 0;
        this.alpha = Vectors$.MODULE$.dense(0.0, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0]));
        this.eta = 0.0;
        this.randomGenerator = null;
        this.sampleWithReplacement = true;
        this.tau0 = 1024.0;
        this.kappa = 0.51;
        this.miniBatchFraction = 0.05;
        this.optimizeDocConcentration = false;
        this.docs = null;
        this.lambda = null;
        this.iteration = 0;
        this.gammaShape = 100.0;
    }
}

