/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.VectorTransformer;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\n\u0014\u0001yA\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tu\u0001\u0011\t\u0011)A\u0005W!AA\b\u0001BC\u0002\u0013\u0005!\u0006\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003,\u0011!\u0011\u0005A!a\u0001\n\u0003\u0019\u0005\u0002\u0003%\u0001\u0005\u0003\u0007I\u0011A%\t\u0011A\u0003!\u0011!Q!\n\u0011C\u0001B\u0015\u0001\u0003\u0002\u0004%\ta\u0011\u0005\t)\u0002\u0011\t\u0019!C\u0001+\"A\u0001\f\u0001B\u0001B\u0003&A\tC\u0003[\u0001\u0011\u00051\fC\u0003[\u0001\u0011\u0005a\rC\u0003[\u0001\u0011\u0005!\u000eC\u0003n\u0001\u0011\u0005a\u000eC\u0003w\u0001\u0011\u0005q\u000f\u0003\u0005|\u0001!\u0015\r\u0011\"\u0003}\u0011\u001d\t9\u0001\u0001C!\u0003\u0013\u00111c\u0015;b]\u0012\f'\u000fZ*dC2,'/T8eK2T!\u0001F\u000b\u0002\u000f\u0019,\u0017\r^;sK*\u0011acF\u0001\u0006[2d\u0017N\u0019\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011c\u0001\u0001 KA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"AJ\u0014\u000e\u0003MI!\u0001K\n\u0003#Y+7\r^8s)J\fgn\u001d4pe6,'/A\u0002ti\u0012,\u0012a\u000b\t\u0003Y=j\u0011!\f\u0006\u0003]U\ta\u0001\\5oC2<\u0017B\u0001\u0019.\u0005\u00191Vm\u0019;pe\"\u001a\u0011A\r\u001d\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U:\u0012AC1o]>$\u0018\r^5p]&\u0011q\u0007\u000e\u0002\u0006'&t7-Z\u0011\u0002s\u0005)\u0011GL\u001a/a\u0005!1\u000f\u001e3!Q\r\u0011!\u0007O\u0001\u0005[\u0016\fg\u000eK\u0002\u0004ey\n\u0013aP\u0001\u0006c9\nd\u0006M\u0001\u0006[\u0016\fg\u000e\t\u0015\u0004\tIr\u0014aB<ji\"\u001cF\u000fZ\u000b\u0002\tB\u0011\u0001%R\u0005\u0003\r\u0006\u0012qAQ8pY\u0016\fg\u000eK\u0002\u0006ea\n1b^5uQN#Hm\u0018\u0013fcR\u0011!*\u0014\t\u0003A-K!\u0001T\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b\u001d\u001a\t\t\u00111\u0001E\u0003\rAH%\r\u0015\u0004\rIB\u0014\u0001C<ji\"\u001cF\u000f\u001a\u0011)\u0007\u001d\u0011\u0004(\u0001\u0005xSRDW*Z1oQ\rA!\u0007O\u0001\ro&$\b.T3b]~#S-\u001d\u000b\u0003\u0015ZCqAT\u0005\u0002\u0002\u0003\u0007A\tK\u0002\nea\n\u0011b^5uQ6+\u0017M\u001c\u0011)\u0007)\u0011\u0004(\u0001\u0004=S:LGO\u0010\u000b\u00069v{\u0016m\u0019\t\u0003M\u0001AQ!K\u0006A\u0002-B3!\u0018\u001a9\u0011\u0015a4\u00021\u0001,Q\ry&G\u0010\u0005\u0006\u0005.\u0001\r\u0001\u0012\u0015\u0004CJB\u0004\"\u0002*\f\u0001\u0004!\u0005fA23q!\u001a1B\r\u001d\u0015\u0007q;\u0007\u000eC\u0003*\u0019\u0001\u00071\u0006C\u0003=\u0019\u0001\u00071\u0006K\u0002\rea\"\"\u0001X6\t\u000b%j\u0001\u0019A\u0016)\u00075\u0011\u0004(A\u0006tKR<\u0016\u000e\u001e5NK\u0006tGCA8q\u001b\u0005\u0001\u0001\"\u0002*\u000f\u0001\u0004!\u0005F\u0001\bs!\t\u00194/\u0003\u0002ui\taA)\u001a<fY>\u0004XM]!qS\"\u001aaB\r\u001d\u0002\u0015M,GoV5uQN#H\r\u0006\u0002pq\")!i\u0004a\u0001\t\"\u0012qB\u001d\u0015\u0004\u001fIB\u0014!B:iS\u001a$X#A?\u0011\t\u0001r\u0018\u0011A\u0005\u0003\u007f\u0006\u0012Q!\u0011:sCf\u00042\u0001IA\u0002\u0013\r\t)!\t\u0002\u0007\t>,(\r\\3\u0002\u0013Q\u0014\u0018M\\:g_JlGcA\u0016\u0002\f!1\u0011QB\tA\u0002-\naA^3di>\u0014\bfA\t3}!\u001a\u0001A\r ")
public class StandardScalerModel
implements VectorTransformer {
    private double[] shift;
    private final Vector std;
    private final Vector mean;
    private boolean withStd;
    private boolean withMean;
    private volatile boolean bitmap$0;

    @Override
    public RDD<Vector> transform(RDD<Vector> data) {
        return VectorTransformer.transform$((VectorTransformer)this, data);
    }

    @Override
    public JavaRDD<Vector> transform(JavaRDD<Vector> data) {
        return VectorTransformer.transform$((VectorTransformer)this, data);
    }

    public Vector std() {
        return this.std;
    }

    public Vector mean() {
        return this.mean;
    }

    public boolean withStd() {
        return this.withStd;
    }

    public void withStd_$eq(boolean x$1) {
        this.withStd = x$1;
    }

    public boolean withMean() {
        return this.withMean;
    }

    public void withMean_$eq(boolean x$1) {
        this.withMean = x$1;
    }

    @DeveloperApi
    public StandardScalerModel setWithMean(boolean withMean) {
        Predef$.MODULE$.require(!withMean || this.mean() != null, (Function0 & java.io.Serializable & Serializable)() -> "cannot set withMean to true while mean is null");
        this.withMean_$eq(withMean);
        return this;
    }

    @DeveloperApi
    public StandardScalerModel setWithStd(boolean withStd) {
        Predef$.MODULE$.require(!withStd || this.std() != null, (Function0 & java.io.Serializable & Serializable)() -> "cannot set withStd to true while std is null");
        this.withStd_$eq(withStd);
        return this;
    }

    private double[] shift$lzycompute() {
        StandardScalerModel standardScalerModel = this;
        synchronized (standardScalerModel) {
            if (!this.bitmap$0) {
                this.shift = this.mean().toArray();
                this.bitmap$0 = true;
            }
        }
        return this.shift;
    }

    private double[] shift() {
        return !this.bitmap$0 ? this.shift$lzycompute() : this.shift;
    }

    @Override
    public Vector transform(Vector vector) {
        Vector vector2;
        Predef$.MODULE$.require(this.mean().size() == vector.size());
        if (this.withMean()) {
            double[] dArray;
            double[] localShift = this.shift();
            Vector vector3 = vector;
            if (vector3 instanceof DenseVector) {
                DenseVector denseVector = (DenseVector)vector3;
                dArray = (double[])denseVector.values().clone();
            } else if (vector3 != null) {
                Vector vector4 = vector3;
                dArray = vector4.toArray();
            } else {
                throw new MatchError((Object)vector3);
            }
            double[] values = dArray;
            int size = values.length;
            if (this.withStd()) {
                for (int i = 0; i < size; ++i) {
                    values[i] = this.std().apply(i) != 0.0 ? (values[i] - localShift[i]) * (1.0 / this.std().apply(i)) : 0.0;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    int n = i;
                    values[n] = values[n] - localShift[i];
                }
            }
            vector2 = Vectors$.MODULE$.dense(values);
        } else if (this.withStd()) {
            SparseVector sparseVector;
            Option<Tuple3<Object, int[], double[]>> option;
            Vector vector5;
            DenseVector denseVector;
            Option<double[]> option2;
            Vector vector6 = vector;
            if (vector6 instanceof DenseVector && !(option2 = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector6)).isEmpty()) {
                double[] vs = (double[])option2.get();
                double[] values = (double[])vs.clone();
                int size = values.length;
                for (int i = 0; i < size; ++i) {
                    int n = i;
                    values[n] = values[n] * (this.std().apply(i) != 0.0 ? 1.0 / this.std().apply(i) : 0.0);
                }
                vector5 = Vectors$.MODULE$.dense(values);
            } else if (vector6 instanceof SparseVector && !(option = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector6)).isEmpty()) {
                int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._1());
                int[] indices = (int[])((Tuple3)option.get())._2();
                double[] vs = (double[])((Tuple3)option.get())._3();
                double[] values = (double[])vs.clone();
                int nnz = values.length;
                for (int i = 0; i < nnz; ++i) {
                    int n = i;
                    values[n] = values[n] * (this.std().apply(indices[i]) != 0.0 ? 1.0 / this.std().apply(indices[i]) : 0.0);
                }
                vector5 = Vectors$.MODULE$.sparse(size, indices, values);
            } else {
                throw new IllegalArgumentException(new StringBuilder(27).append("Do not support vector type ").append(vector6.getClass()).toString());
            }
            vector2 = vector5;
        } else {
            vector2 = vector;
        }
        return vector2;
    }

    public StandardScalerModel(Vector std, Vector mean, boolean withStd, boolean withMean) {
        this.std = std;
        this.mean = mean;
        this.withStd = withStd;
        this.withMean = withMean;
        VectorTransformer.$init$(this);
    }

    public StandardScalerModel(Vector std, Vector mean) {
        block0: {
            this(std, mean, std != null, mean != null);
            Predef$.MODULE$.require(this.withStd() || this.withMean(), (Function0 & java.io.Serializable & Serializable)() -> "at least one of std or mean vectors must be provided");
            if (!this.withStd() || !this.withMean()) break block0;
            Predef$.MODULE$.require(mean.size() == std.size(), (Function0 & java.io.Serializable & Serializable)() -> "mean and std vectors must have equal size if both are provided");
        }
    }

    public StandardScalerModel(Vector std) {
        this(std, null);
    }
}

