/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.distribution;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.linalg.eigSym;
import breeze.linalg.eigSym$;
import breeze.linalg.max$;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\n\u0015\u0001\u0005B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\ty\u0001\u0011\t\u0011)A\u0005[!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003A\u0011\u00151\u0005\u0001\"\u0001H\u0011\u001dy\u0005A1A\u0005\nACaa\u0017\u0001!\u0002\u0013\t\u0006B\u0002$\u0001\t\u0003AB\f\u0003\u0006c\u0001A\u0005\t1!Q\u0001\n\rDqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004i\u0001\u0001\u0006Ia\u0018\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019Y\u0007\u0001)A\u00051\")A\u000e\u0001C\u0001[\")\u0011\u000f\u0001C\u0001e\"1A\u000e\u0001C\u00011UDa!\u001d\u0001\u0005\u0002aI\b\"B>\u0001\t\u0013a(\u0001F'vYRLg/\u0019:jCR,w)Y;tg&\fgN\u0003\u0002\u0016-\u0005aA-[:ue&\u0014W\u000f^5p]*\u0011q\u0003G\u0001\u0005gR\fGO\u0003\u0002\u001a5\u0005)Q\u000e\u001c7jE*\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003G%J!A\u000b\u0013\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u00055,X#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005AB\u0012A\u00027j]\u0006dw-\u0003\u00023_\t1a+Z2u_JD3!\u0001\u001b;!\t)\u0004(D\u00017\u0015\t9$$\u0001\u0006b]:|G/\u0019;j_:L!!\u000f\u001c\u0003\u000bMKgnY3\"\u0003m\nQ!\r\u00184]A\n1!\\;!Q\r\u0011AGO\u0001\u0006g&<W.Y\u000b\u0002\u0001B\u0011a&Q\u0005\u0003\u0005>\u0012a!T1ue&D\bfA\u00025u\u000511/[4nC\u0002B3\u0001\u0002\u001b;\u0003\u0019a\u0014N\\5u}Q\u0019\u0001J\u0013'\u0011\u0005%\u0003Q\"\u0001\u000b\t\u000b-*\u0001\u0019A\u0017)\u0007)#$\bC\u0003?\u000b\u0001\u0007\u0001\tK\u0002MiiB3!\u0002\u001b;\u0003!\u0011'/Z3{K6+X#A)\u0011\u0007I3\u0006,D\u0001T\u0015\t\u0001DKC\u0001V\u0003\u0019\u0011'/Z3{K&\u0011qk\u0015\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0005\u0002$3&\u0011!\f\n\u0002\u0007\t>,(\r\\3\u0002\u0013\t\u0014X-\u001a>f\u001bV\u0004Cc\u0001%^=\")1\u0006\u0003a\u0001#\")a\b\u0003a\u0001?B\u0019!\u000b\u0019-\n\u0005\u0005\u001c&a\u0003#f]N,W*\u0019;sSb\f1\u0001\u001f\u00132!\u0011\u0019Cm\u0018-\n\u0005\u0015$#A\u0002+va2,''\u0001\u0007s_>$8+[4nC&sg/F\u0001`\u00035\u0011xn\u001c;TS\u001el\u0017-\u00138wA\u0005\tQ/F\u0001Y\u0003\t)\b%A\u0002qI\u001a$\"\u0001\u00178\t\u000b=t\u0001\u0019A\u0017\u0002\u0003aD3A\u0004\u001b;\u0003\u0019awn\u001a9eMR\u0011\u0001l\u001d\u0005\u0006_>\u0001\r!\f\u0015\u0004\u001fQRDC\u0001-w\u0011\u0015y\u0007\u00031\u0001x!\r\u0011\u0006\u0010W\u0005\u0003eM#\"\u0001\u0017>\t\u000b=\f\u0002\u0019A<\u00029\r\fGnY;mCR,7i\u001c<be&\fgnY3D_:\u001cH/\u00198ugV\t1\r\u000b\u0002\u0001}B\u0011Qg`\u0005\u0004\u0003\u00031$\u0001\u0004#fm\u0016dw\u000e]3s\u0003BL\u0007f\u0001\u00015u\u0001")
public class MultivariateGaussian
implements scala.Serializable {
    private final Vector mu;
    private final org.apache.spark.mllib.linalg.Matrix sigma;
    private final DenseVector<Object> breezeMu;
    private final /* synthetic */ Tuple2 x$1;
    private final DenseMatrix<Object> rootSigmaInv;
    private final double u;

    public Vector mu() {
        return this.mu;
    }

    public org.apache.spark.mllib.linalg.Matrix sigma() {
        return this.sigma;
    }

    private DenseVector<Object> breezeMu() {
        return this.breezeMu;
    }

    private DenseMatrix<Object> rootSigmaInv() {
        return this.rootSigmaInv;
    }

    private double u() {
        return this.u;
    }

    public double pdf(Vector x) {
        return this.pdf(x.asBreeze());
    }

    public double logpdf(Vector x) {
        return this.logpdf(x.asBreeze());
    }

    public double pdf(breeze.linalg.Vector<Object> x) {
        return package$.MODULE$.exp(this.logpdf(x));
    }

    public double logpdf(breeze.linalg.Vector<Object> x) {
        breeze.linalg.Vector delta = (breeze.linalg.Vector)x.$minus(this.breezeMu(), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub()));
        DenseVector v = (DenseVector)this.rootSigmaInv().$times((Object)delta, (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double());
        return this.u() + BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)v.t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))).$times((Object)v, Transpose$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)DenseVector.canDotD$.MODULE$))) * -0.5;
    }

    private Tuple2<DenseMatrix<Object>, Object> calculateCovarianceConstants() {
        Tuple2 tuple2;
        eigSym.EigSym eigSym2 = (eigSym.EigSym)eigSym$.MODULE$.apply((Object)this.sigma().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (UFunc.UImpl)eigSym.EigSym_DM_Impl$.MODULE$);
        if (eigSym2 == null) {
            throw new MatchError((Object)eigSym2);
        }
        DenseVector d = (DenseVector)eigSym2.eigenvalues();
        DenseMatrix u = (DenseMatrix)eigSym2.eigenvectors();
        Tuple2 tuple22 = new Tuple2((Object)d, (Object)u);
        Tuple2 tuple23 = tuple22;
        DenseVector d2 = (DenseVector)tuple23._1();
        DenseMatrix u2 = (DenseMatrix)tuple23._2();
        double tol = MLUtils$.MODULE$.EPSILON() * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)d2, max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) * (double)d2.length();
        try {
            double logPseudoDetSigma = BoxesRunTime.unboxToDouble((Object)d2.activeValuesIterator().filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$3 -> x$3 > tol).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log(x)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DenseMatrix pinvS = (DenseMatrix)diag$.MODULE$.apply((Object)new DenseVector.mcD.sp(((DenseVector)d2.map$mcD$sp((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)v -> v > tol ? package$.MODULE$.sqrt(1.0 / v) : 0.0, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double())), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
            tuple2 = new Tuple2(pinvS.$times(u2.t(DenseMatrix$.MODULE$.canTranspose()), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()), (Object)BoxesRunTime.boxToDouble((double)(-0.5 * ((double)this.mu().size() * package$.MODULE$.log(Math.PI * 2) + logPseudoDetSigma))));
        }
        catch (UnsupportedOperationException uex) {
            throw new IllegalArgumentException("Covariance matrix has no non-zero singular values");
        }
        return tuple2;
    }

    public MultivariateGaussian(Vector mu, org.apache.spark.mllib.linalg.Matrix sigma) {
        double u;
        DenseMatrix rootSigmaInv;
        block3: {
            Tuple2<DenseMatrix<Object>, Object> tuple2;
            block2: {
                this.mu = mu;
                this.sigma = sigma;
                Predef$.MODULE$.require(sigma.numCols() == sigma.numRows(), (Function0 & Serializable & scala.Serializable)() -> "Covariance matrix must be square");
                Predef$.MODULE$.require(mu.size() == sigma.numCols(), (Function0 & Serializable & scala.Serializable)() -> "Mean vector length must match covariance matrix size");
                this.breezeMu = mu.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
                tuple2 = this.calculateCovarianceConstants();
                if (tuple2 == null) break block2;
                rootSigmaInv = (DenseMatrix)tuple2._1();
                u = tuple2._2$mcD$sp();
                if (rootSigmaInv != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        DenseMatrix denseMatrix = rootSigmaInv;
        double d = u;
        Tuple2 tuple2 = new Tuple2((Object)denseMatrix, (Object)BoxesRunTime.boxToDouble((double)d));
        this.x$1 = tuple2;
        this.rootSigmaInv = (DenseMatrix)this.x$1._1();
        this.u = this.x$1._2$mcD$sp();
    }

    public MultivariateGaussian(DenseVector<Object> mu, DenseMatrix<Object> sigma) {
        this(Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mu), Matrices$.MODULE$.fromBreeze((Matrix<Object>)sigma));
    }
}

