/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset$;
import org.apache.spark.sql.execution.streaming.MetadataLogFileIndex;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\reh\u0001B1c\u0001=D!\"!\u0002\u0001\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011)\ty\u0001\u0001B\u0001B\u0003%\u0011\u0011\u0003\u0005\u000b\u0003W\u0001!\u0011!Q\u0001\n\u0005E\u0001BCA\u0017\u0001\t\u0015\r\u0011\"\u0011\u00020!Q\u0011Q\b\u0001\u0003\u0002\u0003\u0006I!!\r\t\u0015\u0005}\u0002A!A!\u0002\u0013\t\t\u0005\u0003\u0006\u0002T\u0001\u0011\t\u0011)A\u0005\u0003#A!\"!\u0016\u0001\u0005\u0003\u0005\u000b\u0011BA,\u0011\u001d\ti\u0006\u0001C\u0001\u0003?B\u0011\"!\u001d\u0001\u0005\u0004%I!a\u001d\t\u0011\u0005m\u0004\u0001)A\u0005\u0003kB\u0011\"! \u0001\u0005\u0004%I!a \t\u0011\u0005E\u0005\u0001)A\u0005\u0003\u0003C\u0011\"a%\u0001\u0005\u0004%I!!&\t\u0011\u0005\u0005\u0006\u0001)A\u0005\u0003/C\u0011\"!,\u0001\u0005\u0004%I!a,\t\u0011\u0005]\u0006\u0001)A\u0005\u0003cC\u0011\"!/\u0001\u0005\u0004%I!a/\t\u0011\u0005-\u0007\u0001)A\u0005\u0003{C\u0011\"!4\u0001\u0005\u0004%I!a4\t\u0011\u0005]\u0007\u0001)A\u0005\u0003#D\u0011\"!7\u0001\u0001\u0004%I!a7\t\u0013\u0005\r\b\u00011A\u0005\n\u0005\u0015\b\u0002CAy\u0001\u0001\u0006K!!8\t\u0013\u0005M\bA1A\u0005\n\u0005U\b\u0002\u0003B\u0002\u0001\u0001\u0006I!a>\t\u0013\t\u0015\u0001A1A\u0005\n\t\u001d\u0001\u0002\u0003B\u000b\u0001\u0001\u0006IA!\u0003\t\u0013\t]\u0001A1A\u0005\n\u0005m\u0007\u0002\u0003B\r\u0001\u0001\u0006I!!8\t\u0013\tm\u0001A1A\u0005\n\tu\u0001\u0002\u0003B\u0013\u0001\u0001\u0006IAa\b\t\u0013\t\u001d\u0002A1A\u0005\u0002\t%\u0002\u0002CB.\u0001\u0001\u0006IAa\u000b\t\u000f\ru\u0003\u0001\"\u0003\u0004`!91q\r\u0001\u0005\u0002\r%\u0004bBBD\u0001\u0011\u0005\u00111\u001c\u0005\b\u0007\u0013\u0003A\u0011IBF\u0011)\u0019I\f\u0001a\u0001\n\u0003171\u0018\u0005\u000b\u0007\u007f\u0003\u0001\u0019!C\u0001M\u000e\u0005\u0007\u0002CBc\u0001\u0001\u0006Ka!0\t\u000f\r=\u0007\u0001\"\u0003\u0004R\"911\u001c\u0001\u0005\n\rE\u0007bBBo\u0001\u0011%1q\u001c\u0005\b\u0007S\u0004A\u0011IBv\u0011\u001d\u00119\r\u0001C!\u0007[Dqaa<\u0001\t\u0003\u001a\t\u0010C\u0004\u0004v\u0002!\tea>\b\u000f\t=\"\r#\u0001\u00032\u00191\u0011M\u0019E\u0001\u0005gAq!!\u00183\t\u0003\u0011Y$\u0002\u0004\u0003>I\u0002\u0011Q\u001c\u0004\u0007\u0005\u007f\u0011\u0004I!\u0011\t\u0015\u0005=QG!f\u0001\n\u0003\u0011y\u0005\u0003\u0006\u0003RU\u0012\t\u0012)A\u0005\u0003#A!Ba\u00156\u0005+\u0007I\u0011\u0001B+\u0011)\u0011Y&\u000eB\tB\u0003%!q\u000b\u0005\u000b\u0005;*$Q3A\u0005\u0002\u0005m\u0007B\u0003B0k\tE\t\u0015!\u0003\u0002^\"9\u0011QL\u001b\u0005\u0002\t\u0005\u0004\"\u0003B6k\u0005\u0005I\u0011\u0001B7\u0011%\u0011)(NI\u0001\n\u0003\u00119\bC\u0005\u0003\u000eV\n\n\u0011\"\u0001\u0003\u0010\"I!1S\u001b\u0012\u0002\u0013\u0005!Q\u0013\u0005\n\u00053+\u0014\u0011!C!\u00057C\u0011B!)6\u0003\u0003%\tAa)\t\u0013\t\u0015V'!A\u0005\u0002\t\u001d\u0006\"\u0003BYk\u0005\u0005I\u0011\tBZ\u0011%\u0011i,NA\u0001\n\u0003\u0011y\fC\u0005\u0003DV\n\t\u0011\"\u0011\u0003F\"I!qY\u001b\u0002\u0002\u0013\u0005#\u0011\u001a\u0005\n\u0005\u0017,\u0014\u0011!C!\u0005\u001b<\u0011B!53\u0003\u0003E\tAa5\u0007\u0013\t}\"'!A\t\u0002\tU\u0007bBA/\u0015\u0012\u0005!1\u001d\u0005\n\u0005\u000fT\u0015\u0011!C#\u0005\u0013D\u0011B!:K\u0003\u0003%\tIa:\t\u0013\t=(*!A\u0005\u0002\nE\b\"\u0003B\u0000\u0015\u0006\u0005I\u0011BB\u0001\r\u0019\u0019\u0019A\r\u0001\u0004\u0006!Q1q\u0001)\u0003\u0002\u0003\u0006I!!8\t\u001d\r%\u0001\u000b\"A\u0001\u0006\u000b\u0005\t\u0015!\u0003\u0003 !9\u0011Q\f)\u0005\u0002\r-\u0001\"CB\n!\n\u0007I\u0011BB\u000b\u0011!\u0019\u0019\u0003\u0015Q\u0001\n\r]\u0001\"CB\u0013!\u0002\u0007I\u0011\u0002B+\u0011%\u00199\u0003\u0015a\u0001\n\u0013\u0019I\u0003\u0003\u0005\u0004.A\u0003\u000b\u0015\u0002B,\u0011%\u0019y\u0003\u0015a\u0001\n\u0013\u0011)\u0006C\u0005\u00042A\u0003\r\u0011\"\u0003\u00044!A1q\u0007)!B\u0013\u00119\u0006C\u0004\u0004:A#Iaa\u000f\t\u000f\r\u001d\u0003\u000b\"\u0001\u0004J!91q\n)\u0005\u0002\rE\u0003bBB,!\u0012\u0005!Q\u0019\u0005\b\u00073\u0002F\u0011\u0001BR\u0005A1\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cWM\u0003\u0002dI\u0006I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003K\u001a\f\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dD\u0017aA:rY*\u0011\u0011N[\u0001\u0006gB\f'o\u001b\u0006\u0003W2\fa!\u00199bG\",'\"A7\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001\b\u0010 \t\u0003cZl\u0011A\u001d\u0006\u0003gR\fA\u0001\\1oO*\tQ/\u0001\u0003kCZ\f\u0017BA<s\u0005\u0019y%M[3diB\u0011\u0011P_\u0007\u0002E&\u00111P\u0019\u0002\u0007'>,(oY3\u0011\u0007u\f\t!D\u0001\u007f\u0015\ty\b.\u0001\u0005j]R,'O\\1m\u0013\r\t\u0019A \u0002\b\u0019><w-\u001b8h\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\tI!a\u0003\u000e\u0003\u0019L1!!\u0004g\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\u0005M\u0011Q\u0005\b\u0005\u0003+\t\t\u0003\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYB\\\u0001\u0007yI|w\u000e\u001e \u000b\u0005\u0005}\u0011!B:dC2\f\u0017\u0002BA\u0012\u0003;\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0014\u0003S\u0011aa\u0015;sS:<'\u0002BA\u0012\u0003;\t1CZ5mK\u001a{'/\\1u\u00072\f7o\u001d(b[\u0016\faa]2iK6\fWCAA\u0019!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001cM\u0006)A/\u001f9fg&!\u00111HA\u001b\u0005)\u0019FO];diRK\b/Z\u0001\bg\u000eDW-\\1!\u0003A\u0001\u0018M\u001d;ji&|gnQ8mk6t7\u000f\u0005\u0004\u0002D\u00055\u0013\u0011\u0003\b\u0005\u0003\u000b\nIE\u0004\u0003\u0002\u0018\u0005\u001d\u0013BAA\u0010\u0013\u0011\tY%!\b\u0002\u000fA\f7m[1hK&!\u0011qJA)\u0005\r\u0019V-\u001d\u0006\u0005\u0003\u0017\ni\"\u0001\u0007nKR\fG-\u0019;b!\u0006$\b.A\u0004paRLwN\\:\u0011\u0011\u0005M\u0011\u0011LA\t\u0003#IA!a\u0017\u0002*\t\u0019Q*\u00199\u0002\rqJg.\u001b;?)A\t\t'a\u0019\u0002f\u0005\u001d\u0014\u0011NA6\u0003[\ny\u0007\u0005\u0002z\u0001!9\u0011QA\u0005A\u0002\u0005\u001d\u0001bBA\b\u0013\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003WI\u0001\u0019AA\t\u0011\u001d\ti#\u0003a\u0001\u0003cAq!a\u0010\n\u0001\u0004\t\t\u0005C\u0004\u0002T%\u0001\r!!\u0005\t\u000f\u0005U\u0013\u00021\u0001\u0002X\u0005i1o\\;sG\u0016|\u0005\u000f^5p]N,\"!!\u001e\u0011\u0007e\f9(C\u0002\u0002z\t\u0014\u0011CR5mKN#(/Z1n\u001fB$\u0018n\u001c8t\u00039\u0019x.\u001e:dK>\u0003H/[8og\u0002\n!\u0002[1e_>\u00048i\u001c8g+\t\t\t\t\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\t\r|gN\u001a\u0006\u0004\u0003\u0017S\u0017A\u00025bI>|\u0007/\u0003\u0003\u0002\u0010\u0006\u0015%!D\"p]\u001aLw-\u001e:bi&|g.A\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\u0013A\u00014t+\t\t9\n\u0005\u0003\u0002\u001a\u0006uUBAAN\u0015\u0011\t\u0019*!#\n\t\u0005}\u00151\u0014\u0002\u000b\r&dWmU=ti\u0016l\u0017a\u00014tA!\u001aq\"!*\u0011\t\u0005\u001d\u0016\u0011V\u0007\u0003\u0003;IA!a+\u0002\u001e\tIAO]1og&,g\u000e^\u0001\u0012cV\fG.\u001b4jK\u0012\u0014\u0015m]3QCRDWCAAY!\u0011\tI*a-\n\t\u0005U\u00161\u0014\u0002\u0005!\u0006$\b.\u0001\nrk\u0006d\u0017NZ5fI\n\u000b7/\u001a)bi\"\u0004\u0013\u0001H8qi&|gn],ji\"\u0004\u0016M\u001d;ji&|gNQ1tKB\u000bG\u000f[\u000b\u0003\u0003{\u0003\u0002\"a0\u0002J\u0006E\u0011\u0011C\u0007\u0003\u0003\u0003TA!a1\u0002F\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0005\u0003\u000f\fi\"\u0001\u0006d_2dWm\u0019;j_:LA!a\u0017\u0002B\u0006ir\u000e\u001d;j_:\u001cx+\u001b;i!\u0006\u0014H/\u001b;j_:\u0014\u0015m]3QCRD\u0007%A\u0006nKR\fG-\u0019;b\u0019><WCAAi!\rI\u00181[\u0005\u0004\u0003+\u0014'a\u0005$jY\u0016\u001cFO]3b[N{WO]2f\u0019><\u0017\u0001D7fi\u0006$\u0017\r^1M_\u001e\u0004\u0013\u0001G7fi\u0006$\u0017\r^1M_\u001e\u001cUO\u001d:f]R|eMZ:fiV\u0011\u0011Q\u001c\t\u0005\u0003O\u000by.\u0003\u0003\u0002b\u0006u!\u0001\u0002'p]\u001e\fA$\\3uC\u0012\fG/\u0019'pO\u000e+(O]3oi>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u0002h\u00065\b\u0003BAT\u0003SLA!a;\u0002\u001e\t!QK\\5u\u0011%\tyoFA\u0001\u0002\u0004\ti.A\u0002yIE\n\u0011$\\3uC\u0012\fG/\u0019'pO\u000e+(O]3oi>3gm]3uA\u0005\u0001R.\u0019=GS2,7\u000fU3s\u0005\u0006$8\r[\u000b\u0003\u0003o\u0004b!a*\u0002z\u0006u\u0018\u0002BA~\u0003;\u0011aa\u00149uS>t\u0007\u0003BAT\u0003\u007fLAA!\u0001\u0002\u001e\t\u0019\u0011J\u001c;\u0002#5\f\u0007PR5mKN\u0004VM\u001d\"bi\u000eD\u0007%A\u0007gS2,7k\u001c:u\u001fJ$WM]\u000b\u0003\u0005\u0013\u0001bAa\u0003\u0003\u0012\u0005uWB\u0001B\u0007\u0015\u0011\u0011y!!\b\u0002\t5\fG\u000f[\u0005\u0005\u0005'\u0011iA\u0001\u0005Pe\u0012,'/\u001b8h\u000391\u0017\u000e\\3T_J$xJ\u001d3fe\u0002\nA\"\\1y\r&dW-Q4f\u001bN\fQ\"\\1y\r&dW-Q4f\u001bN\u0004\u0013\u0001\u00044jY\u0016t\u0015-\\3P]2LXC\u0001B\u0010!\u0011\t9K!\t\n\t\t\r\u0012Q\u0004\u0002\b\u0005>|G.Z1o\u000351\u0017\u000e\\3OC6,wJ\u001c7zA\u0005I1/Z3o\r&dWm]\u000b\u0003\u0005W\u00012A!\fQ\u001d\tI\u0018'\u0001\tGS2,7\u000b\u001e:fC6\u001cv.\u001e:dKB\u0011\u0011PM\n\u0004e\tU\u0002\u0003BAT\u0005oIAA!\u000f\u0002\u001e\t1\u0011I\\=SK\u001a$\"A!\r\u0003\u0013QKW.Z:uC6\u0004(!\u0003$jY\u0016,e\u000e\u001e:z'\u001d)$Q\u0007B\"\u0005\u0013\u0002B!a*\u0003F%!!qIA\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f!\u0011\t9Ka\u0013\n\t\t5\u0013Q\u0004\u0002\b!J|G-^2u+\t\t\t\"A\u0003qCRD\u0007%A\u0005uS6,7\u000f^1naV\u0011!q\u000b\t\u0004\u00053\"T\"\u0001\u001a\u0002\u0015QLW.Z:uC6\u0004\b%A\u0004cCR\u001c\u0007.\u00133\u0002\u0011\t\fGo\u00195JI\u0002\"\u0002Ba\u0019\u0003f\t\u001d$\u0011\u000e\t\u0004\u00053*\u0004bBA\by\u0001\u0007\u0011\u0011\u0003\u0005\b\u0005'b\u0004\u0019\u0001B,\u0011\u001d\u0011i\u0006\u0010a\u0001\u0003;\fAaY8qsRA!1\rB8\u0005c\u0012\u0019\bC\u0005\u0002\u0010u\u0002\n\u00111\u0001\u0002\u0012!I!1K\u001f\u0011\u0002\u0003\u0007!q\u000b\u0005\n\u0005;j\u0004\u0013!a\u0001\u0003;\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003z)\"\u0011\u0011\u0003B>W\t\u0011i\b\u0005\u0003\u0003\u0000\t%UB\u0001BA\u0015\u0011\u0011\u0019I!\"\u0002\u0013Ut7\r[3dW\u0016$'\u0002\u0002BD\u0003;\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YI!!\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tE%\u0006\u0002B,\u0005w\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0018*\"\u0011Q\u001cB>\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u0014\t\u0004c\n}\u0015bAA\u0014e\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q`\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011IKa,\u0011\t\u0005\u001d&1V\u0005\u0005\u0005[\u000biBA\u0002B]fD\u0011\"a<D\u0003\u0003\u0005\r!!@\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!.\u0011\r\t]&\u0011\u0018BU\u001b\t\t)-\u0003\u0003\u0003<\u0006\u0015'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\b\u0003B\"I\u0011q^#\u0002\u0002\u0003\u0007!\u0011V\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011Q`\u0001\ti>\u001cFO]5oOR\u0011!QT\u0001\u0007KF,\u0018\r\\:\u0015\t\t}!q\u001a\u0005\n\u0003_D\u0015\u0011!a\u0001\u0005S\u000b\u0011BR5mK\u0016sGO]=\u0011\u0007\te#jE\u0003K\u0005/\u0014\u0019\u0005\u0005\u0007\u0003Z\n}\u0017\u0011\u0003B,\u0003;\u0014\u0019'\u0004\u0002\u0003\\*!!Q\\A\u000f\u0003\u001d\u0011XO\u001c;j[\u0016LAA!9\u0003\\\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\tM\u0017!B1qa2LH\u0003\u0003B2\u0005S\u0014YO!<\t\u000f\u0005=Q\n1\u0001\u0002\u0012!9!1K'A\u0002\t]\u0003b\u0002B/\u001b\u0002\u0007\u0011Q\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Pa?\u0011\r\u0005\u001d\u0016\u0011 B{!)\t9Ka>\u0002\u0012\t]\u0013Q\\\u0005\u0005\u0005s\fiB\u0001\u0004UkBdWm\r\u0005\n\u0005{t\u0015\u0011!a\u0001\u0005G\n1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003A\u0014AbU3f]\u001aKG.Z:NCB\u001c2\u0001\u0015B\u001b\u0003!i\u0017\r_!hK6\u001b\u0018\u0001V8sO\u0012\n\u0007/Y2iK\u0012\u001a\b/\u0019:lIM\fH\u000eJ3yK\u000e,H/[8oIM$(/Z1nS:<GER5mKN#(/Z1n'>,(oY3%'\u0016,gNR5mKNl\u0015\r\u001d\u0013%M&dWMT1nK>sG.\u001f\u000b\u0007\u0007\u001b\u0019ya!\u0005\u0011\u0007\te\u0003\u000bC\u0004\u0004\bM\u0003\r!!8\t\u000f\tm1\u000b1\u0001\u0003 \u0005\u0019Q.\u00199\u0016\u0005\r]\u0001\u0003CB\r\u0007?\t\tBa\u0016\u000e\u0005\rm!bAB\u000fi\u0006!Q\u000f^5m\u0013\u0011\u0019\tca\u0007\u0003\u000f!\u000b7\u000f['ba\u0006!Q.\u00199!\u0003=a\u0017\r^3tiRKW.Z:uC6\u0004\u0018a\u00057bi\u0016\u001cH\u000fV5nKN$\u0018-\u001c9`I\u0015\fH\u0003BAt\u0007WA\u0011\"a<X\u0003\u0003\u0005\rAa\u0016\u0002!1\fG/Z:u)&lWm\u001d;b[B\u0004\u0013A\u00057bgR\u0004VO]4f)&lWm\u001d;b[B\fa\u0003\\1tiB+(oZ3US6,7\u000f^1na~#S-\u001d\u000b\u0005\u0003O\u001c)\u0004C\u0005\u0002pj\u000b\t\u00111\u0001\u0003X\u0005\u0019B.Y:u!V\u0014x-\u001a+j[\u0016\u001cH/Y7qA\u0005!2\u000f\u001e:jaB\u000bG\u000f[%g\u001d\u0016\u001cWm]:bef$BA!(\u0004>!9\u0011q\u0002/A\u0002\u0005E\u0001f\u0001/\u0004BA!\u0011qUB\"\u0013\u0011\u0019)%!\b\u0003\r%tG.\u001b8f\u0003\r\tG\r\u001a\u000b\u0007\u0003O\u001cYe!\u0014\t\u000f\u0005=Q\f1\u0001\u0002\u0012!9!1K/A\u0002\t]\u0013!C5t\u001d\u0016<h)\u001b7f)\u0019\u0011yba\u0015\u0004V!9\u0011q\u00020A\u0002\u0005E\u0001b\u0002B*=\u0002\u0007!qK\u0001\u0006aV\u0014x-Z\u0001\u0005g&TX-\u0001\u0006tK\u0016tg)\u001b7fg\u0002\naBZ3uG\"l\u0015\r_(gMN,G\u000f\u0006\u0002\u0004bA\u0019\u0011pa\u0019\n\u0007\r\u0015$M\u0001\fGS2,7\u000b\u001e:fC6\u001cv.\u001e:dK>3gm]3u\u0003I9\u0018\u000e\u001e5CCR\u001c\u0007.\u001b8h\u0019>\u001c7.\u001a3\u0016\t\r-4\u0011\u000f\u000b\u0005\u0007[\u001ai\b\u0005\u0003\u0004p\rED\u0002\u0001\u0003\b\u0007g\"#\u0019AB;\u0005\u0005!\u0016\u0003BB<\u0005S\u0003B!a*\u0004z%!11PA\u000f\u0005\u001dqu\u000e\u001e5j]\u001eD\u0001ba %\t\u0003\u00071\u0011Q\u0001\u0005MVt7\r\u0005\u0004\u0002(\u000e\r5QN\u0005\u0005\u0007\u000b\u000biB\u0001\u0005=Eft\u0017-\\3?\u0003A\u0019WO\u001d:f]RdunZ(gMN,G/\u0001\u0005hKR\u0014\u0015\r^2i)\u0019\u0019ii!+\u00046B!1qRBR\u001d\u0011\u0019\tj!)\u000f\t\rM5q\u0014\b\u0005\u0007+\u001biJ\u0004\u0003\u0004\u0018\u000eme\u0002BA\f\u00073K\u0011!\\\u0005\u0003W2L!!\u001b6\n\u0005\u001dD\u0017bAA&M&!1QUBT\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002L\u0019Dqaa+'\u0001\u0004\u0019i+A\u0003ti\u0006\u0014H\u000f\u0005\u0004\u0002(\u0006e8q\u0016\t\u0004s\u000eE\u0016bABZE\n1qJ\u001a4tKRDqaa.'\u0001\u0004\u0019y+A\u0002f]\u0012\f\u0011c]8ve\u000e,\u0007*Y:NKR\fG-\u0019;b+\t\u0019i\f\u0005\u0004\u0002(\u0006e(qD\u0001\u0016g>,(oY3ICNlU\r^1eCR\fw\fJ3r)\u0011\t9oa1\t\u0013\u0005=\b&!AA\u0002\ru\u0016AE:pkJ\u001cW\rS1t\u001b\u0016$\u0018\rZ1uC\u0002B3!KBe!\u0011\t9ka3\n\t\r5\u0017Q\u0004\u0002\tm>d\u0017\r^5mK\u0006q\u0012\r\u001c7GS2,7/V:j]\u001eLe.T3n_JLh)\u001b7f\u0013:$W\r\u001f\u000b\u0003\u0007'\u0004b!a\u0011\u0002N\rU\u0007\u0003BAM\u0007/LAa!7\u0002\u001c\nQa)\u001b7f'R\fG/^:\u0002C\u0005dGNR5mKN,6/\u001b8h\u001b\u0016$\u0018\rZ1uC2{wMR5mK&sG-\u001a=\u0002\u001b\u0019,Go\u00195BY24\u0015\u000e\\3t)\t\u0019\t\u000f\u0005\u0004\u0002D\u0005531\u001d\t\t\u0003O\u001b)/!\u0005\u0002^&!1q]A\u000f\u0005\u0019!V\u000f\u001d7fe\u0005Iq-\u001a;PM\u001a\u001cX\r^\u000b\u0003\u0007[#\"!!\u0005\u0002\r\r|W.\\5u)\u0011\t9oa=\t\u000f\r]v\u00061\u0001\u00040\u0006!1\u000f^8q)\t\t9\u000f")
public class FileStreamSource
implements Source,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final String fileFormatClassName;
    private final StructType schema;
    private final Seq<String> partitionColumns;
    private final Map<String, String> options;
    private final FileStreamOptions sourceOptions;
    private final Configuration hadoopConf;
    private final transient FileSystem fs;
    private final Path qualifiedBasePath;
    private final Map<String, String> optionsWithPartitionBasePath;
    private final FileStreamSourceLog metadataLog;
    private long metadataLogCurrentOffset;
    private final Option<Object> maxFilesPerBatch;
    private final Ordering<Object> fileSortOrder;
    private final long maxFileAgeMs;
    private final boolean fileNameOnly;
    private final SeenFilesMap seenFiles;
    private volatile Option<Object> sourceHasMetadata;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    private FileStreamOptions sourceOptions() {
        return this.sourceOptions;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private Path qualifiedBasePath() {
        return this.qualifiedBasePath;
    }

    private Map<String, String> optionsWithPartitionBasePath() {
        return this.optionsWithPartitionBasePath;
    }

    private FileStreamSourceLog metadataLog() {
        return this.metadataLog;
    }

    private long metadataLogCurrentOffset() {
        return this.metadataLogCurrentOffset;
    }

    private void metadataLogCurrentOffset_$eq(long x$1) {
        this.metadataLogCurrentOffset = x$1;
    }

    private Option<Object> maxFilesPerBatch() {
        return this.maxFilesPerBatch;
    }

    private Ordering<Object> fileSortOrder() {
        return this.fileSortOrder;
    }

    private long maxFileAgeMs() {
        return this.maxFileAgeMs;
    }

    private boolean fileNameOnly() {
        return this.fileNameOnly;
    }

    public SeenFilesMap seenFiles() {
        return this.seenFiles;
    }

    private synchronized FileStreamSourceOffset fetchMaxOffset() {
        Seq newFiles = (Seq)this.fetchAllFiles().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSource.$anonfun$fetchMaxOffset$1(this, x0$1)));
        Seq batchFiles = this.maxFilesPerBatch().nonEmpty() ? (Seq)newFiles.take(BoxesRunTime.unboxToInt((Object)this.maxFilesPerBatch().get())) : newFiles;
        batchFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            FileStreamSource.$anonfun$fetchMaxOffset$2(this, file);
            return BoxedUnit.UNIT;
        });
        int numPurged = this.seenFiles().purge();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("\n         |Number of new files = ").append(newFiles.size()).append("\n         |Number of files selected for batch = ").append(batchFiles.size()).append("\n         |Number of seen files = ").append(this.seenFiles().size()).append("\n         |Number of files purged from tracking map = ").append(numPurged).append("\n       ").toString())).stripMargin());
        if (batchFiles.nonEmpty()) {
            this.metadataLogCurrentOffset_$eq(this.metadataLogCurrentOffset() + 1L);
            this.metadataLog().add(this.metadataLogCurrentOffset(), (FileEntry[])((TraversableOnce)batchFiles.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String p = (String)tuple2._1();
                long timestamp = tuple2._2$mcJ$sp();
                FileEntry fileEntry = new FileEntry(p, timestamp, this.metadataLogCurrentOffset());
                return fileEntry;
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileEntry.class)));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Log offset set to ").append(this.metadataLogCurrentOffset()).append(" with ").append(batchFiles.size()).append(" new files").toString());
        }
        return new FileStreamSourceOffset(this.metadataLogCurrentOffset());
    }

    public synchronized <T> T withBatchingLocked(Function0<T> func) {
        return (T)func.apply();
    }

    public synchronized long currentLogOffset() {
        return this.metadataLogCurrentOffset();
    }

    @Override
    public Dataset<Row> getBatch(Option<Offset> start, Offset end) {
        long endOffset;
        long startOffset = BoxesRunTime.unboxToLong((Object)start.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)FileStreamSource.$anonfun$getBatch$1(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        Predef$.MODULE$.assert(startOffset <= (endOffset = FileStreamSourceOffset$.MODULE$.apply(end).logOffset()));
        FileEntry[] files = (FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().get((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(startOffset + 1L))), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)endOffset))))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileEntry.class)));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Processing ").append(files.length).append(" files from ").append(startOffset + 1L).append(":").append(endOffset).toString());
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Files are:\n\t").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).mkString("\n\t")).toString());
        SparkSession x$1 = this.sparkSession;
        Seq x$22 = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)f -> new Path(new URI(f.path())).toString(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Some x$32 = new Some((Object)this.schema());
        Seq<String> x$4 = this.partitionColumns;
        String x$5 = this.fileFormatClassName;
        Map<String, String> x$6 = this.optionsWithPartitionBasePath();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource newDataSource = new DataSource(x$1, x$5, (Seq<String>)x$22, (Option<StructType>)x$32, x$4, x$7, x$6, x$8);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)LogicalRelation$.MODULE$.apply(newDataSource.resolveRelation(false), true));
    }

    public Option<Object> sourceHasMetadata() {
        return this.sourceHasMetadata;
    }

    public void sourceHasMetadata_$eq(Option<Object> x$1) {
        this.sourceHasMetadata = x$1;
    }

    private Seq<FileStatus> allFilesUsingInMemoryFileIndex() {
        Seq globbedPaths = SparkHadoopUtil$.MODULE$.get().globPathIfNecessary(this.fs(), this.qualifiedBasePath());
        InMemoryFileIndex fileIndex = new InMemoryFileIndex(this.sparkSession, (Seq<Path>)globbedPaths, this.options, (Option<StructType>)new Some((Object)new StructType()), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5());
        return fileIndex.allFiles();
    }

    private Seq<FileStatus> allFilesUsingMetadataLogFileIndex() {
        return new MetadataLogFileIndex(this.sparkSession, this.qualifiedBasePath(), (Option<StructType>)None$.MODULE$).allFiles();
    }

    /*
     * Unable to fully structure code
     */
    private Seq<Tuple2<String, Object>> fetchAllFiles() {
        block13: {
            block12: {
                startTime = System.nanoTime();
                allFiles = null;
                var5_3 = false;
                var6_4 = null;
                var7_5 = this.sourceHasMetadata();
                if (!None$.MODULE$.equals(var7_5)) break block12;
                if (FileStreamSink$.MODULE$.hasMetadata((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.path}))), this.hadoopConf())) {
                    this.sourceHasMetadata_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                    allFiles = this.allFilesUsingMetadataLogFileIndex();
                    v0 = BoxedUnit.UNIT;
                } else {
                    allFiles = this.allFilesUsingInMemoryFileIndex();
                    if (allFiles.isEmpty()) {
                        v0 = BoxedUnit.UNIT;
                    } else if (FileStreamSink$.MODULE$.hasMetadata((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.path}))), this.hadoopConf())) {
                        this.sourceHasMetadata_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                        allFiles = this.allFilesUsingMetadataLogFileIndex();
                        v0 = BoxedUnit.UNIT;
                    } else {
                        this.sourceHasMetadata_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                        v0 = BoxedUnit.UNIT;
                    }
                }
                var1_6 = v0;
                break block13;
            }
            if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
            var5_3 = true;
            var6_4 = (Some)var7_5;
            var8_9 = BoxesRunTime.unboxToBoolean((Object)var6_4.value());
            if (var8_9) {
                allFiles = this.allFilesUsingMetadataLogFileIndex();
                var1_7 = BoxedUnit.UNIT;
            } else if (var5_3 && !(var9_10 = BoxesRunTime.unboxToBoolean((Object)var6_4.value()))) {
                allFiles = this.allFilesUsingInMemoryFileIndex();
                var1_8 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(var7_5);
            }
        }
        files = (Seq)((TraversableLike)allFiles.sortBy((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fetchAllFiles$1$adapted(org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Ljava/lang/Object;)(), this.fileSortOrder())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fetchAllFiles$2(org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Lscala/Tuple2;)(), Seq$.MODULE$.canBuildFrom());
        endTime = System.nanoTime();
        listingTimeMs = ((double)endTime - (double)startTime) / (double)1000000;
        if (listingTimeMs > (double)2000) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fetchAllFiles$3(scala.collection.Seq double ), ()Ljava/lang/String;)((Seq)files, (double)listingTimeMs));
        } else {
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fetchAllFiles$4(scala.collection.Seq double ), ()Ljava/lang/String;)((Seq)files, (double)listingTimeMs));
        }
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fetchAllFiles$5(scala.collection.Seq ), ()Ljava/lang/String;)((Seq)files));
        return files;
    }

    @Override
    public Option<Offset> getOffset() {
        return new Some((Object)this.fetchMaxOffset()).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSource.$anonfun$getOffset$1(x$5)));
    }

    public String toString() {
        return new StringBuilder(18).append("FileStreamSource[").append(this.qualifiedBasePath()).append("]").toString();
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    public static final /* synthetic */ void $anonfun$new$2(FileStreamSource $this, FileEntry entry) {
        $this.seenFiles().add(entry.path(), entry.timestamp());
    }

    public static final /* synthetic */ boolean $anonfun$fetchMaxOffset$1(FileStreamSource $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String path = (String)tuple2._1();
        long timestamp = tuple2._2$mcJ$sp();
        boolean bl = $this.seenFiles().isNewFile(path, timestamp);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$fetchMaxOffset$2(FileStreamSource $this, Tuple2 file) {
        $this.seenFiles().add((String)file._1(), file._2$mcJ$sp());
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("New file: ").append(file).toString());
    }

    public static final /* synthetic */ long $anonfun$getBatch$1(Offset x$2) {
        return FileStreamSourceOffset$.MODULE$.apply(x$2).logOffset();
    }

    public static final /* synthetic */ Tuple2 $anonfun$fetchAllFiles$2(FileStatus status) {
        return new Tuple2((Object)status.getPath().toUri().toString(), (Object)BoxesRunTime.boxToLong((long)status.getModificationTime()));
    }

    public static final /* synthetic */ String $anonfun$fetchAllFiles$3(Seq files$2, double listingTimeMs$1) {
        return new StringBuilder(22).append("Listed ").append(files$2.size()).append(" file(s) in ").append(listingTimeMs$1).append(" ms").toString();
    }

    public static final /* synthetic */ String $anonfun$fetchAllFiles$4(Seq files$2, double listingTimeMs$1) {
        return new StringBuilder(22).append("Listed ").append(files$2.size()).append(" file(s) in ").append(listingTimeMs$1).append(" ms").toString();
    }

    public static final /* synthetic */ String $anonfun$fetchAllFiles$5(Seq files$2) {
        return new StringBuilder(12).append("Files are:\n\t").append(files$2.mkString("\n\t")).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getOffset$1(FileStreamSourceOffset x$5) {
        return x$5.logOffset() == -1L;
    }

    public FileStreamSource(SparkSession sparkSession, String path, String fileFormatClassName, StructType schema, Seq<String> partitionColumns, String metadataPath, Map<String, String> options) {
        Ordering ordering;
        this.sparkSession = sparkSession;
        this.path = path;
        this.fileFormatClassName = fileFormatClassName;
        this.schema = schema;
        this.partitionColumns = partitionColumns;
        this.options = options;
        Source.$init$(this);
        Logging.$init$((Logging)this);
        this.sourceOptions = new FileStreamOptions(options);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.fs = new Path(path).getFileSystem(this.hadoopConf());
        this.qualifiedBasePath = this.fs().makeQualified(new Path(path));
        this.optionsWithPartitionBasePath = this.sourceOptions().optionMapWithoutPath().$plus$plus((GenTraversableOnce)(!SparkHadoopUtil$.MODULE$.get().isGlobPath(new Path(path)) && options.contains((Object)"path") ? Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"basePath"), (Object)path)})) : Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), sparkSession, metadataPath);
        this.metadataLogCurrentOffset = BoxesRunTime.unboxToLong((Object)this.metadataLog().getLatest().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        this.maxFilesPerBatch = this.sourceOptions().maxFilesPerTrigger();
        if (this.sourceOptions().latestFirst()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("'latestFirst' is true. New files will be processed first, which may affect the watermark\n          |value. In addition, 'maxFileAge' will be ignored.")).stripMargin());
            ordering = ((Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$)).reverse();
        } else {
            ordering = (Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$);
        }
        this.fileSortOrder = ordering;
        this.maxFileAgeMs = this.sourceOptions().latestFirst() && this.maxFilesPerBatch().isDefined() ? Long.MAX_VALUE : this.sourceOptions().maxFileAgeMs();
        this.fileNameOnly = this.sourceOptions().fileNameOnly();
        if (this.fileNameOnly()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "'fileNameOnly' is enabled. Make sure your file names are unique (e.g. using UUID), otherwise, files with the same name but under different paths will be considered the same and causes data lost.");
        }
        this.seenFiles = new SeenFilesMap(this.maxFileAgeMs(), this.fileNameOnly());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().allFiles())).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            FileStreamSource.$anonfun$new$2(this, entry);
            return BoxedUnit.UNIT;
        });
        this.seenFiles().purge();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("maxFilesPerBatch = ").append(this.maxFilesPerBatch()).append(", maxFileAgeMs = ").append(this.maxFileAgeMs()).toString());
        this.sourceHasMetadata = SparkHadoopUtil$.MODULE$.get().isGlobPath(new Path(path)) ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)) : None$.MODULE$;
    }

    public static final /* synthetic */ Object $anonfun$fetchAllFiles$1$adapted(FileStatus x$4) {
        return BoxesRunTime.boxToLong((long)x$4.getModificationTime());
    }

    public static class FileEntry
    implements scala.Serializable,
    Product {
        private final String path;
        private final long timestamp;
        private final long batchId;

        public String path() {
            return this.path;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long batchId() {
            return this.batchId;
        }

        public FileEntry copy(String path, long timestamp, long batchId) {
            return new FileEntry(path, timestamp, batchId);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.batchId();
        }

        public String productPrefix() {
            return "FileEntry";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.path();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.batchId());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileEntry;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.batchId()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            FileEntry fileEntry = (FileEntry)x$1;
            String string = this.path();
            String string2 = fileEntry.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.timestamp() != fileEntry.timestamp()) return false;
            if (this.batchId() != fileEntry.batchId()) return false;
            if (!fileEntry.canEqual(this)) return false;
            return true;
        }

        public FileEntry(String path, long timestamp, long batchId) {
            this.path = path;
            this.timestamp = timestamp;
            this.batchId = batchId;
            Product.$init$((Product)this);
        }
    }

    public static class SeenFilesMap {
        private final long maxAgeMs;
        public final boolean org$apache$spark$sql$execution$streaming$FileStreamSource$SeenFilesMap$$fileNameOnly;
        private final HashMap<String, Object> map;
        private long latestTimestamp;
        private long lastPurgeTimestamp;

        private HashMap<String, Object> map() {
            return this.map;
        }

        private long latestTimestamp() {
            return this.latestTimestamp;
        }

        private void latestTimestamp_$eq(long x$1) {
            this.latestTimestamp = x$1;
        }

        private long lastPurgeTimestamp() {
            return this.lastPurgeTimestamp;
        }

        private void lastPurgeTimestamp_$eq(long x$1) {
            this.lastPurgeTimestamp = x$1;
        }

        private String stripPathIfNecessary(String path) {
            return this.org$apache$spark$sql$execution$streaming$FileStreamSource$SeenFilesMap$$fileNameOnly ? new Path(new URI(path)).getName() : path;
        }

        public void add(String path, long timestamp) {
            block0: {
                this.map().put(this.stripPathIfNecessary(path), BoxesRunTime.boxToLong((long)timestamp));
                if (timestamp <= this.latestTimestamp()) break block0;
                this.latestTimestamp_$eq(timestamp);
            }
        }

        public boolean isNewFile(String path, long timestamp) {
            return timestamp >= this.lastPurgeTimestamp() && !this.map().containsKey(this.stripPathIfNecessary(path));
        }

        /*
         * WARNING - void declaration
         */
        public int purge() {
            void var2_2;
            this.lastPurgeTimestamp_$eq(this.latestTimestamp() - this.maxAgeMs);
            java.util.Iterator<Map.Entry<String, Object>> iter = this.map().entrySet().iterator();
            int count = 0;
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                if (BoxesRunTime.unboxToLong((Object)entry.getValue()) >= this.lastPurgeTimestamp()) continue;
                ++count;
                iter.remove();
            }
            return (int)var2_2;
        }

        public int size() {
            return this.map().size();
        }

        public SeenFilesMap(long maxAgeMs, boolean fileNameOnly) {
            this.maxAgeMs = maxAgeMs;
            this.org$apache$spark$sql$execution$streaming$FileStreamSource$SeenFilesMap$$fileNameOnly = fileNameOnly;
            Predef$.MODULE$.require(maxAgeMs >= 0L);
            this.map = new HashMap();
            this.latestTimestamp = 0L;
            this.lastPurgeTimestamp = 0L;
        }
    }
}

