/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantCP;
import org.aspectj.apache.bcel.classfile.ConstantNameAndType;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.generic.InstructionCP;
import org.aspectj.apache.bcel.generic.ObjectType;

public abstract class FieldOrMethod
extends InstructionCP {
    protected String signature;
    protected String name;
    private String classname;

    protected FieldOrMethod(short s, int n) {
        super(s, n);
    }

    public String getSignature(ConstantPool constantPool) {
        if (this.signature == null) {
            Constant constant = constantPool.getConstant(this.index);
            ConstantCP constantCP = (ConstantCP)constant;
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantPool.getConstant(constantCP.getNameAndTypeIndex());
            this.signature = ((ConstantUtf8)constantPool.getConstant(constantNameAndType.getSignatureIndex())).getValue();
        }
        return this.signature;
    }

    public String getName(ConstantPool constantPool) {
        if (this.name == null) {
            ConstantCP constantCP = (ConstantCP)constantPool.getConstant(this.index);
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantPool.getConstant(constantCP.getNameAndTypeIndex());
            this.name = ((ConstantUtf8)constantPool.getConstant(constantNameAndType.getNameIndex())).getValue();
        }
        return this.name;
    }

    public String getClassName(ConstantPool constantPool) {
        if (this.classname == null) {
            ConstantCP constantCP = (ConstantCP)constantPool.getConstant(this.index);
            String string = constantPool.getConstantString(constantCP.getClassIndex(), (byte)7);
            this.classname = string.charAt(0) == '[' ? string : string.replace('/', '.');
        }
        return this.classname;
    }

    public ObjectType getClassType(ConstantPool constantPool) {
        return new ObjectType(this.getClassName(constantPool));
    }

    @Override
    public ObjectType getLoadClassType(ConstantPool constantPool) {
        return this.getClassType(constantPool);
    }
}

