// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.hdf5.global.hdf5.*;


/** \class H5Location
    \brief H5Location is an abstract base class, added in version 1.8.12.
    <p>
    It provides a collection of wrappers for the C functions that take a
    location identifier to specify the HDF5 object.  The location identifier
    can be either file, group, dataset, attribute, or named datatype.
    Wrappers for H5A functions stay in H5Object.
*/
// Inheritance: IdComponent
@Namespace("H5") @Properties(inherit = org.bytedeco.hdf5.presets.hdf5.class)
public class H5Location extends IdComponent {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5Location(Pointer p) { super(p); }

        // Checks if a link of a given name exists in a location
        public native @Cast("bool") boolean nameExists(@Cast("const char*") BytePointer name, @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native @Cast("bool") boolean nameExists(@Cast("const char*") BytePointer name);
        public native @Cast("bool") boolean nameExists(String name, @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native @Cast("bool") boolean nameExists(String name);

        // Checks if a link of a given name exists in a location
        // Deprecated in favor of nameExists for better name.
        public native @Cast("bool") boolean exists(@Cast("const char*") BytePointer name, @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native @Cast("bool") boolean exists(@Cast("const char*") BytePointer name);
        public native @Cast("bool") boolean exists(String name, @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native @Cast("bool") boolean exists(String name);

        // Flushes all buffers associated with this location to disk.
        public native void flush(@Cast("H5F_scope_t") int scope);

        // Gets the name of the file, specified by this location.
        public native @StdString BytePointer getFileName();

// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

        // Retrieves the type of object that an object reference points to.
        public native @Cast("H5O_type_t") int getRefObjType(Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/);
        public native @Cast("H5O_type_t") int getRefObjType(Pointer ref);
        // Note: getRefObjType deprecates getObjType, but getObjType's name is
        // misleading, so getRefObjType is used in the new function instead.

        // Sets the comment for an HDF5 object specified by its name.
        public native void setComment(@Cast("const char*") BytePointer name, @Cast("const char*") BytePointer comment);
        public native void setComment(String name, String comment);
        public native void setComment(@Cast("const char*") BytePointer comment);
        public native void setComment(String comment);

        // Retrieves comment for the HDF5 object specified by its name.
        public native @Cast("ssize_t") long getComment(@Cast("const char*") BytePointer name, @Cast("size_t") long buf_size, @Cast("char*") BytePointer comment);
        public native @Cast("ssize_t") long getComment(String name, @Cast("size_t") long buf_size, @Cast("char*") ByteBuffer comment);
        public native @Cast("ssize_t") long getComment(@Cast("const char*") BytePointer name, @Cast("size_t") long buf_size, @Cast("char*") byte[] comment);
        public native @Cast("ssize_t") long getComment(String name, @Cast("size_t") long buf_size, @Cast("char*") BytePointer comment);
        public native @Cast("ssize_t") long getComment(@Cast("const char*") BytePointer name, @Cast("size_t") long buf_size, @Cast("char*") ByteBuffer comment);
        public native @Cast("ssize_t") long getComment(String name, @Cast("size_t") long buf_size, @Cast("char*") byte[] comment);
        public native @StdString BytePointer getComment(@Cast("const char*") BytePointer name, @Cast("size_t") long buf_size/*=0*/);
        public native @StdString BytePointer getComment(@Cast("const char*") BytePointer name);
        public native @StdString String getComment(String name, @Cast("size_t") long buf_size/*=0*/);
        public native @StdString String getComment(String name);

        // Removes the comment for the HDF5 object specified by its name.
        public native void removeComment(@Cast("const char*") BytePointer name);
        public native void removeComment(String name);

        // Creates a reference to a named object or to a dataset region
        // in this object.
        public native void reference(Pointer ref, @Cast("const char*") BytePointer name, 
                                @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/);
        public native void reference(Pointer ref, @Cast("const char*") BytePointer name);
        public native void reference(Pointer ref, String name, 
                                @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/);
        public native void reference(Pointer ref, String name);
        public native void reference(Pointer ref, @Cast("const char*") BytePointer name, @Const @ByRef DataSpace dataspace,
                                @Cast("H5R_type_t") int ref_type/*=H5R_DATASET_REGION*/);
        public native void reference(Pointer ref, @Cast("const char*") BytePointer name, @Const @ByRef DataSpace dataspace);
        public native void reference(Pointer ref, String name, @Const @ByRef DataSpace dataspace,
                                @Cast("H5R_type_t") int ref_type/*=H5R_DATASET_REGION*/);
        public native void reference(Pointer ref, String name, @Const @ByRef DataSpace dataspace);

        // Open a referenced object whose location is specified by either
        // a file, an HDF5 object, or an attribute.
        public native void dereference(@Const @ByRef H5Location loc, @Const Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_OBJECT*/, @Const @ByRef(nullValue = "H5::PropList::DEFAULT") PropList plist);
        public native void dereference(@Const @ByRef H5Location loc, @Const Pointer ref);
        // Removed in 1.10.1, because H5Location is baseclass
        //void dereference(const Attribute& attr, const void* ref, H5R_type_t ref_type = H5R_OBJECT, const PropList& plist = PropList::DEFAULT);

        // Retrieves a dataspace with the region pointed to selected.
        public native @ByVal DataSpace getRegion(Pointer ref, @Cast("H5R_type_t") int ref_type/*=H5R_DATASET_REGION*/);
        public native @ByVal DataSpace getRegion(Pointer ref);

        // Create a new group with using link create property list.
        public native @ByVal Group createGroup(@Cast("const char*") BytePointer name, @Const @ByRef LinkCreatPropList lcpl);
        public native @ByVal Group createGroup(String name, @Const @ByRef LinkCreatPropList lcpl);

// From CommonFG
        // Creates a new group at this location which can be a file
        // or another group.
        public native @ByVal Group createGroup(@Cast("const char*") BytePointer name, @Cast("size_t") long size_hint/*=0*/);
        public native @ByVal Group createGroup(@Cast("const char*") BytePointer name);
        public native @ByVal Group createGroup(String name, @Cast("size_t") long size_hint/*=0*/);
        public native @ByVal Group createGroup(String name);

        // Opens an existing group in a location which can be a file
        // or another group.
        public native @ByVal Group openGroup(@Cast("const char*") BytePointer name);
        public native @ByVal Group openGroup(String name);

        // Creates a new dataset in this location.
        public native @ByVal DataSet createDataSet(@Cast("const char*") BytePointer name, @Const @ByRef DataType data_type, @Const @ByRef DataSpace data_space, @Const @ByRef(nullValue = "H5::DSetCreatPropList::DEFAULT") DSetCreatPropList create_plist, @Const @ByRef(nullValue = "H5::DSetAccPropList::DEFAULT") DSetAccPropList dapl, @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl);
        public native @ByVal DataSet createDataSet(@Cast("const char*") BytePointer name, @Const @ByRef DataType data_type, @Const @ByRef DataSpace data_space);
        public native @ByVal DataSet createDataSet(String name, @Const @ByRef DataType data_type, @Const @ByRef DataSpace data_space, @Const @ByRef(nullValue = "H5::DSetCreatPropList::DEFAULT") DSetCreatPropList create_plist, @Const @ByRef(nullValue = "H5::DSetAccPropList::DEFAULT") DSetAccPropList dapl, @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl);
        public native @ByVal DataSet createDataSet(String name, @Const @ByRef DataType data_type, @Const @ByRef DataSpace data_space);

        // Deprecated to add LinkCreatPropList and DSetAccPropList - 1.10.3
        // DataSet createDataSet(const char* name, const DataType& data_type, const DataSpace& data_space, const DSetCreatPropList& create_plist = DSetCreatPropList::DEFAULT) const;
        // DataSet createDataSet(const H5std_string& name, const DataType& data_type, const DataSpace& data_space, const DSetCreatPropList& create_plist = DSetCreatPropList::DEFAULT) const;

        // Opens an existing dataset at this location.
        // DSetAccPropList is added - 1.10.3
        public native @ByVal DataSet openDataSet(@Cast("const char*") BytePointer name, @Const @ByRef(nullValue = "H5::DSetAccPropList::DEFAULT") DSetAccPropList dapl);
        public native @ByVal DataSet openDataSet(@Cast("const char*") BytePointer name);
        public native @ByVal DataSet openDataSet(String name, @Const @ByRef(nullValue = "H5::DSetAccPropList::DEFAULT") DSetAccPropList dapl);
        public native @ByVal DataSet openDataSet(String name);

        public native @ByVal H5L_info_t getLinkInfo(@Cast("const char*") BytePointer link_name, @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native @ByVal H5L_info_t getLinkInfo(@Cast("const char*") BytePointer link_name);
        public native @ByVal H5L_info_t getLinkInfo(String link_name, @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native @ByVal H5L_info_t getLinkInfo(String link_name);

        // Returns the value of a symbolic link.
        public native @StdString BytePointer getLinkval(@Cast("const char*") BytePointer link_name, @Cast("size_t") long size/*=0*/);
        public native @StdString BytePointer getLinkval(@Cast("const char*") BytePointer link_name);
        public native @StdString String getLinkval(String link_name, @Cast("size_t") long size/*=0*/);
        public native @StdString String getLinkval(String link_name);

        // Returns the number of objects in this group.
        // Deprecated - moved to H5::Group in 1.10.2.
        public native @Cast("hsize_t") long getNumObjs();

        // Retrieves the name of an object in this group, given the
        // object's index.
        public native @StdString BytePointer getObjnameByIdx(@Cast("hsize_t") long idx);
        public native @Cast("ssize_t") long getObjnameByIdx(@Cast("hsize_t") long idx, @Cast("char*") BytePointer name, @Cast("size_t") long size);
        public native @Cast("ssize_t") long getObjnameByIdx(@Cast("hsize_t") long idx, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
        public native @Cast("ssize_t") long getObjnameByIdx(@Cast("hsize_t") long idx, @Cast("char*") byte[] name, @Cast("size_t") long size);

        // Retrieves the type of an object in this file or group, given the
        // object's name
        public native @Cast("H5O_type_t") int childObjType(@StdString BytePointer objname);
        public native @Cast("H5O_type_t") int childObjType(@StdString String objname);
        public native @Cast("H5O_type_t") int childObjType(@Cast("hsize_t") long index, @Cast("H5_index_t") int index_type/*=H5_INDEX_NAME*/, @Cast("H5_iter_order_t") int order/*=H5_ITER_INC*/, @Cast("const char*") BytePointer objname/*="."*/);
        public native @Cast("H5O_type_t") int childObjType(@Cast("hsize_t") long index);
        public native @Cast("H5O_type_t") int childObjType(@Cast("hsize_t") long index, @Cast("H5_index_t") int index_type/*=H5_INDEX_NAME*/, @Cast("H5_iter_order_t") int order/*=H5_ITER_INC*/, String objname/*="."*/);

        // Returns the object header version of an object in this file or group,
        // given the object's name.
        public native @Cast("unsigned") int childObjVersion(@Cast("const char*") BytePointer objname);
        public native @Cast("unsigned") int childObjVersion(String objname);

        // Retrieves information about an HDF5 object.
        public native void getObjinfo(@ByRef H5O_info_t objinfo, @Cast("unsigned") int fields/*=H5O_INFO_BASIC*/);
        public native void getObjinfo(@ByRef H5O_info_t objinfo);

        // Retrieves information about an HDF5 object, given its name.
        public native void getObjinfo(@Cast("const char*") BytePointer name, @ByRef H5O_info_t objinfo,
                        @Cast("unsigned") int fields/*=H5O_INFO_BASIC*/,
                        @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void getObjinfo(@Cast("const char*") BytePointer name, @ByRef H5O_info_t objinfo);
        public native void getObjinfo(String name, @ByRef H5O_info_t objinfo,
                        @Cast("unsigned") int fields/*=H5O_INFO_BASIC*/,
                        @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void getObjinfo(String name, @ByRef H5O_info_t objinfo);

        // Retrieves information about an HDF5 object, given its index.
        public native void getObjinfo(@Cast("const char*") BytePointer grp_name, @Cast("H5_index_t") int idx_type,
                        @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long idx, @ByRef H5O_info_t objinfo,
                        @Cast("unsigned") int fields/*=H5O_INFO_BASIC*/,
                        @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void getObjinfo(@Cast("const char*") BytePointer grp_name, @Cast("H5_index_t") int idx_type,
                        @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long idx, @ByRef H5O_info_t objinfo);
        public native void getObjinfo(String grp_name, @Cast("H5_index_t") int idx_type,
                        @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long idx, @ByRef H5O_info_t objinfo,
                        @Cast("unsigned") int fields/*=H5O_INFO_BASIC*/,
                        @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void getObjinfo(String grp_name, @Cast("H5_index_t") int idx_type,
                        @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long idx, @ByRef H5O_info_t objinfo);

// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

        // Creates a soft link from link_name to target_name.
        public native void link(@Cast("const char*") BytePointer target_name, @Cast("const char*") BytePointer link_name,
                     @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                     @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void link(@Cast("const char*") BytePointer target_name, @Cast("const char*") BytePointer link_name);
        public native void link(String target_name, String link_name,
                     @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                     @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void link(String target_name, String link_name);

        // Creates a hard link from new_name to curr_name.
        public native void link(@Cast("const char*") BytePointer curr_name,
                     @Const @ByRef Group new_loc, @Cast("const char*") BytePointer new_name,
                     @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                     @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void link(@Cast("const char*") BytePointer curr_name,
                     @Const @ByRef Group new_loc, @Cast("const char*") BytePointer new_name);
        public native void link(String curr_name,
                     @Const @ByRef Group new_loc, String new_name,
                     @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                     @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void link(String curr_name,
                     @Const @ByRef Group new_loc, String new_name);

        // Creates a hard link from new_name to curr_name in same location.
        public native void link(@Cast("const char*") BytePointer curr_name,
                     @Cast("const hid_t") long same_loc, @Cast("const char*") BytePointer new_name,
                     @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                     @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void link(@Cast("const char*") BytePointer curr_name,
                     @Cast("const hid_t") long same_loc, @Cast("const char*") BytePointer new_name);
        public native void link(String curr_name,
                     @Cast("const hid_t") long same_loc, String new_name,
                     @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                     @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void link(String curr_name,
                     @Cast("const hid_t") long same_loc, String new_name);

        // Creates a link of the specified type from new_name to current_name;
        // both names are interpreted relative to the specified location id.
        // Deprecated due to inadequate functionality.
        public native void link(@Cast("H5L_type_t") int link_type, @Cast("const char*") BytePointer curr_name, @Cast("const char*") BytePointer new_name);
        public native void link(@Cast("H5L_type_t") int link_type, String curr_name, String new_name);

        // Removes the specified link from this location.
        public native void unlink(@Cast("const char*") BytePointer link_name,
                    @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void unlink(@Cast("const char*") BytePointer link_name);
        public native void unlink(String link_name,
                    @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void unlink(String link_name);

        // Mounts the file 'child' onto this location.
        public native void mount(@Cast("const char*") BytePointer name, @Const @ByRef H5File child, @Const @ByRef PropList plist);
        public native void mount(String name, @Const @ByRef H5File child, @Const @ByRef PropList plist);

        // Unmounts the file named 'name' from this parent location.
        public native void unmount(@Cast("const char*") BytePointer name);
        public native void unmount(String name);

        // Copies a link from a group to another.
        public native void copyLink(@Cast("const char*") BytePointer src_name,
                     @Const @ByRef Group dst, @Cast("const char*") BytePointer dst_name,
                     @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                     @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void copyLink(@Cast("const char*") BytePointer src_name,
                     @Const @ByRef Group dst, @Cast("const char*") BytePointer dst_name);
        public native void copyLink(String src_name,
                     @Const @ByRef Group dst, String dst_name,
                     @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                     @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void copyLink(String src_name,
                     @Const @ByRef Group dst, String dst_name);

        // Makes a copy of a link in the same group.
        public native void copyLink(@Cast("const char*") BytePointer src_name, @Cast("const char*") BytePointer dst_name,
                     @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                     @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void copyLink(@Cast("const char*") BytePointer src_name, @Cast("const char*") BytePointer dst_name);
        public native void copyLink(String src_name, String dst_name,
                     @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                     @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void copyLink(String src_name, String dst_name);

        // Renames a link in this group and moves to a new location.
        public native void moveLink(@Cast("const char*") BytePointer src_name,
                    @Const @ByRef Group dst, @Cast("const char*") BytePointer dst_name,
                    @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                    @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void moveLink(@Cast("const char*") BytePointer src_name,
                    @Const @ByRef Group dst, @Cast("const char*") BytePointer dst_name);
        public native void moveLink(String src_name,
                    @Const @ByRef Group dst, String dst_name,
                    @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                    @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void moveLink(String src_name,
                    @Const @ByRef Group dst, String dst_name);

        // Renames a link in this group.
        public native void moveLink(@Cast("const char*") BytePointer src_name, @Cast("const char*") BytePointer dst_name,
                    @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                    @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void moveLink(@Cast("const char*") BytePointer src_name, @Cast("const char*") BytePointer dst_name);
        public native void moveLink(String src_name, String dst_name,
                    @Const @ByRef(nullValue = "H5::LinkCreatPropList::DEFAULT") LinkCreatPropList lcpl,
                    @Const @ByRef(nullValue = "H5::LinkAccPropList::DEFAULT") LinkAccPropList lapl);
        public native void moveLink(String src_name, String dst_name);

        // Renames an object at this location.
        // Deprecated due to inadequate functionality.
        public native void move(@Cast("const char*") BytePointer src, @Cast("const char*") BytePointer dst);
        public native void move(String src, String dst);

// end From CommonFG

        /** For subclasses, H5File and Group, to throw appropriate exception. */
        public native void throwException(@StdString BytePointer func_name, @StdString BytePointer msg);
        public native void throwException(@StdString String func_name, @StdString String msg);

        // Default constructor

}
