/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=VersionHelper.class)
public class VersionHelper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String EARLIEST_SUFFIX = "alpha-SNAPSHOT";
    private final VersionScheme versionScheme;

    public VersionHelper() {
        this((VersionScheme)new GenericVersionScheme());
    }

    @VisibleForTesting
    public VersionHelper(VersionScheme versionScheme) {
        this.versionScheme = (VersionScheme)Preconditions.checkNotNull((Object)versionScheme);
    }

    public VersionScheme getScheme() {
        return this.versionScheme;
    }

    public Version parseVersion(String version) {
        Preconditions.checkNotNull((Object)version);
        try {
            return this.versionScheme.parseVersion(version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public VersionRange parseRange(String pattern) {
        Preconditions.checkNotNull((Object)pattern);
        try {
            return this.versionScheme.parseVersionRange(pattern);
        }
        catch (InvalidVersionSpecificationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public VersionRange range(int ... parts) {
        int i;
        Preconditions.checkNotNull((Object)parts);
        Preconditions.checkArgument((parts.length != 0 ? 1 : 0) != 0);
        StringBuilder buff = new StringBuilder().append("[");
        for (i = 0; i < parts.length; ++i) {
            buff.append(parts[i]);
            if (i + 1 >= parts.length) continue;
            buff.append(".");
        }
        buff.append(",");
        for (i = 0; i < parts.length; ++i) {
            if (i + 1 == parts.length) {
                buff.append(parts[i] + 1);
                continue;
            }
            buff.append(parts[i]).append(".");
        }
        buff.append(")");
        this.log.trace("Range pattern: {}", (Object)buff);
        return this.parseRange(buff.toString());
    }

    public VersionRange before(int ... parts) {
        Preconditions.checkNotNull((Object)parts);
        Preconditions.checkArgument((parts.length != 0 ? 1 : 0) != 0);
        StringBuilder buff = new StringBuilder().append("(,");
        for (int i = 0; i < parts.length; ++i) {
            buff.append(parts[i]);
            if (i + 1 >= parts.length) continue;
            buff.append(".");
        }
        buff.append("-").append(EARLIEST_SUFFIX).append(")");
        this.log.trace("Range pattern: {}", (Object)buff);
        return this.parseRange(buff.toString());
    }
}

