/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.io.IOException;
import java.util.Date;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SerializerProvider {
    protected final SerializationConfig _config;

    protected SerializerProvider(SerializationConfig config) {
        this._config = config;
    }

    public abstract void serializeValue(SerializationConfig var1, JsonGenerator var2, Object var3, SerializerFactory var4) throws IOException, JsonGenerationException;

    public abstract boolean hasSerializerFor(SerializationConfig var1, Class<?> var2, SerializerFactory var3);

    public final SerializationConfig getConfig() {
        return this._config;
    }

    public final boolean isEnabled(SerializationConfig.Feature f) {
        return this._config.isEnabled(f);
    }

    public abstract JsonSerializer<Object> findValueSerializer(Class<?> var1) throws JsonMappingException;

    public abstract JsonSerializer<Object> getKeySerializer();

    public abstract JsonSerializer<Object> getNullKeySerializer();

    public abstract JsonSerializer<Object> getNullValueSerializer();

    public abstract JsonSerializer<Object> getUnknownTypeSerializer(Class<?> var1);

    public final void defaultSerializeValue(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        if (value == null) {
            this.getNullValueSerializer().serialize(null, jgen, this);
        } else {
            this.findValueSerializer(value.getClass()).serialize(value, jgen, this);
        }
    }

    public final void defaultSerializeField(String fieldName, Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        jgen.writeFieldName(fieldName);
        if (value == null) {
            this.getNullValueSerializer().serialize(null, jgen, this);
        } else {
            this.findValueSerializer(value.getClass()).serialize(value, jgen, this);
        }
    }

    public abstract void defaultSerializeDateValue(long var1, JsonGenerator var3) throws IOException, JsonProcessingException;

    public abstract void defaultSerializeDateValue(Date var1, JsonGenerator var2) throws IOException, JsonProcessingException;
}

