/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.NullNode;

public class TreeMapper
extends JsonNodeFactory {
    protected DupFields _cfgDupFields = DupFields.ERROR;
    protected final ObjectMapper _objectMapper;

    public TreeMapper() {
        this(new ObjectMapper());
    }

    public TreeMapper(ObjectMapper m) {
        this._objectMapper = m;
    }

    public JsonFactory getJsonFactory() {
        return this._objectMapper.getJsonFactory();
    }

    public JsonNode readTree(JsonParser jp) throws IOException, JsonParseException {
        JsonToken t = jp.getCurrentToken();
        if (t == null && (t = jp.nextToken()) == null) {
            return null;
        }
        return this._objectMapper.readTree(jp);
    }

    public JsonNode readTree(File src) throws IOException, JsonParseException {
        JsonNode n = this._objectMapper.readValue(src, JsonNode.class);
        return n == null ? NullNode.instance : n;
    }

    public JsonNode readTree(URL src) throws IOException, JsonParseException {
        JsonNode n = this._objectMapper.readValue(src, JsonNode.class);
        return n == null ? NullNode.instance : n;
    }

    public JsonNode readTree(InputStream src) throws IOException, JsonParseException {
        JsonNode n = this._objectMapper.readValue(src, JsonNode.class);
        return n == null ? NullNode.instance : n;
    }

    public JsonNode readTree(Reader src) throws IOException, JsonParseException {
        JsonNode n = this._objectMapper.readValue(src, JsonNode.class);
        return n == null ? NullNode.instance : n;
    }

    public JsonNode readTree(String jsonContent) throws IOException, JsonParseException {
        JsonNode n = this._objectMapper.readValue(jsonContent, JsonNode.class);
        return n == null ? NullNode.instance : n;
    }

    public JsonNode readTree(byte[] jsonContent) throws IOException, JsonParseException {
        JsonNode n = this._objectMapper.readValue(jsonContent, 0, jsonContent.length, JsonNode.class);
        return n == null ? NullNode.instance : n;
    }

    public void writeTree(JsonNode rootNode, File dst) throws IOException, JsonParseException {
        this._objectMapper.writeValue(dst, (Object)rootNode);
    }

    public void writeTree(JsonNode rootNode, Writer dst) throws IOException, JsonParseException {
        this._objectMapper.writeValue(dst, (Object)rootNode);
    }

    public void writeTree(JsonNode rootNode, OutputStream dst) throws IOException, JsonParseException {
        this._objectMapper.writeValue(dst, (Object)rootNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DupFields {
        ERROR,
        USE_FIRST,
        USE_LAST;

    }
}

