/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.Tool;
import org.javamoney.tck.TCKTestSetup;
import org.javamoney.tck.tests.AccessingCurrenciesAmountsRoundingsTest;
import org.javamoney.tck.tests.CreatingMonetaryAmountsTest;
import org.javamoney.tck.tests.ExternalizingNumericValueTest;
import org.javamoney.tck.tests.FunctionalExtensionPointsTest;
import org.javamoney.tck.tests.ModellingCurrenciesTest;
import org.javamoney.tck.tests.ModellingMonetaryAmountsTest;
import org.javamoney.tck.tests.conversion.ConvertingAmountsTest;
import org.javamoney.tck.tests.conversion.ExchangeRatesAndRateProvidersTest;
import org.javamoney.tck.tests.conversion.MonetaryConversionsTest;
import org.javamoney.tck.tests.conversion.ProviderChainsTest;
import org.javamoney.tck.tests.format.FormattingMonetaryAmountsTest;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;
import org.testng.annotations.Test;
import org.testng.reporters.VerboseReporter;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class TCKRunner
extends XmlSuite
implements Tool {
    public TCKRunner() {
        this.setName("JSR354-TCK, version 1.1");
        XmlTest test = new XmlTest((XmlSuite)this);
        test.setName("TCK/Test Setup");
        ArrayList<XmlClass> classes = new ArrayList<XmlClass>();
        classes.add(new XmlClass(TCKTestSetup.class));
        classes.add(new XmlClass(ModellingCurrenciesTest.class));
        classes.add(new XmlClass(ModellingMonetaryAmountsTest.class));
        classes.add(new XmlClass(CreatingMonetaryAmountsTest.class));
        classes.add(new XmlClass(ExternalizingNumericValueTest.class));
        classes.add(new XmlClass(FunctionalExtensionPointsTest.class));
        classes.add(new XmlClass(AccessingCurrenciesAmountsRoundingsTest.class));
        classes.add(new XmlClass(MonetaryConversionsTest.class));
        classes.add(new XmlClass(ExchangeRatesAndRateProvidersTest.class));
        classes.add(new XmlClass(ConvertingAmountsTest.class));
        classes.add(new XmlClass(ProviderChainsTest.class));
        classes.add(new XmlClass(FormattingMonetaryAmountsTest.class));
        test.setXmlClasses(classes);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... args) {
        System.out.println("-- JSR 354 TCK started --");
        ArrayList<TCKRunner> suites = new ArrayList<TCKRunner>();
        suites.add(new TCKRunner());
        TestNG tng = new TestNG();
        tng.setXmlSuites(suites);
        String outDir = System.getProperty("outputDir");
        if (outDir != null) {
            tng.setOutputDirectory(outDir);
        } else {
            tng.setOutputDirectory("./target/tck-output");
        }
        String verbose = System.getProperty("verbose");
        if ("true".equalsIgnoreCase(verbose)) {
            tng.addListener((ITestListener)new VerboseReporter());
        }
        String reportFile = System.getProperty("reportFile");
        File file = null;
        file = reportFile != null ? new File(reportFile) : new File("./target/tck-results.txt");
        TCKReporter rep = new TCKReporter(file);
        System.out.println("Writing to file " + file.getAbsolutePath() + " ...");
        tng.addListener((ITestListener)rep);
        tng.run();
        rep.writeSummary();
        System.out.println("-- JSR 354 TCK  finished --");
        return 0;
    }

    @Override
    public final Set<SourceVersion> getSourceVersions() {
        return Collections.unmodifiableSet(new HashSet<SourceVersion>(Arrays.asList(SourceVersion.RELEASE_5, SourceVersion.RELEASE_6, SourceVersion.RELEASE_7)));
    }

    public static void main(String ... args) {
        TCKRunner runner = new TCKRunner();
        runner.run(System.in, System.out, System.err, args);
    }

    public static final class TCKReporter
    extends TestListenerAdapter {
        private int count = 0;
        private int skipped = 0;
        private int failed = 0;
        private int success = 0;
        private StringWriter internalBuffer = new StringWriter(3000);
        private FileWriter w;

        public TCKReporter(File file) {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                this.w = new FileWriter(file);
                this.w.write("********************************************************************************************\n");
                this.w.write("**** JSR 354 - Money & Currency, Technical Compatibility Kit, version 1.1\n");
                this.w.write("********************************************************************************************\n\n");
                this.w.write("Executed on " + new Date() + "\n\n");
                this.internalBuffer.write("********************************************************************************\n");
                this.internalBuffer.write("**** JSR 354 - Money & Currency, Technical Compatibility Kit, version 1.1.\n");
                this.internalBuffer.write("********************************************************************************\n\n");
                this.internalBuffer.write("Executed on " + new Date() + "\n\n");
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }

        public void onTestFailure(ITestResult tr) {
            ++this.failed;
            ++this.count;
            String location = tr.getTestClass().getRealClass().getSimpleName() + '#' + tr.getMethod().getMethodName();
            try {
                Method realTestMethod = tr.getMethod().getConstructorOrMethod().getMethod();
                Test testAnnot = realTestMethod.getAnnotation(Test.class);
                if (!testAnnot.description().isEmpty()) {
                    if (tr.getThrowable() != null) {
                        StringWriter sw = new StringWriter();
                        PrintWriter w = new PrintWriter(sw);
                        tr.getThrowable().printStackTrace(w);
                        w.flush();
                        this.log("[FAILED]  " + testAnnot.description() + "(" + location + "):\n" + sw.toString());
                    } else {
                        this.log("[FAILED]  " + testAnnot.description() + "(" + location + ")");
                    }
                } else if (tr.getThrowable() != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter w = new PrintWriter(sw);
                    tr.getThrowable().printStackTrace(w);
                    w.flush();
                    this.log("[FAILED]  " + location + ":\n" + sw.toString());
                } else {
                    this.log("[FAILED]  " + location);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("IO Error", e);
            }
        }

        public void onTestSkipped(ITestResult tr) {
            ++this.skipped;
            ++this.count;
            String location = tr.getTestClass().getRealClass().getSimpleName() + '#' + tr.getMethod().getMethodName();
            try {
                Method realTestMethod = tr.getMethod().getMethod();
                Test specAssert = realTestMethod.getAnnotation(Test.class);
                if (specAssert != null && !specAssert.description().isEmpty()) {
                    this.log("[SKIPPED] " + specAssert.description() + "(" + location + ")");
                } else {
                    this.log("[SKIPPED] " + location);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("IO Error", e);
            }
        }

        public void onTestSuccess(ITestResult tr) {
            ++this.success;
            ++this.count;
            String location = tr.getTestClass().getRealClass().getSimpleName() + '#' + tr.getMethod().getMethodName();
            try {
                Method realTestMethod = tr.getMethod().getConstructorOrMethod().getMethod();
                Test specAssert = realTestMethod.getAnnotation(Test.class);
                if (specAssert != null && !specAssert.description().isEmpty()) {
                    this.log("[SUCCESS] " + specAssert.description() + "(" + location + ")");
                } else {
                    this.log("[SUCCESS] " + location);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("IO Error", e);
            }
        }

        private void log(String text) throws IOException {
            this.w.write(text);
            this.w.write(10);
            this.internalBuffer.write(text);
            this.internalBuffer.write(10);
        }

        public void writeSummary() {
            try {
                this.log("\nJSR 354 TCK, version 1.1 Summary");
                this.log("------------------------------------------");
                this.log("\nTOTAL TESTS EXECUTED : " + this.count);
                this.log("TOTAL TESTS SKIPPED  : " + this.skipped);
                this.log("TOTAL TESTS SUCCESS  : " + this.success);
                this.log("TOTAL TESTS FAILED   : " + this.failed);
                this.w.flush();
                this.w.close();
                this.internalBuffer.flush();
                System.out.println();
                System.out.println(this.internalBuffer);
            }
            catch (IOException e) {
                throw new IllegalStateException("IO Error", e);
            }
        }
    }
}

