/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Currency;
import java.util.Random;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryAmountFactoryQuery;
import javax.money.MonetaryAmountFactoryQueryBuilder;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import javax.money.NumberValue;
import org.hamcrest.Matcher;
import org.javamoney.tck.TCKValidationException;
import org.mutabilitydetector.unittesting.AllowedReason;
import org.mutabilitydetector.unittesting.MutabilityAssert;
import org.mutabilitydetector.unittesting.MutabilityMatchers;
import org.testng.AssertJUnit;

public final class TestUtils {
    private static final StringBuffer WARNINGS = new StringBuffer();

    private TestUtils() {
    }

    public static BigDecimal createNumberWithPrecision(int precision) {
        if (precision == 0) {
            precision = new Random().nextInt(100);
        }
        StringBuilder b = new StringBuilder(precision + 1);
        for (int i = 0; i < precision; ++i) {
            b.append(String.valueOf(i % 10));
        }
        return new BigDecimal(b.toString(), MathContext.UNLIMITED);
    }

    public static BigDecimal createNumberWithScale(int scale) {
        StringBuilder b = new StringBuilder(scale + 2);
        b.append("9.");
        for (int i = 0; i < scale; ++i) {
            b.append(String.valueOf(i % 10));
        }
        return new BigDecimal(b.toString(), MathContext.UNLIMITED);
    }

    public static void testSerializable(String section, Class c) {
        if (!Serializable.class.isAssignableFrom(c)) {
            throw new TCKValidationException(section + ": Class must be serializable: " + c.getName());
        }
    }

    public static void testImmutable(String section, Class c) {
        try {
            MutabilityAssert.assertInstancesOf((Class)c, (Matcher)MutabilityMatchers.areImmutable(), (Matcher)AllowedReason.provided((Class[])new Class[]{Currency.class, MonetaryAmount.class, CurrencyUnit.class, NumberValue.class, MonetaryOperator.class, MonetaryQuery.class}).areAlsoImmutable(), (Matcher)AllowedReason.allowingForSubclassing(), (Matcher)AllowedReason.allowingNonFinalFields());
        }
        catch (Exception e) {
            throw new TCKValidationException(section + ": Class is not immutable: " + c.getName(), e);
        }
    }

    public static void testSerializable(String section, Object o) {
        if (!(o instanceof Serializable)) {
            throw new TCKValidationException(section + ": Class must be serializable: " + o.getClass().getName());
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new ByteArrayOutputStream());){
            oos.writeObject(o);
        }
        catch (Exception e) {
            throw new TCKValidationException("Class must be serializable, but serialization failed: " + o.getClass().getName(), e);
        }
    }

    public static void testImplementsInterface(String section, Class type, Class iface) {
        for (Class<?> ifa : type.getInterfaces()) {
            if (!ifa.equals(iface)) continue;
            return;
        }
        AssertJUnit.fail((String)(section + ": Class must implement " + iface.getName() + ", but does not: " + type.getName()));
    }

    public static void testHasPublicMethod(String section, Class type, Class returnType, String name, Class ... paramTypes) {
        for (Class current = type; current != null; current = current.getSuperclass()) {
            for (Method m : current.getDeclaredMethods()) {
                if (!returnType.equals(returnType) || !m.getName().equals(name) || (m.getModifiers() & 1) == 0 || !Arrays.equals(m.getParameterTypes(), paramTypes)) continue;
                return;
            }
        }
        throw new TCKValidationException(section + ": Class must implement method " + name + '(' + Arrays.toString(paramTypes) + "): " + returnType.getName() + ", but does not: " + type.getName());
    }

    public static void testHasPublicStaticMethod(String section, Class type, Class returnType, String name, Class ... paramTypes) {
        for (Class current = type; current != null; current = current.getSuperclass()) {
            for (Method m : current.getDeclaredMethods()) {
                if (!returnType.equals(returnType) || !m.getName().equals(name) || (m.getModifiers() & 1) == 0 || (m.getModifiers() & 8) == 0 || !Arrays.equals(m.getParameterTypes(), paramTypes)) continue;
                return;
            }
        }
        throw new TCKValidationException(section + ": Class must implement method " + name + '(' + Arrays.toString(paramTypes) + "): " + returnType.getName() + ", but does not: " + type.getName());
    }

    public static void testHasNotPublicMethod(String section, Class type, Class returnType, String name, Class ... paramTypes) {
        for (Class current = type; current != null; current = current.getSuperclass()) {
            for (Method m : current.getDeclaredMethods()) {
                if (!returnType.equals(returnType) || !m.getName().equals(name) || !Arrays.equals(m.getParameterTypes(), paramTypes)) continue;
                throw new TCKValidationException(section + ": Class must NOT implement method " + name + '(' + Arrays.toString(paramTypes) + "): " + returnType.getName() + ", but does: " + type.getName());
            }
        }
    }

    public static void testComparable(String section, Class type) {
        TestUtils.testImplementsInterface(section, type, Comparable.class);
    }

    public static void assertValue(String section, Object value, String methodName, Object instance) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method m = instance.getClass().getDeclaredMethod(methodName, new Class[0]);
        AssertJUnit.assertEquals((String)(section + ": " + m.getName() + '(' + instance + ") returned invalid value:"), (Object)value, (Object)m.invoke(instance, new Object[0]));
    }

    public static boolean testImmutableOpt(String section, Class type) {
        try {
            TestUtils.testImmutable(section, type);
            return true;
        }
        catch (Exception e) {
            WARNINGS.append(section).append(": Recommendation failed: Class should be immutable: ").append(type.getName()).append(", details: ").append(e.getMessage()).append("\n");
            return false;
        }
    }

    public static boolean testSerializableOpt(String section, Class type) {
        try {
            TestUtils.testSerializable(section, type);
            return true;
        }
        catch (Exception e) {
            WARNINGS.append(section).append(": Recommendation failed: Class should be serializable: ").append(type.getName()).append(", details: ").append(e.getMessage()).append("\n");
            return false;
        }
    }

    public static boolean testHasPublicStaticMethodOpt(String section, Class type, Class returnType, String methodName, Class ... paramTypes) {
        try {
            TestUtils.testHasPublicStaticMethod(section, type, returnType, methodName, paramTypes);
            return true;
        }
        catch (Exception e) {
            WARNINGS.append(section).append(": Recommendation failed: Missing method [public static ").append(methodName).append('(').append(Arrays.toString(paramTypes)).append("):").append(returnType.getName()).append("] on: ").append(type.getName()).append("\n");
            return false;
        }
    }

    public static boolean testSerializableOpt(String section, Object instance) {
        try {
            TestUtils.testSerializable(section, instance);
            return true;
        }
        catch (Exception e) {
            WARNINGS.append(section).append(": Recommendation failed: Class is serializable, but serialization failed: ").append(instance.getClass().getName()).append("\n");
            return false;
        }
    }

    public static void resetWarnings() {
        WARNINGS.setLength(0);
    }

    public static String getWarnings() {
        return WARNINGS.toString();
    }

    public static MonetaryAmount createAmountWithScale(int scale) {
        MonetaryAmountFactoryQuery tgtContext = MonetaryAmountFactoryQueryBuilder.of().setMaxScale(scale).build();
        try {
            MonetaryAmountFactory exceedingFactory = Monetary.getAmountFactory((MonetaryAmountFactoryQuery)tgtContext);
            AssertJUnit.assertNotNull((Object)exceedingFactory);
            MonetaryAmountFactory bigFactory = Monetary.getAmountFactory((Class)exceedingFactory.getAmountType());
            return bigFactory.setCurrency("CHF").setNumber((Number)TestUtils.createNumberWithScale(scale)).create();
        }
        catch (MonetaryException e) {
            return null;
        }
    }

    public static MonetaryAmount createAmountWithPrecision(int precision) {
        MonetaryAmountFactoryQuery tgtContext = MonetaryAmountFactoryQueryBuilder.of().setPrecision(precision).build();
        try {
            MonetaryAmountFactory exceedingFactory = Monetary.getAmountFactory((MonetaryAmountFactoryQuery)tgtContext);
            AssertJUnit.assertNotNull((Object)exceedingFactory);
            MonetaryAmountFactory bigFactory = Monetary.getAmountFactory((Class)exceedingFactory.getAmountType());
            return bigFactory.setCurrency("CHF").setNumber((Number)TestUtils.createNumberWithPrecision(precision)).create();
        }
        catch (MonetaryException e) {
            return null;
        }
    }
}

