/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Currency;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryContextBuilder;
import javax.money.MonetaryException;
import javax.money.UnknownCurrencyException;
import org.javamoney.tck.TestUtils;
import org.javamoney.tck.tests.internal.TestAmount;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.1.0")
public class CreatingMonetaryAmountsTest {
    @Test(description="4.2.6 Ensure MonetaryAmountFactory instances are accessible for all amount types under test.")
    @SpecAssertion(section="4.2.6", id="426-A1")
    public void testAccessToMonetaryAmountFactory() {
        for (Class type : Monetary.getAmountTypes()) {
            AssertJUnit.assertNotNull((String)("Section 4.2.6: No MonetaryAmountFactory available for " + type.getName()), (Object)Monetary.getAmountFactory((Class)type));
        }
    }

    @Test(description="4.2.6 Ensure MonetaryAmountFactory instances accessible for all amount types under test return correct amount type.")
    @SpecAssertion(section="4.2.6", id="426-A2")
    public void testMonetaryAmountFactoryReturnsCorrectType() {
        for (Class type : Monetary.getAmountTypes()) {
            AssertJUnit.assertEquals((String)("Section 4.2.6: MonetaryAmountFactory declares invalid amount type for " + type.getName()), (Object)type, (Object)Monetary.getAmountFactory((Class)type).getAmountType());
        }
    }

    @Test(description="4.2.6 Ensure MonetaryAmountFactory instances accessible for all amount types under test return correct min/max MonetaryContext.")
    @SpecAssertion(section="4.2.6", id="426-A3")
    public void testMonetaryAmountFactoryMinMaxCapabilities() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            MonetaryContext defCtx = f.getDefaultMonetaryContext();
            MonetaryContext maxCts = f.getMaximalMonetaryContext();
            AssertJUnit.assertTrue((String)("Section 4.2.6: MonetaryAmountFactory default/max declares invalid precisions for " + type.getName()), (maxCts.getPrecision() == 0 || defCtx.getPrecision() <= maxCts.getPrecision() ? 1 : 0) != 0);
            AssertJUnit.assertTrue((String)("Section 4.2.6: MonetaryAmountFactory default/max declares invalid scales for " + type.getName()), (maxCts.getMaxScale() == -1 || defCtx.getMaxScale() <= maxCts.getMaxScale() ? 1 : 0) != 0);
        }
    }

    @Test(description="4.2.6 Ensure MonetaryAmountFactory instances accessible for all amount types under test return correct min/max MonetaryContext (min <= max).")
    @SpecAssertion(section="4.2.6", id="426-A4")
    public void testMonetaryAmountFactoryMinMaxCapabilities_Compare() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            MonetaryContext defCtx = f.getDefaultMonetaryContext();
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            if (f.getDefaultMonetaryContext().getMaxScale() > -1) {
                AssertJUnit.assertTrue((String)("Section 4.2.6: MonetaryAmountFactory maximal MonetaryContext cannot be less capable than the default (maxScale default/max=" + f.getDefaultMonetaryContext().getMaxScale() + '/' + f.getMaximalMonetaryContext().getMaxScale() + " for " + type.getName()), (maxCtx.getMaxScale() == -1 || defCtx.getMaxScale() <= maxCtx.getMaxScale() ? 1 : 0) != 0);
            }
            if (f.getDefaultMonetaryContext().getMaxScale() == -1) {
                AssertJUnit.assertTrue((String)("Section 4.2.6: MonetaryAmountFactory maximal MonetaryContext cannot be less capable than the default (maxScale default/max=" + f.getDefaultMonetaryContext().getMaxScale() + '/' + f.getMaximalMonetaryContext().getMaxScale() + " for " + type.getName()), (maxCtx.getMaxScale() == -1 ? 1 : 0) != 0);
            }
            if (f.getDefaultMonetaryContext().getPrecision() > 0) {
                AssertJUnit.assertTrue((String)("Section 4.2.6: MonetaryAmountFactory maximal MonetaryContext cannot be less capable than the default (precision default/max=" + f.getDefaultMonetaryContext().getPrecision() + '/' + f.getMaximalMonetaryContext().getPrecision() + " for " + type.getName()), (maxCtx.getPrecision() == 0 || defCtx.getPrecision() <= maxCtx.getPrecision() ? 1 : 0) != 0);
            }
            if (f.getDefaultMonetaryContext().getPrecision() != 0) continue;
            AssertJUnit.assertTrue((String)("Section 4.2.6: MonetaryAmountFactory maximal MonetaryContext cannot be less capable than the default (precision default/max=" + f.getDefaultMonetaryContext().getPrecision() + '/' + f.getMaximalMonetaryContext().getPrecision() + " for " + type.getName()), (maxCtx.getPrecision() == 0 ? 1 : 0) != 0);
        }
    }

    @Test(description="4.2.6 Ensure MonetaryAmountFactory instances support creation of 0 amounts.")
    @SpecAssertion(section="4.2.6", id="426-B1")
    public void testMonetaryAmountFactoryCreateZeroAmountsWithDiffCurrencies() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            for (Currency cur : Currency.getAvailableCurrencies()) {
                CurrencyUnit cu = Monetary.getCurrency((String)cur.getCurrencyCode(), (String[])new String[0]);
                MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
                f.setCurrency(cu);
                f.setNumber(0L);
                MonetaryAmount m = f.create();
                AssertJUnit.assertEquals((String)("Section 4.2.6: Amount created with factory has invalid currency for " + type.getName()), (Object)cu, (Object)m.getCurrency());
                AssertJUnit.assertEquals((String)("Section 4.2.6: Amount created with factory returns invalid amount type " + type.getName()), (Object)type, m.getClass());
                AssertJUnit.assertTrue((String)("Section 4.2.6: Amount created with factory has invalid value for " + type.getName()), (boolean)m.isZero());
                AssertJUnit.assertTrue((String)("Amount created with factory has invalid value for " + type.getName()), (m.signum() == 0 ? 1 : 0) != 0);
                AssertJUnit.assertTrue((String)("Section 4.2.6: Amount created with factory has invalid value for " + type.getName()), (m.getNumber().intValueExact() == 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.6 Ensure MonetaryAmountFactory instances support creation of 0 amounts, with explicit MonetaryContext.")
    @SpecAssertion(section="4.2.6", id="426-B2")
    public void testMonetaryAmountFactoryCreateZeroAmountsWithDiffContexts() {
        for (Class type : Monetary.getAmountTypes()) {
            int s;
            MonetaryAmount m;
            int p;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency("GBP");
            f.setNumber(0L);
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            if (maxCtx.getPrecision() != 0) {
                for (p = maxCtx.getPrecision(); p > 0; --p) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            } else {
                for (p = 0; p < 100; p += 10) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            }
            if (maxCtx.getMaxScale() != -1) {
                for (s = maxCtx.getMaxScale(); s >= 0; --s) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the scale set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
                }
                continue;
            }
            for (s = 0; s < 100; s += 10) {
                f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                m = f.create();
                AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.6 Ensure MonetaryAmountFactory instances support creation of 0 amounts, with different explicit MonetaryContext.")
    @SpecAssertion(section="4.2.6", id="426-B2")
    public void testMonetaryAmountFactoryCreateZeroAmountsWithDiffContexts2() {
        for (Class type : Monetary.getAmountTypes()) {
            int s;
            MonetaryAmount m;
            int p;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency("GBP");
            f.setNumber(0.0);
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            if (maxCtx.getPrecision() != 0) {
                for (p = maxCtx.getPrecision(); p > 0; --p) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            } else {
                for (p = 0; p < 100; p += 10) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            }
            if (maxCtx.getMaxScale() != -1) {
                for (s = maxCtx.getMaxScale(); s >= 0; --s) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the scale set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
                }
                continue;
            }
            for (s = 0; s < 100; s += 10) {
                f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                m = f.create();
                AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.6 Ensure MonetaryAmountFactory instances support creation of 0 amounts, with different explicit MonetaryContext (precision, scale).")
    @SpecAssertion(section="4.2.6", id="426-B2")
    public void testMonetaryAmountFactoryCreateZeroAmountsWithDiffContexts3() {
        for (Class type : Monetary.getAmountTypes()) {
            int s;
            MonetaryAmount m;
            int p;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency("GBP");
            f.setNumber((Number)BigDecimal.ZERO);
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            if (maxCtx.getPrecision() != 0) {
                for (p = maxCtx.getPrecision(); p > 0; --p) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            } else {
                for (p = 0; p < 100; p += 10) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            }
            if (maxCtx.getMaxScale() != -1) {
                for (s = maxCtx.getMaxScale(); s >= 0; --s) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the scale set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
                }
                continue;
            }
            for (s = 0; s < 100; s += 10) {
                f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                m = f.create();
                AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.6 Bad case: For each MonetaryAmount Factory: Create zero amounts from a factory with an invalid currency.")
    @SpecAssertion(section="4.2.6", id="426-B3")
    public void testMonetaryAmountFactoryCreateAmountsWithInvalidCurrency() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            for (Currency cur : Currency.getAvailableCurrencies()) {
                Monetary.getCurrency((String)cur.getCurrencyCode(), (String[])new String[0]);
                MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
                try {
                    f.setCurrency("shjgssgsjgsj");
                    AssertJUnit.fail((String)("Section 4.2.6: Factory should throw UnknownCurrencyException for invalid currency, type was " + type.getName()));
                }
                catch (UnknownCurrencyException unknownCurrencyException) {}
            }
        }
    }

    @Test(description="4.2.6 Bad case: For each MonetaryAmount Factory: Create zero amounts from a factory with an invalid MonetaryContext.")
    @SpecAssertion(section="4.2.6", id="426-B4")
    public void testMonetaryAmountFactoryCreateAmountsWithInvalidMonetaryContext() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            try {
                f.setCurrency("USD");
                MonetaryContext maxCtx = f.getMaximalMonetaryContext();
                if (maxCtx.getPrecision() != 0) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(maxCtx.getPrecision() + 1).build());
                    AssertJUnit.fail((String)("Section 4.2.6: Factory should throw MonetaryException for invalid context (exceeding precision), type was " + type.getName()));
                }
                if (maxCtx.getMaxScale() == -1) continue;
                f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(maxCtx.getMaxScale() + 1).build());
                AssertJUnit.fail((String)("Section 4.2.6: Factory should throw MonetaryException for invalid context (exceeding scale), type was " + type.getName()));
            }
            catch (MonetaryException monetaryException) {}
        }
    }

    @Test(description="4.2.6 For each MonetaryAmount Factory: Create positive amounts.")
    @SpecAssertion(section="4.2.6", id="426-C1")
    public void testMonetaryAmountFactoryCreatePositiveAmountsWitCurrencies() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            for (Currency cur : Currency.getAvailableCurrencies()) {
                CurrencyUnit cu = Monetary.getCurrency((String)cur.getCurrencyCode(), (String[])new String[0]);
                MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
                f.setCurrency(cu);
                f.setNumber(1L);
                MonetaryAmount m = f.create();
                AssertJUnit.assertEquals((String)("Section 4.2.6: Amount created with factory has invalid currency for " + type.getName()), (Object)cu, (Object)m.getCurrency());
                AssertJUnit.assertEquals((String)("Section 4.2.6: Amount created with factory returns invalid amount type " + type.getName()), (Object)type, m.getClass());
                AssertJUnit.assertTrue((String)("Section 4.2.6: Amount created with factory has invalid value for " + type.getName()), (boolean)m.isPositive());
                AssertJUnit.assertTrue((String)("Section 4.2.6: Amount created with factory has invalid value for " + type.getName()), (m.signum() == 1 ? 1 : 0) != 0);
                AssertJUnit.assertTrue((String)("Section 4.2.6: Amount created with factory has invalid value for " + type.getName()), (m.getNumber().intValueExact() == 1 ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.6 For each MonetaryAmount Factory: Create positive amounts with explicit MonetaryContext.")
    @SpecAssertion(section="4.2.6", id="426-C2")
    public void testMonetaryAmountFactoryCreatePositiveAmountsWithContexts() {
        for (Class type : Monetary.getAmountTypes()) {
            int s;
            MonetaryAmount m;
            int p;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency("GBP");
            f.setNumber(1L);
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            if (maxCtx.getPrecision() != 0) {
                for (p = maxCtx.getPrecision(); p > 0; --p) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            } else {
                for (p = 0; p < 100; p += 10) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            }
            if (maxCtx.getMaxScale() != -1) {
                for (s = maxCtx.getMaxScale(); s >= 0; --s) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the scale set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
                }
                continue;
            }
            for (s = 0; s < 100; s += 10) {
                f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                m = f.create();
                AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.6 For each MonetaryAmount Factory: Create positive amounts using doubles with explicit MonetaryContext (precision/scale).")
    @SpecAssertion(section="4.2.6", id="426-C2")
    public void testMonetaryAmountFactoryCreatePositiveAmountsWithContexts2() {
        for (Class type : Monetary.getAmountTypes()) {
            int s;
            MonetaryAmount m;
            int p;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency("GBP");
            f.setNumber(1.0);
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            if (maxCtx.getPrecision() != 0) {
                for (p = maxCtx.getPrecision(); p > 0; --p) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            } else {
                for (p = 0; p < 100; p += 10) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            }
            if (maxCtx.getMaxScale() != -1) {
                for (s = maxCtx.getMaxScale(); s >= 0; --s) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the scale set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
                }
                continue;
            }
            for (s = 0; s < 100; s += 10) {
                f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                m = f.create();
                AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.6 For each MonetaryAmount Factory: Create positive amounts using BigDecimal with explicit MonetaryContext (precision/scale).")
    @SpecAssertion(section="4.2.6", id="426-C2")
    public void testMonetaryAmountFactoryCreatePositiveAmountsWithContexts3() {
        for (Class type : Monetary.getAmountTypes()) {
            int s;
            MonetaryAmount m;
            int p;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency("GBP");
            f.setNumber((Number)BigDecimal.ONE);
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            if (maxCtx.getPrecision() != 0) {
                for (p = maxCtx.getPrecision(); p > 0; --p) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            } else {
                for (p = 0; p < 100; p += 10) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            }
            if (maxCtx.getMaxScale() != -1) {
                for (s = maxCtx.getMaxScale(); s >= 0; --s) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the scale set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
                }
                continue;
            }
            for (s = 0; s < 100; s += 10) {
                f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                m = f.create();
                AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.6 Bad case: For each MonetaryAmount Factory: Create positive amounts using invalid numbers, expecting ArithemticException thrown.")
    @SpecAssertion(section="4.2.6", id="426-C3")
    public void testMonetaryAmountFactoryCreatePositiveAmountsWithInvalidNumber() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency("INR");
            MonetaryContext ctx = f.getMaximalMonetaryContext();
            if (ctx.getPrecision() != 0) {
                try {
                    f.setNumber((Number)TestUtils.createNumberWithPrecision(ctx.getPrecision() + 5));
                    f.create();
                    AssertJUnit.fail((String)("Section 4.2.6: MonetaryAmountFactory must throw an ArithmeticException, when an amount with exceeding precision is tried being created, type: " + type.getName()));
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
            if (ctx.getMaxScale() == -1) continue;
            try {
                f.setNumber((Number)TestUtils.createNumberWithScale(ctx.getMaxScale() + 5));
                f.create();
                AssertJUnit.fail((String)("Section 4.2.6: MonetaryAmountFactory must throw an ArithmeticException, when an amount with exceeding scale is tried being created, type: " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @Test(description="4.2.6 Bad case: For each MonetaryAmount Factory: Create negative amounts without currency, expecting MonetaryException thrown.")
    @SpecAssertion(section="4.2.6", id="426-C4")
    public void testMonetaryAmountFactoryCreatePositiveNoCurrency_BadCase() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            try {
                if (f.getDefaultMonetaryContext().getPrecision() == 0) {
                    f.setNumber((Number)TestUtils.createNumberWithPrecision(5));
                } else {
                    f.setNumber((Number)TestUtils.createNumberWithPrecision(f.getDefaultMonetaryContext().getPrecision()));
                }
                f.create();
                AssertJUnit.fail((String)("Section 4.2.6: MonetaryAmountFactory must throw a MonetaryException, when a positive amount without a currency is tried to be created, type: " + type.getName()));
            }
            catch (MonetaryException monetaryException) {
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Section 4.2.6: MonetaryAmountFactory must throw a MonetaryException, when a positive amount without a currency is tried to be created, but threw " + e.getClass() + " type: " + type.getName()));
            }
        }
    }

    @Test(description="4.2.6 Bad case: For each MonetaryAmount Factory: Create negative amounts with an invalid currency, expecting MonetaryException thrown.")
    @SpecAssertion(section="4.2.6", id="426-C4")
    public void testMonetaryAmountFactoryCreatePositiveInvalidCurrency_BadCase() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            try {
                if (f.getDefaultMonetaryContext().getPrecision() == 0) {
                    f.setNumber((Number)TestUtils.createNumberWithPrecision(5));
                } else {
                    f.setNumber((Number)TestUtils.createNumberWithPrecision(f.getDefaultMonetaryContext().getPrecision()));
                }
                f.setCurrency("FooBar_foobar_fOobAr_foObaR");
                f.create();
                AssertJUnit.fail((String)("Section 4.2.6: MonetaryAmountFactory must throw a MonetaryException, when a positive amount with an invalid currency is tried to be created, type: " + type.getName()));
            }
            catch (MonetaryException monetaryException) {}
        }
    }

    @Test(description="4.2.6 Bad case: For each MonetaryAmount Factory: Create negative amounts with an invalid currency, expecting MonetaryException thrown.")
    @SpecAssertion(section="4.2.6", id="426-C5")
    public void testMonetaryAmountFactoryCreatePositiveInvalidContext_BadCase() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            MonetaryContext mc = f.getMaximalMonetaryContext();
            try {
                MonetaryContextBuilder b = mc.toBuilder();
                boolean runTest = false;
                if (mc.getMaxScale() != -1) {
                    b.setMaxScale(mc.getMaxScale() + 10);
                    runTest = true;
                }
                if (mc.getPrecision() != 0) {
                    b.setPrecision(mc.getPrecision() + 10);
                    runTest = true;
                }
                if (!runTest) continue;
                f.setNumber((Number)TestUtils.createNumberWithPrecision(f.getDefaultMonetaryContext().getPrecision()));
                f.setCurrency("FooBar_foobar_fOobAr_foObaR");
                f.create();
                AssertJUnit.fail((String)("Section 4.2.6: MonetaryAmountFactory must throw a MonetaryException, when a positive amount without an invalid MonetaryContext is tried to be created, type: " + type.getName()));
            }
            catch (MonetaryException monetaryException) {}
        }
    }

    @Test(description="4.2.6 For each MonetaryAmount Factory: Create negative amounts.")
    @SpecAssertion(section="4.2.6", id="426-D1")
    public void testMonetaryAmountFactoryNegativePositiveAmountsWitCurrencies() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            for (Currency cur : Currency.getAvailableCurrencies()) {
                CurrencyUnit cu = Monetary.getCurrency((String)cur.getCurrencyCode(), (String[])new String[0]);
                MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
                f.setCurrency(cu);
                f.setNumber(-3L);
                MonetaryAmount m = f.create();
                AssertJUnit.assertEquals((String)("Section 4.2.6: Amount created with factory has invalid currency for " + type.getName()), (Object)cu, (Object)m.getCurrency());
                AssertJUnit.assertEquals((String)("Section 4.2.6: Amount created with factory returns invalid amount type " + type.getName()), (Object)type, m.getClass());
                AssertJUnit.assertTrue((String)("Section 4.2.6: Amount created with factory has invalid value for " + type.getName()), (boolean)m.isNegative());
                AssertJUnit.assertTrue((String)("Section 4.2.6: Amount created with factory has invalid value for " + type.getName()), (m.signum() == -1 ? 1 : 0) != 0);
                AssertJUnit.assertTrue((String)("Section 4.2.6: Amount created with factory has invalid value for " + type.getName()), (m.getNumber().intValueExact() == -3 ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.6 For each MonetaryAmount Factory: Create negative amounts, with explicit MonetaryContext.")
    @SpecAssertion(section="4.2.6", id="426-D2")
    public void testMonetaryAmountFactoryNegativePositiveAmountsWithContexts() {
        for (Class type : Monetary.getAmountTypes()) {
            int s;
            MonetaryAmount m;
            int p;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency("GBP");
            f.setNumber(1L);
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            if (maxCtx.getPrecision() != 0) {
                for (p = maxCtx.getPrecision(); p > 0; --p) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            } else {
                for (p = 0; p < 100; p += 10) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            }
            if (maxCtx.getMaxScale() != -1) {
                for (s = maxCtx.getMaxScale(); s >= 0; --s) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the scale set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
                }
                continue;
            }
            for (s = 0; s < 100; s += 10) {
                f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                m = f.create();
                AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.6 For each MonetaryAmount Factory: Create negative amounts, with explicit MonetaryContext.")
    @SpecAssertion(section="4.2.6", id="426-D2")
    public void testMonetaryAmountFactoryNegativePositiveAmountsWithContexts2() {
        for (Class type : Monetary.getAmountTypes()) {
            int s;
            MonetaryAmount m;
            int p;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency("GBP");
            f.setNumber(11.2);
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            if (maxCtx.getPrecision() != 0) {
                for (p = maxCtx.getPrecision(); p > 0; --p) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            } else {
                for (p = 0; p < 100; p += 10) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            }
            if (maxCtx.getMaxScale() != -1) {
                for (s = maxCtx.getMaxScale(); s >= 0; --s) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the scale set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
                }
                continue;
            }
            for (s = 0; s < 100; s += 10) {
                f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                m = f.create();
                AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.6 For each MonetaryAmount Factory: Create negative amounts, with explicit MonetaryContext.")
    @SpecAssertion(section="4.2.6", id="426-D2")
    public void testMonetaryAmountFactoryNegativePositiveAmountsWithContexts3() {
        for (Class type : Monetary.getAmountTypes()) {
            int s;
            MonetaryAmount m;
            int p;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency("GBP");
            f.setNumber((Number)BigDecimal.TEN);
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            if (maxCtx.getPrecision() != 0) {
                for (p = maxCtx.getPrecision(); p > 0; --p) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            } else {
                for (p = 0; p < 100; p += 10) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setPrecision(p).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getPrecision() == 0 || m.getContext().getPrecision() >= p ? 1 : 0) != 0);
                }
            }
            if (maxCtx.getMaxScale() != -1) {
                for (s = maxCtx.getMaxScale(); s >= 0; --s) {
                    f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                    m = f.create();
                    AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the scale set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
                }
                continue;
            }
            for (s = 0; s < 100; s += 10) {
                f.setContext(MonetaryContextBuilder.of(MonetaryAmount.class).setMaxScale(s).build());
                m = f.create();
                AssertJUnit.assertTrue((String)("Section 4.2.6: Factory did not honor the precision set on the context for " + type.getName()), (m.getContext().getMaxScale() == -1 || m.getContext().getMaxScale() >= s ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.6 Bad case: For each MonetaryAmount Factory: Create negative amounts, with invalid numeric value, expect ArithmeticException.")
    @SpecAssertion(section="4.2.6", id="426-D3")
    public void testMonetaryAmountFactoryNegativePositiveAmountsWithInvalidNumber() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency("INR");
            MonetaryContext ctx = f.getMaximalMonetaryContext();
            if (ctx.getPrecision() != 0) {
                try {
                    f.setNumber((Number)TestUtils.createNumberWithPrecision(ctx.getPrecision() + 5).negate());
                    f.create();
                    AssertJUnit.fail((String)("Section 4.2.6: MonetaryAmountFactory must throw an ArithmeticException, when an amount with exceeding precision is tried being created, type: " + type.getName()));
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
            if (ctx.getMaxScale() == -1) continue;
            try {
                f.setNumber((Number)TestUtils.createNumberWithScale(ctx.getMaxScale() + 5).negate());
                f.create();
                AssertJUnit.fail((String)("Section 4.2.6: MonetaryAmountFactory must throw an ArithmeticException, when an amount with exceeding scale is tried being created, type: " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @Test(description="4.2.6 Bad case: For each MonetaryAmount Factory: Create negative amounts, with no currency, expect MonetaryException.")
    @SpecAssertion(section="4.2.6", id="426-D4")
    public void testMonetaryAmountFactoryCreateNegativeNoCurrency_BadCase() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            try {
                if (f.getDefaultMonetaryContext().getPrecision() == 0) {
                    f.setNumber((Number)TestUtils.createNumberWithPrecision(5).negate());
                } else {
                    f.setNumber((Number)TestUtils.createNumberWithPrecision(f.getDefaultMonetaryContext().getPrecision()).negate());
                }
                f.create();
                AssertJUnit.fail((String)("Section 4.2.6: MonetaryAmountFactory must throw a MonetaryException, when an amount without a currency is tried to be created, type: " + type.getName()));
            }
            catch (MonetaryException monetaryException) {
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Section 4.2.6: MonetaryAmountFactory must throw a MonetaryException, when an amount without a currency is tried to be created, but threw " + e.getClass() + " type: " + type.getName()));
            }
        }
    }

    @Test(description="4.2.6 Bad case: For each MonetaryAmount Factory: Create negative amounts, with invalid currency, expect MonetaryException.")
    @SpecAssertion(section="4.2.6", id="426-D4")
    public void testMonetaryAmountFactoryCreateNegativeInvalidCurrency_BadCase() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            try {
                if (f.getDefaultMonetaryContext().getPrecision() == 0) {
                    f.setNumber((Number)TestUtils.createNumberWithPrecision(5).negate());
                } else {
                    f.setNumber((Number)TestUtils.createNumberWithPrecision(f.getDefaultMonetaryContext().getPrecision()).negate());
                }
                f.setCurrency("Section 4.2.6: FooBar_foobar_fOobAr_foObaR");
                f.create();
                AssertJUnit.fail((String)("Section 4.2.6: MonetaryAmountFactory must throw a MonetaryException, when an amount with an invalid currency is tried to be created, type: " + type.getName()));
            }
            catch (MonetaryException monetaryException) {}
        }
    }

    @Test(description="4.2.6 Bad case: For each MonetaryAmount Factory: Create negative amounts, with no currency, expect MonetaryException.")
    @SpecAssertion(section="4.2.6", id="426-D5")
    public void testMonetaryAmountFactoryCreateNegativeInvalidContext_BadCase() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            MonetaryContext mc = f.getMaximalMonetaryContext();
            try {
                MonetaryContextBuilder b = mc.toBuilder();
                boolean runTest = false;
                if (mc.getMaxScale() != -1) {
                    b.setMaxScale(mc.getMaxScale() + 10);
                    runTest = true;
                }
                if (mc.getPrecision() != 0) {
                    b.setPrecision(mc.getPrecision() + 10);
                    runTest = true;
                }
                if (!runTest) continue;
                if (f.getDefaultMonetaryContext().getPrecision() == 0) {
                    f.setNumber((Number)TestUtils.createNumberWithPrecision(5).negate());
                } else {
                    f.setNumber((Number)TestUtils.createNumberWithPrecision(f.getDefaultMonetaryContext().getPrecision()).negate());
                }
                f.setCurrency("FooBar_foobar_fOobAr_foObaR");
                f.create();
                AssertJUnit.fail((String)("Section 4.2.6: MonetaryAmountFactory must throw a MonetaryException, when an amount with an invalid MonetaryContext is tried to be created, type: " + type.getName()));
            }
            catch (MonetaryException monetaryException) {}
        }
    }

    @Test(description="4.2.7 Ensure the types available, must be at least one type.")
    @SpecAssertion(section="4.2.7", id="427-B1")
    public void testMonetaryAmountTypes_Available() {
        Collection types = Monetary.getAmountTypes();
        AssertJUnit.assertNotNull((String)"Section 4.2.6: Monetary returns null for amount implementations.", (Object)types);
        AssertJUnit.assertTrue((String)"Section 4.2.6: Monetary does not provide any amount implementations.", (!types.isEmpty() ? 1 : 0) != 0);
    }
}

