/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Currency;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import javax.money.NumberValue;
import org.javamoney.tck.TCKTestSetup;
import org.javamoney.tck.TestUtils;
import org.javamoney.tck.tests.internal.TestAmount;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.mutabilitydetector.unittesting.MutabilityAssertionError;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.1.0")
public class ModellingMonetaryAmountsTest {
    private static final String DEFAULT_CURRENCY = "CHF";
    private static final String ADDITIONAL_CURRENCY = "USD";

    @Test(description="4.2.2 Ensure Monetary.getAmountTypes() is not null and not empty.")
    @SpecAssertion(section="4.2.2", id="422-0")
    public void testEnsureMonetaryAmount() {
        AssertJUnit.assertNotNull((String)"Section 4.2.2: Monetary.getAmountTypes() must never return null.", (Object)Monetary.getAmountTypes());
        AssertJUnit.assertTrue((String)"Section 4.2.2: At least one type must be registered with Monetary (see getAmountTypes()).", (!Monetary.getAmountTypes().isEmpty() ? 1 : 0) != 0);
    }

    @Test(description="4.2.2 Ensure amount can be created with all default currencies.")
    @SpecAssertion(section="4.2.2", id="422-A1")
    public void testCurrencyCode() {
        for (Class type : Monetary.getAmountTypes()) {
            for (Currency jdkCur : Currency.getAvailableCurrencies()) {
                MonetaryAmount amount = Monetary.getDefaultAmountFactory().setCurrency(jdkCur.getCurrencyCode()).setNumber(10.15).create();
                AssertJUnit.assertNotNull((String)("Section 4.2.2: Amount factory returned null for new amount type: " + type.getName()), (Object)amount);
                AssertJUnit.assertNotNull((String)("Section 4.2.2: Amount factory returned new amount with null currency, type: " + type.getName()), (Object)amount.getCurrency());
                AssertJUnit.assertEquals((String)("Section 4.2.2: Amount factory returned new amount with invalid currency, type: " + type.getName()), (String)jdkCur.getCurrencyCode(), (String)amount.getCurrency().getCurrencyCode());
            }
        }
    }

    @Test(description="4.2.2 Ensure amounts created return correct getNumber().")
    @SpecAssertion(section="4.2.2", id="422-A2")
    public void testGetNumber() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            MonetaryAmount[] moneys = new MonetaryAmount[]{f.setNumber(100L).create(), f.setNumber((Number)new BigDecimal("23123213.435")).create(), f.setNumber((Number)new BigDecimal("-23123213.435")).create(), f.setNumber(-23123213L).create(), f.setNumber(0L).create()};
            BigDecimal[] numbers = new BigDecimal[]{new BigDecimal("100"), new BigDecimal("23123213.435"), new BigDecimal("-23123213.435"), new BigDecimal("-23123213"), BigDecimal.ZERO};
            int[] intNums = new int[]{100, 23123213, -23123213, -23123213, 0};
            long[] longNums = new long[]{100L, 23123213L, -23123213L, -23123213L, 0L};
            double[] doubleNums = new double[]{100.0, 2.3123213435E7, -2.3123213435E7, -2.3123213E7, 0.0};
            float[] floatNums = new float[]{100.0f, 2.3123214E7f, -2.3123214E7f, -2.3123212E7f, 0.0f};
            for (int i = 0; i < moneys.length; ++i) {
                NumberValue nv = moneys[i].getNumber();
                AssertJUnit.assertNotNull((String)("Section 4.2.2: Amount returned returns null for getNumber(), type: " + moneys[i].getClass().getName()), (Object)nv);
                AssertJUnit.assertEquals((String)("Section 4.2.2: getNumber().numberValue(BigDecimal.class) incorrect for " + type.getName()), (Object)numbers[i].stripTrailingZeros(), (Object)((BigDecimal)nv.numberValue(BigDecimal.class)).stripTrailingZeros());
                AssertJUnit.assertEquals((String)("Section 4.2.2: getNumber().intValue() incorrect for " + type.getName()), (int)intNums[i], (int)nv.intValue());
                AssertJUnit.assertEquals((String)("Section 4.2.2: getNumber().longValue() incorrect for " + type.getName()), (long)longNums[i], (long)nv.longValue());
                AssertJUnit.assertEquals((String)("Section 4.2.2: getNumber().doubleValue() incorrect for " + type.getName()), (double)doubleNums[i], (double)nv.doubleValue(), (double)0.0);
                AssertJUnit.assertEquals((String)("Section 4.2.2: getNumber().floatValue() incorrect for " + type.getName()), (double)floatNums[i], (double)nv.floatValue(), (double)0.0);
            }
        }
    }

    @Test(description="4.2.2 Ensure amounts created return correct getContext().")
    @SpecAssertion(section="4.2.2", id="422-A3")
    public void testGetMonetaryContext() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            MonetaryContext defCtx = f.getDefaultMonetaryContext();
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            MonetaryContext mc = f.setNumber(1L).create().getContext();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid MonetaryContext(amountType) for " + type.getName()), (Object)mc.getAmountType(), (Object)type);
            if (maxCtx.getPrecision() > 0) {
                AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid MonetaryContext(precision) for " + type.getName()), (mc.getPrecision() <= maxCtx.getPrecision() ? 1 : 0) != 0);
            }
            if (maxCtx.getMaxScale() > 0) {
                AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid MonetaryContext(maxScale) for " + type.getName()), (mc.getMaxScale() <= maxCtx.getMaxScale() ? 1 : 0) != 0);
            }
            AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid MonetaryContext(amountType) for " + type.getName()), (Object)f.setNumber(0.34746).create().getContext().getAmountType(), (Object)type);
            mc = f.setNumber(0L).create().getContext();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid MonetaryContext(amountType) for " + type.getName()), (Object)mc.getAmountType(), (Object)type);
            if (maxCtx.getPrecision() > 0) {
                AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid MonetaryContext(precision) for " + type.getName()), (mc.getPrecision() <= maxCtx.getPrecision() ? 1 : 0) != 0);
            }
            if (maxCtx.getMaxScale() > 0) {
                AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid MonetaryContext(maxScale) for " + type.getName()), (mc.getMaxScale() <= maxCtx.getMaxScale() ? 1 : 0) != 0);
            }
            AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid MonetaryContext(amountType) for " + type.getName()), (Object)f.setNumber(100034L).create().getContext().getAmountType(), (Object)type);
            mc = f.setNumber(0L).create().getContext();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid MonetaryContext(amountType) for " + type.getName()), (Object)mc.getAmountType(), (Object)type);
            if (maxCtx.getPrecision() > 0) {
                AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid MonetaryContext(precision) for " + type.getName()), (mc.getPrecision() <= maxCtx.getPrecision() ? 1 : 0) != 0);
            }
            if (maxCtx.getMaxScale() <= 0) continue;
            AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid MonetaryContext(maxScale) for " + type.getName()), (mc.getMaxScale() <= maxCtx.getMaxScale() ? 1 : 0) != 0);
        }
    }

    @Test(description="4.2.2 For each amount class, test isNegative().")
    @SpecAssertion(section="4.2.2", id="422-A4")
    public void testIsNegative() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmount[] moneys;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            for (MonetaryAmount m : moneys = new MonetaryAmount[]{f.setNumber(0L).create(), f.setNumber(0.0).create(), f.setNumber((Number)BigDecimal.ZERO).create(), f.setNumber((Number)new BigDecimal("0.00000000000000000")).create(), f.setNumber(100L).create(), f.setNumber(34242344L).create(), f.setNumber(2.3123213435E7).create()}) {
                AssertJUnit.assertFalse((String)("Section 4.2.2: Invalid isNegative (expected false) for " + type.getName()), (boolean)m.isNegative());
            }
            for (MonetaryAmount m : moneys = new MonetaryAmount[]{f.setNumber(-100L).create(), f.setNumber(-34242344L).create(), f.setNumber(-2.3123213435E7).create()}) {
                AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid isNegative (expected true) for " + type.getName()), (boolean)m.isNegative());
            }
        }
    }

    @Test(description="4.2.2 For each amount class, test isPositive().")
    @SpecAssertion(section="4.2.2", id="422-A5")
    public void testIsPositive() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmount[] moneys;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            for (MonetaryAmount m : moneys = new MonetaryAmount[]{f.setNumber(100L).create(), f.setNumber(34242344L).create(), f.setNumber(2.3123213435E7).create()}) {
                AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid isPositive (expected true) for " + type.getName()), (boolean)m.isPositive());
            }
            for (MonetaryAmount m : moneys = new MonetaryAmount[]{f.setNumber(0L).create(), f.setNumber(0.0).create(), f.setNumber((Number)BigDecimal.ZERO).create(), f.setNumber((Number)new BigDecimal("0.00000000000000000")).create(), f.setNumber(-100L).create(), f.setNumber(-34242344L).create(), f.setNumber(-2.3123213435E7).create()}) {
                AssertJUnit.assertFalse((String)("Section 4.2.2: Invalid isPositive (expected false) for " + type.getName()), (boolean)m.isPositive());
            }
        }
    }

    @Test(description="4.2.2 For each amount class, test isZero().")
    @SpecAssertion(section="4.2.2", id="422-A6")
    public void testIsZero() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmount[] moneys;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            for (MonetaryAmount m : moneys = new MonetaryAmount[]{f.setNumber(100L).create(), f.setNumber(34242344L).create(), f.setNumber(2.3123213435E7).create(), f.setNumber(-100L).create(), f.setNumber(-723527.36532).create()}) {
                AssertJUnit.assertFalse((String)("Section 4.2.2: Invalid isZero (expected false) for " + type.getName()), (boolean)m.isZero());
            }
            for (MonetaryAmount m : moneys = new MonetaryAmount[]{f.setNumber(0L).create(), f.setNumber(0.0).create(), f.setNumber((Number)BigDecimal.ZERO).create(), f.setNumber((Number)new BigDecimal("0.00000000000000000")).create()}) {
                AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid isZero (expected true) for " + type.getName()), (boolean)m.isZero());
            }
        }
    }

    @Test(description="4.2.2 For each amount class, test isZero(), advanced.")
    @SpecAssertion(section="4.2.2", id="422-A6")
    public void testIsZeroAdvanced() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmount[] moneys;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            for (MonetaryAmount m : moneys = new MonetaryAmount[]{f.setNumber(0L).create(), f.setNumber(0L).create(), f.setNumber(-0.0).create(), f.setNumber(0.0).create(), f.setNumber(-0.0).create(), f.setNumber(0.0).create()}) {
                AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid isZero (expected true) for " + type.getName()), (boolean)m.isZero());
            }
        }
    }

    @Test(description="4.2.2 For each amount class, test signum().")
    @SpecAssertion(section="4.2.2", id="422-A7")
    public void testSignum() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            MonetaryAmount m = f.setNumber(100L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid signum of 100 for " + type.getName()), (int)1, (int)m.signum());
            m = f.setNumber(-100L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: signum of -100 for " + type.getName()), (int)-1, (int)m.signum());
            m = f.setNumber(100.3435).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: signum of 100.3435 for " + type.getName()), (int)1, (int)m.signum());
            m = f.setNumber(-100.3435).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: signum of -100.3435 for " + type.getName()), (int)-1, (int)m.signum());
            m = f.setNumber(0L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: signum of 0 for " + type.getName()), (int)0, (int)m.signum());
            m = f.setNumber(0L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: signum of - for " + type.getName()), (int)0, (int)m.signum());
        }
    }

    @Test(description="4.2.2 For each amount class, test isNegativeOrZero().")
    @SpecAssertion(section="4.2.2", id="422-A8")
    public void testIsNegativeOrZero() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmount[] moneys;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            for (MonetaryAmount m : moneys = new MonetaryAmount[]{f.setNumber(100L).create(), f.setNumber(34242344L).create(), f.setNumber(2.3123213435E7).create()}) {
                AssertJUnit.assertFalse((String)("Section 4.2.2: Invalid negativeOrZero (expected false) for " + type.getName()), (boolean)m.isNegativeOrZero());
            }
            for (MonetaryAmount m : moneys = new MonetaryAmount[]{f.setNumber(0L).create(), f.setNumber(0.0).create(), f.setNumber((Number)BigDecimal.ZERO).create(), f.setNumber((Number)new BigDecimal("0.0000")).create(), f.setNumber(-100L).create(), f.setNumber(-34242344L).create(), f.setNumber(-2.3123213435E7).create()}) {
                AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid negativeOrZero (expected true) for " + type.getName()), (boolean)m.isNegativeOrZero());
            }
        }
    }

    @Test(description="4.2.2 For each amount class, test isPositiveOrZero().")
    @SpecAssertion(section="4.2.2", id="422-A9")
    public void testIsPositiveOrZero() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmount[] moneys;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            for (MonetaryAmount m : moneys = new MonetaryAmount[]{f.setNumber(0L).create(), f.setNumber(0.0).create(), f.setNumber((Number)BigDecimal.ZERO).create(), f.setNumber((Number)new BigDecimal("0.00000000000000000")).create(), f.setNumber(100L).create(), f.setNumber(34242344L).create(), f.setNumber(2.3123213435E7).create()}) {
                AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid positiveOrZero (expected true): for " + type.getName()), (boolean)m.isPositiveOrZero());
            }
            for (MonetaryAmount m : moneys = new MonetaryAmount[]{f.setNumber(-100L).create(), f.setNumber(-34242344L).create(), f.setNumber(-2.3123213435E7).create()}) {
                AssertJUnit.assertFalse((String)("Section 4.2.2: Invalid positiveOrZero (expected false) for " + type.getName() + m), (boolean)m.isPositiveOrZero());
            }
        }
    }

    @Test(description="4.2.2 For each amount class, access factory and of amounts.")
    @SpecAssertion(section="4.2.2", id="422-B1")
    public void testMonetaryAmountFactories() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            AssertJUnit.assertNotNull((Object)f);
            MonetaryAmount m = f.setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid class for created amount, expected: " + type.getName()), m.getClass(), (Object)type);
            m = f.setCurrency(DEFAULT_CURRENCY).setNumber(-10L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid class for created amount, expected: " + type.getName()), m.getClass(), (Object)type);
            m = f.setCurrency(DEFAULT_CURRENCY).setNumber(10.3).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid class for created amount, expected: " + type.getName()), m.getClass(), (Object)type);
            m = f.setCurrency(DEFAULT_CURRENCY).setNumber(-10.3).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid class for created amount, expected: " + type.getName()), m.getClass(), (Object)type);
            m = f.setCurrency(DEFAULT_CURRENCY).setNumber(0.0).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid class for created amount, expected: " + type.getName()), m.getClass(), (Object)type);
            m = f.setCurrency(DEFAULT_CURRENCY).setNumber(-0.0).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid class for created amount, expected: " + type.getName()), m.getClass(), (Object)type);
        }
    }

    @Test(description="4.2.2 For each amount class, access factory and of amounts, ensure amounts are equal if theyshould.")
    @SpecAssertion(section="4.2.2", id="422-B2")
    public void testMonetaryAmountFactories_InstancesMustBeEqual() {
        MonetaryAmount m2;
        MonetaryAmount m1;
        MonetaryAmountFactory f;
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            f = Monetary.getAmountFactory((Class)type);
            m1 = f.setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            f = Monetary.getAmountFactory((Class)type);
            m2 = f.setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Expected equal instances for " + type.getName()), (Object)m1, (Object)m2);
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            f = Monetary.getAmountFactory((Class)type);
            m1 = f.setCurrency(DEFAULT_CURRENCY).setNumber(10.5).create();
            f = Monetary.getAmountFactory((Class)type);
            m2 = f.setCurrency(DEFAULT_CURRENCY).setNumber(10.5).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Expected equal types created by same factory for " + type.getName()), (Object)m1, (Object)m2);
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            f = Monetary.getAmountFactory((Class)type);
            m1 = f.setCurrency(DEFAULT_CURRENCY).setNumber((Number)new BigDecimal("10.52")).create();
            f = Monetary.getAmountFactory((Class)type);
            m2 = f.setCurrency(DEFAULT_CURRENCY).setNumber((Number)new BigDecimal("10.52")).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Expected equal types created by same factory for " + type.getName()), (Object)m1, (Object)m2);
        }
    }

    @Test(description="4.2.2 For each amount class, check new amounts are not equal.")
    @SpecAssertion(section="4.2.2", id="422-B3")
    public void testMonetaryAmountFactories_InstantesMustBeNotEqual() {
        MonetaryAmount m2;
        MonetaryAmount m1;
        MonetaryAmountFactory f;
        for (Class type : Monetary.getAmountTypes()) {
            f = Monetary.getAmountFactory((Class)type);
            m1 = f.setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            f = Monetary.getAmountFactory((Class)type);
            m2 = f.setCurrency(DEFAULT_CURRENCY).setNumber(11L).create();
            AssertJUnit.assertNotSame((String)("Section 4.2.2: Expected non equal instances for " + type.getName()), (Object)m1, (Object)m2);
        }
        for (Class type : Monetary.getAmountTypes()) {
            f = Monetary.getAmountFactory((Class)type);
            m1 = f.setCurrency(DEFAULT_CURRENCY).setNumber(10.5).create();
            f = Monetary.getAmountFactory((Class)type);
            m2 = f.setCurrency(DEFAULT_CURRENCY).setNumber(10.4).create();
            AssertJUnit.assertNotSame((String)("Section 4.2.2: Expected non equal instances for " + type.getName()), (Object)m1, (Object)m2);
        }
        for (Class type : Monetary.getAmountTypes()) {
            f = Monetary.getAmountFactory((Class)type);
            m1 = f.setCurrency(DEFAULT_CURRENCY).setNumber((Number)new BigDecimal("10.52")).create();
            f = Monetary.getAmountFactory((Class)type);
            m2 = f.setCurrency(DEFAULT_CURRENCY).setNumber((Number)new BigDecimal("10.11")).create();
            AssertJUnit.assertNotSame((String)("Section 4.2.2: Expected non equal instances for " + type.getName()), (Object)m1, (Object)m2);
        }
    }

    @Test(description="4.2.2 For each amount class, check multiple instances are not equal.")
    @SpecAssertion(section="4.2.2", id="422-B4")
    public void testMonetaryAmountFactories_CreateWithCurrencies() {
        MonetaryAmount m2;
        MonetaryAmount m1;
        MonetaryAmountFactory f;
        for (Class type : Monetary.getAmountTypes()) {
            f = Monetary.getAmountFactory((Class)type);
            m1 = f.setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            f = Monetary.getAmountFactory((Class)type);
            m2 = f.setCurrency(ADDITIONAL_CURRENCY).setNumber(10L).create();
            AssertJUnit.assertNotSame((String)("Section 4.2.2: Expected non equal instances for " + type.getName()), (Object)m1, (Object)m2);
        }
        for (Class type : Monetary.getAmountTypes()) {
            f = Monetary.getAmountFactory((Class)type);
            m1 = f.setCurrency(DEFAULT_CURRENCY).setNumber(10.5).create();
            f = Monetary.getAmountFactory((Class)type);
            m2 = f.setCurrency(ADDITIONAL_CURRENCY).setNumber(10.5).create();
            AssertJUnit.assertNotSame((String)("Section 4.2.2: Expected non equal instances for " + type.getName()), (Object)m1, (Object)m2);
        }
        for (Class type : Monetary.getAmountTypes()) {
            f = Monetary.getAmountFactory((Class)type);
            m1 = f.setCurrency(DEFAULT_CURRENCY).setNumber((Number)new BigDecimal("10.52")).create();
            f = Monetary.getAmountFactory((Class)type);
            m2 = f.setCurrency(ADDITIONAL_CURRENCY).setNumber((Number)new BigDecimal("10.52")).create();
            AssertJUnit.assertNotSame((String)("Section 4.2.2: Expected non equal instances for " + type.getName()), (Object)m1, (Object)m2);
        }
    }

    @Test(description="4.2.2 For each amount class, check new amounts with explcit MonetaryContext.")
    @SpecAssertion(section="4.2.2", id="422-B5")
    public void testMonetaryAmountFactories_CreateWithMonetaryContext() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmount m2;
            MonetaryAmount m1;
            MonetaryContext mc2;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            MonetaryContext mc1 = f.getDefaultMonetaryContext();
            if (mc1.equals((Object)(mc2 = f.getMaximalMonetaryContext()))) {
                m1 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc1).setNumber(10L).create();
                m2 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc2).setNumber(10L).create();
                AssertJUnit.assertNotSame((String)("Section 4.2.2: Expected non equal instances for " + type.getName()), (Object)m1, (Object)m2);
            } else {
                m1 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc1).setNumber(10L).create();
                m2 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc2).setNumber(10L).create();
                AssertJUnit.assertNotSame((String)("Section 4.2.2: Expected non equal instances for " + type.getName()), (Object)m1, (Object)m2);
            }
            AssertJUnit.assertTrue((String)("Section 4.2.2: Expected equality for " + type.getName()), (boolean)m1.equals(m1));
            AssertJUnit.assertTrue((String)("Section 4.2.2: Expected equality for " + type.getName()), (boolean)m2.equals(m2));
        }
    }

    @Test(description="4.2.2 For each amount class, check new amounts are not equal for different currencies and contexts.")
    @SpecAssertion(section="4.2.2", id="422-B6")
    public void testMonetaryAmountFactories_CreateWithMonetaryContextNumberAndCurrency() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            MonetaryContext mc1 = f.getDefaultMonetaryContext();
            MonetaryContext mc2 = f.getMaximalMonetaryContext();
            MonetaryAmount m1 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc1).setNumber(10L).create();
            MonetaryAmount m2 = f.setCurrency(ADDITIONAL_CURRENCY).setContext(mc2).setNumber(11L).create();
            AssertJUnit.assertNotSame((String)("Section 4.2.2: Expected not same for " + type.getName()), (Object)m1, (Object)m2);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Expected isEqualTo==true for " + type.getName()), (boolean)m1.isEqualTo(m1));
            AssertJUnit.assertTrue((String)("Section 4.2.2: Expected isEqualTo==true for " + type.getName()), (boolean)m2.isEqualTo(m2));
            AssertJUnit.assertTrue((String)("Section 4.2.2: Expected equality for " + type.getName()), (boolean)m1.equals(m1));
            AssertJUnit.assertTrue((String)("Section 4.2.2: Expected equality for " + type.getName()), (boolean)m2.equals(m2));
        }
    }

    @Test(description="4.2.2 For each amount class, check isGreaterThan().")
    @SpecAssertion(section="4.2.2", id="422-C1")
    public void testMonetaryAmount_isGreaterThan() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            AssertJUnit.assertFalse((String)("Section 4.2.2: isGreaterThan failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(0.0)).create().isGreaterThan(f.setNumber((Number)BigDecimal.valueOf(0L)).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isGreaterThan failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(1.0E-5)).create().isGreaterThan(f.setNumber((Number)BigDecimal.valueOf(0.0)).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isGreaterThan failed for " + type.getName()), (boolean)f.setNumber(15L).create().isGreaterThan(f.setNumber(10L).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isGreaterThan failed for " + type.getName()), (boolean)f.setNumber(15.546).create().isGreaterThan(f.setNumber(10.34).create()));
            AssertJUnit.assertFalse((String)("Section 4.2.2: isGreaterThan failed for " + type.getName()), (boolean)f.setNumber(5L).create().isGreaterThan(f.setNumber(10L).create()));
            AssertJUnit.assertFalse((String)("Section 4.2.2: isGreaterThan failed for " + type.getName()), (boolean)f.setNumber(5.546).create().isGreaterThan(f.setNumber(10.34).create()));
        }
    }

    @Test(description="4.2.2 For each amount class, check isGreaterThanOrEquals().")
    @SpecAssertion(section="4.2.2", id="422-C2")
    public void testMonetaryAmount_isGreaterThanOrEquals() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            AssertJUnit.assertTrue((String)("Section 4.2.2: isGreaterThanOrEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(0.0)).create().isGreaterThanOrEqualTo(f.setNumber((Number)BigDecimal.valueOf(0L)).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isGreaterThanOrEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(1.0E-5)).create().isGreaterThanOrEqualTo(f.setNumber((Number)BigDecimal.valueOf(0.0)).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isGreaterThanOrEqualTo failed for " + type.getName()), (boolean)f.setNumber(15L).create().isGreaterThanOrEqualTo(f.setNumber(10L).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isGreaterThanOrEqualTo failed for " + type.getName()), (boolean)f.setNumber(15.546).create().isGreaterThanOrEqualTo(f.setNumber(10.34).create()));
            AssertJUnit.assertFalse((String)("Section 4.2.2: isGreaterThanOrEqualTo failed for " + type.getName()), (boolean)f.setNumber(5L).create().isGreaterThanOrEqualTo(f.setNumber(10L).create()));
            AssertJUnit.assertFalse((String)("Section 4.2.2: isGreaterThanOrEqualTo failed for " + type.getName()), (boolean)f.setNumber(5.546).create().isGreaterThanOrEqualTo(f.setNumber(10.34).create()));
        }
    }

    @Test(description="4.2.2 For each amount class, check isLessThan().")
    @SpecAssertion(section="4.2.2", id="422-C3")
    public void testMonetaryAmount_isLessThan() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            AssertJUnit.assertFalse((String)("Section 4.2.2: isLessThan failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(0.0)).create().isLessThan(f.setNumber((Number)BigDecimal.valueOf(0L)).create()));
            AssertJUnit.assertFalse((String)("Section 4.2.2: isLessThan failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(1.0E-5)).create().isLessThan(f.setNumber((Number)BigDecimal.valueOf(0.0)).create()));
            AssertJUnit.assertFalse((String)("Section 4.2.2: isLessThan failed for " + type.getName()), (boolean)f.setNumber(15L).create().isLessThan(f.setNumber(10L).create()));
            AssertJUnit.assertFalse((String)("Section 4.2.2: isLessThan failed for " + type.getName()), (boolean)f.setNumber(15.546).create().isLessThan(f.setNumber(10.34).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isLessThan failed for " + type.getName()), (boolean)f.setNumber(5L).create().isLessThan(f.setNumber(10L).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isLessThan failed for " + type.getName()), (boolean)f.setNumber(5.546).create().isLessThan(f.setNumber(10.34).create()));
        }
    }

    @Test(description="4.2.2 For each amount class, check isLessThanOrEqualTo().")
    @SpecAssertion(section="4.2.2", id="422-C4")
    public void testMonetaryAmount_isLessThanOrEqualTo() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            AssertJUnit.assertTrue((String)("Section 4.2.2: isLessThanOrEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(0.0)).create().isLessThanOrEqualTo(f.setNumber((Number)BigDecimal.valueOf(0L)).create()));
            AssertJUnit.assertFalse((String)("Section 4.2.2: isLessThanOrEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(1.0E-5)).create().isLessThanOrEqualTo(f.setNumber((Number)BigDecimal.valueOf(0.0)).create()));
            AssertJUnit.assertFalse((String)("Section 4.2.2: isLessThanOrEqualTo failed for " + type.getName()), (boolean)f.setNumber(15L).create().isLessThanOrEqualTo(f.setNumber(10L).create()));
            AssertJUnit.assertFalse((String)("Section 4.2.2: isLessThan failed for " + type.getName()), (boolean)f.setNumber(15.546).create().isLessThan(f.setNumber(10.34).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isLessThanOrEqualTo failed for " + type.getName()), (boolean)f.setNumber(5L).create().isLessThanOrEqualTo(f.setNumber(10L).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isLessThanOrEqualTo failed for " + type.getName()), (boolean)f.setNumber(5.546).create().isLessThanOrEqualTo(f.setNumber(10.34).create()));
        }
    }

    @Test(description="4.2.2 For each amount class, check isEqualTo().")
    @SpecAssertion(section="4.2.2", id="422-C5")
    public void testMonetaryAmount_isEqualTo() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(0.0)).create().isEqualTo(f.setNumber((Number)BigDecimal.valueOf(0L)).create()));
            AssertJUnit.assertFalse((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(1.0E-5)).create().isEqualTo(f.setNumber((Number)BigDecimal.valueOf(0.0)).create()));
            AssertJUnit.assertTrue((String)("isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(5.0)).create().isEqualTo(f.setNumber((Number)BigDecimal.valueOf(5L)).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(1.0)).create().isEqualTo(f.setNumber((Number)BigDecimal.valueOf(1.0)).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(1.0)).create().isEqualTo(f.setNumber((Number)BigDecimal.ONE).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(1L)).create().isEqualTo(f.setNumber((Number)BigDecimal.ONE).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)new BigDecimal("1.0000")).create().isEqualTo(f.setNumber((Number)new BigDecimal("1.00")).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(0.0)).create().isEqualTo(f.setNumber((Number)BigDecimal.valueOf(0L)).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.ZERO).create().isEqualTo(f.setNumber((Number)BigDecimal.valueOf(0L)).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(5L)).create().isEqualTo(f.setNumber((Number)new BigDecimal("5.0")).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(5L)).create().isEqualTo(f.setNumber((Number)new BigDecimal("5.00")).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(5L)).create().isEqualTo(f.setNumber((Number)new BigDecimal("5.000")).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)BigDecimal.valueOf(5L)).create().isEqualTo(f.setNumber((Number)new BigDecimal("5.0000")).create()));
            AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)new BigDecimal("-1.23")).create().isEqualTo(f.setNumber((Number)new BigDecimal("-1.23")).create()));
            try {
                AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)new BigDecimal("-1.23")).create().isEqualTo(f.setNumber((Number)new BigDecimal("-1.230")).create()));
                AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)new BigDecimal("-1.23")).create().isEqualTo(f.setNumber((Number)new BigDecimal("-1.2300")).create()));
                AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)new BigDecimal("-1.23")).create().isEqualTo(f.setNumber((Number)new BigDecimal("-1.23000")).create()));
                AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo failed for " + type.getName()), (boolean)f.setNumber((Number)new BigDecimal("-1.23")).create().isEqualTo(f.setNumber((Number)new BigDecimal("-1.230000000000000000000")).create()));
            }
            catch (MonetaryException monetaryException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, check isEqualTo(), regardless different MonetaryContext instances.")
    @SpecAssertion(section="4.2.2", id="422-C6")
    public void testMonetaryAmount_isEqualToRegardlessMonetaryContext() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmount m2;
            MonetaryAmount m1;
            MonetaryContext mc2;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            MonetaryContext mc1 = f.getDefaultMonetaryContext();
            if (mc1.equals((Object)(mc2 = f.getMaximalMonetaryContext()))) {
                m1 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc1).setNumber(10L).create();
                m2 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc2).setNumber(10L).create();
                AssertJUnit.assertEquals((String)("Section 4.2.2: m1.equals(m2) must be true for m1=" + m1 + " and m2=" + m2), (Object)m1, (Object)m2);
                m1 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc1).setNumber(10.5).create();
                m2 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc2).setNumber(10.5).create();
                AssertJUnit.assertEquals((String)("Section 4.2.2: m1.equals(m2) must be true for m1=" + m1 + " and m2=" + m2), (Object)m1, (Object)m2);
                m1 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc1).setNumber((Number)BigDecimal.TEN).create();
                m2 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc2).setNumber((Number)BigDecimal.TEN).create();
                AssertJUnit.assertEquals((String)("Section 4.2.2: m1.equals(m2) must be true for m1=" + m1 + " and m2=" + m2), (Object)m1, (Object)m2);
            } else {
                m1 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc1).setNumber(10L).create();
                m2 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc2).setNumber(10L).create();
                AssertJUnit.assertNotSame((String)("Section 4.2.2: m1.equals(m2) must be false for m1=" + m1 + " and m2=" + m2), (Object)m1, (Object)m2);
                AssertJUnit.assertTrue((String)("Section 4.2.2: m1.isEqualTo(m2) must be true for m1=" + m1 + " and m2=" + m2), (boolean)m1.isEqualTo(m2));
                AssertJUnit.assertTrue((String)("Section 4.2.2: m1.isEqualTo(m2) must be true for m1=" + m2 + " and m2=" + m1), (boolean)m2.isEqualTo(m1));
                m1 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc1).setNumber(10.5).create();
                m2 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc2).setNumber(10.5).create();
                AssertJUnit.assertNotSame((String)("Section 4.2.2: m1.equals(m2) must be false for m1=" + m1 + " and m2=" + m2), (Object)m1, (Object)m2);
                AssertJUnit.assertTrue((String)("Section 4.2.2: m1.isEqualTo(m2) must be true for m1=" + m1 + " and m2=" + m2), (boolean)m1.isEqualTo(m2));
                AssertJUnit.assertTrue((String)("Section 4.2.2: m1.isEqualTo(m2) must be true for m1=" + m2 + " and m2=" + m1), (boolean)m2.isEqualTo(m1));
                m1 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc1).setNumber((Number)BigDecimal.TEN).create();
                m2 = f.setCurrency(DEFAULT_CURRENCY).setContext(mc2).setNumber((Number)BigDecimal.TEN).create();
                AssertJUnit.assertNotSame((String)("Section 4.2.2: m1.equals(m2) must be false for m1=" + m1 + " and m2=" + m2), (Object)m1, (Object)m2);
                AssertJUnit.assertTrue((String)("Section 4.2.2: m1.isEqualTo(m2) must be true for m1=" + m1 + " and m2=" + m2), (boolean)m1.isEqualTo(m2));
                AssertJUnit.assertTrue((String)("Section 4.2.2: m1.isEqualTo(m2) must be true for m1=" + m2 + " and m2=" + m1), (boolean)m2.isEqualTo(m1));
            }
            AssertJUnit.assertTrue((String)("Section 4.2.2: m.isEqualTo(m) must be true for " + m1), (boolean)m1.isEqualTo(m1));
            AssertJUnit.assertTrue((String)("Section 4.2.2: m.isEqualTo(m) must be true for " + m2), (boolean)m2.isEqualTo(m2));
        }
    }

    @Test(description="4.2.2 For each amount class, check isEqualTo(), regardless implementation type.")
    @SpecAssertion(section="4.2.2", id="422-C7")
    public void testMonetaryAmount_isEqualToRegardlessType() {
        ArrayList<MonetaryAmount> instances = new ArrayList<MonetaryAmount>();
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            instances.add(f.setNumber(10L).create());
            instances.add(f.setNumber(10.0).create());
            instances.add(f.setNumber((Number)BigDecimal.TEN).create());
        }
        for (MonetaryAmount mi : instances) {
            for (MonetaryAmount mj : instances) {
                AssertJUnit.assertTrue((String)("Section 4.2.2: isEqualTo must be true for " + mi + " and " + mj), (boolean)mi.isEqualTo(mj));
            }
        }
    }

    @Test(description="4.2.2 For each amount class, check m1.add(m2), m1 >0, m2>0.")
    @SpecAssertion(section="4.2.2", id="422-D1")
    public void testAddPositiveIntegers() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(20L).create();
            MonetaryAmount mActualResult = mAmount1.add(mAmount2);
            MonetaryAmount mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(30L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: Adding two simple ammounts failed, " + mAmount1 + " + " + mAmount2 + " != " + mExpectedResult), (Object)mExpectedResult, (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, check m1.add(m2), m1 <0, m2<0.")
    @SpecAssertion(section="4.2.2", id="422-D1")
    public void testAddNegativeIntegers() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-10L).create();
            MonetaryAmount mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-20L).create();
            MonetaryAmount mActualResult = mAmount1.add(mAmount2);
            MonetaryAmount mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-30L).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, check m1.add(m2), m2 is fraction.")
    @SpecAssertion(section="4.2.2", id="422-D1")
    public void testAddPositiveFractions() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(1.5).create();
            MonetaryAmount mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(2.85).create();
            MonetaryAmount mActualResult = mAmount1.add(mAmount2);
            MonetaryAmount mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(4.35).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, check m1.add(m2), m1, m2 = mixed ints.")
    @SpecAssertion(section="4.2.2", id="422-D1")
    public void testAddMixedIntegers() {
        MonetaryAmount mExpectedResult;
        MonetaryAmount mActualResult;
        MonetaryAmount mAmount2;
        MonetaryAmount mAmount1;
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-10L).create();
            mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(20L).create();
            mActualResult = mAmount1.add(mAmount2);
            mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-20L).create();
            mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            mActualResult = mAmount1.add(mAmount2);
            mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-10L).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-10L).create();
            mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            mActualResult = mAmount1.add(mAmount2);
            mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(0L).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, check m1.add(m2), m1, m2 = mixed fractions.")
    @SpecAssertion(section="4.2.2", id="422-D1")
    public void testAddMixedFractions() {
        MonetaryAmount mExpectedResult;
        MonetaryAmount mActualResult;
        MonetaryAmount mAmount2;
        MonetaryAmount mAmount1;
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(1.5).create();
            mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-2.85).create();
            mActualResult = mAmount1.add(mAmount2);
            mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-1.35).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-1.5).create();
            mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(2.85).create();
            mActualResult = mAmount1.add(mAmount2);
            mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(1.35).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-2.85).create();
            mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(2.85).create();
            mActualResult = mAmount1.add(mAmount2);
            mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(0L).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure currency compatibility is working.")
    @SpecAssertion(section="4.2.2", id="422-D2")
    public void testAdd_IncompatibleCurrencies() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(ADDITIONAL_CURRENCY).setNumber(20L).create();
            try {
                mAmount1.add(mAmount2);
                AssertJUnit.fail((String)"Section 4.2.2: Exception expected");
            }
            catch (MonetaryException monetaryException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure m2 = m1,add(0) -> m1==m2.")
    @SpecAssertion(section="4.2.2", id="422-D3")
    public void testAdd_Zero() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(0L).create();
            MonetaryAmount mActualResult = mAmount1.add(mAmount2);
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding zero", (Object)mAmount1, (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure ArithemticException is thrown when adding exceeding values.")
    @SpecAssertion(section="4.2.2", id="422-D4")
    public void testAdd_ExceedsCapabilities() {
        MonetaryAmount m;
        MonetaryContext maxCtx;
        MonetaryAmountFactory f;
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            maxCtx = f.getMaximalMonetaryContext();
            if (maxCtx.getPrecision() <= 0) continue;
            MonetaryAmount ms = m = f.setNumber((Number)f.getMaxNumber()).create();
            try {
                for (int i = 0; i < 20; ++i) {
                    ms = ms.add(ms);
                }
                AssertJUnit.fail((String)("Section 4.2.2: ArithmeticException expected, since adding 20x " + m + " to " + m + " exceeds capabilities (precision) for " + type.getName()));
            }
            catch (ArithmeticException i) {
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Section 4.2.2: Addition of amount " + ms + " to " + ms + " exceeds max monetary context(scale), but did not throw an ArithmeticException (exception thrown was " + e.getClass().getName() + "), type was " + type));
            }
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            maxCtx = f.getMaximalMonetaryContext();
            if (maxCtx.getMaxScale() < 0) continue;
            try {
                m = f.setNumber(1L).create();
                MonetaryAmount m2 = f.setNumber((Number)TestUtils.createNumberWithScale(maxCtx.getMaxScale() + 5)).create();
                m.add(m2);
                AssertJUnit.fail((String)("Section 4.2.2: Exception expected, since adding " + m2 + " to " + m + " exceeds capabilities (scale) for " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure NullPointerException is thrown when calling m.add(null).")
    @SpecAssertion(section="4.2.2", id="422-D5")
    public void testAdd_Null() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                MonetaryAmount mActualResult = mAmount1.add(null);
                AssertJUnit.fail((String)"Section 4.2.2: MonetaryAmount.add(null): NullPointerException expected");
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure correct subtraction of positive ints.")
    @SpecAssertion(section="4.2.2", id="422-D6")
    public void testSubtractPositiveIntegers() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(20L).create();
            MonetaryAmount mActualResult = mAmount1.subtract(mAmount2);
            MonetaryAmount mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-10L).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Subtracting two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure correct subtraction of negative ints.")
    @SpecAssertion(section="4.2.2", id="422-D6")
    public void testSubtractNegativeIntegers() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-10L).create();
            MonetaryAmount mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-20L).create();
            MonetaryAmount mActualResult = mAmount1.subtract(mAmount2);
            MonetaryAmount mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Subtracting two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure correct subtraction of positive fractions.")
    @SpecAssertion(section="4.2.2", id="422-D6")
    public void testSubtractPositiveFractions() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(1.5).create();
            MonetaryAmount mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(2.85).create();
            MonetaryAmount mActualResult = mAmount1.subtract(mAmount2);
            MonetaryAmount mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-1.35).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure correct subtraction of mixed ints.")
    @SpecAssertion(section="4.2.2", id="422-D6")
    public void testSubtractMixedIntegers() {
        MonetaryAmount mExpectedResult;
        MonetaryAmount mActualResult;
        MonetaryAmount mAmount2;
        MonetaryAmount mAmount1;
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(20L).create();
            mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            mActualResult = mAmount1.subtract(mAmount2);
            mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            mActualResult = mAmount1.subtract(mAmount2);
            mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(0L).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-10L).create();
            mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            mActualResult = mAmount1.subtract(mAmount2);
            mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-20L).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure correct subtraction of mixed fractions.")
    @SpecAssertion(section="4.2.2", id="422-D6")
    public void testSubtractMixedFractions() {
        MonetaryAmount mExpectedResult;
        MonetaryAmount mActualResult;
        MonetaryAmount mAmount2;
        MonetaryAmount mAmount1;
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(1.5).create();
            mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-2.85).create();
            mActualResult = mAmount1.subtract(mAmount2);
            mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(4.35).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-1.5).create();
            mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(2.85).create();
            mActualResult = mAmount1.subtract(mAmount2);
            mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(-4.35).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(2.85).create();
            mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(2.85).create();
            mActualResult = mAmount1.subtract(mAmount2);
            mExpectedResult = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(0L).create();
            AssertJUnit.assertEquals((String)"Section 4.2.2: Adding two simple ammounts", (Object)mExpectedResult, (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure subtraction with invalid currency throws MonetaryException.")
    @SpecAssertion(section="4.2.2", id="422-D8")
    public void testSubtract_IncompatibleCurrencies() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(ADDITIONAL_CURRENCY).setNumber(20L).create();
            try {
                MonetaryAmount mActualResult = mAmount1.subtract(mAmount2);
                AssertJUnit.fail((String)"Section 4.2.2: Exception expected");
            }
            catch (MonetaryException monetaryException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure subtraction of 0 returns same instance.")
    @SpecAssertion(section="4.2.2", id="422-D7")
    public void testSubtract_Zero() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mAmount2 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(0L).create();
            MonetaryAmount mActualResult = mAmount1.subtract(mAmount2);
            AssertJUnit.assertEquals((String)"Section 4.2.2: Subtract zero", (Object)mAmount1, (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure subtraction with exceeding capabilities throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D9")
    public void testSubtract_ExceedsCapabilities() {
        MonetaryAmountFactory f;
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            MonetaryAmount m = null;
            if (maxCtx.getPrecision() <= 0) continue;
            MonetaryAmount mAmount1 = null;
            try {
                mAmount1 = f.setNumber((Number)f.getMinNumber()).create().negate();
                m = TestUtils.createAmountWithPrecision(maxCtx.getPrecision() + 1);
                mAmount1 = mAmount1.subtract(m);
                AssertJUnit.fail((String)("Section 4.2.2: ArithmeticException expected on subtraction that exceeds capabilities for " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Section 4.2.2: Subtraction of amount " + m + " from " + mAmount1 + " exceeds max monetary context(scale), but did not throw an ArithmeticException (exception thrown was " + e.getClass().getName() + "), type was " + type));
            }
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            MonetaryAmount mAmount1 = f.setNumber(0L).create();
            MonetaryContext maxCtx = f.getMaximalMonetaryContext();
            MonetaryAmount m = null;
            if (maxCtx.getMaxScale() >= 0) {
                m = TestUtils.createAmountWithScale(maxCtx.getMaxScale() + 1);
            }
            if (m == null) continue;
            try {
                mAmount1.subtract(m);
                AssertJUnit.fail((String)("Section 4.2.2: ArithmeticException expected on subtraction that exceeds capabilities for " + type.getName()));
            }
            catch (ArithmeticException e) {
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Section 4.2.2: Subtraction of amount " + m + " from " + mAmount1 + " exceeds max monetary context(scale), but did not throw an ArithmeticException (exception thrown was " + e.getClass().getName() + "), type was " + type));
            }
        }
    }

    @Test(description="4.2.2 For each amount class, ensure subtraction with null throws NullPointerException.")
    @SpecAssertion(section="4.2.2", id="422-D10")
    public void testSubtract_Null() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                mAmount1.subtract(null);
                AssertJUnit.fail((String)"Section 4.2.2: MonetaryAmount.subtract(null): NullPointerException expected");
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure correct multiplication of int values.")
    @SpecAssertion(section="4.2.2", id="422-D11")
    public void testMultiply_Integral() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mActualResult = mAmount1.multiply(2L);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with 2 does not return correct value for " + type.getName()), (mActualResult.getNumber().longValueExact() == 20L ? 1 : 0) != 0);
            mActualResult = mAmount1.multiply((Number)-3.0);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with -3 does not return correct value for " + type.getName()), (mActualResult.getNumber().longValueExact() == -30L ? 1 : 0) != 0);
            mActualResult = mAmount1.multiply((Number)BigDecimal.ONE);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with 1 does not return correct value for " + type.getName()), (mActualResult.getNumber().longValueExact() == 10L ? 1 : 0) != 0);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with 1 does not return identity value for " + type.getName()), (mActualResult == mAmount1 ? 1 : 0) != 0);
            mActualResult = mAmount1.multiply((Number)BigDecimal.ZERO);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with 0 does not return correct value for " + type.getName()), (mActualResult.getNumber().longValue() == 0L ? 1 : 0) != 0);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure correct multiplication of decimal values.")
    @SpecAssertion(section="4.2.2", id="422-D11")
    public void testMultiply_Decimals() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mActualResult = mAmount1.multiply(1.5);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with 1.5 does not return correct value for " + type.getName()), (mActualResult.getNumber().longValueExact() == 15L ? 1 : 0) != 0);
            mActualResult = mAmount1.multiply((Number)-1.5);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with -3 does not return correct value for " + type.getName()), (mActualResult.getNumber().longValueExact() == -15L ? 1 : 0) != 0);
            mActualResult = mAmount1.multiply(0.0);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with 0 does not return correct value for " + type.getName()), (mActualResult.getNumber().longValueExact() == 0L ? 1 : 0) != 0);
            mActualResult = mAmount1.multiply(1.0);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with 0 does not return correct value for " + type.getName()), (mActualResult.getNumber().longValueExact() == 10L ? 1 : 0) != 0);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with 0 does not return identity value for " + type.getName()), (mActualResult == mAmount1 ? 1 : 0) != 0);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure multiplication by one returns same instance.")
    @SpecAssertion(section="4.2.2", id="422-D12")
    public void testMultiplyOne() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mActualResult = mAmount1.multiply(1L);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with 1 does not return identity value for " + type.getName()), (mActualResult == mAmount1 ? 1 : 0) != 0);
            mActualResult = mAmount1.multiply(1.0);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with 1 does not return identity value for " + type.getName()), (mActualResult == mAmount1 ? 1 : 0) != 0);
            mActualResult = mAmount1.multiply((Number)BigDecimal.ONE);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Multiplication with 1 does not return identity value for " + type.getName()), (mActualResult == mAmount1 ? 1 : 0) != 0);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure multiplication with exceeding values throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D13")
    public void testMultiplyExceedsCapabilities() {
        MonetaryAmount m;
        BigDecimal num;
        MonetaryAmountFactory f;
        MonetaryContext ctx;
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class) || (ctx = (f = Monetary.getAmountFactory((Class)type)).getMaximalMonetaryContext()).getMaxScale() < 0) continue;
            num = TestUtils.createNumberWithScale(ctx.getMaxScale() + 5);
            m = f.setNumber(10L).setCurrency(ADDITIONAL_CURRENCY).create();
            try {
                m.multiply((Number)num);
            }
            catch (ArithmeticException arithmeticException) {
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Section 4.2.2: Multiplication of amount 10 with " + num + " exceeds max monetary context(scale), should be rounded, but did throw an Exception (exception thrown was " + e.getClass().getName() + "), type was " + type));
            }
        }
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class) || (ctx = (f = Monetary.getAmountFactory((Class)type)).getMaximalMonetaryContext()).getPrecision() <= 0) continue;
            num = TestUtils.createNumberWithPrecision(ctx.getPrecision() + 5);
            m = f.setNumber(10L).setCurrency(ADDITIONAL_CURRENCY).create();
            try {
                m.multiply((Number)num);
                AssertJUnit.fail((String)("Section 4.2.2: Multiplication of amount " + num + " with 10000000 exceeds max monetary context(precision), but did not throw an ArithmeticException, type was " + type.getName()));
            }
            catch (ArithmeticException e) {
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Section 4.2.2: Multiplication of amount " + num + " with 10000000 exceeds max monetary context(precision), but did not throw an ArithmeticException (exception thrown was " + e.getClass().getName() + "), type was " + type.getName()));
            }
        }
    }

    @Test(description="4.2.2 For each amount class, ensure multiplication of null throws NullPointerException.")
    @SpecAssertion(section="4.2.2", id="422-D14")
    public void testMultiplyNull() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                MonetaryAmount mActualResult = mAmount1.multiply(null);
                AssertJUnit.fail((String)("Section 4.2.2: NullPointerException expected for multiplication with null, type was " + type.getName()));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure multiplication of Double.NaN throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D14")
    public void testMultiply_DoubleNaN() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                MonetaryAmount mActualResult = mAmount1.multiply(Double.NaN);
                AssertJUnit.fail((String)("Section 4.2.2: ArithmeticException expected for multiplication with Double.NaN, type was " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure multiplication of Double.POSITIVE_INFINITY throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D14")
    public void testMultiply_DoublePOSITIVE_INFINITY() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                MonetaryAmount mActualResult = mAmount1.multiply(Double.POSITIVE_INFINITY);
                AssertJUnit.fail((String)("Section 4.2.2: ArithmeticException expected for multiplication with Double.POSITIVE_INFINITY, type was " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure multiplication of Double.NEGATIVE_INFINITY throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D14")
    public void testMultiply_DoubleNEGATIVE_INFINITY() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                MonetaryAmount mActualResult = mAmount1.multiply(Double.NEGATIVE_INFINITY);
                AssertJUnit.fail((String)("Section 4.2.2: ArithmeticException expected for multiplication with Double.NEGATIVE_INFINITY, type was " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure correct division.")
    @SpecAssertion(section="4.2.2", id="422-D15")
    public void testDivide() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount m = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount m2 = m.divide(10L);
            AssertJUnit.assertEquals((String)("Section 4.2.2: Currency not equal after division, type was " + type.getName()), (String)DEFAULT_CURRENCY, (String)m2.getCurrency().getCurrencyCode());
            AssertJUnit.assertEquals((String)("Section 4.2.2: Division result is not correct for " + type.getName()), (long)1L, (long)m2.getNumber().longValueExact());
        }
    }

    @Test(description="4.2.2 For each amount class, ensure correct division with int values.")
    @SpecAssertion(section="4.2.2", id="422-D15")
    public void testDivideToIntegralValue() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            CurrencyUnit euro = Monetary.getCurrency((String)"EUR", (String[])new String[0]);
            MonetaryAmount money1 = Monetary.getAmountFactory((Class)type).setNumber((Number)BigDecimal.ONE).setCurrency(euro).create();
            MonetaryAmount result = money1.divideToIntegralValue((Number)new BigDecimal("0.5001"));
            AssertJUnit.assertEquals((String)("Section 4.2.2: divideToIntegralValue returned incorrect result for " + type.getName()), (Object)((BigDecimal)result.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros(), (Object)new BigDecimal("1.0").stripTrailingZeros());
            result = money1.divideToIntegralValue((Number)new BigDecimal("0.2001"));
            AssertJUnit.assertEquals((String)("Section 4.2.2: divideToIntegralValue returned incorrect result for " + type.getName()), (Object)((BigDecimal)result.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros(), (Object)new BigDecimal("4.0").stripTrailingZeros());
            result = money1.divideToIntegralValue((Number)new BigDecimal("5.0"));
            AssertJUnit.assertTrue((String)("Section 4.2.2: divideToIntegralValue returned incorrect result for " + type.getName()), (((BigDecimal)result.getNumber().numberValue(BigDecimal.class)).intValueExact() == 0 ? 1 : 0) != 0);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure divide(0) throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D16")
    public void testDivideZero() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                MonetaryAmount mActualResult = mAmount1.divide(0L);
                AssertJUnit.fail((String)("Section 4.2.2: ArithmeticException expected on division by 0, type was " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure divide(Double.NaN) throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D16")
    public void testDivideDoubleNaN() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                MonetaryAmount mActualResult = mAmount1.divide(Double.NaN);
                AssertJUnit.fail((String)("Section 4.2.2: ArithmeticException expected on division by Double.NaN, type was " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure divide(Double.POSITIVE_INFINITY) return ZERO amount.")
    @SpecAssertion(section="4.2.2", id="422-D16")
    public void testDivideDoublePOSITIVE_INFINITY() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mActualResult = mAmount1.divide(Double.POSITIVE_INFINITY);
            AssertJUnit.assertEquals((String)("Section 4.2.2: ZERO amount expected on division by Double.POSITIVE_INFINITY, type was " + type.getName()), (Object)mActualResult, (Object)Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(0L).create());
        }
    }

    @Test(description="4.2.2 For each amount class, ensure divide(Double.NEGATIVE_INFINITY) return ZERO amount.")
    @SpecAssertion(section="4.2.2", id="422-D16")
    public void testDivideDoubleNEGATIVE_INFINITY() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mActualResult = mAmount1.divide(Double.NEGATIVE_INFINITY);
            AssertJUnit.assertEquals((String)("Section 4.2.2: ZERO amount expected on division by Double.POSITIVE_INFINITY, type was " + type.getName()), (Object)mActualResult, (Object)Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(0L).create());
        }
    }

    @Test(description="4.2.2 For each amount class, ensure divide 1 returns same instance.")
    @SpecAssertion(section="4.2.2", id="422-D17")
    public void testDivideOne() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mActualResult = mAmount1.divide(1L);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Division by 1 does not return identity value for " + type.getName()), (mActualResult == mAmount1 ? 1 : 0) != 0);
            mActualResult = mAmount1.divide(1.0);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Division by 1 does not return identity value for " + type.getName()), (mActualResult == mAmount1 ? 1 : 0) != 0);
            mActualResult = mAmount1.divide((Number)BigDecimal.ONE);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Division by 1 does not return identity value for " + type.getName()), (mActualResult == mAmount1 ? 1 : 0) != 0);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure divide by null throws NullPointerException.")
    @SpecAssertion(section="4.2.2", id="422-D18")
    public void testDivideNull() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                MonetaryAmount mActualResult = mAmount1.divide(null);
                AssertJUnit.fail((String)("Section 4.2.2: NullPointerException expected for division by null, type was " + type.getName()));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure correct results for remainder.")
    @SpecAssertion(section="4.2.2", id="422-D19")
    public void testRemainder() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmount[] moneys;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            for (MonetaryAmount m : moneys = new MonetaryAmount[]{f.setNumber(100L).create(), f.setNumber(34242344L).create(), f.setNumber(2.3123213435E7).create(), f.setNumber(0L).create(), f.setNumber(-100L).create(), f.setNumber(-723527.36532).create()}) {
                AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid remainder of 10.5 for " + type.getName()), (Object)m.getFactory().setNumber((Number)((BigDecimal)m.getNumber().numberValue(BigDecimal.class)).remainder(BigDecimal.valueOf(10.5))).create(), (Object)m.remainder(10.5));
                AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid remainder of -30.2 for " + type.getName()), (Object)m.getFactory().setNumber((Number)((BigDecimal)m.getNumber().numberValue(BigDecimal.class)).remainder(BigDecimal.valueOf(-30.2))).create(), (Object)m.remainder(-30.2));
                AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid remainder of -3 for " + type.getName()), (Object)m.getFactory().setNumber((Number)((BigDecimal)m.getNumber().numberValue(BigDecimal.class)).remainder(BigDecimal.valueOf(-3L))).create(), (Object)m.remainder(-3L));
                AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid remainder of 3 for " + type.getName()), (Object)m.getFactory().setNumber((Number)((BigDecimal)m.getNumber().numberValue(BigDecimal.class)).remainder(BigDecimal.valueOf(3L))).create(), (Object)m.remainder(3L));
            }
        }
    }

    @Test(description="4.2.2 For each amount class, ensure remainder(0), double, throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D20")
    public void testRemainderZero_Double() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount m = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                m.remainder(0.0);
                AssertJUnit.fail((String)("Section 4.2.2: remainder(0) did not throw an ArithmeticException for " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Section 4.2.2: remainder(0.0d) did not throw an ArithmeticException for " + type.getName() + ", but " + e));
            }
        }
    }

    @Test(description="4.2.2 For each amount class, ensure remainder(0), long, throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D20")
    public void testRemainderZero_Long() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount m = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                m.remainder(0L);
                AssertJUnit.fail((String)("Section 4.2.2: remainder(0L) did not throw an ArithmeticException for " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Section 4.2.2: remainder(0L) did not throw an ArithmeticException for " + type.getName() + ", but " + e));
            }
        }
    }

    @Test(description="4.2.2 For each amount class, ensure remainder(0), Number, throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D20")
    public void testRemainderZero_Number() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount m = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                m.remainder((Number)BigDecimal.ZERO);
                AssertJUnit.fail((String)("Section 4.2.2: remainder(BigDecimal.ZERO) did not throw an ArithmeticException for " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Section 4.2.2: remainder(BigDecimal.ZERO) did not throw an ArithmeticException for " + type.getName() + ", but " + e));
            }
        }
    }

    @Test(description="4.2.2 For each amount class, ensure remainder(null), throws NullPointerException.")
    @SpecAssertion(section="4.2.2", id="422-D21")
    public void testRemainderNull() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                MonetaryAmount mActualResult = mAmount1.remainder(null);
                AssertJUnit.fail((String)("Section 4.2.2: NullPointerException expected for remainder with null, type was " + type.getName()));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure remainder(Double.NaN), throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D21")
    public void testRemainder_DoubleNaN() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                MonetaryAmount mActualResult = mAmount1.remainder(Double.NaN);
                AssertJUnit.fail((String)("Section 4.2.2: ArithmeticException expected for remainder(Double.NaN), type was " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure remainder(Double.POSITIVE_INFINITY), throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D21")
    public void testRemainder_DoublePOSITIVE_INFINITY() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mActualResult = mAmount1.remainder(Double.POSITIVE_INFINITY);
            AssertJUnit.assertEquals((Object)Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(0L).create(), (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure remainder(Double.NEGATIVE_INFINITY), throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D21")
    public void testRemainder_DoubleNEGATIVE_INFINITY() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount mActualResult = mAmount1.remainder(Double.NEGATIVE_INFINITY);
            AssertJUnit.assertEquals((Object)Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(0L).create(), (Object)mActualResult);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure correct divideAndRemainder().")
    @SpecAssertion(section="4.2.2", id="422-D22")
    public void testDivideAndRemainder() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmount[] divideAndRemainder;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            MonetaryAmount money1 = f.setNumber((Number)BigDecimal.ONE).setCurrency("EUR").create();
            if (f.getDefaultMonetaryContext().getMaxScale() < 5) {
                divideAndRemainder = money1.divideAndRemainder((Number)new BigDecimal("0.6"));
                AssertJUnit.assertEquals((String)("Section 4.2.2: divideAndRemainder(0.6)[0] failed for " + type.getName()), (Object)((BigDecimal)divideAndRemainder[0].getNumber().numberValue(BigDecimal.class)).stripTrailingZeros(), (Object)BigDecimal.ONE.stripTrailingZeros());
                AssertJUnit.assertEquals((String)("Section 4.2.2: divideAndRemainder(0.6)[1] failed for " + type.getName()), (Object)((BigDecimal)divideAndRemainder[1].getNumber().numberValue(BigDecimal.class)).stripTrailingZeros(), (Object)new BigDecimal("0.4").stripTrailingZeros());
                continue;
            }
            divideAndRemainder = money1.divideAndRemainder((Number)new BigDecimal("0.50001"));
            AssertJUnit.assertEquals((String)("Section 4.2.2: divideAndRemainder(0.50001)[0] failed for " + type.getName()), (Object)((BigDecimal)divideAndRemainder[0].getNumber().numberValue(BigDecimal.class)).stripTrailingZeros(), (Object)BigDecimal.ONE.stripTrailingZeros());
            AssertJUnit.assertEquals((String)("Section 4.2.2: divideAndRemainder(0.50001)[1] failed for " + type.getName()), (Object)((BigDecimal)divideAndRemainder[1].getNumber().numberValue(BigDecimal.class)).stripTrailingZeros(), (Object)new BigDecimal("0.49999").stripTrailingZeros());
        }
    }

    @Test(description="4.2.2 For each amount class, ensure correct divideAndRemainderZero().")
    @SpecAssertion(section="4.2.2", id="422-D23")
    public void testDivideAndRemainderZero() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                mAmount1.divideAndRemainder((Number)BigDecimal.ZERO);
                AssertJUnit.fail((String)("Section 4.2.2: divideAndRemainder(0) for " + type.getName() + ", should throw ArithmeticException!"));
            }
            catch (ArithmeticException arithmeticException) {
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Section 4.2.2: Unexpected exception for divideAndRemainder(0) for " + type.getName() + ", should be ArithmeticException, but was " + e));
            }
        }
    }

    @Test(description="4.2.2 For each amount class, ensure divideAndRemainder(null) throws a NullPointerException.")
    @SpecAssertion(section="4.2.2", id="422-D24")
    public void testDivideAndRemainderNull() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                MonetaryAmount[] mActualResult = mAmount1.divideAndRemainder(null);
                AssertJUnit.fail((String)("Section 4.2.2: NullPointerException expected for divideAndRemainder with null, type was " + type.getName()));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure divideAndRemainder(Double.NaN) throws a ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D24")
    public void testDivideAndRemainderDoubleNaN() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            try {
                MonetaryAmount[] mActualResult = mAmount1.divideAndRemainder(Double.NaN);
                AssertJUnit.fail((String)("Section 4.2.2: ArithmeticException expected for divideAndRemainder with Double.NaN, type was " + type.getName()));
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, ensure divideAndRemainder(Double.POSITIVE_INFINITY) returns ZERO amount.")
    @SpecAssertion(section="4.2.2", id="422-D24")
    public void testDivideAndRemainderDoublePOSITIVE_INFINITY() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount[] mActualResult = mAmount1.divideAndRemainder(Double.POSITIVE_INFINITY);
            MonetaryAmount zero = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(0L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: ZERO amount expected for divideAndRemainder with Double.POSITIVE_INFINITY, type was " + type.getName()), (Object)zero, (Object)mActualResult[0]);
            AssertJUnit.assertEquals((String)("Section 4.2.2: ZERO amount expected for divideAndRemainder with Double.POSITIVE_INFINITY, type was " + type.getName()), (Object)zero, (Object)mActualResult[1]);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure divideAndRemainder(Double.NEGATIVE_INFINITY) returns ZERO amount.")
    @SpecAssertion(section="4.2.2", id="422-D24")
    public void testDivideAndRemainderDoubleNEGATIVE_INFINITY() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount[] mActualResult = mAmount1.divideAndRemainder(Double.NEGATIVE_INFINITY);
            MonetaryAmount zero = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(0L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: ZERO amount expected for divideAndRemainder with Double.NEGATIVE_INFINITY, type was " + type.getName()), (Object)zero, (Object)mActualResult[0]);
            AssertJUnit.assertEquals((String)("Section 4.2.2: ZERO amount expected for divideAndRemainder with Double.NEGATIVE_INFINITY, type was " + type.getName()), (Object)zero, (Object)mActualResult[1]);
        }
    }

    @Test(description="4.2.2 For each amount class, ensure divideAndRemainder(1) returns same instance.")
    @SpecAssertion(section="4.2.2", id="422-D25")
    public void testDivideAndRemainderOne() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            MonetaryAmount m = f.setNumber(100L).setCurrency(DEFAULT_CURRENCY).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: DivideAndRemainder not returning correct result for type: " + type.getName()), (Object)BigDecimal.valueOf(33L), (Object)((BigDecimal)m.divideAndRemainder(3L)[0].getNumber().numberValue(BigDecimal.class)).stripTrailingZeros());
            AssertJUnit.assertEquals((String)("Section 4.2.2: DivideAndRemainder not returning correct result for type: " + type.getName()), (Object)BigDecimal.valueOf(1L), (Object)((BigDecimal)m.divideAndRemainder(3L)[1].getNumber().numberValue(BigDecimal.class)).stripTrailingZeros());
            AssertJUnit.assertEquals((String)("Section 4.2.2: DivideAndRemainder not returning correct result for type: " + type.getName()), (Object)BigDecimal.ONE, (Object)((BigDecimal)m.divideAndRemainder((Number)BigDecimal.valueOf(3L))[1].getNumber().numberValue(BigDecimal.class)).stripTrailingZeros());
        }
    }

    @Test(description="4.2.2 For each amount class, ensure scaleByPowerOfTen(1) throws an ArithmeticException.", expectedExceptions={ArithmeticException.class})
    @SpecAssertion(section="4.2.2", id="422-D26")
    public void testScaleByPowerOfTen() {
        for (Class type : Monetary.getAmountTypes()) {
            MonetaryAmount[] amounts;
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            for (MonetaryAmount m : amounts = new MonetaryAmount[]{f.setNumber(100L).create(), f.setNumber(342444L).create(), f.setNumber(2312213.435).create(), f.setNumber((Number)BigDecimal.ZERO).create(), f.setNumber(-100L).create(), f.setNumber(-723527.3653).create()}) {
                for (int p = -3; p < 3; ++p) {
                    BigDecimal bdExpected = (BigDecimal)m.scaleByPowerOfTen(p).getNumber().numberValue(BigDecimal.class);
                    BigDecimal bdCalculated = ((BigDecimal)m.getNumber().numberValue(BigDecimal.class)).scaleByPowerOfTen(p);
                    bdCalculated = bdCalculated.setScale(m.getContext().getMaxScale(), RoundingMode.HALF_EVEN);
                    if (bdExpected.signum() == 0) {
                        AssertJUnit.assertTrue((String)("Section 4.2.2: Invalid " + m + " -> scaleByPowerOfTen(" + p + ") for " + type.getName()), (bdCalculated.signum() == 0 ? 1 : 0) != 0);
                        continue;
                    }
                    AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid " + m + " -> scaleByPowerOfTen(" + p + ") for " + type.getName()), (Object)bdExpected.setScale(m.getContext().getMaxScale() - 1, RoundingMode.HALF_EVEN).stripTrailingZeros(), (Object)bdCalculated.setScale(m.getContext().getMaxScale() - 1, RoundingMode.HALF_EVEN).stripTrailingZeros());
                }
            }
        }
    }

    @Test(description="4.2.2 For each amount class, ensure scaleByPowerOfTen(-1).scaleByPowerOfTen(1) returns correct results or throws ArithmeticException.")
    @SpecAssertion(section="4.2.2", id="422-D26")
    public void testScaleByPowerOfTenArithmeticException() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            MonetaryContext maximalContext = f.getMaximalMonetaryContext();
            f.setCurrency(DEFAULT_CURRENCY);
            f.setContext(maximalContext);
            f.setNumber((Number)BigDecimal.valueOf(16L, maximalContext.getMaxScale()));
            MonetaryAmount m = f.create();
            try {
                AssertJUnit.assertEquals((String)("Section 4.2.2: Invalid " + m + " -> scaleByPowerOfTen(-1) for " + type.getName()), (Object)m, (Object)m.scaleByPowerOfTen(-1).scaleByPowerOfTen(1));
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, test absolute().")
    @SpecAssertion(section="4.2.2", id="422-D27")
    public void testAbsolute() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            MonetaryAmount m = f.setNumber(10L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: abs(m) !equals m, if m > 0 for type: " + type.getName()), (Object)m, (Object)m.abs());
            AssertJUnit.assertTrue((String)("Section 4.2.2: abs(m) != m, if m > 0 for type: " + type.getName()), (m == m.abs() ? 1 : 0) != 0);
            m = f.setNumber(0L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: abs(m) != equals, if m == 0 for type: " + type.getName()), (Object)m, (Object)m.abs());
            AssertJUnit.assertTrue((String)("Section 4.2.2: abs(m) != m, if m == 0 for type: " + type.getName()), (m == m.abs() ? 1 : 0) != 0);
            m = f.setNumber(-10L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: abs(m) == m, if m < 0 for type: " + type.getName()), (Object)m.negate(), (Object)m.abs());
            AssertJUnit.assertTrue((String)("Section 4.2.2: abs(m) == m, if m < 0 for type: " + type.getName()), (m != m.abs() ? 1 : 0) != 0);
        }
    }

    @Test(description="4.2.2 For each amount class, test negate().")
    @SpecAssertion(section="4.2.2", id="422-D28")
    public void testNegate() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = Monetary.getAmountFactory((Class)type);
            f.setCurrency(DEFAULT_CURRENCY);
            MonetaryAmount m = f.setNumber(100L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: negate(-x) failed for " + type.getName()), (Object)f.setNumber(-100L).create(), (Object)m.negate());
            m = f.setNumber(-123.234).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: negate(+x) failed for " + type.getName()), (Object)f.setNumber(123.234).create(), (Object)m.negate());
        }
    }

    @Test(description="4.2.2 For each amount class, test with().")
    @SpecAssertion(section="4.2.2", id="422-E1")
    public void testWith() {
        MonetaryOperator op = new MonetaryOperator(){

            public MonetaryAmount apply(MonetaryAmount amount) {
                return amount;
            }
        };
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount amount = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            MonetaryAmount amount2 = amount.with(op);
            AssertJUnit.assertTrue((String)("Section 4.2.2: MonetaryAmount returned from operator is wrapped by implementation of type: " + type.getName()), (amount == amount2 ? 1 : 0) != 0);
            final MonetaryAmount result = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(4L).create();
            MonetaryOperator op2 = new MonetaryOperator(){

                public MonetaryAmount apply(MonetaryAmount amount) {
                    return result;
                }
            };
            amount2 = amount.with(op);
            AssertJUnit.assertTrue((String)("Section 4.2.2: MonetaryAmount returned from operator is wrapped by implementation of type: " + type.getName()), (amount == amount2 ? 1 : 0) != 0);
        }
    }

    @Test(description="4.2.2 For each amount class, test with().")
    @SpecAssertion(section="4.2.2", id="422-E1")
    public void testWith4ProvidedOperators() {
        for (MonetaryOperator op : TCKTestSetup.getTestConfiguration().getMonetaryOperators4Test()) {
            for (Class type : Monetary.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount amount = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
                MonetaryAmount amount2 = amount.with(op);
                AssertJUnit.assertTrue((String)("Section 4.2.2: MonetaryAmount returned from operator is wrapped by implementation of type: " + type.getName()), (amount.getClass() == amount2.getClass() ? 1 : 0) != 0);
                MonetaryAmount result = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(4L).create();
                MonetaryOperator op2 = new MonetaryOperator(){

                    public MonetaryAmount apply(MonetaryAmount amount) {
                        return amount;
                    }
                };
                amount2 = amount.with(op2);
                AssertJUnit.assertTrue((String)("Section 4.2.2: MonetaryAmount returned from operator is wrapped by implementation of type: " + type.getName()), (amount == amount2 ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="4.2.2 Bad case: For each amount class, test with(), operator throws exception.")
    @SpecAssertion(section="4.2.2", id="422-E2")
    public void testWithInvalidOperator() {
        MonetaryOperator op = new MonetaryOperator(){

            public MonetaryAmount apply(MonetaryAmount value) {
                throw new IllegalStateException();
            }
        };
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory factory = Monetary.getAmountFactory((Class)type);
            MonetaryAmount amount = factory.setCurrency("XXX").setNumber(1L).create();
            try {
                amount.with(op);
                AssertJUnit.fail((String)("Section 4.2.2: MonetaryException expected as operator fails, type was " + type.getName()));
            }
            catch (MonetaryException monetaryException) {}
        }
    }

    @Test(description="4.2.2 Bad case: For each amount class, test with(null), expected NullPointerException.")
    @SpecAssertion(section="4.2.2", id="422-E2")
    public void testWithNull() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory factory = Monetary.getAmountFactory((Class)type);
            MonetaryAmount amount = factory.setCurrency("XXX").setNumber(1L).create();
            try {
                amount.with(null);
                AssertJUnit.fail((String)("Section 4.2.2: NullPointerException expected as operator applied is null, type was " + type.getName()));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.2.2 Bad case: For each amount class, test with(), operator throws exception.")
    @SpecAssertion(section="4.2.2", id="422-E2")
    public void testWithNull4ProvidedOperators() {
        for (MonetaryOperator op : TCKTestSetup.getTestConfiguration().getMonetaryOperators4Test()) {
            try {
                op.apply(null);
                AssertJUnit.fail((String)("Section 4.2.2: NullPointerException expected as operator was applied on null, operator was " + op.getClass().getName()));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, test query().")
    @SpecAssertion(section="4.2.2", id="422-E3")
    public void testQuery() {
        MonetaryQuery<Integer> query = new MonetaryQuery<Integer>(){

            public Integer queryFrom(MonetaryAmount amount) {
                return amount.getNumber().intValue();
            }
        };
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount amount = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            Integer value = (Integer)amount.query((MonetaryQuery)query);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Value returned from MonetaryAmount Query is not correct for " + type.getName()), (value == 10 ? 1 : 0) != 0);
            amount = Monetary.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(4.5).create();
            value = (Integer)amount.query((MonetaryQuery)query);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Value returned from MonetaryAmount Query is not correct for " + type.getName()), (value == 4 ? 1 : 0) != 0);
        }
    }

    @Test(description="4.2.2 For each amount class, test query(), MonetaryQuery throws exception, MonetaryException expected.")
    @SpecAssertion(section="4.2.2", id="422-E4")
    public void testQueryInvalidQuery() {
        MonetaryQuery<Integer> query = new MonetaryQuery<Integer>(){

            public Integer queryFrom(MonetaryAmount amount) {
                throw new IllegalStateException();
            }
        };
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            TestUtils.testComparable("Section 4.2.2", type);
            MonetaryAmountFactory factory = Monetary.getAmountFactory((Class)type);
            MonetaryAmount amount = factory.setCurrency("XXX").setNumber(1L).create();
            try {
                amount.query((MonetaryQuery)query);
                AssertJUnit.fail((String)("Section 4.2.2: MonetaryException expected as query applied is failing, type was " + type.getName()));
            }
            catch (MonetaryException monetaryException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, test query(null), NullPointerException expected.")
    @SpecAssertion(section="4.2.2", id="422-E4")
    public void testQueryNull() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            TestUtils.testComparable("Section 4.2.2", type);
            MonetaryAmountFactory factory = Monetary.getAmountFactory((Class)type);
            MonetaryAmount amount = factory.setCurrency("XXX").setNumber(1L).create();
            try {
                amount.query(null);
                AssertJUnit.fail((String)("Section 4.2.2: NullPointerException expected as query applied is null, type was " + type.getName()));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.2.2 For each amount class, test implements hashCode().")
    @SpecAssertion(section="4.2.2", id="422-F1")
    public void testImplementsHashCode() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount amount = Monetary.getAmountFactory((Class)type).setCurrency(ADDITIONAL_CURRENCY).setNumber(0L).create();
            TestUtils.testHasPublicMethod("Section 4.2.2", type, type, "hashCode", new Class[0]);
            MonetaryAmount amount2 = Monetary.getAmountFactory((Class)type).setCurrency(ADDITIONAL_CURRENCY).setNumber(0L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: hashCode() for equal amounts differ for type " + type.getName()), (int)amount.hashCode(), (int)amount2.hashCode());
        }
    }

    @Test(description="4.2.2 For each amount class, test implements equals().")
    @SpecAssertion(section="4.2.2", id="422-F2")
    public void testImplementsEquals() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount amount = Monetary.getAmountFactory((Class)type).setCurrency("XXX").setNumber(0L).create();
            TestUtils.testHasPublicMethod("Section 4.2.2", type, type, "equals", Object.class);
            MonetaryAmount amount2 = Monetary.getAmountFactory((Class)type).setCurrency("XXX").setNumber(0L).create();
            AssertJUnit.assertEquals((String)("Section 4.2.2: equals(Object) for equal amounts returns false for " + type.getName()), (Object)amount, (Object)amount2);
        }
    }

    @Test(description="4.2.2 For each amount class, test is Comparable.")
    @SpecAssertion(section="4.2.2", id="422-F3")
    public void testImplementComparable() {
        for (Class type : Monetary.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            TestUtils.testComparable("Section 4.2.2", type);
            MonetaryAmountFactory factory = Monetary.getAmountFactory((Class)type);
            MonetaryAmount amount = factory.setCurrency("XXX").setNumber(0L).create();
            MonetaryAmount amount2 = factory.setCurrency("XXX").setNumber(0L).create();
            MonetaryAmount amount3 = factory.setCurrency(DEFAULT_CURRENCY).setNumber(1L).create();
            MonetaryAmount amount4 = factory.setCurrency("XXX").setNumber(1L).create();
            AssertJUnit.assertTrue((String)("Section 4.2.2: Comparable failed for: " + type.getName()), (amount.compareTo((Object)amount3) > 0 ? 1 : 0) != 0);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Comparable failed for: " + type.getName()), (amount3.compareTo((Object)amount) < 0 ? 1 : 0) != 0);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Comparable failed for: " + type.getName()), (amount.compareTo((Object)amount4) < 0 ? 1 : 0) != 0);
            AssertJUnit.assertTrue((String)("Section 4.2.2: Comparable failed for: " + type.getName()), (amount4.compareTo((Object)amount) > 0 ? 1 : 0) != 0);
        }
    }

    @Test(description="4.2.2 For each amount class, test iis immutable.")
    @SpecAssertion(section="4.2.2", id="422-F4")
    public void testImmutable() {
        for (Class clazz : TCKTestSetup.getTestConfiguration().getAmountClasses()) {
            if (clazz.equals(TestAmount.class)) continue;
            TestUtils.testImmutable("Section 4.2.2", clazz);
        }
        for (Class<Object> clazz : Monetary.getAmountTypes()) {
            if (clazz.equals(TestAmount.class)) continue;
            try {
                TestUtils.testImmutable("Section 4.2.2", clazz);
            }
            catch (MutabilityAssertionError e) {
                System.out.println("Warning: found non immutable MonetaryAmountType: " + clazz.getName() + ", details: " + e.getMessage());
            }
        }
    }
}

