/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests;

import java.util.Collection;
import org.javamoney.tck.TCKTestSetup;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.1.0")
public class TCKSetupTest {
    @Test(description="TCK Setup: ensure TCK Configuration is registered and available.")
    @SpecAssertion(section="0", id="Setup", note="Tests that a TestConfiguration is registered with the JDK's ServiceLoader.")
    public void testTestSetup() {
        AssertJUnit.assertTrue((String)"TCK Configuration not available.", (TCKTestSetup.getTestConfiguration() != null ? 1 : 0) != 0);
        AssertJUnit.assertNotNull((Object)TCKTestSetup.getTestConfiguration());
    }

    @Test(description="TChecks that MonetaryAmount classes are registered for testing.")
    @SpecAssertion(section="0", id="Setup", note="Checks that TestConfiguration.getAmountClasses() returns a non empty collection of amount implementations")
    public void testTestAmountConfiguration() {
        Collection<Class> amountClasses = TCKTestSetup.getTestConfiguration().getAmountClasses();
        AssertJUnit.assertNotNull((String)"TCK Test Configuration amount classes are null.", amountClasses);
        AssertJUnit.assertFalse((String)"TCK Test Configuration amount classes is empty.", (boolean)amountClasses.isEmpty());
    }
}

